function _inheritsLoose(subClass, superClass) { subClass.prototype = Object.create(superClass.prototype); subClass.prototype.constructor = subClass; _setPrototypeOf(subClass, superClass); }

function _setPrototypeOf(o, p) { _setPrototypeOf = Object.setPrototypeOf || function _setPrototypeOf(o, p) { o.__proto__ = p; return o; }; return _setPrototypeOf(o, p); }

var Util = require('../util');

var DomUtil = Util.DomUtil;

var Guide = require('./base');

var Html = /*#__PURE__*/function (_Guide) {
  _inheritsLoose(Html, _Guide);

  function Html() {
    return _Guide.apply(this, arguments) || this;
  }

  var _proto = Html.prototype;

  _proto.getDefaultCfg = function getDefaultCfg() {
    var cfg = _Guide.prototype.getDefaultCfg.call(this);

    return Util.mix({}, cfg, {
      name: 'html',
      zIndex: 7,
      position: null,

      /**
       * Horizontal alignment, can be 'left'、'middle'、'right'
       * @type {String}
       */
      alignX: 'middle',

      /**
       * vertical alignment, can be 'top'、'middle'、'bottom'
       * @type {String}
       */
      alignY: 'middle',

      /**
       * Horizontal offset
       * @type {Number}
       */
      offsetX: null,

      /**
       * Vertical offset
       * @type {Number}
       */
      offsetY: null,

      /**
      * html content
      *@type {String | Function}
      */
      html: null
    });
  }
  /**
   * render Html Guide
   * @override
   * @param {Coordinate} coord the instance of Coordinate class
   * @param {Container} container the container which contain the guide component
   */
  ;

  _proto.render = function render(coord, container) {
    var self = this;
    var position = self.parsePoint(coord, self.get('position'));

    if (!position) {
      return;
    }

    var parentNode = container.get('canvas').get('el').parentNode;
    var wrapperNode = DomUtil.createDom('<div class="g-guide"></div>');
    parentNode.appendChild(wrapperNode);
    var html = self.get('htmlContent') || self.get('html');

    if (Util.isFunction(html)) {
      var xScales = self.get('xScales');
      var yScales = self.get('yScales');
      html = html(xScales, yScales);
    }

    var htmlNode = DomUtil.createDom(html);
    wrapperNode.appendChild(htmlNode);
    DomUtil.modifyCSS(wrapperNode, {
      position: 'absolute' // to fix dom in the document stream to get the true width

    });

    self._setDomPosition(wrapperNode, htmlNode, position);

    self.set('el', wrapperNode);
  };

  _proto._setDomPosition = function _setDomPosition(parentDom, childDom, point) {
    var self = this;
    var alignX = self.get('alignX');
    var alignY = self.get('alignY');
    var domWidth = DomUtil.getOuterWidth(childDom);
    var domHeight = DomUtil.getOuterHeight(childDom);
    var position = {
      x: point.x,
      y: point.y
    };

    if (alignX === 'middle' && alignY === 'top') {
      position.x -= Math.round(domWidth / 2);
    } else if (alignX === 'middle' && alignY === 'bottom') {
      position.x -= Math.round(domWidth / 2);
      position.y -= Math.round(domHeight);
    } else if (alignX === 'left' && alignY === 'bottom') {
      position.y -= Math.round(domHeight);
    } else if (alignX === 'left' && alignY === 'middle') {
      position.y -= Math.round(domHeight / 2);
    } else if (alignX === 'left' && alignY === 'top') {
      position.x = point.x;
      position.y = point.y;
    } else if (alignX === 'right' && alignY === 'bottom') {
      position.x -= Math.round(domWidth);
      position.y -= Math.round(domHeight);
    } else if (alignX === 'right' && alignY === 'middle') {
      position.x -= Math.round(domWidth);
      position.y -= Math.round(domHeight / 2);
    } else if (alignX === 'right' && alignY === 'top') {
      position.x -= Math.round(domWidth);
    } else {
      // 默认位于中心点
      position.x -= Math.round(domWidth / 2);
      position.y -= Math.round(domHeight / 2);
    }

    var offsetX = self.get('offsetX');

    if (offsetX) {
      position.x += offsetX;
    }

    var offsetY = self.get('offsetY');

    if (offsetY) {
      position.y += offsetY;
    }

    DomUtil.modifyCSS(parentDom, {
      top: Math.round(position.y) + 'px',
      left: Math.round(position.x) + 'px',
      visibility: 'visible',
      zIndex: self.get('zIndex')
    });
  }
  /**
   * clear html guide
   * @override
   */
  ;

  _proto.clear = function clear() {
    var self = this;
    var el = self.get('el');
    el && el.parentNode && el.parentNode.removeChild(el);
  };

  return Html;
}(Guide);

module.exports = Html;