function _inheritsLoose(subClass, superClass) { subClass.prototype = Object.create(superClass.prototype); subClass.prototype.constructor = subClass; _setPrototypeOf(subClass, superClass); }

function _setPrototypeOf(o, p) { _setPrototypeOf = Object.setPrototypeOf || function _setPrototypeOf(o, p) { o.__proto__ = p; return o; }; return _setPrototypeOf(o, p); }

var Util = require('../util');

var Helper = require('./util/helper');

var Guide = require('./base');

var DataRegion = /*#__PURE__*/function (_Guide) {
  _inheritsLoose(DataRegion, _Guide);

  function DataRegion() {
    return _Guide.apply(this, arguments) || this;
  }

  var _proto = DataRegion.prototype;

  _proto.getDefaultCfg = function getDefaultCfg() {
    var cfg = _Guide.prototype.getDefaultCfg.call(this);

    return Util.mix({}, cfg, {
      name: 'dataRegion',
      start: null,
      // 只支持数值
      end: null,
      // 只支持数值
      content: '',
      // 文本内容
      style: {
        region: {
          lineWidth: 0,
          fill: '#000000',
          opacity: 0.04
        },
        text: {
          textAlign: 'center',
          textBaseline: 'bottom',
          fontSize: 12,
          fill: 'rgba(0, 0, 0, .65)'
        }
      }
    });
  };

  _proto.render = function render(coord, group, data) {
    var self = this; // draw region

    var lineLength = self.get('lineLength') || 0; // TODO: 如何命名

    var regionData = self._getRegionData(coord, data);

    if (!regionData.length) return;

    var regionBBox = self._getBBox(regionData);

    var path = [];
    path.push(['M', regionData[0].x, regionBBox.yMin - lineLength]);

    for (var i = 0, len = regionData.length; i < len; i++) {
      var p = ['L', regionData[i].x, regionData[i].y];
      path.push(p);
    }

    path.push(['L', regionData[regionData.length - 1].x, regionBBox.yMin - lineLength]); // draw

    var style = self.get('style');
    var regionStyle = style.region; // 兼容之前的写法

    var textStyle = style.text;
    var regionGroup = group.addGroup();
    regionGroup.name = 'guide-data-region';
    regionGroup.addShape('path', {
      attrs: Util.mix({
        path: path
      }, regionStyle)
    });
    var content = self.get('content');

    if (content) {
      regionGroup.addShape('Text', {
        attrs: Util.mix({
          x: (regionBBox.xMin + regionBBox.xMax) / 2,
          y: regionBBox.yMin - lineLength,
          text: content
        }, textStyle)
      });
    }

    self.get('appendInfo') && regionGroup.setSilent('appendInfo', self.get('appendInfo'));
    self.set('el', regionGroup);
  };

  _proto._getRegionData = function _getRegionData(coord, data) {
    var self = this;
    var start = self.get('start');
    var end = self.get('end');
    var xField = Helper.getFirstScale(self.get('xScales')).field;
    var yField = Helper.getFirstScale(self.get('yScales')).field;
    var startXValue = Util.isArray(start) ? start[0] : start[xField];
    var endXValue = Util.isArray(end) ? end[0] : end[xField];
    var startIndex;
    var arr = [];

    for (var i = 0, len = data.length; i < len; i++) {
      var item = data[i];

      if (item[xField] === startXValue) {
        startIndex = i;
      }

      if (i >= startIndex) {
        var point = self.parsePoint(coord, [item[xField], item[yField]]); // 判断是否是有效点

        point && arr.push(point);
      }

      if (item[xField] === endXValue) {
        break;
      }
    }

    return arr;
  };

  _proto._getBBox = function _getBBox(data) {
    var xs = [];
    var ys = [];

    for (var i = 0; i < data.length; i++) {
      xs.push(data[i].x);
      ys.push(data[i].y);
    }

    var xRange = Util.arrayUtil.getRange(xs);
    var yRange = Util.arrayUtil.getRange(ys);
    return {
      xMin: xRange.min,
      xMax: xRange.max,
      yMin: yRange.min,
      yMax: yRange.max
    };
  };

  return DataRegion;
}(Guide);

module.exports = DataRegion;