function _inheritsLoose(subClass, superClass) { subClass.prototype = Object.create(superClass.prototype); subClass.prototype.constructor = subClass; _setPrototypeOf(subClass, superClass); }

function _setPrototypeOf(o, p) { _setPrototypeOf = Object.setPrototypeOf || function _setPrototypeOf(o, p) { o.__proto__ = p; return o; }; return _setPrototypeOf(o, p); }

var Util = require('../util');

var Guide = require('./base');

var DataMarker = /*#__PURE__*/function (_Guide) {
  _inheritsLoose(DataMarker, _Guide);

  function DataMarker() {
    return _Guide.apply(this, arguments) || this;
  }

  var _proto = DataMarker.prototype;

  _proto.getDefaultCfg = function getDefaultCfg() {
    var cfg = _Guide.prototype.getDefaultCfg.call(this);

    return Util.mix({}, cfg, {
      name: 'dataMarker',
      zIndex: 1,
      top: true,
      position: null,
      style: {
        point: {
          r: 3,
          fill: '#FFFFFF',
          stroke: '#1890FF',
          lineWidth: 2
        },
        line: {
          stroke: '#A3B1BF',
          lineWidth: 1
        },
        text: {
          fill: '#000000',
          opacity: 0.65,
          fontSize: 12,
          textAlign: 'start'
        }
      },
      // end of style
      display: {
        point: true,
        line: true,
        text: true
      },
      lineLength: 20,
      direction: 'upward',
      autoAdjust: true
    });
  };

  _proto.render = function render(coord, group) {
    var self = this;
    var point = self.parsePoint(coord, self.get('position'));

    if (!point) {
      return;
    } // container


    var markerGroup = group.addGroup();
    markerGroup.name = 'guide-data-marker'; // markerGroup.translate(point.x, point.y);

    var positions = self._getElementPosition(point);

    var display = self.get('display');
    var lineShape;
    var textShape; // add line

    if (display.line) {
      var lineData = positions.line;
      lineShape = self._drawLine(lineData, markerGroup);
    } // add text


    if (display.text && self.get('content')) {
      var textPosition = positions.text;
      textShape = self._drawText(textPosition, markerGroup);
    } // add circle


    if (display.point) {
      var pointPoisition = positions.point;

      self._drawPoint(pointPoisition, markerGroup);
    }

    if (self.get('autoAdjust')) {
      var bbox = markerGroup.getBBox();
      var minX = bbox.minX,
          minY = bbox.minY,
          maxX = bbox.maxX,
          maxY = bbox.maxY;
      var start = coord.start,
          end = coord.end;

      if (textShape) {
        if (minX <= start.x) {
          // 左侧超出
          textShape.attr('textAlign', 'start');
        }

        if (maxX >= end.x) {
          // 右侧超出
          textShape.attr('textAlign', 'end');
        }

        var direction = self.get('direction');

        if (direction === 'upward' && minY <= end.y || direction !== 'upward' && maxY >= start.y) {
          // 上方或者下方超出
          var textBaseline;
          var dir;

          if (direction === 'upward' && minY <= end.y) {
            textBaseline = 'top';
            dir = 1;
          } else {
            textBaseline = 'bottom';
            dir = -1;
          }

          textShape.attr('textBaseline', textBaseline);
          var lineLength = 0;

          if (self.get('display').line) {
            lineLength = self.get('lineLength');
            var linePath = [['M', point.x, point.y], ['L', point.x, point.y + lineLength * dir]];
            lineShape.attr('path', linePath);
          }

          var newY = point.y + (lineLength + 2) * dir;
          textShape.attr('y', newY);
        }
      }
    }

    self.get('appendInfo') && markerGroup.setSilent('appendInfo', self.get('appendInfo'));
    self.set('el', markerGroup);
  };

  _proto._getElementPosition = function _getElementPosition(position) {
    var self = this;
    var x = position.x,
        y = position.y;
    var lineLength = self.get('display').line ? self.get('lineLength') : 0;
    var direction = self.get('direction');
    var textStyle = self.get('style').text;
    textStyle.textBaseline = direction === 'upward' ? 'bottom' : 'top';
    var dir = direction === 'upward' ? -1 : 1;
    var pointPoisition = {
      x: x,
      y: y
    };
    var lineStart = {
      x: x,
      y: y
    };
    var lineEnd = {
      x: x,
      y: lineLength * dir + y
    };
    var textPosition = {
      x: x,
      y: (lineLength + 2) * dir + y
    };
    return {
      point: pointPoisition,
      line: [lineStart, lineEnd],
      text: textPosition
    };
  };

  _proto._drawLine = function _drawLine(lineData, g) {
    var self = this;
    var lineStyle = self.get('style').line;
    var linePath = [['M', lineData[0].x, lineData[0].y], ['L', lineData[1].x, lineData[1].y]];
    var lineShape = g.addShape('path', {
      attrs: Util.mix({
        path: linePath
      }, lineStyle)
    });
    return lineShape;
  };

  _proto._drawText = function _drawText(position, g) {
    var self = this;
    var textStyle = this.get('style').text;
    var textShape = g.addShape('text', {
      attrs: Util.mix({
        text: self.get('content')
      }, textStyle, position)
    });
    return textShape;
  };

  _proto._drawPoint = function _drawPoint(position, g) {
    var self = this;
    var pointStyle = self.get('style').point;
    var pointShape = g.addShape('circle', {
      attrs: Util.mix({}, pointStyle, position)
    });
    return pointShape;
  };

  return DataMarker;
}(Guide);

module.exports = DataMarker;