function _inheritsLoose(subClass, superClass) { subClass.prototype = Object.create(superClass.prototype); subClass.prototype.constructor = subClass; _setPrototypeOf(subClass, superClass); }

function _setPrototypeOf(o, p) { _setPrototypeOf = Object.setPrototypeOf || function _setPrototypeOf(o, p) { o.__proto__ = p; return o; }; return _setPrototypeOf(o, p); }

var Util = require('../util');

var Helper = require('./util/helper');

var Component = require('../component');

var KEYWORDS = ['min', 'max', 'median', 'start', 'end'];

var Guide = /*#__PURE__*/function (_Component) {
  _inheritsLoose(Guide, _Component);

  function Guide() {
    return _Component.apply(this, arguments) || this;
  }

  var _proto = Guide.prototype;

  _proto.getDefaultCfg = function getDefaultCfg() {
    var cfg = _Component.prototype.getDefaultCfg.call(this);

    return Util.mix({}, cfg, {
      xScales: null,
      yScales: null,
      el: null
    });
  };

  _proto.render = function render() {}
  /**
   * clear container
   * @override
   */
  ;

  _proto.clear = function clear() {
    var self = this;
    var el = self.get('el');
    el && el.remove();
    this.set('el', null);
  };

  _proto.destroy = function destroy() {
    this.clear();

    _Component.prototype.destroy.call(this);
  }
  /**
   * show or hide
   * @protected
   * @param {Boolean} visible true means show, false means hide
   */
  ;

  _proto.changeVisible = function changeVisible(visible) {
    var self = this;
    self.set('visible', visible);
    var el = self.get('el');
    if (!el) return;

    if (el.set) {
      el.set('visible', visible);
    } else {
      el.style.display = visible ? '' : 'none';
    }
  }
  /**
   * calculate the canvas coordinate value
   * @protected
   * @param  {Coordinate} coord  the instance of Coordinate class
   * @param  {Object | Array | Function} position the value need to convert
   * @return {Object} return the result
   */
  ;

  _proto.parsePoint = function parsePoint(coord, position) {
    var self = this;
    var xScales = self.get('xScales');
    var yScales = self.get('yScales');

    if (Util.isFunction(position)) {
      position = position(xScales, yScales);
    }

    var x;
    var y; // 如果数据格式是 ['50%', '50%'] 的格式

    if (Util.isArray(position) && Util.isString(position[0]) && position[0].indexOf('%') !== -1) {
      return this._parsePercentPoint(coord, position);
    }

    if (Util.isArray(position)) {
      // Array，suuport for mixing of keyword, percent and value
      x = self._getNormalizedValue(position[0], Helper.getFirstScale(xScales));
      y = self._getNormalizedValue(position[1], Helper.getFirstScale(yScales));
    } else {
      for (var field in position) {
        var value = position[field];

        if (xScales[field]) {
          x = self._getNormalizedValue(value, xScales[field]);
        }

        if (yScales[field]) {
          y = self._getNormalizedValue(value, yScales[field], 'y');
        }
      }
    }

    if (!Util.isNil(x) && !Util.isNil(y) && !isNaN(x) && !isNaN(y)) {
      return coord.convert({
        x: x,
        y: y
      });
    }

    return null;
  }
  /**
   * Normalized the value
   * @param  {String | Number} val   param
   * @param  {Scale} scale the instance of Scale
   * @return {Number}       return the normalized value
   */
  ;

  _proto._getNormalizedValue = function _getNormalizedValue(val, scale) {
    var result;

    if (Util.indexOf(KEYWORDS, val) !== -1) {
      // keyword
      var scaleValue;

      if (val === 'start') {
        // the start of coordinate
        result = 0;
      } else if (val === 'end') {
        result = 1;
      } else if (val === 'median') {
        scaleValue = scale.isCategory ? (scale.values.length - 1) / 2 : (scale.min + scale.max) / 2;
        result = scale.scale(scaleValue);
      } else {
        if (scale.isCategory) {
          scaleValue = val === 'min' ? 0 : scale.values.length - 1;
        } else {
          scaleValue = scale[val];
        }

        result = scale.scale(scaleValue);
      }
    } else {
      // 数值
      result = scale.scale(val);
    }

    return result;
  };

  _proto._parsePercentPoint = function _parsePercentPoint(coord, position) {
    var xPercent = parseFloat(position[0]) / 100;
    var yPercent = parseFloat(position[1]) / 100;
    var start = coord.start,
        end = coord.end;
    var topLeft = {
      x: Math.min(start.x, end.x),
      y: Math.min(start.y, end.y)
    };
    var x = coord.width * xPercent + topLeft.x;
    var y = coord.height * yPercent + topLeft.y;
    return {
      x: x,
      y: y
    };
  };

  return Guide;
}(Component);

module.exports = Guide;