function _inheritsLoose(subClass, superClass) { subClass.prototype = Object.create(superClass.prototype); subClass.prototype.constructor = subClass; _setPrototypeOf(subClass, superClass); }

function _setPrototypeOf(o, p) { _setPrototypeOf = Object.setPrototypeOf || function _setPrototypeOf(o, p) { o.__proto__ = p; return o; }; return _setPrototypeOf(o, p); }

var Util = require('../util');

var Guide = require('./base');

var PI = Math.PI;
var atan = Math.atan;

function calculateAngle(point, center) {
  var x = point.x - center.x;
  var y = point.y - center.y;
  var deg;

  if (y === 0) {
    if (x < 0) {
      deg = PI / 2;
    } else {
      deg = 270 * PI / 180;
    }
  } else if (x >= 0 && y > 0) {
    deg = PI * 2 - atan(x / y);
  } else if (x <= 0 && y < 0) {
    deg = PI - atan(x / y);
  } else if (x > 0 && y < 0) {
    deg = PI + atan(-x / y);
  } else if (x < 0 && y > 0) {
    deg = atan(x / -y);
  }

  return deg;
}

var Arc = /*#__PURE__*/function (_Guide) {
  _inheritsLoose(Arc, _Guide);

  function Arc() {
    return _Guide.apply(this, arguments) || this;
  }

  var _proto = Arc.prototype;

  _proto.getDefaultCfg = function getDefaultCfg() {
    var cfg = _Guide.prototype.getDefaultCfg.call(this);

    return Util.mix({}, cfg, {
      /**
       * 辅助元素类型
       * @type {String}
       */
      name: 'arc',

      /**
       * 辅助弧线的起始点
       * @type {Object | Function | Array}
       */
      start: null,

      /**
       * 辅助弧线的终止点
       * @type {Object | Function | Array}
       */
      end: null,

      /**
       * 辅助文本的样式配置
       * @type {Object}
       */
      style: {
        stroke: '#999',
        lineWidth: 1
      }
    });
  };

  _proto.render = function render(coord, group) {
    var self = this;
    var start = self.parsePoint(coord, self.get('start'));
    var end = self.parsePoint(coord, self.get('end')); // 只要有一个点无意义，则不绘制

    if (!start || !end) {
      return;
    }

    var coordCenter = coord.getCenter();
    var radius = Math.sqrt((start.x - coordCenter.x) * (start.x - coordCenter.x) + (start.y - coordCenter.y) * (start.y - coordCenter.y));
    var path; // 处理整圆的情况

    var startAngle = calculateAngle(start, coordCenter);
    var endAngle = calculateAngle(end, coordCenter);

    if (endAngle < startAngle) {
      endAngle += PI * 2;
    }

    if (Util.isNumberEqual(start.x, end.x) && Util.isNumberEqual(start.y, end.y) && (self.get('start')[0] !== self.get('end')[0] || self.get('start')[1] !== self.get('end')[1])) {
      path = [['M', start.x, start.y], ['A', radius, radius, 0, 1, 1, 2 * coordCenter.x - start.x, 2 * coordCenter.y - start.y], ['A', radius, radius, 0, 1, 1, start.x, start.y]];
    } else {
      var dAngle = (endAngle - startAngle) % (PI * 2);
      var largeArc = dAngle > PI ? 1 : 0;
      path = [['M', start.x, start.y], ['A', radius, radius, 0, largeArc, 1, end.x, end.y]];
    }

    var arcShape = group.addShape('path', {
      zIndex: self.get('zIndex'),
      attrs: Util.mix({
        path: path
      }, self.get('style'))
    });
    arcShape.name = 'guide-arc';
    self.get('appendInfo') && arcShape.setSilent('appendInfo', self.get('appendInfo'));
    self.set('el', arcShape);
  };

  return Arc;
}(Guide);

module.exports = Arc;