function _assertThisInitialized(self) { if (self === void 0) { throw new ReferenceError("this hasn't been initialised - super() hasn't been called"); } return self; }

function _inheritsLoose(subClass, superClass) { subClass.prototype = Object.create(superClass.prototype); subClass.prototype.constructor = subClass; _setPrototypeOf(subClass, superClass); }

function _setPrototypeOf(o, p) { _setPrototypeOf = Object.setPrototypeOf || function _setPrototypeOf(o, p) { o.__proto__ = p; return o; }; return _setPrototypeOf(o, p); }

/**
 * @fileOverview Chart、View、Geometry 的基类
 * @author dxq613@gmail.com
 */
var EventEmitter = require('wolfy87-eventemitter');

var Util = require('./util');

var Base = /*#__PURE__*/function (_EventEmitter) {
  _inheritsLoose(Base, _EventEmitter);

  var _proto = Base.prototype;

  _proto.getDefaultCfg = function getDefaultCfg() {
    return {};
  };

  function Base(cfg) {
    var _this;

    _this = _EventEmitter.call(this) || this;

    var self = _assertThisInitialized(_this);

    var attrs = {
      visible: true
    };
    var defaultCfg = self.getDefaultCfg();
    self._attrs = attrs;
    Util.deepMix(attrs, defaultCfg, cfg);
    return _this;
  }

  _proto.get = function get(name) {
    return this._attrs[name];
  };

  _proto.set = function set(name, value) {
    this._attrs[name] = value;
  }
  /**
   * @protected
   * @param {Boolean} visible 是否可见
   * 显示、隐藏
   */
  ;

  _proto.changeVisible = function changeVisible() {};

  _proto.destroy = function destroy() {
    var self = this;
    self._attrs = {};
    self.removeAllListeners();
    self.destroyed = true;
  };

  return Base;
}(EventEmitter);

module.exports = Base;