function _inheritsLoose(subClass, superClass) { subClass.prototype = Object.create(superClass.prototype); subClass.prototype.constructor = subClass; _setPrototypeOf(subClass, superClass); }

function _setPrototypeOf(o, p) { _setPrototypeOf = Object.setPrototypeOf || function _setPrototypeOf(o, p) { o.__proto__ = p; return o; }; return _setPrototypeOf(o, p); }

var Util = require('../util');

var Base = require('./base');

var MatrixUtil = Util.MatrixUtil,
    PathUtil = Util.PathUtil;
var vec2 = MatrixUtil.vec2;

var Polyline = /*#__PURE__*/function (_Base) {
  _inheritsLoose(Polyline, _Base);

  function Polyline() {
    return _Base.apply(this, arguments) || this;
  }

  var _proto = Polyline.prototype;

  _proto.getDefaultCfg = function getDefaultCfg() {
    var cfg = _Base.prototype.getDefaultCfg.call(this);

    return Util.mix({}, cfg, {
      type: 'polyline'
    });
  };

  _proto.getLinePath = function getLinePath() {
    var self = this;
    var tickPoints = self.get('tickPoints');
    var start = self.get('start');
    var end = self.get('end');
    var points = [];
    points.push(start.x);
    points.push(start.y);
    Util.each(tickPoints, function (tick) {
      points.push(tick.x);
      points.push(tick.y);
    });
    points.push(end.x);
    points.push(end.y);
    var path = PathUtil.catmullRomToBezier(points);
    path.unshift(['M', start.x, start.y]);
    return path;
  };

  _proto.getTickPoint = function getTickPoint(value, index) {
    var tickPoints = this.get('tickPoints');
    return tickPoints[index];
  };

  _proto.getTickEnd = function getTickEnd(start, value, index) {
    var self = this;
    var lineAttrs = self.get('tickLine');
    var tickLength = value ? value : lineAttrs.length;
    var offsetVector = self.getSideVector(tickLength, start, index);
    return {
      x: start.x + offsetVector[0],
      y: start.y + offsetVector[1]
    };
  };

  _proto.getSideVector = function getSideVector(offset, point, index) {
    var self = this;
    var preTickPoint;

    if (index === 0) {
      preTickPoint = self.get('start');

      if (preTickPoint.x === point.x && preTickPoint.y === point.y) {
        return [0, 0];
      }
    } else {
      var tickPoints = self.get('tickPoints');
      preTickPoint = tickPoints[index - 1];
    }

    var vector = [point.x - preTickPoint.x, point.y - preTickPoint.y];
    var normal = vec2.normalize([], vector);
    var verticalVector = vec2.vertical([], normal, false);
    return vec2.scale([], verticalVector, offset);
  };

  return Polyline;
}(Base);

module.exports = Polyline;