function _inheritsLoose(subClass, superClass) { subClass.prototype = Object.create(superClass.prototype); subClass.prototype.constructor = subClass; _setPrototypeOf(subClass, superClass); }

function _setPrototypeOf(o, p) { _setPrototypeOf = Object.setPrototypeOf || function _setPrototypeOf(o, p) { o.__proto__ = p; return o; }; return _setPrototypeOf(o, p); }

var Base = require('./base');

var Util = require('../util');

var MatrixUtil = Util.MatrixUtil;
var vec2 = MatrixUtil.vec2;

var Line = /*#__PURE__*/function (_Base) {
  _inheritsLoose(Line, _Base);

  function Line() {
    return _Base.apply(this, arguments) || this;
  }

  var _proto = Line.prototype;

  _proto.getDefaultCfg = function getDefaultCfg() {
    var cfg = _Base.prototype.getDefaultCfg.call(this);

    return Util.mix({}, cfg, {
      x: null,
      // @type {Number} 距离初始位置的x轴偏移量,仅对于左侧、右侧的纵向坐标有效
      y: null,
      // @type {Number} 距离初始位置的y轴偏移量，仅对顶部、底部的横向坐标轴有效
      line: {
        // @type {Attrs} 坐标轴线的图形属性,如果设置成null，则不显示轴线
        lineWidth: 1,
        stroke: '#C0D0E0'
      },
      tickLine: {
        // @type {Attrs} 标注坐标线的图形属性
        lineWidth: 1,
        stroke: '#C0D0E0',
        length: 5
      },
      isVertical: false,
      start: null,
      // @type {Object} 起点
      end: null // @type {Object} 终点

    });
  };

  _proto._getAvgLabelLength = function _getAvgLabelLength(labelRenderer) {
    var labels = labelRenderer.get('group').get('children');
    return labels[1].attr('x') - labels[0].attr('x');
  };

  _proto._getAvgLabelHeightSpace = function _getAvgLabelHeightSpace(labelRenderer) {
    var labels = labelRenderer.get('group').get('children');
    return labels[1].attr('y') - labels[0].attr('y');
  }
  /**
   * 获取距离坐标轴的向量
   * @override
   * @param  {Number} offset 偏移值
   * @return {Array}        返回二维向量
   */
  ;

  _proto.getSideVector = function getSideVector(offset) {
    var self = this;
    var isVertical = self.get('isVertical');
    var factor = self.get('factor'); // if (Util.isArray(offset)) {
    //   return offset.map(value => value * factor);
    // }

    if (!Util.isNumber(offset)) {
      return [0, 0];
    }

    var start = self.get('start');
    var end = self.get('end');
    var axisVector = self.getAxisVector();
    var normal = vec2.normalize([], axisVector);
    var direction = false;

    if (isVertical && start.y < end.y || !isVertical && start.x > end.x) {
      direction = true;
    }

    var verticalVector = vec2.vertical([], normal, direction);
    return vec2.scale([], verticalVector, offset * factor);
  };

  _proto.getAxisVector = function getAxisVector() {
    var start = this.get('start');
    var end = this.get('end');
    return [end.x - start.x, end.y - start.y];
  };

  _proto.getLinePath = function getLinePath() {
    var self = this;
    var start = self.get('start');
    var end = self.get('end');
    var path = [];
    path.push(['M', start.x, start.y]);
    path.push(['L', end.x, end.y]);
    return path;
  };

  _proto.getTickEnd = function getTickEnd(start, value) {
    var self = this;
    var offsetVector = self.getSideVector(value);
    return {
      x: start.x + offsetVector[0],
      y: start.y + offsetVector[1]
    };
  };

  _proto.getTickPoint = function getTickPoint(tickValue) {
    var self = this;
    var start = self.get('start');
    var end = self.get('end');
    var rangeX = end.x - start.x;
    var rangeY = end.y - start.y;
    return {
      x: start.x + rangeX * tickValue,
      y: start.y + rangeY * tickValue
    };
  };

  _proto.renderTitle = function renderTitle() {
    var self = this;
    var title = self.get('title');
    var offsetPoint = self.getTickPoint(0.5);
    var titleOffset = title.offset;

    if (Util.isNil(titleOffset)) {
      // 没有指定 offset 则自动计算
      titleOffset = 20;
      var labelsGroup = self.get('labelsGroup');

      if (labelsGroup) {
        var labelLength = self.getMaxLabelWidth(labelsGroup);
        var labelOffset = self.get('label').offset || self.get('_labelOffset');
        titleOffset += labelLength + labelOffset;
      }
    }

    var textStyle = title.textStyle;
    var cfg = Util.mix({}, textStyle);

    if (title.text) {
      var vector = self.getAxisVector(); // 坐标轴方向的向量

      if (title.autoRotate && Util.isNil(textStyle.rotate)) {
        // 自动旋转并且用户没有指定标题的旋转角度
        var angle = 0;

        if (!Util.snapEqual(vector[1], 0)) {
          // 所有水平坐标轴，文本不转置
          var v1 = [1, 0];
          var v2 = [vector[0], vector[1]];
          angle = vec2.angleTo(v2, v1, true);
        }

        cfg.rotate = angle * (180 / Math.PI);
      } else if (!Util.isNil(textStyle.rotate)) {
        // 用户设置了旋转角度就以用户设置的为准
        cfg.rotate = textStyle.rotate / 180 * Math.PI; // 将角度转换为弧度
      }

      var sideVector = self.getSideVector(titleOffset);
      var point;
      var position = title.position;

      if (position === 'start') {
        point = {
          x: this.get('start').x + sideVector[0],
          y: this.get('start').y + sideVector[1]
        };
      } else if (position === 'end') {
        point = {
          x: this.get('end').x + sideVector[0],
          y: this.get('end').y + sideVector[1]
        };
      } else {
        point = {
          x: offsetPoint.x + sideVector[0],
          y: offsetPoint.y + sideVector[1]
        };
      }

      cfg.x = point.x;
      cfg.y = point.y;
      cfg.text = title.text;
      var group = self.get('group');
      var titleShape = group.addShape('Text', {
        zIndex: 2,
        attrs: cfg
      });
      titleShape.name = 'axis-title';
      self.get('appendInfo') && titleShape.setSilent('appendInfo', self.get('appendInfo'));
    }
  };

  _proto.autoRotateLabels = function autoRotateLabels() {
    var self = this;
    var labelRenderer = self.get('labelRenderer');
    var title = self.get('title');

    if (labelRenderer) {
      var labelGroup = labelRenderer.get('group');
      var labels = labelGroup.get('children');
      var offset = self.get('label').offset;
      var append = 12;
      var titleOffset = title ? title.offset : 48;

      if (titleOffset < 0) {
        // 如果是负的的话就不旋转
        return;
      }

      var vector = self.getAxisVector(); // 坐标轴的向量，仅处理水平或者垂直的场景

      var angle;
      var maxWidth;

      if (Util.snapEqual(vector[0], 0) && title && title.text) {
        // 坐标轴垂直，由于不知道边距，只能防止跟title重合，如果title不存在，则不自动旋转
        maxWidth = self.getMaxLabelWidth(labelRenderer);

        if (maxWidth > titleOffset - offset - append) {
          angle = Math.acos((titleOffset - offset - append) / maxWidth) * -1;
        }
      } else if (Util.snapEqual(vector[1], 0) && labels.length > 1) {
        // 坐标轴水平，不考虑边距，根据最长的和平均值进行翻转
        var avgWidth = Math.abs(self._getAvgLabelLength(labelRenderer));
        maxWidth = self.getMaxLabelWidth(labelRenderer);

        if (maxWidth > avgWidth) {
          angle = Math.asin((titleOffset - offset - append) * 1.25 / maxWidth);
        }
      }

      if (angle) {
        var factor = self.get('factor');
        Util.each(labels, function (label) {
          label.rotateAtStart(angle);

          if (Util.snapEqual(vector[1], 0)) {
            if (factor > 0) {
              label.attr('textAlign', 'left');
            } else {
              label.attr('textAlign', 'right');
            }
          }
        });
      }
    }
  };

  _proto.autoHideLabels = function autoHideLabels() {
    var self = this;
    var labelRenderer = self.get('labelRenderer');
    var labelSpace;
    var tickStep;
    var append = 8;

    if (labelRenderer) {
      var labelGroup = labelRenderer.get('group');
      var labels = labelGroup.get('children');
      var vector = self.getAxisVector(); // 坐标轴的向量，仅处理水平或者垂直的场景

      if (labels.length < 2) {
        return;
      }

      if (Util.snapEqual(vector[0], 0)) {
        // 坐标轴垂直
        var maxHeight = self.getMaxLabelHeight(labelRenderer) + append;
        var avgHeight = Math.abs(self._getAvgLabelHeightSpace(labelRenderer));

        if (maxHeight > avgHeight) {
          labelSpace = maxHeight;
          tickStep = avgHeight;
        }
      } else if (Util.snapEqual(vector[1], 0) && labels.length > 1) {
        // 坐标轴水平
        var maxWidth = self.getMaxLabelWidth(labelRenderer) + append;
        var avgWidth = Math.abs(self._getAvgLabelLength(labelRenderer));

        if (maxWidth > avgWidth) {
          labelSpace = maxWidth;
          tickStep = avgWidth;
        }
      }

      if (labelSpace && tickStep) {
        var ratio = Math.ceil(labelSpace / tickStep);
        Util.each(labels, function (label, i) {
          if (i % ratio !== 0) {
            label.attr('text', '');
          }
        });
      }
    }
  };

  return Line;
}(Base);

module.exports = Line;