package com.bcxin.flink.data.webhook.tasks.datas;

import com.bcxin.event.core.definitions.KafkaTopicConnectorDefinition;
import lombok.Data;

import java.io.Serializable;
import java.util.Collection;

@Data
public class Kafka2WebHookDefinition implements Serializable {
    private String jobId;
    private String name;
    private Collection<WebHookConfigWrapper> webHookConfigs;
    private KafkaTopicConnectorDefinition topicDefinition;

    public void assignJobId(String jobId) {
        this.jobId = jobId;
    }

    @Data
    public static class WebHookConfigWrapper implements Serializable {
        /**
         * WebHook 标题
         */
        private String title;

        /**
         * kafka的主题信息()
         */
        private String topic;

        /**
         * webhook API
         */
        private WebHoodApiDefinition apiDefinition;
    }
}
