package com.bcxin.flink.data.webhook.tasks.components;

import com.bcxin.event.core.JsonProvider;
import com.bcxin.event.core.JsonProviderImpl;
import com.bcxin.event.core.exceptions.NoSupportEventException;
import com.bcxin.flink.data.webhook.tasks.datas.WebHoodApiDefinition;
import com.bcxin.flink.streaming.cores.dtos.DebeziumJsonNodeDto;
import org.apache.http.HttpStatus;
import org.apache.http.StatusLine;
import org.apache.http.client.methods.*;
import org.apache.http.entity.AbstractHttpEntity;
import org.apache.http.entity.StringEntity;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClients;
import org.apache.http.util.EntityUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StringUtils;

import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.util.*;
import java.util.stream.Collectors;

public class WebHookClientUtils {
    private static final Logger logger = LoggerFactory.getLogger(WebHookClientUtils.class);

    private static CloseableHttpClient httpClient = HttpClients.createDefault();

    public static boolean doExecute(Collection<DebeziumJsonNodeDto> values,
                                    WebHoodApiDefinition apiDefinition) throws IOException {
        if (CollectionUtils.isEmpty(values)) {
            return false;
        }

        String body = null;
        try {
            JsonProvider jsonProvider = new JsonProviderImpl();
            if (apiDefinition.getBodyJsonTemplate().contains("#{after:json}")) {
                for (DebeziumJsonNodeDto value : values) {
                    Map mapBodyMap = jsonProvider.toObject(Map.class, apiDefinition.getBodyJsonTemplate());
                    Map contentMap = new HashMap();
                    Iterator<String> iterable = value.getAfter().fieldNames();
                    while (iterable.hasNext()) {
                        String name = iterable.next();
                        contentMap.put(name, value.getAfter().get(name).asText());
                    }
                    mapBodyMap.put("content", jsonProvider.getJson(contentMap, true));

                    body = jsonProvider.getJson(mapBodyMap);
                    doExecute(apiDefinition, 1, body, jsonProvider);
                }
            } else {
                String batchValue =
                        values.stream().map(ix -> String.format("\"%s\"", ix.getKey()))
                                .collect(Collectors.joining(","));

                body = apiDefinition.getBodyJsonTemplate().replace("\"#{after.id}\"", batchValue);

                DebeziumJsonNodeDto value = values.stream().findFirst().get();

                if (value.getSource().get("table").asText().equalsIgnoreCase("rd_security_station_person_summary")) {
                    body = generateBodyFromTemplate(values, apiDefinition);
                }

                doExecute(apiDefinition, values.size(), body, jsonProvider);
            }

            return true;
        } catch (Exception ex) {
            ex.printStackTrace();

            logger.error(String.format("WebHookClientUtils.doExecute: body=%s;ids=%s", body, values.stream().filter(ii -> ii != null && StringUtils.hasLength(ii.getKey())).map(ix -> ix.getKey()).collect(Collectors.joining(","))));
            throw ex;
        }
    }

    private static String generateBodyFromTemplate(Collection<DebeziumJsonNodeDto> values, WebHoodApiDefinition apiDefinition) {


        if (true) {
            Map<String, Object> params = new HashMap<>();
            params.put("dataType", "StationPersonRelative");


            Map<String, Collection<String>> request = new HashMap<>();
            /*
            request.put("stationIds", Collections.singleton(value.getAfter().get("security_station_id").asText()));
            request.put("employeeIds", Collections.singleton(value.getAfter().get("employee_id").asText()));
             */
            Collection<String> stationIds = values.stream().map(ix -> ix.getAfter().get("security_station_id").asText()).collect(Collectors.toList());
            Collection<String> employeeIds = values.stream().map(ix -> ix.getAfter().get("employee_id").asText()).collect(Collectors.toList());
            request.put("stationIds", stationIds);
            request.put("employeeIds", employeeIds);
            params.put("stationPersonRequest", request);

            Map<String, Collection> dtContent = new HashMap<>();
            dtContent.put("contents", Collections.singleton(params));
            JsonProvider jsonProvider = new JsonProviderImpl();
            String data = jsonProvider.getJson(dtContent);

            return data;
        }

        /*
        Map<String, DebeziumJsonNodeDto> map = new HashMap<>();
        map.put("root", value);
        String body = FreemarkerUtils.processTemplate(apiDefinition.getBodyJsonTemplate(), map);
        return body;
         */
        return null;
    }

    private static boolean doExecute(WebHoodApiDefinition apiDefinition,int size, String body,JsonProvider jsonProvider) throws IOException {
        HttpRequestBase requestBase = null;
        logger.warn("开始执行如下请求:{} 参数:{}", apiDefinition.getApi(), body);
        switch (apiDefinition.getMethod()) {
            case GET: {
                requestBase = new HttpGet(apiDefinition.getApi());
            }
            break;
            case PUT: {
                requestBase = new HttpPut(apiDefinition.getApi());
            }
            break;
            case POST: {
                HttpPost post = new HttpPost(apiDefinition.getApi());
                AbstractHttpEntity httpEntity = new StringEntity(body, "UTF-8");
                httpEntity.setContentEncoding(StandardCharsets.UTF_8.toString());
                httpEntity.setContentEncoding("application/json");
                post.setEntity(httpEntity);
                requestBase = post;
            }
            break;
            case DELETE: {
                requestBase = new HttpDelete(apiDefinition.getApi());
            }
            break;
            default:
                throw new NoSupportEventException();
        }

        Map<String, String> headerTemplate = jsonProvider.toObject(Map.class, apiDefinition.getHeaderJsonTemplate());
        if (headerTemplate != null) {
            for (String key : headerTemplate.keySet()) {
                requestBase.addHeader(key, headerTemplate.get(key));
            }
        } else {
            requestBase.addHeader("Content-Type", "application/json");
        }

        try (CloseableHttpResponse response = httpClient.execute(requestBase)) {
            StatusLine statusLine = response.getStatusLine();

            if (statusLine.getStatusCode() != HttpStatus.SC_OK) {
                String content = EntityUtils.toString(response.getEntity());
                logger.error("{}: 执行结束(总数量={}):{} 失败-状态:{} 请求-{}; 响应:{}",
                        Thread.currentThread().getId(),
                        size,
                        apiDefinition.getApi(),
                        statusLine.getStatusCode(),
                        body,
                        content);
            } else {
                logger.error("{}: 成功-执行结束(总数量={}):{} 参数={} Ok-响应:{}",
                        Thread.currentThread().getId(),
                        size,
                        apiDefinition.getApi(), body, statusLine.getStatusCode());
            }

            return statusLine.getStatusCode() == HttpStatus.SC_OK;
        }
    }
}
