package com.bcxin.flink.data.webhook.tasks.components;

import com.bcxin.flink.streaming.cores.dtos.DebeziumJsonNodeDto;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.util.CollectionUtils;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.concurrent.CyclicBarrier;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.TimeUnit;
import com.bcxin.flink.data.webhook.tasks.datas.WebHoodApiDefinition;

public class MultiThreadConsumerClient implements Runnable{
    private static final Logger logger = LoggerFactory.getLogger(MultiThreadConsumerClient.class);

    private final LinkedBlockingQueue<DebeziumJsonNodeDto> bufferQueue;
    private final CyclicBarrier barrier;
    private final WebHoodApiDefinition webHoodApiDefinition;

    public MultiThreadConsumerClient(LinkedBlockingQueue<DebeziumJsonNodeDto> bufferQueue,
                                     CyclicBarrier barrier, WebHoodApiDefinition webHoodApiDefinition) {
        this.bufferQueue = bufferQueue;
        this.barrier = barrier;
        this.webHoodApiDefinition = webHoodApiDefinition;
    }

    @Override
    public void run() {
        DebeziumJsonNodeDto entity;
        int MAX_BATCH_SIZE = 500;
        Collection<DebeziumJsonNodeDto> willSend=new ArrayList<>(MAX_BATCH_SIZE);
        while (true) {
            try {
                //entity = bufferQueue.poll(50, TimeUnit.MILLISECONDS);
                entity = bufferQueue.take();
                willSend.add(entity);
                int i = 0;
                while (++i < MAX_BATCH_SIZE &&
                        (entity = bufferQueue.poll(3, TimeUnit.SECONDS)) != null) { // poll是一个等待的操作，当等
                    willSend.add(entity);                                                     // 待 MAX_WAIT_TIME 后未能获
                }

                if (!CollectionUtils.isEmpty(willSend)) {
                    doExecute(willSend);
                } else {
                    if (barrier.getNumberWaiting() > 0) {
                        logger.error("MultiThreadConsumerClient 执行flush, 当前线程数:" + barrier.getNumberWaiting());
                        flush();
                        /*
                        barrier.await();
                         */
                    }
                }
            } catch (Exception ex) {
                ex.printStackTrace();
            }
        }
    }

    /**
     * 消费端逻辑
     * @param debeziumJsonNodes
     */
    private void doExecute(Collection<DebeziumJsonNodeDto> debeziumJsonNodes) throws IOException {
        WebHookClientUtils.doExecute(debeziumJsonNodes, this.webHoodApiDefinition);
    }

    /**
     * client执行flush操作, 防止丢数据
     */
    private void flush()
    {

    }
}
