package com.bcxin.flink.data.webhook.tasks;

import com.bcxin.event.core.FlinkJobAbstract;
import com.bcxin.event.core.JsonProvider;
import com.bcxin.event.core.JsonProviderImpl;
import com.bcxin.flink.data.webhook.tasks.datas.Kafka2WebHookDefinition;
import com.bcxin.flink.data.webhook.tasks.jobs.WebHookSinkJob;
import com.bcxin.flink.streaming.cores.AppAbstract;
import com.bcxin.flink.streaming.cores.properties.CheckpointConfigProperty;
import com.bcxin.flink.streaming.cores.properties.StreamingConfigConstants;

import java.io.IOException;
import java.util.Properties;

public class WebHookApp extends AppAbstract {
    public static void main(String[] args) throws Exception {
        System.setProperty("org.slf4j.simpleLogger.defaultLogLevel", "info");
        if (args.length < 1) {
            throw new IllegalArgumentException("配置参数不能为空");
        }
        initEnv(args);

        Kafka2WebHookDefinition definition = initStreamingJobContextAndReturnDefinition(args[1]);

        FlinkJobAbstract job = new WebHookSinkJob(definition);
        job.execute();
    }

    /**
     * 初始化参数配置
     * @param jobId
     * @throws IOException
     */
    private static Kafka2WebHookDefinition initStreamingJobContextAndReturnDefinition(String jobId) throws IOException {
        JsonProvider jsonProvider = new JsonProviderImpl();
        CheckpointConfigProperty configProperty = initCheckPointAndEnv(jsonProvider, jobId);
        Properties properties = System.getProperties();
        StreamingJobContext.init(properties.getProperty(StreamingConfigConstants.JOB_NAME), configProperty);
        String databasePropertyConf = getDatabasePropertyConfAfterInitEnv();

        Kafka2WebHookDefinition definition = jsonProvider.toObject(Kafka2WebHookDefinition.class, databasePropertyConf);
        definition.setJobId(jobId);

        return definition;
    }
}
