package com.bcxin.flink.event.job.web.apis.controllers.requests;

import com.bcxin.event.core.EventConstant;
import com.bcxin.event.core.JdbcSqlTemplateDefinition;
import com.bcxin.event.job.domain.enums.JobType;
import lombok.Data;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;

@Data
public class JobSimpleStreamRequest {
    private String name;
    private String title;
    private String description;
    private Collection<TopicJdbcDefinition> definitions;
    private boolean isOnline;

    @Data
    public static class TopicJdbcDefinition {
        private String topicName;
        private Collection<JdbcSqlTemplateDefinition> jdbcDefinitions;
    }

    public JobRequest getJobRequest(String bootStrapServer) {
        JobRequest jobRequest = new JobRequest();
        jobRequest.setName(this.getName());
        jobRequest.setJobType(JobType.STREAMING_COMPUTED);
        jobRequest.setDescription(this.getDescription());
        jobRequest.setOnline(this.isOnline());
        jobRequest.setTitle(this.getTitle());

        /**
         * param2
         */
        Map param2 = new HashMap();
        param2.put("id", this.getName());
        param2.put("name", this.getName());
        param2.put("description", this.getDescription());
        Collection<Map<String, Object>> kafka2JdbcDefinitions = new ArrayList<>();

        for (TopicJdbcDefinition topicJdbcDefinition : definitions) {
            Map<String, Object> topicJdbcMap = new HashMap<>();
            Map<String, Object> kafkaDefinition = new HashMap<>();
            kafkaDefinition.put("name", this.getName());
            kafkaDefinition.put("bootstrapServer", bootStrapServer);
            kafkaDefinition.put("topic", topicJdbcDefinition.getTopicName());
            kafkaDefinition.put("consumerGroupId", String.format("consume-kafka:%s", this.getName()));
            kafkaDefinition.put("autoOffsetRest", "earliest");
            kafkaDefinition.put("scanStartupMode", "group-offsets");
            kafkaDefinition.put("enableAutoCommit", "true");
            kafkaDefinition.put("primaryKeyName", "ID");

            topicJdbcMap.put("kafkaDefinition", kafkaDefinition);
            topicJdbcMap.put(EventConstant.JDBC_DEFINITION_NAMES, topicJdbcDefinition.getJdbcDefinitions());

            kafka2JdbcDefinitions.add(topicJdbcMap);
        }
        param2.put("kafka2JdbcDefinitions", kafka2JdbcDefinitions);

        /**
         * param1
         */
        Map param1 = new HashMap();
        param1.put("job.name", this.getTitle());
        param1.put("checkpoint.mode", "file");
        param1.put("checkpoint.hdfs.config", "core-site-default.xml");
        param1.put("checkpoint.disk.location", String.format("/tmp/%s", this.getName()));

        jobRequest.setParam1(param1);
        jobRequest.setParam2(param2);

        return jobRequest;
    }
}
