package com.bcxin.flink.event.job.web.apis.controllers.requests;

import com.bcxin.event.core.JobExecutorParam;
import com.bcxin.event.core.JsonProvider;
import com.bcxin.event.job.domain.commands.CreateJobCommand;
import com.bcxin.event.job.domain.commands.UpdateJobCommand;
import com.bcxin.event.job.domain.enums.JobType;
import lombok.Data;

@Data
public class JobRequest {
    private String name;
    private String title;
    private JobType jobType;
    private Object param1;
    private Object param2;
    private String description;
    private boolean isOnline;

    public CreateJobCommand getCreateCommand(JsonProvider jsonProvider) {
        String param1Json = jsonProvider.getJson(this.getParam1());
        String param2Json = jsonProvider.getJson(this.getParam2());

        JobExecutorParam param = JobExecutorParam.create(param1Json, param2Json);

        return CreateJobCommand.create(name,title, isOnline, jobType, jsonProvider.getJson(param), description);
    }

    public UpdateJobCommand getUpdateCommand(JsonProvider jsonProvider,int id) {
        String param1Json = jsonProvider.getJson(this.getParam1());
        String param2Json = jsonProvider.getJson(this.getParam2());

        JobExecutorParam param = JobExecutorParam.create(param1Json, param2Json);

        return UpdateJobCommand.create(
                id,
                name,title, isOnline, jobType,
                jsonProvider.getJson(param),
                description);
    }
}
