package com.bcxin.flink.event.job.web.apis.controllers.requests;

import com.bcxin.event.core.KafkaConstants;
import com.bcxin.event.core.exceptions.BadEventException;
import lombok.Data;

@Data
public class DataBinlogTransferRequest {
    private String topic;
    private String key;
    private String value;

    public int getPartition() {
        if (this.getKey() == null) {
            return 0;
        }

        int partition =
                Math.abs(this.getKey().hashCode()) % KafkaConstants.DEFAULT_PARTITION_COUNT;

        if (partition >= KafkaConstants.DEFAULT_PARTITION_COUNT) {
            throw new BadEventException(String.format("无效分区数据:%s", partition));
        }

        return partition;
    }
}