package com.bcxin.flink.event.job.web.apis.controllers;

import com.bcxin.event.job.domain.commands.CreateJdbcDefinitionCommand;
import com.bcxin.event.job.domain.commands.UpdateJdbcDefinitionCommand;
import com.bcxin.event.job.domain.entities.JdbcDefinitionEntity;
import com.bcxin.event.job.domain.repositories.JdbcDefinitionRepository;
import com.bcxin.event.job.domain.services.JdbcDefinitionService;
import com.bcxin.flink.event.job.web.apis.controllers.requests.JdbcDefinitionRequest;
import com.bcxin.flink.event.job.web.apis.controllers.responses.JdbcResponse;
import com.bcxin.flink.event.job.web.apis.controllers.responses.TopicResponse;
import org.apache.kafka.clients.admin.AdminClient;
import org.apache.kafka.clients.admin.ListTopicsResult;
import org.apache.kafka.clients.admin.TopicListing;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.*;
import java.util.Collection;
import java.util.concurrent.ExecutionException;
import java.util.stream.Collectors;

@RestController
@RequestMapping("/source-sink")
public class SourceSinkController extends ControllerBase {
    private final AdminClient adminClient;
    private final JdbcDefinitionRepository jdbcDefinitionRepository;
    private final JdbcDefinitionService jdbcDefinitionService;

    public SourceSinkController(AdminClient adminClient,
                                JdbcDefinitionRepository jdbcDefinitionRepository,
                                JdbcDefinitionService jdbcDefinitionService) {
        this.adminClient = adminClient;
        this.jdbcDefinitionRepository = jdbcDefinitionRepository;
        this.jdbcDefinitionService = jdbcDefinitionService;
    }

    @GetMapping("/kafka")
    public ResponseEntity get() throws ExecutionException, InterruptedException {
        ListTopicsResult topicsResult = this.adminClient.listTopics();
        Collection<TopicListing> topicListings = topicsResult.listings().get();

        Collection<TopicResponse> topicResponses = topicListings.stream()
                .map(ix-> TopicResponse.create(ix.topicId().toString(),ix.name()))
                .collect(Collectors.toList());

        return this.ok(topicResponses);
    }

    @GetMapping("/jdbc")
    public ResponseEntity getJdbc() throws InterruptedException {
        Collection<JdbcDefinitionEntity> jdbcDefinitionEntities =
                this.jdbcDefinitionRepository.findAll();
        Thread.sleep(2 * 1000);
        return this.ok(jdbcDefinitionEntities.stream()
                .map(ix -> JdbcResponse.create(ix.getId(), ix.getName(), ix.getUrl(),ix.getDriveClassName(),
                        ix.getUserName(),ix.getPassword(),ix.getConnectionTimeZone()))
                .collect(Collectors.toList()));
    }

    @PostMapping("/jdbc")
    public ResponseEntity postJdbc(@RequestBody JdbcDefinitionRequest request) {
        this.jdbcDefinitionService.dispatch(CreateJdbcDefinitionCommand.create(request.getName(),
                request.getDriveClassName(),
                request.getUrl(),
                request.getUserName(),
                request.getPassword(),
                request.getConnectionTimeZone()
                )
        );

        return this.ok();
    }

    @PutMapping("/jdbc/{id}")
    public ResponseEntity putJdbc(@PathVariable Long id, @RequestBody JdbcDefinitionRequest request) {
        this.jdbcDefinitionService.dispatch(
                UpdateJdbcDefinitionCommand.create(id, request.getName(),
                        request.getDriveClassName(),
                        request.getUrl(),
                        request.getUserName(),
                        request.getPassword(),
                        request.getconnectionTimeZone()
                )
        );

        return this.ok();
    }
}
