package com.bcxin.flink.event.job.web.apis.controllers;

import com.bcxin.event.core.JsonProvider;
import com.bcxin.event.core.exceptions.NoSupportEventException;
import com.bcxin.event.job.domain.entities.JobEntity;
import com.bcxin.event.job.domain.enums.JobType;
import com.bcxin.event.job.domain.repositories.JobRepository;
import com.bcxin.flink.event.job.web.apis.configs.FlinkConfig;
import com.bcxin.flink.event.job.web.apis.controllers.requests.JobJarRunRequest;
import com.bcxin.flink.event.job.web.apis.controllers.responses.JobJarResponse;
import org.apache.http.HttpEntity;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.entity.SerializableEntity;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClientBuilder;
import org.apache.http.util.EntityUtils;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.*;

import java.io.IOException;
import java.util.Optional;

@RestController
@RequestMapping("/jobs")
public class JobController extends ControllerBase {
    private final FlinkConfig flinkConfig;
    private final JsonProvider jsonProvider;
    private final JobRepository jobRepository;

    public JobController(FlinkConfig flinkConfig, JsonProvider jsonProvider,
                         JobRepository jobRepository) {
        this.flinkConfig = flinkConfig;
        this.jsonProvider = jsonProvider;
        this.jobRepository = jobRepository;
    }


    @GetMapping("/jars")
    public ResponseEntity getJars() throws IOException {

        JobJarResponse jobJarResponse = getJobJarResponse();

        return this.ok(jobJarResponse);
    }

    @PostMapping("/jar-run/{id}")
    public ResponseEntity doRun(@PathVariable int id) throws IOException {
        ///jars/268d3289-563b-45c2-8a01-c0804c4a9b3a_flink-streaming-computing-task-1.0.0-2.0.jar/run?entry-class=com.bcxin.flink.streaming.computing.task.StreamingJobApp&program-args=te%2047
        //{"entryClass":"com.bcxin.flink.streaming.computing.task.StreamingJobApp","parallelism":null,"programArgs":"te 47","savepointPath":null,"allowNonRestoredState":null}
        JobEntity jobEntity = this.jobRepository.getById(id);
        if (jobEntity == null) {
            return this.noFound();
        }

        if (jobEntity.getJobType() != JobType.STREAMING_COMPUTED) {
            throw new NoSupportEventException();
        }

        Optional<JobJarResponse.JobJarResponseFile> jobJarResponseFileOptional =
                getJobJarResponse().getFiles().stream().filter(ix -> ix.getName().contains("flink-streaming-computing-task")).findFirst();

        if (!jobJarResponseFileOptional.isPresent()) {
            throw new NoSupportEventException("找不对对应的Job类型");
        }

        String env = flinkConfig.getEnv();
        CloseableHttpClient httpClient = HttpClientBuilder.create().build();
        String webApi = String.format("%s/jars/%s/run?entry-class=com.bcxin.flink.streaming.computing.task.StreamingJobApp&program-args=%s",
                flinkConfig.getBaseApi(),
                jobJarResponseFileOptional.get().getId(),
                env.concat("%20").concat(String.valueOf(id)));

        HttpPost httpPost = new HttpPost(webApi);
        JobJarRunRequest jobJarRunRequest =
                JobJarRunRequest.create("com.bcxin.flink.streaming.computing.task.StreamingJobApp",
                        null, env.concat(" ").concat(String.valueOf(id)),
                        null, null);

        HttpEntity body = new SerializableEntity(jobJarRunRequest);
        httpPost.setEntity(body);
        try (CloseableHttpResponse httpResponse = httpClient.execute(httpPost)) {
            if (httpResponse.getStatusLine().getStatusCode() == 200) {
                return this.ok(EntityUtils.toString(httpResponse.getEntity()));
            } else {
                return this.error(EntityUtils.toString(httpResponse.getEntity()));
            }
        }
    }

    private JobJarResponse getJobJarResponse() throws IOException {
        FlinkConfig config = this.flinkConfig;
        CloseableHttpClient httpClient = HttpClientBuilder.create().build();
        HttpGet httpGet = new HttpGet(flinkConfig.getBaseApi().concat("/jars"));

        try (CloseableHttpResponse response = httpClient.execute(httpGet)) {
            String responseJson = EntityUtils.toString(response.getEntity());
            JobJarResponse jobJarResponse = this.jsonProvider.toObject(JobJarResponse.class, responseJson);

            return jobJarResponse;
        }
    }
}
