package com.bcxin.flink.event.job.web.apis.controllers;

import com.bcxin.event.core.KafkaConstants;
import com.bcxin.flink.event.job.web.apis.controllers.requests.BatchDataBinlogTransferRequest;
import org.apache.kafka.clients.admin.CreateTopicsResult;
import org.apache.kafka.clients.admin.KafkaAdminClient;
import org.apache.kafka.clients.admin.NewTopic;
import org.apache.kafka.clients.producer.ProducerRecord;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.http.ResponseEntity;
import org.springframework.kafka.core.KafkaTemplate;
import org.springframework.util.CollectionUtils;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

import java.util.Collection;
import java.util.stream.Collectors;

@RestController
@RequestMapping("/data-binlog-transfer")
public class DataBinlogTransferSinkController extends ControllerBase {

    private static final Logger logger = LoggerFactory.getLogger(DataBinlogTransferSinkController.class);

    private final KafkaTemplate<String, String> kafkaTemplate;
    private final KafkaAdminClient kafkaAdminClient;

    public DataBinlogTransferSinkController(KafkaTemplate<String, String> kafkaTemplate,
                                            KafkaAdminClient kafkaAdminClient) {
        this.kafkaTemplate = kafkaTemplate;
        this.kafkaAdminClient = kafkaAdminClient;
    }

    @PostMapping
    public ResponseEntity post(@RequestBody BatchDataBinlogTransferRequest request) {
        this.ensureTopic(request);

        request.getItems().forEach(ri -> {
            ProducerRecord<String, String> record =
                    new ProducerRecord<>(ri.getTopic(), ri.getPartition(), ri.getKey(), ri.getValue());
            this.kafkaTemplate.send(record);
        });

        return this.ok();
    }


    private void ensureTopic(BatchDataBinlogTransferRequest request) {
        try {
            if (CollectionUtils.isEmpty(request.getItems())) {
                return;
            }

            Collection<NewTopic> topics =
                    request.getItems().stream().map(ix ->
                                    new NewTopic(ix.getTopic(),
                                            KafkaConstants.DEFAULT_PARTITION_COUNT,
                                            (short) 0))
                            .collect(Collectors.toList());

            CreateTopicsResult result =
                    this.kafkaAdminClient
                            .createTopics(topics);

            logger.error("完成确保主题信息:{}", topics.stream().map(ix -> ix.name()).collect(Collectors.joining(";")));
        } catch (Exception ex) {
            ex.printStackTrace();
            logger.error("确保主题信息存在", ex);
        }
    }
}
