package com.bcxin.flink.event.job.web.apis.controllers;

import com.bcxin.flink.event.job.web.apis.controllers.responses.ResourceResponse;
import org.springframework.http.ResponseEntity;

public abstract class ControllerBase {
    protected ResponseEntity ok(Object data) {
        return ResponseEntity.ok(ResourceResponse.create(data));
    }

    protected ResponseEntity error(String msg) {
        return ResponseEntity.ok(ResourceResponse.createError(msg));
    }

    protected ResponseEntity ok() {
        return ResponseEntity.ok(ResourceResponse.createOk());
    }

    protected ResponseEntity noFound() {
        return ResponseEntity.notFound().build();
    }
}