package com.bcxin.flink.event.job.web.apis.configs;

import lombok.Data;
import org.springframework.boot.context.properties.ConfigurationProperties;
import org.springframework.context.annotation.Configuration;

import java.util.Collection;

@Configuration
@Data
@ConfigurationProperties(prefix = "spring.jdbc")
public class JdbcPropertyConfig {

    public Collection<JdbcItemProperty> definitions;

    @Data
    public static class JdbcItemProperty {
        private String name;
        private String code;
        private String driveClassName;
        private String url;
        private String userName;
        private String password;
    }
}
