package com.bcxin.flink.event.job.web.apis.configs;

import com.bcxin.event.core.JsonProvider;
import com.bcxin.event.core.JsonProviderImpl;
import com.bcxin.event.core.exceptions.EventExceptionCoreAbstract;
import com.bcxin.event.job.domain.repositories.JdbcDefinitionRepository;
import com.bcxin.event.job.domain.repositories.JobRepository;
import com.bcxin.event.job.domain.services.JdbcDefinitionService;
import com.bcxin.event.job.domain.services.JobService;
import com.bcxin.event.job.domain.services.impls.JdbcDefinitionServiceImpl;
import com.bcxin.event.job.domain.services.impls.JobServiceImpl;
import com.bcxin.flink.event.job.web.apis.controllers.responses.ResourceResponse;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.http.HttpStatus;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.ControllerAdvice;
import org.springframework.web.bind.annotation.ExceptionHandler;
import org.springframework.web.bind.annotation.ResponseBody;

import javax.servlet.http.HttpServletResponse;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.StringWriter;

@ControllerAdvice
@Configuration
public class EventJobConfig {
    @Bean
    public JobService jobService(JobRepository jobRepository,JsonProvider jsonProvider,JdbcDefinitionRepository jdbcDefinitionRepository) {
        return new JobServiceImpl(jobRepository, jsonProvider, jdbcDefinitionRepository);
    }

    @Bean
    public JdbcDefinitionService jdbcDefinitionService(JdbcDefinitionRepository jdbcDefinitionRepository)
    {
        return new JdbcDefinitionServiceImpl(jdbcDefinitionRepository);
    }

    @Bean
    public JsonProvider jsonProvider() {
        return new JsonProviderImpl();
    }


    @ResponseBody
    @ExceptionHandler
    public ResponseEntity error(Exception ex,HttpServletResponse servletResponse) throws IOException {
        StringWriter stringWriter = new StringWriter();
        try (PrintWriter printWriter = new PrintWriter(stringWriter)) {
            ex.printStackTrace(printWriter);
        }
        String error = stringWriter.toString();
        ResourceResponse data = null;
        if (EventExceptionCoreAbstract.class.isAssignableFrom(ex.getClass())) {
            data = ResourceResponse.createError(ex.getMessage(), error);
        } else {
            data = ResourceResponse.createError("系统异常, 请联系管理员", error);
        }

        return ResponseEntity.status(HttpStatus.BAD_REQUEST).body(data);
    }
}
