package com.bcxin.data.event.transfer.web.apis.configs;

import lombok.Data;
import org.apache.kafka.clients.admin.AdminClient;
import org.apache.kafka.clients.admin.KafkaAdminClient;
import org.springframework.boot.context.properties.ConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

import java.util.Properties;

@Data
@Configuration
@ConfigurationProperties(prefix = "spring.kafka")
public class KafkaConfig {
    private String bootstrapServers;

    @Bean
    public AdminClient adminClient() {
        Properties properties = new Properties();
        properties.setProperty("bootstrap.servers", this.getBootstrapServers());

        return KafkaAdminClient.create(properties);
    }
}
