/*
 * Decompiled with CFR 0.152.
 */
package com.bcxin.event.job.core.domain.dtos;

import com.bcxin.event.core.utils.StringUtils;
import com.bcxin.event.job.core.domain.documents.enums.DocumentType;
import java.io.Serializable;
import java.util.Map;

public class BinlogMapDTO
implements Serializable {
    private String db;
    private String table;
    private DocumentType documentType;
    private String id;
    private String domainId;
    private long syncVersion;
    private Map<String, String> before;
    private Map<String, String> content;

    public boolean isNewVersion(String currentTsVersion) {
        long cVersion = 0L;
        try {
            if (StringUtils.hasAlpha((String)currentTsVersion)) {
                System.err.println(String.format("\u65e0\u6548\u7248\u672c\u4fe1\u606f=%s", cVersion));
                return true;
            }
            cVersion = Long.parseLong(currentTsVersion);
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        return this.getSyncVersion() >= cVersion - 30L;
    }

    public static BinlogMapDTO create(String db, String table, String domainId, String id, long syncVersion, DocumentType documentType, Map<String, String> content, Map<String, String> changedBefore) {
        BinlogMapDTO binlogMapDTO = new BinlogMapDTO();
        binlogMapDTO.setDb(db);
        binlogMapDTO.setTable(table);
        binlogMapDTO.setDocumentType(documentType);
        binlogMapDTO.setContent(content);
        binlogMapDTO.setBefore(changedBefore);
        binlogMapDTO.setSyncVersion(syncVersion);
        binlogMapDTO.setDomainId(domainId);
        binlogMapDTO.setId(id);
        return binlogMapDTO;
    }

    public String getDb() {
        return this.db;
    }

    public String getTable() {
        return this.table;
    }

    public DocumentType getDocumentType() {
        return this.documentType;
    }

    public String getId() {
        return this.id;
    }

    public String getDomainId() {
        return this.domainId;
    }

    public long getSyncVersion() {
        return this.syncVersion;
    }

    public Map<String, String> getBefore() {
        return this.before;
    }

    public Map<String, String> getContent() {
        return this.content;
    }

    public void setDb(String db) {
        this.db = db;
    }

    public void setTable(String table) {
        this.table = table;
    }

    public void setDocumentType(DocumentType documentType) {
        this.documentType = documentType;
    }

    public void setId(String id) {
        this.id = id;
    }

    public void setDomainId(String domainId) {
        this.domainId = domainId;
    }

    public void setSyncVersion(long syncVersion) {
        this.syncVersion = syncVersion;
    }

    public void setBefore(Map<String, String> before) {
        this.before = before;
    }

    public void setContent(Map<String, String> content) {
        this.content = content;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof BinlogMapDTO)) {
            return false;
        }
        BinlogMapDTO other = (BinlogMapDTO)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.getSyncVersion() != other.getSyncVersion()) {
            return false;
        }
        String this$db = this.getDb();
        String other$db = other.getDb();
        if (this$db == null ? other$db != null : !this$db.equals(other$db)) {
            return false;
        }
        String this$table = this.getTable();
        String other$table = other.getTable();
        if (this$table == null ? other$table != null : !this$table.equals(other$table)) {
            return false;
        }
        DocumentType this$documentType = this.getDocumentType();
        DocumentType other$documentType = other.getDocumentType();
        if (this$documentType == null ? other$documentType != null : !this$documentType.equals(other$documentType)) {
            return false;
        }
        String this$id = this.getId();
        String other$id = other.getId();
        if (this$id == null ? other$id != null : !this$id.equals(other$id)) {
            return false;
        }
        String this$domainId = this.getDomainId();
        String other$domainId = other.getDomainId();
        if (this$domainId == null ? other$domainId != null : !this$domainId.equals(other$domainId)) {
            return false;
        }
        Map<String, String> this$before = this.getBefore();
        Map<String, String> other$before = other.getBefore();
        if (this$before == null ? other$before != null : !((Object)this$before).equals(other$before)) {
            return false;
        }
        Map<String, String> this$content = this.getContent();
        Map<String, String> other$content = other.getContent();
        return !(this$content == null ? other$content != null : !((Object)this$content).equals(other$content));
    }

    protected boolean canEqual(Object other) {
        return other instanceof BinlogMapDTO;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        long $syncVersion = this.getSyncVersion();
        result = result * 59 + (int)($syncVersion >>> 32 ^ $syncVersion);
        String $db = this.getDb();
        result = result * 59 + ($db == null ? 43 : $db.hashCode());
        String $table = this.getTable();
        result = result * 59 + ($table == null ? 43 : $table.hashCode());
        DocumentType $documentType = this.getDocumentType();
        result = result * 59 + ($documentType == null ? 43 : $documentType.hashCode());
        String $id = this.getId();
        result = result * 59 + ($id == null ? 43 : $id.hashCode());
        String $domainId = this.getDomainId();
        result = result * 59 + ($domainId == null ? 43 : $domainId.hashCode());
        Map<String, String> $before = this.getBefore();
        result = result * 59 + ($before == null ? 43 : ((Object)$before).hashCode());
        Map<String, String> $content = this.getContent();
        result = result * 59 + ($content == null ? 43 : ((Object)$content).hashCode());
        return result;
    }

    public String toString() {
        return "BinlogMapDTO(db=" + this.getDb() + ", table=" + this.getTable() + ", documentType=" + this.getDocumentType() + ", id=" + this.getId() + ", domainId=" + this.getDomainId() + ", syncVersion=" + this.getSyncVersion() + ", before=" + this.getBefore() + ", content=" + this.getContent() + ")";
    }
}

