/*
 * Decompiled with CFR 0.152.
 */
package com.bcxin.event.core.definitions;

import com.bcxin.event.core.definitions.JdbcConnectorDefinition;
import com.bcxin.event.core.definitions.TableDefinitionAbstract;
import com.bcxin.event.core.metas.TableMeta;
import java.util.Collection;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JdbcTableDefinition
extends TableDefinitionAbstract {
    private static final Logger logger = LoggerFactory.getLogger(JdbcTableDefinition.class);
    private JdbcConnectorDefinition connector;
    private String definitionSql;
    private Collection<String> autoGeneratedDefinitionSql;

    @Override
    public String getSql() {
        if (this.getConnector() == null) {
            throw new IllegalArgumentException("JdbcTableDefinition\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (this.getDefinitionSql() == null) {
            throw new IllegalArgumentException(String.format("JdbcTableDefinition(%s)\u7684definitionSql\u4e0d\u80fd\u4e3a\u7a7a", this.getConnector().getUrl()));
        }
        return String.format("%s WITH (%s)", this.getDefinitionSql(), this.getConnector().getJdbcDefinitionMeta());
    }

    public void build(TableMeta tableMeta) {
        if (this.getConnector() == null) {
            throw new IllegalArgumentException("JdbcTableDefinition\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (StringUtils.isEmpty((CharSequence)this.getDefinitionSql())) {
            logger.warn("JdbcTableDefinition({})\u7684definitionSql\u4e0d\u80fd\u4e3a\u7a7a", (Object)this.getConnector().getUrl());
            return;
        }
    }

    public JdbcConnectorDefinition getConnector() {
        return this.connector;
    }

    public String getDefinitionSql() {
        return this.definitionSql;
    }

    public void setConnector(JdbcConnectorDefinition connector) {
        this.connector = connector;
    }

    public void setDefinitionSql(String definitionSql) {
        this.definitionSql = definitionSql;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof JdbcTableDefinition)) {
            return false;
        }
        JdbcTableDefinition other = (JdbcTableDefinition)o;
        if (!other.canEqual(this)) {
            return false;
        }
        JdbcConnectorDefinition this$connector = this.getConnector();
        JdbcConnectorDefinition other$connector = other.getConnector();
        if (this$connector == null ? other$connector != null : !((Object)this$connector).equals(other$connector)) {
            return false;
        }
        String this$definitionSql = this.getDefinitionSql();
        String other$definitionSql = other.getDefinitionSql();
        if (this$definitionSql == null ? other$definitionSql != null : !this$definitionSql.equals(other$definitionSql)) {
            return false;
        }
        Collection<String> this$autoGeneratedDefinitionSql = this.getAutoGeneratedDefinitionSql();
        Collection<String> other$autoGeneratedDefinitionSql = other.getAutoGeneratedDefinitionSql();
        return !(this$autoGeneratedDefinitionSql == null ? other$autoGeneratedDefinitionSql != null : !((Object)this$autoGeneratedDefinitionSql).equals(other$autoGeneratedDefinitionSql));
    }

    protected boolean canEqual(Object other) {
        return other instanceof JdbcTableDefinition;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        JdbcConnectorDefinition $connector = this.getConnector();
        result = result * 59 + ($connector == null ? 43 : ((Object)$connector).hashCode());
        String $definitionSql = this.getDefinitionSql();
        result = result * 59 + ($definitionSql == null ? 43 : $definitionSql.hashCode());
        Collection<String> $autoGeneratedDefinitionSql = this.getAutoGeneratedDefinitionSql();
        result = result * 59 + ($autoGeneratedDefinitionSql == null ? 43 : ((Object)$autoGeneratedDefinitionSql).hashCode());
        return result;
    }

    public String toString() {
        return "JdbcTableDefinition(connector=" + this.getConnector() + ", definitionSql=" + this.getDefinitionSql() + ", autoGeneratedDefinitionSql=" + this.getAutoGeneratedDefinitionSql() + ")";
    }

    private Collection<String> getAutoGeneratedDefinitionSql() {
        return this.autoGeneratedDefinitionSql;
    }

    private void setAutoGeneratedDefinitionSql(Collection<String> autoGeneratedDefinitionSql) {
        this.autoGeneratedDefinitionSql = autoGeneratedDefinitionSql;
    }
}

