/*
 * Decompiled with CFR 0.152.
 */
package com.zbkj.common.utils;

import com.zbkj.common.exception.CrmebException;
import com.zbkj.common.utils.UploadUtil;
import com.zbkj.common.vo.ImageMergeUtilVo;
import java.awt.Graphics;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URL;
import java.net.URLConnection;
import java.util.List;
import javax.imageio.ImageIO;
import org.apache.commons.lang3.StringUtils;
import org.springframework.stereotype.Component;

@Component
public class ImageMergeUtil {
    public static BufferedImage bufferedImage;
    public static String model;
    public static String ext;

    public static String drawWordFile(List<ImageMergeUtilVo> list) {
        ImageMergeUtil.buildImage(list);
        if (bufferedImage == null) {
            return null;
        }
        try {
            UploadUtil.setModelPath(model);
            UploadUtil.setExtStr(ext);
            String newFileName = UploadUtil.fileName(ext);
            String destPath = UploadUtil.getDestPath(newFileName);
            File file = UploadUtil.createFile(destPath);
            ImageIO.write((RenderedImage)bufferedImage, ext, file);
            return destPath;
        }
        catch (IOException ex) {
            ex.printStackTrace();
            return null;
        }
    }

    private static void drawImage(ImageMergeUtilVo imageMergeUtilVo) {
        String fileName = ImageMergeUtil.getFileSource(imageMergeUtilVo.getPath());
        if (StringUtils.isBlank((CharSequence)fileName)) {
            return;
        }
        try {
            File file = new File(fileName);
            BufferedImage read = ImageIO.read(file);
            if (bufferedImage == null || bufferedImage.equals("")) {
                imageMergeUtilVo.setX(0);
                imageMergeUtilVo.setY(0);
                bufferedImage = new BufferedImage(read.getWidth(), read.getHeight(), 4);
            }
            Graphics graphics = bufferedImage.getGraphics();
            graphics.drawImage(read, imageMergeUtilVo.getX(), imageMergeUtilVo.getX(), read.getWidth(), read.getHeight(), null);
            file.delete();
        }
        catch (Exception e) {
            throw new CrmebException("\u5408\u6210\u56fe\u7247 + " + fileName + "\u5931\u8d25");
        }
    }

    private static void buildImage(List<ImageMergeUtilVo> list) {
        if (list.size() < 2) {
            throw new CrmebException("\u81f3\u5c11\u9700\u89812\u5f20\u56fe\u7247\u624d\u53ef\u4ee5\u505a\u5408\u5e76");
        }
        for (ImageMergeUtilVo imageMergeUtilVo : list) {
            ImageMergeUtil.drawImage(imageMergeUtilVo);
        }
    }

    private static String getFileSource(String url) {
        if (!url.contains("http")) {
            return url;
        }
        try {
            int len;
            URL urlInfo = new URL(url);
            URLConnection con = urlInfo.openConnection();
            InputStream is = con.getInputStream();
            byte[] bs = new byte[1024];
            String fileName = UploadUtil.fileName(ext);
            FileOutputStream os = new FileOutputStream(fileName);
            while ((len = is.read(bs)) != -1) {
                ((OutputStream)os).write(bs, 0, len);
            }
            ((OutputStream)os).close();
            is.close();
            return fileName;
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ImageMergeUtil)) {
            return false;
        }
        ImageMergeUtil other = (ImageMergeUtil)o;
        return other.canEqual(this);
    }

    protected boolean canEqual(Object other) {
        return other instanceof ImageMergeUtil;
    }

    public int hashCode() {
        boolean result = true;
        return 1;
    }

    public String toString() {
        return "ImageMergeUtil()";
    }

    static {
        model = "merge";
        ext = "jpg";
    }
}

