/*
 * Decompiled with CFR 0.152.
 */
package com.zbkj.common.utils;

import cn.hutool.core.collection.CollUtil;
import cn.hutool.core.date.DateUtil;
import cn.hutool.core.util.StrUtil;
import cn.hutool.crypto.SecureUtil;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.sun.crypto.provider.SunJCE;
import com.zbkj.common.enums.RoleEnum;
import com.zbkj.common.exception.CrmebException;
import com.zbkj.common.model.admin.SystemAdmin;
import com.zbkj.common.utils.SecurityUtil;
import java.io.UnsupportedEncodingException;
import java.math.BigDecimal;
import java.nio.charset.StandardCharsets;
import java.security.Security;
import java.text.NumberFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Base64;
import java.util.Date;
import java.util.Formatter;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.UUID;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.crypto.Cipher;
import javax.crypto.SecretKey;
import javax.crypto.spec.SecretKeySpec;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.lang3.StringUtils;

public class CrmebUtil {
    public static String encryptSign() {
        String time = DateUtil.format((Date)new Date(), (String)"yyyyMMdd");
        return CrmebUtil.encryptPassword(time, "DevDate" + time).replace("+", "").replace("/", "").replace("=", "");
    }

    public static String encryptPassword(String pwd, String key) {
        try {
            Security.addProvider(new SunJCE());
            SecretKey _key = CrmebUtil.getDESSercretKey(key);
            Cipher cipher = Cipher.getInstance("DES");
            cipher.init(1, _key);
            byte[] data = pwd.getBytes(StandardCharsets.UTF_8);
            byte[] result = cipher.doFinal(data);
            Base64.Encoder encoder = Base64.getEncoder();
            return encoder.encodeToString(result);
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new CrmebException("\u5bc6\u7801\u5904\u7406\u5f02\u5e38");
        }
    }

    public static String decryptPassowrd(String pwd, String key) throws Exception {
        Security.addProvider(new SunJCE());
        SecretKey aKey = CrmebUtil.getDESSercretKey(key);
        Cipher cipher = Cipher.getInstance("DES");
        cipher.init(2, aKey);
        Base64.Decoder decoder = Base64.getDecoder();
        byte[] data = decoder.decode(pwd);
        byte[] result = cipher.doFinal(data);
        return new String(result, StandardCharsets.UTF_8);
    }

    public static SecretKey getDESSercretKey(String key) throws UnsupportedEncodingException {
        byte[] result = new byte[8];
        byte[] keys = null;
        keys = key.getBytes(StandardCharsets.UTF_8);
        for (int i = 0; i < 8; ++i) {
            result[i] = i < keys.length ? keys[i] : (byte)1;
        }
        return new SecretKeySpec(result, "DES");
    }

    public static Map objectToMap(Object object) {
        return (Map)JSONObject.parseObject((String)JSONObject.toJSONString((Object)object), Map.class);
    }

    public static Map StringToMap(String strValue) {
        return (Map)JSONObject.parseObject((String)strValue, HashMap.class);
    }

    public static <T> T mapToObj(HashMap<String, Object> map, Class<T> clz) {
        if (map == null) {
            return null;
        }
        return (T)JSONObject.parseObject((String)JSONObject.toJSONString(map), clz);
    }

    public static <T> T mapStringToObj(HashMap<String, String> map, Class<T> clz) {
        if (map == null) {
            return null;
        }
        return (T)JSONObject.parseObject((String)JSONObject.toJSONString(map), clz);
    }

    public static void main(String[] args) throws Exception {
        System.out.println(CrmebUtil.encryptSign());
    }

    public static Map<String, Object> mergeMap(Map<String, Object> map, Map<String, Object> map1) {
        HashMap<String, Object> map2 = new HashMap<String, Object>();
        map2.putAll(map);
        map2.putAll(map1);
        return map2;
    }

    public static List<Integer> stringToArray(String str) {
        return CrmebUtil.stringToArrayByRegex(str, ",");
    }

    public static List<Integer> stringToArrayByRegex(String str, String regex) {
        ArrayList<Integer> list = new ArrayList<Integer>();
        if (str.contains(regex)) {
            String[] split;
            for (String value : split = str.split(regex)) {
                if (!StrUtil.isNotBlank((CharSequence)value)) continue;
                list.add(Integer.parseInt(value.trim()));
            }
        } else {
            list.add(Integer.parseInt(str));
        }
        return list;
    }

    public static List<String> stringToArrayStr(String str) {
        return CrmebUtil.stringToArrayStrRegex(str, ",");
    }

    public static List<Integer> stringToArrayInt(String str) {
        List<String> strings = CrmebUtil.stringToArrayStrRegex(str, ",");
        ArrayList<Integer> ids = new ArrayList<Integer>();
        for (String string : strings) {
            ids.add(Integer.parseInt(string.trim()));
        }
        return ids;
    }

    public static List<String> stringToArrayStrRegex(String str, String regex) {
        ArrayList<String> list = new ArrayList<String>();
        if (str.contains(regex)) {
            String[] split;
            for (String value : split = str.split(regex)) {
                if (!StrUtil.isNotBlank((CharSequence)value)) continue;
                list.add(value);
            }
        } else {
            list.add(str);
        }
        return list;
    }

    public static List<Object> stringToArrayObject(String str) {
        return CrmebUtil.stringToArrayObjectRegex(str, ",");
    }

    public static List<Object> stringToArrayObjectRegex(String str, String regex) {
        ArrayList<Object> list = new ArrayList<Object>();
        if (str.contains(regex)) {
            String[] split;
            for (String value : split = str.split(regex)) {
                if (!StrUtil.isNotBlank((CharSequence)value)) continue;
                list.add(value);
            }
        } else {
            list.add(str);
        }
        return list;
    }

    public static List<String> jsonToListString(String str) {
        try {
            return JSONObject.parseArray((String)str).toJavaList(String.class);
        }
        catch (Exception e) {
            ArrayList<String> list = new ArrayList<String>();
            list.add(str);
            return list;
        }
    }

    public static List<Integer> jsonToListInteger(String str) {
        try {
            return JSONObject.parseArray((String)str).toJavaList(Integer.class);
        }
        catch (Exception e) {
            ArrayList<Integer> list = new ArrayList<Integer>();
            list.add(Integer.parseInt(str));
            return list;
        }
    }

    public static List<Object> jsonToListObject(String str) {
        try {
            return JSONObject.parseArray((String)str).toJavaList(Object.class);
        }
        catch (Exception e) {
            ArrayList<Object> list = new ArrayList<Object>();
            list.add(str);
            return list;
        }
    }

    public static <T> List<T> jsonToListClass(String str, Class<T> cls) {
        try {
            return JSONObject.parseArray((String)str, cls);
        }
        catch (Exception e) {
            return new ArrayList();
        }
    }

    public static String getCleanLowerDomain(String domain) {
        domain = domain.toLowerCase();
        domain = domain.replaceAll("http://", "");
        domain = domain.replaceAll("https://", "");
        domain = domain.replaceAll("www.", "");
        domain = domain.replaceAll("/", "");
        return domain;
    }

    public static String getBaseLowerDomain(String domain) {
        String[] split;
        int len;
        if (!domain.contains(".")) {
            domain = domain + ".com";
        }
        if ((len = (split = (domain = CrmebUtil.getCleanLowerDomain(domain)).split("\\.")).length) == 0) {
            return domain;
        }
        return split[len - 2] + "." + split[len - 1];
    }

    public static String getClientIp(HttpServletRequest request) {
        String ip = request.getHeader("X-Forwarded-For");
        if (CrmebUtil.checkIsIp(ip)) {
            return ip;
        }
        ip = request.getHeader("X-Real-IP");
        if (CrmebUtil.checkIsIp(ip)) {
            return ip;
        }
        ip = request.getRemoteAddr();
        if (ip.equals("0:0:0:0:0:0:0:1")) {
            ip = "127.0.0.1";
        }
        if (CrmebUtil.checkIsIp(ip)) {
            return ip;
        }
        return "";
    }

    public static boolean checkIsIp(String ip) {
        if (StringUtils.isBlank((CharSequence)ip)) {
            return false;
        }
        if (ip.equals("unKnown")) {
            return false;
        }
        if (ip.equals("unknown")) {
            return false;
        }
        return ip.split("\\.").length == 4;
    }

    public static String getFindInSetSql(String field, Integer value) {
        return "find_in_set(" + value + ", " + field + ")";
    }

    public static String getFindInSetSql(String field, ArrayList<Integer> list) {
        ArrayList<String> sqlList = new ArrayList<String>();
        for (Integer value : list) {
            sqlList.add(CrmebUtil.getFindInSetSql(field, value));
        }
        return "( " + StringUtils.join(sqlList, (String)" or ") + ")";
    }

    public static String getFindInSetSql(String field, String idStr) {
        List<Integer> list = CrmebUtil.stringToArray(idStr);
        ArrayList<String> sqlList = new ArrayList<String>();
        for (Integer value : list) {
            sqlList.add(CrmebUtil.getFindInSetSql(field, value));
        }
        return "( " + StringUtils.join(sqlList, (String)" or ") + ")";
    }

    public static String getValueByIndex(HashMap<Integer, String> list, String categoryIdStr) {
        if (list.size() < 1 || StringUtils.isBlank((CharSequence)categoryIdStr)) {
            return "";
        }
        ArrayList<String> name = new ArrayList<String>();
        List<Integer> idList = CrmebUtil.stringToArray(categoryIdStr);
        String str = "";
        for (Integer id : idList) {
            str = CrmebUtil.getStrValueByIndex(list, id);
            if (!StrUtil.isNotBlank((CharSequence)str)) continue;
            name.add(CrmebUtil.getStrValueByIndex(list, id));
        }
        if (name.size() < 1) {
            return "";
        }
        return StringUtils.join(name, (String)",");
    }

    public static String getStrValueByIndex(HashMap<Integer, String> list, Integer key) {
        if (list.size() < 1) {
            return "";
        }
        return list.getOrDefault(key, "");
    }

    public static Integer getIntValueByIndex(HashMap<Integer, Integer> list, Integer key) {
        if (null == list || list.size() < 1) {
            return 0;
        }
        return list.getOrDefault(key, 0);
    }

    public static String getUuid() {
        return UUID.randomUUID().toString().replace("-", "");
    }

    public static int getRate(Integer i1, Integer i2) {
        BigDecimal b1 = new BigDecimal(i1);
        BigDecimal b2 = new BigDecimal(i2);
        return CrmebUtil.getRate(b1, b2);
    }

    public static int getRate(BigDecimal b1, BigDecimal b2) {
        if (b2.equals(b1)) {
            return 0;
        }
        if (b2.equals(BigDecimal.ZERO)) {
            return 100;
        }
        return b1.subtract(b2).divide(b2, 2, 0).multiply(BigDecimal.TEN).multiply(BigDecimal.TEN).intValue();
    }

    public static BigDecimal getRateBig(Integer i1, Integer i2) {
        BigDecimal b1 = new BigDecimal(i1);
        BigDecimal b2 = new BigDecimal(i2);
        return CrmebUtil.getRateBig(b1, b2);
    }

    public static BigDecimal getRateBig(BigDecimal b1, BigDecimal b2) {
        if (b2.compareTo(b1) == 0) {
            return BigDecimal.ZERO;
        }
        if (b2.compareTo(BigDecimal.ZERO) == 0) {
            return b1.setScale(2, 0);
        }
        return b1.subtract(b2).multiply(BigDecimal.TEN).multiply(BigDecimal.TEN).divide(b2, 0);
    }

    public static String byteToHex(byte[] hash) {
        Formatter formatter = new Formatter();
        for (byte b : hash) {
            formatter.format("%02x", b);
        }
        String result = formatter.toString();
        formatter.close();
        return result;
    }

    public static String getBase64Image(String base64) {
        return "data:image/png;base64," + base64;
    }

    public static String trimSingeQua(String param) {
        return param.substring(1, param.length() - 1);
    }

    public static Integer randomCount(Integer start, Integer end) {
        return (int)(Math.random() * (double)(end - start + 1) + (double)start.intValue());
    }

    public static String getOrderNo(String payType) {
        return payType + CrmebUtil.randomCount(111, 999) + System.currentTimeMillis() + CrmebUtil.randomCount(11111, 99999);
    }

    public static Map<String, Object> mapSort(Map<String, Object> map) {
        return new TreeMap<String, Object>(map);
    }

    public static String mapToStringUrl(Map<String, Object> map) {
        map = CrmebUtil.mapSort(map);
        StringBuilder sb = new StringBuilder();
        Set<String> es = map.keySet();
        for (String set : es) {
            String k = set.toString();
            Object v = map.get(k);
            sb.append(k).append("=").append(v.toString()).append("&");
        }
        String str = sb.toString();
        return str.substring(0, str.length() - 1);
    }

    public static BigDecimal getBigDecimalRate(String rate) {
        return new BigDecimal(rate).divide(BigDecimal.TEN.multiply(BigDecimal.TEN));
    }

    public static String UnicodeToCN(String unicodeStr) {
        Pattern pattern = Pattern.compile("(\\\\u(\\p{XDigit}{4}))");
        Matcher matcher = pattern.matcher(unicodeStr);
        while (matcher.find()) {
            String group = matcher.group(2);
            char ch = (char)Integer.parseInt(group, 16);
            String group1 = matcher.group(1);
            unicodeStr = unicodeStr.replace(group1, ch + "");
        }
        return unicodeStr.replace("\\", "").trim();
    }

    public static String CNToUnicode(String CN) {
        try {
            StringBuffer out = new StringBuffer();
            byte[] bytes = CN.getBytes("unicode");
            for (int i = 0; i < bytes.length - 1; i += 2) {
                out.append("\\u");
                String str = Integer.toHexString(bytes[i + 1] & 0xFF);
                for (int j = str.length(); j < 2; ++j) {
                    out.append("0");
                }
                String str1 = Integer.toHexString(bytes[i] & 0xFF);
                out.append(str1);
                out.append(str);
            }
            return out.toString();
        }
        catch (UnsupportedEncodingException e) {
            e.printStackTrace();
            return null;
        }
    }

    public static String getSign(Map<String, Object> map, String signKey) {
        String result = CrmebUtil.mapToStringUrl(map) + "&key=" + signKey;
        String sign = SecureUtil.md5((String)result).toUpperCase();
        System.out.println("sign ========== " + sign);
        return sign;
    }

    public static boolean isString2Num(String str) {
        Pattern pattern = Pattern.compile("^[0-9]*$");
        Matcher matcher = pattern.matcher(str);
        return matcher.matches();
    }

    public static List<Integer> arrayUnique(Integer[] arr) {
        ArrayList<Integer> list = new ArrayList<Integer>();
        for (Integer integer : arr) {
            if (list.contains(integer)) continue;
            list.add(integer);
        }
        return list;
    }

    public static String percentInstance(Integer detailTotalNumber, Integer totalNumber) {
        Double bfTotalNumber = (double)detailTotalNumber;
        Double zcTotalNumber = (double)totalNumber;
        double percent = bfTotalNumber / zcTotalNumber;
        NumberFormat nt = NumberFormat.getPercentInstance();
        nt.setMinimumFractionDigits(2);
        return nt.format(percent);
    }

    public static int percentInstanceIntVal(Integer detailTotalNumber, Integer totalNumber) {
        BigDecimal sales = new BigDecimal(detailTotalNumber);
        BigDecimal total = new BigDecimal(totalNumber);
        int percentage = sales.divide(total, 2, 0).multiply(new BigDecimal(100)).intValue();
        return Math.min(percentage, 100);
    }

    public static int percentInstanceIntVal(BigDecimal detailTotalNumber, BigDecimal totalNumber) {
        int percentage = detailTotalNumber.divide(totalNumber, 2, 0).multiply(new BigDecimal(100)).intValue();
        return Math.min(percentage, 100);
    }

    public static <T> List<T> castList(Object obj, Class<T> clazz) {
        ArrayList<T> result = new ArrayList<T>();
        if (obj instanceof List) {
            for (Object o : (List)obj) {
                result.add(clazz.cast(o));
            }
            return result;
        }
        return null;
    }

    public static List<JSONObject> jsonArrayToJsonObjectList(JSONArray jsonArray) {
        ArrayList list = CollUtil.newArrayList((Object[])new JSONObject[0]);
        for (int i = 0; i < jsonArray.size(); ++i) {
            JSONObject arrayJSONObject = jsonArray.getJSONObject(i);
            list.add(arrayJSONObject);
        }
        return list;
    }

    public static String maskMobile(String phone) {
        if (StrUtil.isBlank((CharSequence)phone)) {
            return "";
        }
        return phone.replaceAll("(\\d{3})\\d{4}(\\d{4})", "$1****$2");
    }

    public static Integer getOwnerByAdmin() {
        SystemAdmin systemAdmin = SecurityUtil.getLoginUserVo().getUser();
        if (systemAdmin.getType().equals(RoleEnum.SUPER_MERCHANT.getValue()) || systemAdmin.getType().equals(RoleEnum.MERCHANT_ADMIN.getValue())) {
            return systemAdmin.getMerId();
        }
        return -1;
    }

    public static String merchantInitPassword(String account) {
        if (StrUtil.isBlank((CharSequence)account)) {
            return "";
        }
        return CrmebUtil.encryptPassword("000000", account);
    }

    public static Integer dateStrToInteger(String dateStr) {
        if (StrUtil.isBlank((CharSequence)dateStr)) {
            return null;
        }
        String[] split = dateStr.split("-");
        StringBuilder stringBuilder = new StringBuilder();
        Arrays.stream(split).forEach(stringBuilder::append);
        return Integer.valueOf(stringBuilder.toString());
    }
}

