/*
 * Decompiled with CFR 0.152.
 */
package com.zbkj.service.service.impl;

import cn.hutool.core.util.ObjectUtil;
import cn.hutool.core.util.StrUtil;
import com.zbkj.common.config.CrmebConfig;
import com.zbkj.common.model.system.SystemConfig;
import com.zbkj.common.result.CommonResultCode;
import com.zbkj.common.token.FrontTokenComponent;
import com.zbkj.common.utils.RedisUtil;
import com.zbkj.service.dao.CommonConfigDao;
import com.zbkj.service.service.CommonConfigService;
import java.util.List;
import javax.annotation.Resource;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class CommonConfigServiceImpl
implements CommonConfigService {
    @Resource
    private CommonConfigDao commonConfigDao;
    @Autowired
    private RedisUtil redisUtil;
    @Autowired
    private CrmebConfig crmebConfig;
    @Autowired
    private FrontTokenComponent tokenComponent;

    @Override
    public Integer getUserId() {
        Integer userId = this.tokenComponent.getUserId();
        if (userId == null) {
            throw CommonResultCode.PERMISSION_EXPIRATION.newException();
        }
        return userId;
    }

    @Override
    public String getAccoutCode() {
        String code = this.tokenComponent.accoutCode();
        if (StringUtils.isEmpty((CharSequence)code)) {
            throw CommonResultCode.PERMISSION_EXPIRATION.newException();
        }
        return code;
    }

    @Override
    public String getValueByKey(String name) {
        return this.get(name);
    }

    private void asyncBlank(String key) {
        this.redisUtil.hset("config_list", key, (Object)"");
    }

    private void async(SystemConfig systemConfig) {
        this.redisUtil.hset("config_list", systemConfig.getName(), (Object)systemConfig.getValue());
    }

    private void async(List<SystemConfig> systemConfigList) {
        for (SystemConfig systemConfig : systemConfigList) {
            this.redisUtil.hset("config_list", systemConfig.getName(), (Object)systemConfig.getValue());
        }
    }

    private String get(String name) {
        if (!this.crmebConfig.isAsyncConfig().booleanValue()) {
            SystemConfig systemConfig = this.commonConfigDao.getSConfigByName(name);
            if (ObjectUtil.isNull((Object)systemConfig) || StrUtil.isBlank((CharSequence)systemConfig.getValue())) {
                return "";
            }
            return systemConfig.getValue();
        }
        Long size = this.redisUtil.getHashSize("config_list");
        if (size <= 0L) {
            SystemConfig systemConfig = this.commonConfigDao.getSConfigByName(name);
            if (ObjectUtil.isNull((Object)systemConfig) || StrUtil.isBlank((CharSequence)systemConfig.getValue())) {
                this.asyncBlank(name);
                return "";
            }
            this.async(systemConfig);
            return systemConfig.getValue();
        }
        Object data = this.redisUtil.hget("config_list", name);
        if (ObjectUtil.isNull((Object)data)) {
            this.asyncBlank(name);
            return "";
        }
        return data.toString();
    }
}

