/*
 * Decompiled with CFR 0.152.
 */
package com.zbkj.service.service.impl;

import cn.hutool.core.collection.CollUtil;
import cn.hutool.core.util.ObjectUtil;
import cn.hutool.core.util.StrUtil;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.zbkj.common.constants.WeChatConstants;
import com.zbkj.common.exception.CrmebException;
import com.zbkj.common.utils.RedisUtil;
import com.zbkj.common.utils.RestTemplateUtil;
import com.zbkj.common.utils.WxUtil;
import com.zbkj.common.vo.wxvedioshop.ShopSpuAddResponseVo;
import com.zbkj.common.vo.wxvedioshop.ShopSpuAddVo;
import com.zbkj.common.vo.wxvedioshop.ShopSpuCommonVo;
import com.zbkj.common.vo.wxvedioshop.ShopSpuListRequestVo;
import com.zbkj.common.vo.wxvedioshop.ShopSpuListResponseVo;
import com.zbkj.common.vo.wxvedioshop.ShopSpuVo;
import com.zbkj.common.vo.wxvedioshop.cat_brand.ShopAccountUpdateVo;
import com.zbkj.common.vo.wxvedioshop.cat_brand.ShopBrandVo;
import com.zbkj.common.vo.wxvedioshop.cat_brand.ShopCatDetailVo;
import com.zbkj.common.vo.wxvedioshop.cat_brand.ShopCatListResponse;
import com.zbkj.common.vo.wxvedioshop.cat_brand.ShopCatVo;
import com.zbkj.service.service.WechatService;
import com.zbkj.service.service.WechatVideoSpuService;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class WechatVideoSpuServiceImpl
implements WechatVideoSpuService {
    private final Logger logger = LoggerFactory.getLogger(WechatVideoSpuServiceImpl.class);
    @Autowired
    private RedisUtil redisUtil;
    @Autowired
    private RestTemplateUtil restTemplateUtil;
    @Autowired
    private WechatService wechatService;

    @Override
    public List<ShopBrandVo> getShopBrandList() {
        String miniAccessToken = this.wechatService.getMiniAccessToken();
        String url = StrUtil.format((CharSequence)WeChatConstants.WECHAT_SHOP_ACCOUNT_GET_BRAND_LIST, (Object[])new Object[]{miniAccessToken});
        String s = this.restTemplateUtil.postStringData(url, "{}");
        JSONObject jsonObject = JSONObject.parseObject((String)s);
        WxUtil.checkResult((JSONObject)jsonObject);
        JSONArray dataArr = jsonObject.getJSONArray("data");
        if (ObjectUtil.isNull((Object)dataArr) || dataArr.size() == 0) {
            throw new CrmebException("\u6682\u65e0\u54c1\u724c\u4fe1\u606f");
        }
        List brandVoList = JSONArray.parseArray((String)dataArr.toJSONString(), ShopBrandVo.class);
        this.logger.info("\u81ea\u5b9a\u4e49\u4ea4\u6613\u7ec4\u4ef6--\u300b\u83b7\u53d6\u54c1\u724c\u5217\u8868--\u300b" + StrUtil.format((CharSequence)("\u8bf7\u6c42\u5fae\u4fe1\u6570\u636e\u8fd4\u56de\uff0c" + jsonObject.toJSONString()), (Object[])new Object[0]));
        return brandVoList;
    }

    @Override
    public List<ShopCatListResponse> getShopCategoryList() {
        String miniAccessToken = this.wechatService.getMiniAccessToken();
        String url = StrUtil.format((CharSequence)WeChatConstants.WECHAT_SHOP_ACCOUNT_GET_CATEGORY_LIST, (Object[])new Object[]{miniAccessToken});
        String s = this.restTemplateUtil.postStringData(url, "{}");
        JSONObject jsonObject = JSONObject.parseObject((String)s);
        WxUtil.checkResult((JSONObject)jsonObject);
        List catListResponses = JSONArray.parseArray((String)jsonObject.getJSONObject("data").toJSONString(), ShopCatListResponse.class);
        this.logger.info("\u81ea\u5b9a\u4e49\u4ea4\u6613\u7ec4\u4ef6--\u300b\u83b7\u53d6\u7c7b\u76ee\u5217\u8868--\u300b" + StrUtil.format((CharSequence)("\u8bf7\u6c42\u5fae\u4fe1\u6570\u636e\u8fd4\u56de\uff0c" + jsonObject.toJSONString()), (Object[])new Object[0]));
        return catListResponses;
    }

    @Override
    public Boolean shopUpdateInfo(ShopAccountUpdateVo request) {
        String miniAccessToken = this.wechatService.getMiniAccessToken();
        String url = StrUtil.format((CharSequence)WeChatConstants.WECHAT_SHOP_ACCOUNT_UPDATE_INFO, (Object[])new Object[]{miniAccessToken});
        String s = this.restTemplateUtil.postStringData(url, JSONObject.toJSONString((Object)request));
        JSONObject jsonObject = JSONObject.parseObject((String)s);
        WxUtil.checkResult((JSONObject)jsonObject);
        this.logger.info("\u81ea\u5b9a\u4e49\u4ea4\u6613\u7ec4\u4ef6--\u300b\u66f4\u65b0\u5546\u5bb6\u4fe1\u606f--\u300b" + StrUtil.format((CharSequence)("\u8bf7\u6c42\u5fae\u4fe1\u6570\u636e\u8fd4\u56de" + jsonObject.toJSONString()), (Object[])new Object[0]));
        return "0".equals(jsonObject.getString("errcode"));
    }

    @Override
    public ShopAccountUpdateVo shopGetAccountInfo() {
        String miniAccessToken = this.wechatService.getMiniAccessToken();
        String url = StrUtil.format((CharSequence)WeChatConstants.WECHAT_SHOP_ACCOUNT_GET_INFO, (Object[])new Object[]{miniAccessToken});
        String s = this.restTemplateUtil.postStringData(url, "{}");
        JSONObject jsonObject = JSONObject.parseObject((String)s);
        WxUtil.checkResult((JSONObject)jsonObject);
        this.logger.info("\u81ea\u5b9a\u4e49\u4ea4\u6613\u7ec4\u4ef6--\u300b\u83b7\u53d6\u5546\u5bb6\u4fe1\u606f--\u300b" + StrUtil.format((CharSequence)("\u8bf7\u6c42\u5fae\u4fe1\u6570\u636e\u8fd4\u56de\uff0c" + jsonObject.toJSONString()), (Object[])new Object[0]));
        return (ShopAccountUpdateVo)JSONObject.parseObject((String)s, ShopAccountUpdateVo.class);
    }

    @Override
    public List<ShopCatDetailVo> getShopCat() {
        String miniAccessToken = this.wechatService.getMiniAccessToken();
        String url = StrUtil.format((CharSequence)WeChatConstants.WECHAT_SHOP_CAT_GET_URL, (Object[])new Object[]{miniAccessToken});
        String s = this.restTemplateUtil.postStringData(url, "{}");
        JSONObject jsonObject = JSONObject.parseObject((String)s);
        WxUtil.checkResult((JSONObject)jsonObject);
        ShopCatVo shopCatVo = (ShopCatVo)JSONObject.parseObject((String)jsonObject.toJSONString(), ShopCatVo.class);
        this.logger.info(StrUtil.format((CharSequence)("\u8bf7\u6c42\u5fae\u4fe1\u7c7b\u76ee\u6570\u636e\u8fd4\u56de\uff0ccatData\uff1a" + jsonObject.toJSONString()), (Object[])new Object[0]));
        return shopCatVo.getThirdCatList();
    }

    @Override
    public ShopSpuAddResponseVo shopSpuAdd(ShopSpuAddVo shopSpuVo) {
        Map<String, Object> spuAddMap = this.assembleSpuAddMap(shopSpuVo);
        this.logger.info("\u81ea\u5b9a\u4e49\u7ec4\u4ef6\u65b0\u589e\u5546\u54c1:spuAddMap = " + spuAddMap);
        String miniAccessToken = this.wechatService.getMiniAccessToken();
        String url = StrUtil.format((CharSequence)WeChatConstants.WECHAT_SHOP_SPU_ADD_URL, (Object[])new Object[]{miniAccessToken});
        String postStringData = this.restTemplateUtil.postStringData(url, JSONObject.toJSONString(spuAddMap));
        this.logger.info("\u81ea\u5b9a\u4e49\u7ec4\u4ef6\u65b0\u589e\u5546\u54c1:\u8fd4\u56de:postStringData = " + postStringData);
        JSONObject jsonObject = JSONObject.parseObject((String)postStringData);
        WxUtil.checkResult((JSONObject)jsonObject);
        ShopSpuAddResponseVo addResponseVo = (ShopSpuAddResponseVo)JSONObject.parseObject((String)jsonObject.getJSONObject("data").toJSONString(), ShopSpuAddResponseVo.class);
        return addResponseVo;
    }

    private Map<String, Object> assembleSpuAddMap(ShopSpuAddVo shopSpuVo) {
        HashMap map = CollUtil.newHashMap();
        map.put("out_product_id", shopSpuVo.getOutProductId());
        map.put("title", shopSpuVo.getTitle());
        map.put("path", shopSpuVo.getPath());
        map.put("head_img", shopSpuVo.getHeadImg());
        if (CollUtil.isNotEmpty((Collection)shopSpuVo.getQualificationPics())) {
            map.put("qualification_pics", shopSpuVo.getQualificationPics());
        }
        if (ObjectUtil.isNotNull((Object)shopSpuVo.getDescInfo())) {
            HashMap infoMap = CollUtil.newHashMap();
            infoMap.put("desc", shopSpuVo.getDescInfo().getDesc());
        }
        map.put("third_cat_id", shopSpuVo.getThirdCatId());
        map.put("brand_id", shopSpuVo.getBrandId());
        List skuMapLsit = shopSpuVo.getSkus().stream().map(sku -> {
            HashMap skuMap = CollUtil.newHashMap();
            skuMap.put("out_product_id", sku.getOutProductId());
            skuMap.put("out_sku_id", sku.getOutSkuId());
            skuMap.put("thumb_img", sku.getThumbImg());
            skuMap.put("sale_price", sku.getSalePrice());
            skuMap.put("market_price", sku.getMarketPrice());
            skuMap.put("stock_num", sku.getStockNum());
            List attrMapList = sku.getSkuAttrs().stream().map(attr -> {
                HashMap attrMap = CollUtil.newHashMap();
                attrMap.put("attr_key", attr.getAttrKey());
                attrMap.put("attr_value", attr.getAttrValue());
                return attrMap;
            }).collect(Collectors.toList());
            skuMap.put("sku_attrs", attrMapList);
            return skuMap;
        }).collect(Collectors.toList());
        map.put("skus", skuMapLsit);
        return map;
    }

    @Override
    public Boolean shopSpuDel(ShopSpuCommonVo shopSpuCommonVo) {
        if (ObjectUtil.isNull((Object)shopSpuCommonVo.getProductId()) && StrUtil.isBlank((CharSequence)shopSpuCommonVo.getOutProductId())) {
            throw new CrmebException("\u5546\u54c1ID\u4e0d\u80fd\u4e3a\u7a7a");
        }
        String miniAccessToken = this.wechatService.getMiniAccessToken();
        String url = StrUtil.format((CharSequence)WeChatConstants.WECHAT_SHOP_SPU_DEL_URL, (Object[])new Object[]{miniAccessToken});
        HashMap<String, Object> map = new HashMap<String, Object>();
        if (ObjectUtil.isNotNull((Object)shopSpuCommonVo.getProductId())) {
            map.put("product_id", shopSpuCommonVo.getProductId());
        }
        if (StrUtil.isNotBlank((CharSequence)shopSpuCommonVo.getOutProductId())) {
            map.put("out_product_id", shopSpuCommonVo.getOutProductId());
        }
        String mapData = this.restTemplateUtil.postMapData(url, map);
        JSONObject jsonObject = JSONObject.parseObject((String)mapData);
        WxUtil.checkResult((JSONObject)jsonObject);
        return Boolean.TRUE;
    }

    @Override
    public Boolean shopSpuDelAudit(ShopSpuCommonVo shopSpuCommonVo) {
        if (ObjectUtil.isNull((Object)shopSpuCommonVo.getProductId()) && StrUtil.isBlank((CharSequence)shopSpuCommonVo.getOutProductId())) {
            throw new CrmebException("\u5546\u54c1ID\u4e0d\u80fd\u4e3a\u7a7a");
        }
        String miniAccessToken = this.wechatService.getMiniAccessToken();
        String url = StrUtil.format((CharSequence)WeChatConstants.WECHAT_SHOP_SPU_DEL_AUDIT_URL, (Object[])new Object[]{miniAccessToken});
        HashMap<String, Object> map = new HashMap<String, Object>();
        if (ObjectUtil.isNotNull((Object)shopSpuCommonVo.getProductId())) {
            map.put("product_id", shopSpuCommonVo.getProductId());
        }
        if (StrUtil.isNotBlank((CharSequence)shopSpuCommonVo.getOutProductId())) {
            map.put("out_product_id", shopSpuCommonVo.getOutProductId());
        }
        String mapData = this.restTemplateUtil.postMapData(url, map);
        JSONObject jsonObject = JSONObject.parseObject((String)mapData);
        WxUtil.checkResult((JSONObject)jsonObject);
        return Boolean.TRUE;
    }

    @Override
    public ShopSpuVo shopSpuGet(ShopSpuCommonVo shopSpuCommonVo) {
        if (ObjectUtil.isNull((Object)shopSpuCommonVo.getProductId()) && StrUtil.isBlank((CharSequence)shopSpuCommonVo.getOutProductId())) {
            throw new CrmebException("\u5546\u54c1ID\u4e0d\u80fd\u4e3a\u7a7a");
        }
        String miniAccessToken = this.wechatService.getMiniAccessToken();
        String url = StrUtil.format((CharSequence)WeChatConstants.WECHAT_SHOP_SPU_GET_URL, (Object[])new Object[]{miniAccessToken});
        HashMap<String, Object> map = new HashMap<String, Object>();
        if (ObjectUtil.isNotNull((Object)shopSpuCommonVo.getProductId())) {
            map.put("product_id", shopSpuCommonVo.getProductId());
        }
        if (StrUtil.isNotBlank((CharSequence)shopSpuCommonVo.getOutProductId())) {
            map.put("out_product_id", shopSpuCommonVo.getOutProductId());
        }
        map.put("need_edit_spu", shopSpuCommonVo.getNeedEditSpu());
        String mapData = this.restTemplateUtil.postMapData(url, map);
        JSONObject jsonObject = JSONObject.parseObject((String)mapData);
        WxUtil.checkResult((JSONObject)jsonObject);
        ShopSpuVo shopSpuVo = (ShopSpuVo)JSONObject.parseObject((String)jsonObject.getJSONObject("spu").toJSONString(), ShopSpuVo.class);
        return shopSpuVo;
    }

    @Override
    public ShopSpuListResponseVo shopSpuGetList(ShopSpuListRequestVo shopSpuListRequestVo) {
        String miniAccessToken = this.wechatService.getMiniAccessToken();
        String url = StrUtil.format((CharSequence)WeChatConstants.WECHAT_SHOP_SPU_GET_LIST_URL, (Object[])new Object[]{miniAccessToken});
        HashMap<String, Object> map = new HashMap<String, Object>();
        if (StrUtil.isNotBlank((CharSequence)shopSpuListRequestVo.getStartCreateTime())) {
            map.put("start_create_time", shopSpuListRequestVo.getStartCreateTime());
        }
        if (StrUtil.isNotBlank((CharSequence)shopSpuListRequestVo.getEndCreateTime())) {
            map.put("end_create_time", shopSpuListRequestVo.getEndCreateTime());
        }
        if (StrUtil.isNotBlank((CharSequence)shopSpuListRequestVo.getStartUpdateTime())) {
            map.put("start_update_time", shopSpuListRequestVo.getStartUpdateTime());
        }
        if (StrUtil.isNotBlank((CharSequence)shopSpuListRequestVo.getEndUpdateTime())) {
            map.put("end_update_time", shopSpuListRequestVo.getEndUpdateTime());
        }
        if (ObjectUtil.isNotNull((Object)shopSpuListRequestVo.getStatus())) {
            map.put("status", shopSpuListRequestVo.getStatus());
        }
        map.put("need_edit_spu", shopSpuListRequestVo.getNeedEditSpu());
        map.put("page", shopSpuListRequestVo.getPage());
        map.put("page_size", shopSpuListRequestVo.getPageSize());
        String mapData = this.restTemplateUtil.postMapData(url, map);
        JSONObject jsonObject = JSONObject.parseObject((String)mapData);
        WxUtil.checkResult((JSONObject)jsonObject);
        ShopSpuListResponseVo shopSpuListResponseVo = (ShopSpuListResponseVo)JSONObject.parseObject((String)jsonObject.toJSONString(), ShopSpuListResponseVo.class);
        return shopSpuListResponseVo;
    }

    @Override
    public ShopSpuAddResponseVo shopSpuUpdate(ShopSpuAddVo shopSpuVo) {
        Map<String, Object> spuUpdateMap = this.assembleSpuAddMap(shopSpuVo);
        System.out.println("spuUpdateMap = " + spuUpdateMap);
        String miniAccessToken = this.wechatService.getMiniAccessToken();
        String url = StrUtil.format((CharSequence)WeChatConstants.WECHAT_SHOP_SPU_UPDATE_URL, (Object[])new Object[]{miniAccessToken});
        String postStringData = this.restTemplateUtil.postStringData(url, JSONObject.toJSONString(spuUpdateMap));
        JSONObject jsonObject = JSONObject.parseObject((String)postStringData);
        WxUtil.checkResult((JSONObject)jsonObject);
        ShopSpuAddResponseVo updateResponseVo = (ShopSpuAddResponseVo)JSONObject.parseObject((String)jsonObject.getJSONObject("data").toJSONString(), ShopSpuAddResponseVo.class);
        return updateResponseVo;
    }

    @Override
    public Boolean shopSpuPuton(ShopSpuCommonVo shopSpuCommonVo) {
        if (ObjectUtil.isNull((Object)shopSpuCommonVo.getProductId()) && StrUtil.isBlank((CharSequence)shopSpuCommonVo.getOutProductId())) {
            throw new CrmebException("\u5546\u54c1ID\u4e0d\u80fd\u4e3a\u7a7a");
        }
        String miniAccessToken = this.wechatService.getMiniAccessToken();
        String url = StrUtil.format((CharSequence)WeChatConstants.WECHAT_SHOP_SPU_LISTING_URL, (Object[])new Object[]{miniAccessToken});
        HashMap<String, Object> map = new HashMap<String, Object>();
        if (ObjectUtil.isNotNull((Object)shopSpuCommonVo.getProductId())) {
            map.put("product_id", shopSpuCommonVo.getProductId());
        }
        if (StrUtil.isNotBlank((CharSequence)shopSpuCommonVo.getOutProductId())) {
            map.put("out_product_id", shopSpuCommonVo.getOutProductId());
        }
        String mapData = this.restTemplateUtil.postMapData(url, map);
        JSONObject jsonObject = JSONObject.parseObject((String)mapData);
        WxUtil.checkResult((JSONObject)jsonObject);
        return Boolean.TRUE;
    }

    @Override
    public Boolean shopSpuPutdown(ShopSpuCommonVo shopSpuCommonVo) {
        if (ObjectUtil.isNull((Object)shopSpuCommonVo.getProductId()) && StrUtil.isBlank((CharSequence)shopSpuCommonVo.getOutProductId())) {
            throw new CrmebException("\u5546\u54c1ID\u4e0d\u80fd\u4e3a\u7a7a");
        }
        String miniAccessToken = this.wechatService.getMiniAccessToken();
        String url = StrUtil.format((CharSequence)WeChatConstants.WECHAT_SHOP_SPU_DELISTING_URL, (Object[])new Object[]{miniAccessToken});
        HashMap<String, Object> map = new HashMap<String, Object>();
        if (ObjectUtil.isNotNull((Object)shopSpuCommonVo.getProductId())) {
            map.put("product_id", shopSpuCommonVo.getProductId());
        }
        if (StrUtil.isNotBlank((CharSequence)shopSpuCommonVo.getOutProductId())) {
            map.put("out_product_id", shopSpuCommonVo.getOutProductId());
        }
        String mapData = this.restTemplateUtil.postMapData(url, map);
        JSONObject jsonObject = JSONObject.parseObject((String)mapData);
        WxUtil.checkResult((JSONObject)jsonObject);
        return Boolean.TRUE;
    }
}

