/*
 * Decompiled with CFR 0.152.
 */
package com.zbkj.service.service.impl;

import cn.hutool.core.collection.CollUtil;
import cn.hutool.core.collection.CollectionUtil;
import cn.hutool.core.date.DateUtil;
import cn.hutool.core.util.ObjectUtil;
import cn.hutool.core.util.StrUtil;
import cn.hutool.core.util.URLUtil;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.baomidou.mybatisplus.core.toolkit.support.SFunction;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.github.pagehelper.Page;
import com.github.pagehelper.PageHelper;
import com.github.pagehelper.PageInfo;
import com.zbkj.common.constants.BrokerageRecordConstants;
import com.zbkj.common.model.user.User;
import com.zbkj.common.model.user.UserBrokerageRecord;
import com.zbkj.common.page.CommonPage;
import com.zbkj.common.request.PageParamRequest;
import com.zbkj.common.request.RetailStoreSubUserSearchRequest;
import com.zbkj.common.utils.ArrayUtil;
import com.zbkj.common.utils.CrmebDateUtil;
import com.zbkj.common.vo.DateLimitUtilVo;
import com.zbkj.service.dao.UserBrokerageRecordDao;
import com.zbkj.service.service.UserBrokerageRecordService;
import com.zbkj.service.service.UserService;
import java.math.BigDecimal;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.transaction.support.TransactionTemplate;

@Service
public class UserBrokerageRecordServiceImpl
extends ServiceImpl<UserBrokerageRecordDao, UserBrokerageRecord>
implements UserBrokerageRecordService {
    private static final Logger logger = LoggerFactory.getLogger(UserBrokerageRecordServiceImpl.class);
    @Resource
    private UserBrokerageRecordDao dao;
    @Autowired
    private UserService userService;
    @Autowired
    private TransactionTemplate transactionTemplate;

    @Override
    public List<UserBrokerageRecord> getByOrderNo(String orderNo) {
        LambdaQueryWrapper lqw = Wrappers.lambdaQuery();
        lqw.eq(UserBrokerageRecord::getLinkNo, (Object)orderNo);
        return this.dao.selectList((Wrapper)lqw);
    }

    @Override
    public List<UserBrokerageRecord> findListByLinkNoAndLinkType(String linkNo, String linkType) {
        LambdaQueryWrapper lqw = new LambdaQueryWrapper();
        lqw.eq(UserBrokerageRecord::getLinkNo, (Object)linkNo);
        lqw.eq(UserBrokerageRecord::getLinkType, (Object)linkType);
        return this.dao.selectList((Wrapper)lqw);
    }

    @Override
    public void brokerageThaw() {
        List<UserBrokerageRecord> thawList = this.findThawList();
        if (CollUtil.isEmpty(thawList)) {
            return;
        }
        for (UserBrokerageRecord record : thawList) {
            User user = (User)this.userService.getById(record.getUid());
            if (ObjectUtil.isNull((Object)user)) continue;
            record.setStatus(BrokerageRecordConstants.BROKERAGE_RECORD_STATUS_COMPLETE);
            BigDecimal balance = user.getBrokeragePrice().add(record.getPrice());
            record.setBalance(balance);
            record.setUpdateTime((Date)DateUtil.date());
            Boolean execute = (Boolean)this.transactionTemplate.execute(e -> {
                this.updateById(record);
                this.userService.updateBrokerage(record.getUid(), record.getPrice(), "add");
                return Boolean.TRUE;
            });
            if (execute.booleanValue()) continue;
            logger.error(StrUtil.format((CharSequence)"\u4f63\u91d1\u89e3\u51bb\u5904\u7406\u2014\u6570\u636e\u5e93\u51fa\u9519\uff0c\u8bb0\u5f55id = {}", (Object[])new Object[]{record.getId()}));
        }
    }

    @Override
    public PageInfo<UserBrokerageRecord> findDetailListByUid(Integer uid, PageParamRequest pageParamRequest) {
        Page recordPage = PageHelper.startPage((int)pageParamRequest.getPage(), (int)pageParamRequest.getLimit());
        QueryWrapper queryWrapper = new QueryWrapper();
        queryWrapper.eq((Object)"uid", (Object)uid);
        queryWrapper.eq((Object)"status", (Object)BrokerageRecordConstants.BROKERAGE_RECORD_STATUS_COMPLETE);
        queryWrapper.orderByDesc((Object)"id");
        List recordList = this.dao.selectList((Wrapper)queryWrapper);
        return CommonPage.copyPageInfo((Page)recordPage, (List)recordList);
    }

    @Override
    public Integer getSpreadCountByUid(Integer uid) {
        LambdaQueryWrapper lqw = new LambdaQueryWrapper();
        lqw.select(new SFunction[]{UserBrokerageRecord::getId});
        lqw.eq(UserBrokerageRecord::getUid, (Object)uid);
        lqw.eq(UserBrokerageRecord::getLinkType, (Object)"order");
        lqw.eq(UserBrokerageRecord::getStatus, (Object)BrokerageRecordConstants.BROKERAGE_RECORD_STATUS_COMPLETE);
        return this.dao.selectCount((Wrapper)lqw);
    }

    @Override
    public List<UserBrokerageRecord> findSpreadListByUid(Integer uid, PageParamRequest pageParamRequest) {
        PageHelper.startPage((int)pageParamRequest.getPage(), (int)pageParamRequest.getLimit());
        LambdaQueryWrapper lqw = new LambdaQueryWrapper();
        lqw.eq(UserBrokerageRecord::getUid, (Object)uid);
        lqw.eq(UserBrokerageRecord::getLinkType, (Object)"order");
        lqw.eq(UserBrokerageRecord::getStatus, (Object)BrokerageRecordConstants.BROKERAGE_RECORD_STATUS_COMPLETE);
        lqw.orderByDesc(UserBrokerageRecord::getUpdateTime);
        return this.dao.selectList((Wrapper)lqw);
    }

    @Override
    @Transactional
    public void updateStatusByOrderNo(Integer uid, String orderNo, Integer brokerageRecordConstants) {
        List<UserBrokerageRecord> userBrokerageRecordList = this.getByUidAndOrderNo(uid, orderNo);
        if (CollectionUtil.isNotEmpty(userBrokerageRecordList)) {
            for (UserBrokerageRecord userBrokerageRecord : userBrokerageRecordList) {
                if (userBrokerageRecord == null || userBrokerageRecord.getStatus().intValue() == brokerageRecordConstants.intValue()) continue;
                userBrokerageRecord.setStatus(brokerageRecordConstants);
                userBrokerageRecord.setUpdateTime((Date)DateUtil.date());
                this.dao.updateById(userBrokerageRecord);
            }
        }
    }

    @Override
    public void createRefundBrokerageRecord(Integer uid, String orderNo, BigDecimal price) {
        List<UserBrokerageRecord> oldList = this.getByUidAndOrderNo(uid, orderNo);
        if (CollectionUtil.isNotEmpty(oldList)) {
            for (UserBrokerageRecord old : oldList) {
                UserBrokerageRecord brokerageRecord = new UserBrokerageRecord();
                brokerageRecord.setUid(old.getUid());
                brokerageRecord.setSubUid(old.getSubUid());
                brokerageRecord.setLinkNo(old.getLinkNo());
                brokerageRecord.setLinkType("order");
                brokerageRecord.setType(BrokerageRecordConstants.BROKERAGE_RECORD_TYPE_ADD);
                brokerageRecord.setTitle("\u8ba2\u5355\u9000\u6b3e\u83b7\u5f97\u63a8\u5e7f\u4f63\u91d1");
                brokerageRecord.setPrice(price);
                brokerageRecord.setMark(StrUtil.format((CharSequence)"\u8ba2\u5355\u9000\u6b3e\u83b7\u5f97\u63a8\u5e7f\u4f63\u91d1\uff0c\u5206\u4f63{}", (Object[])new Object[]{price}));
                brokerageRecord.setStatus(BrokerageRecordConstants.BROKERAGE_RECORD_STATUS_COMPLETE);
                brokerageRecord.setFrozenTime(Integer.valueOf(0));
                brokerageRecord.setCreateTime(CrmebDateUtil.nowDateTime());
                brokerageRecord.setBrokerageLevel(old.getBrokerageLevel());
                this.dao.insert(brokerageRecord);
            }
        }
    }

    private List<UserBrokerageRecord> getByUidAndOrderNo(Integer uid, String orderNo) {
        LambdaQueryWrapper lqw = new LambdaQueryWrapper();
        lqw.eq(UserBrokerageRecord::getUid, (Object)uid);
        lqw.eq(UserBrokerageRecord::getLinkType, (Object)"order");
        lqw.eq(UserBrokerageRecord::getLinkNo, (Object)orderNo);
        return this.dao.selectList((Wrapper)lqw);
    }

    @Override
    public PageInfo<UserBrokerageRecord> findAdminSpreadListByUid(RetailStoreSubUserSearchRequest request, PageParamRequest pageParamRequest) {
        Page page = PageHelper.startPage((int)pageParamRequest.getPage(), (int)pageParamRequest.getLimit());
        LambdaQueryWrapper lqw = new LambdaQueryWrapper();
        lqw.eq(UserBrokerageRecord::getUid, (Object)request.getUid());
        lqw.eq(UserBrokerageRecord::getLinkType, (Object)"order");
        lqw.eq(UserBrokerageRecord::getStatus, (Object)BrokerageRecordConstants.BROKERAGE_RECORD_STATUS_COMPLETE);
        if (request.getType().equals(1)) {
            lqw.eq(UserBrokerageRecord::getBrokerageLevel, (Object)1);
        }
        if (request.getType().equals(2)) {
            lqw.eq(UserBrokerageRecord::getBrokerageLevel, (Object)2);
        }
        if (StrUtil.isNotBlank((CharSequence)request.getKeywords())) {
            String keywords = URLUtil.decode((String)request.getKeywords());
            lqw.like(UserBrokerageRecord::getLinkNo, (Object)keywords);
        }
        if (StrUtil.isNotBlank((CharSequence)request.getDateLimit())) {
            DateLimitUtilVo dateLimit = CrmebDateUtil.getDateLimit((String)request.getDateLimit());
            lqw.between(UserBrokerageRecord::getUpdateTime, (Object)dateLimit.getStartTime(), (Object)dateLimit.getEndTime());
        }
        lqw.orderByDesc(UserBrokerageRecord::getUpdateTime);
        return CommonPage.copyPageInfo((Page)page, (List)this.dao.selectList((Wrapper)lqw));
    }

    @Override
    public Map<String, Integer> getSpreadCountByUidAndMonth(Integer uid, List<String> monthList) {
        QueryWrapper queryWrapper = new QueryWrapper();
        queryWrapper.select(new String[]{"count(id) as uid, update_time"});
        queryWrapper.eq((Object)"uid", (Object)uid);
        queryWrapper.eq((Object)"link_type", (Object)"order");
        queryWrapper.eq((Object)"status", (Object)BrokerageRecordConstants.BROKERAGE_RECORD_STATUS_COMPLETE);
        queryWrapper.apply(StrUtil.format((CharSequence)"left(update_time, 7) in ({})", (Object[])new Object[]{ArrayUtil.strListToSqlJoin(monthList)}), new Object[0]);
        queryWrapper.groupBy((Object)"left(update_time, 7)");
        List list = this.dao.selectList((Wrapper)queryWrapper);
        HashMap map = CollUtil.newHashMap();
        if (CollUtil.isEmpty((Collection)list)) {
            return map;
        }
        list.forEach(record -> map.put(CrmebDateUtil.dateToStr((Date)record.getUpdateTime(), (String)"yyyy-MM"), record.getUid()));
        return map;
    }

    @Override
    public List<UserBrokerageRecord> getBrokerageTopByDate(String type) {
        QueryWrapper queryWrapper = new QueryWrapper();
        queryWrapper.select(new String[]{"uid", "sum(price) AS price"});
        queryWrapper.eq((Object)"link_type", (Object)"order");
        queryWrapper.eq((Object)"status", (Object)BrokerageRecordConstants.BROKERAGE_RECORD_STATUS_COMPLETE);
        DateLimitUtilVo dateLimit = CrmebDateUtil.getDateLimit((String)type);
        if (StrUtil.isNotBlank((CharSequence)dateLimit.getStartTime())) {
            queryWrapper.between((Object)"update_time", (Object)dateLimit.getStartTime(), (Object)dateLimit.getEndTime());
        }
        queryWrapper.groupBy((Object)"uid");
        queryWrapper.orderByDesc((Object)"price");
        queryWrapper.last(" limit 50");
        return this.dao.selectList((Wrapper)queryWrapper);
    }

    @Override
    public List<UserBrokerageRecord> getSpreadListByUid(Integer uid) {
        LambdaQueryWrapper lqw = new LambdaQueryWrapper();
        lqw.eq(UserBrokerageRecord::getUid, (Object)uid);
        lqw.eq(UserBrokerageRecord::getLinkType, (Object)"order");
        lqw.eq(UserBrokerageRecord::getType, (Object)BrokerageRecordConstants.BROKERAGE_RECORD_TYPE_ADD);
        lqw.eq(UserBrokerageRecord::getStatus, (Object)BrokerageRecordConstants.BROKERAGE_RECORD_STATUS_COMPLETE);
        return this.dao.selectList((Wrapper)lqw);
    }

    @Override
    public BigDecimal getFreezePrice(Integer uid) {
        LambdaQueryWrapper lqw = new LambdaQueryWrapper();
        lqw.select(new SFunction[]{UserBrokerageRecord::getPrice});
        lqw.eq(UserBrokerageRecord::getUid, (Object)uid);
        lqw.eq(UserBrokerageRecord::getLinkType, (Object)"order");
        lqw.in(UserBrokerageRecord::getStatus, new Object[]{BrokerageRecordConstants.BROKERAGE_RECORD_STATUS_FROZEN, BrokerageRecordConstants.BROKERAGE_RECORD_STATUS_CREATE});
        List list = this.dao.selectList((Wrapper)lqw);
        if (CollUtil.isEmpty((Collection)list)) {
            return BigDecimal.ZERO;
        }
        return list.stream().map(UserBrokerageRecord::getPrice).reduce(BigDecimal.ZERO, BigDecimal::add);
    }

    @Override
    public BigDecimal getSettledCommission(Integer uid) {
        LambdaQueryWrapper lqw = new LambdaQueryWrapper();
        lqw.select(new SFunction[]{UserBrokerageRecord::getPrice});
        lqw.eq(UserBrokerageRecord::getUid, (Object)uid);
        lqw.eq(UserBrokerageRecord::getLinkType, (Object)"withdraw");
        lqw.eq(UserBrokerageRecord::getStatus, (Object)BrokerageRecordConstants.BROKERAGE_RECORD_STATUS_COMPLETE);
        List list = this.dao.selectList((Wrapper)lqw);
        if (CollUtil.isEmpty((Collection)list)) {
            return BigDecimal.ZERO;
        }
        return list.stream().map(UserBrokerageRecord::getPrice).reduce(BigDecimal.ZERO, BigDecimal::add);
    }

    @Override
    public UserBrokerageRecord getOneByLinkNo(String linkNo) {
        LambdaQueryWrapper lqw = new LambdaQueryWrapper();
        lqw.select(new SFunction[]{UserBrokerageRecord::getPrice});
        lqw.eq(UserBrokerageRecord::getLinkNo, (Object)linkNo);
        return (UserBrokerageRecord)this.dao.selectOne((Wrapper)lqw);
    }

    private List<UserBrokerageRecord> findThawList() {
        LambdaQueryWrapper lqw = new LambdaQueryWrapper();
        lqw.le(UserBrokerageRecord::getThawTime, (Object)System.currentTimeMillis());
        lqw.eq(UserBrokerageRecord::getLinkType, (Object)"order");
        lqw.eq(UserBrokerageRecord::getType, (Object)BrokerageRecordConstants.BROKERAGE_RECORD_TYPE_ADD);
        lqw.eq(UserBrokerageRecord::getStatus, (Object)BrokerageRecordConstants.BROKERAGE_RECORD_STATUS_FROZEN);
        return this.dao.selectList((Wrapper)lqw);
    }
}

