/*
 * Decompiled with CFR 0.152.
 */
package com.zbkj.service.wangshang.notify.service.impl;

import cn.hutool.core.date.DateUtil;
import com.github.pagehelper.util.StringUtil;
import com.zbkj.common.constants.Constants;
import com.zbkj.common.model.huifu.HuifuWalletTrade;
import com.zbkj.service.config.PaymentChannel;
import com.zbkj.service.dao.HuifuWalletAccountDao;
import com.zbkj.service.dao.HuifuWalletAccountDetailDao;
import com.zbkj.service.dao.HuifuWalletTradeDao;
import com.zbkj.service.service.TransactionLogService;
import com.zbkj.service.wangshang.api.domain.RequestHead;
import com.zbkj.service.wangshang.api.domain.model.notify.BkcloudfundsProtocolWithholdResultNotifyModel;
import com.zbkj.service.wangshang.api.internal.parser.xml.XmlConverter;
import com.zbkj.service.wangshang.api.service.notify.BkcloudfundsProtocolWithholdResultNotifyRequest;
import com.zbkj.service.wangshang.handle.CommomRequstHandle;
import com.zbkj.service.wangshang.notify.service.MybankNotifyService;
import java.util.Date;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service(value="bkcloudfundsProtocolWithholdResultNotifyService")
public class BkcloudfundsProtocolWithholdResultNotifyServiceImpl
implements MybankNotifyService {
    private static final Logger logger = LoggerFactory.getLogger(BkcloudfundsProtocolWithholdResultNotifyServiceImpl.class);
    @Autowired
    private CommomRequstHandle commomRequstHandle;
    @Resource
    private HuifuWalletTradeDao huifuWalletTradeDao;
    @Resource
    private HuifuWalletAccountDetailDao huifuWalletAccountDetailDao;
    @Resource
    private HuifuWalletAccountDao huifuWalletAccountDao;
    @Autowired
    TransactionLogService transactionLogService;

    @Override
    public String notifyHandle(String context, String function) throws Exception {
        System.out.println("========= > \u534f\u8bae\u6388\u6743\u4ee3\u6263\u901a\u77e5\u7ed3\u679c\uff1aant.mybank.bkcloudfunds.protocol.withhold.result.notify");
        System.out.println("========= > \u8bf7\u6c42\u62a5\u6587\uff1a" + context);
        logger.info("========= > \u534f\u8bae\u6388\u6743\u4ee3\u6263\u901a\u77e5\u7ed3\u679c\uff1aant.mybank.bkcloudfunds.protocol.withhold.result.notify");
        logger.info("========= > \u8bf7\u6c42\u62a5\u6587\uff1a" + context);
        BkcloudfundsProtocolWithholdResultNotifyRequest protocolWithholdResultNotifyRequest = XmlConverter.getInstance().toResponse(context, BkcloudfundsProtocolWithholdResultNotifyRequest.class);
        RequestHead head = protocolWithholdResultNotifyRequest.getBkcloudfundsProtocolWithholdResultNotify().getRequestHead();
        boolean flag = false;
        try {
            flag = this.saveNotify(protocolWithholdResultNotifyRequest.getBkcloudfundsProtocolWithholdResultNotify().getBkcloudfundsProtocolWithholdResultNotifyModel());
        }
        catch (Exception e) {
            logger.error("========= > \u534f\u8bae\u6388\u6743\u4ee3\u6263\u901a\u77e5\u7ed3\u679c\uff1aant.mybank.bkcloudfunds.protocol.withhold.result.notify:" + e.getMessage());
        }
        String response = this.commomRequstHandle.getSignResult(flag, head);
        this.transactionLogService.save("\u534f\u8bae\u6388\u6743\u4ee3\u6263\u901a\u77e5\u7ed3\u679c\uff1aant.mybank.bkcloudfunds.protocol.withhold.result.notify", "1", context, response, PaymentChannel.WANGSHANG.toString());
        return response;
    }

    private boolean saveNotify(BkcloudfundsProtocolWithholdResultNotifyModel model) {
        HuifuWalletTrade trade = this.huifuWalletTradeDao.getHuifuWalletTradeByHfSeqId(model.getOperateNo());
        int cf = this.huifuWalletAccountDetailDao.checkFlowNo(trade.getReqSeqId(), trade.getUniId());
        if (cf > 0) {
            return true;
        }
        if ("SUCCESS".equals(model.getStatus())) {
            trade.setTradeStatus(Constants.tradeStatus((String)"S"));
            trade.setOrderNo(model.getOrderNo());
        } else {
            trade.setTradeStatus(Constants.tradeStatus((String)"F"));
            trade.setErrorMsg(model.getErrorDesc());
        }
        if (StringUtil.isNotEmpty((String)model.getFinishDate())) {
            trade.setTransFinishTime(DateUtil.formatDateTime((Date)DateUtil.parse((String)model.getFinishDate(), (String)"yyyyMMddHHmmss")));
        }
        trade.setUpdateTime(new Date());
        this.huifuWalletTradeDao.updateById(trade);
        return true;
    }
}

