/*
 * Decompiled with CFR 0.152.
 */
package com.zbkj.common.vo;

import cn.hutool.core.collection.CollUtil;
import com.zbkj.common.vo.ProCategoryCacheVo;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.stream.Collectors;

public class ProCategoryCacheTree {
    private List<ProCategoryCacheVo> categoryList = new ArrayList<ProCategoryCacheVo>();

    public ProCategoryCacheTree(List<ProCategoryCacheVo> categoryList) {
        this.categoryList = categoryList;
    }

    public List<ProCategoryCacheVo> buildTree() {
        ArrayList<ProCategoryCacheVo> treeCategory = new ArrayList<ProCategoryCacheVo>();
        for (ProCategoryCacheVo categoryNode : this.getRootNode()) {
            categoryNode = this.buildChildTree(categoryNode);
            treeCategory.add(categoryNode);
        }
        return this.sortList(treeCategory);
    }

    private List<ProCategoryCacheVo> sortList(List<ProCategoryCacheVo> treeMenus) {
        treeMenus = treeMenus.stream().sorted(Comparator.comparing(ProCategoryCacheVo::getSort).reversed()).collect(Collectors.toList());
        treeMenus.forEach(e -> {
            if (CollUtil.isNotEmpty(e.getChildList())) {
                e.setChildList(this.sortList(e.getChildList()));
            }
        });
        return treeMenus;
    }

    private ProCategoryCacheVo buildChildTree(ProCategoryCacheVo pNode) {
        ArrayList<ProCategoryCacheVo> childMenus = new ArrayList<ProCategoryCacheVo>();
        for (ProCategoryCacheVo categoryNode : this.categoryList) {
            if (!categoryNode.getPid().equals(pNode.getId())) continue;
            childMenus.add(this.buildChildTree(categoryNode));
        }
        pNode.setChildList(childMenus);
        return pNode;
    }

    private List<ProCategoryCacheVo> getRootNode() {
        ArrayList<ProCategoryCacheVo> rootMenuLists = new ArrayList<ProCategoryCacheVo>();
        for (ProCategoryCacheVo categoryNode : this.categoryList) {
            if (!categoryNode.getPid().equals(0)) continue;
            rootMenuLists.add(categoryNode);
        }
        return rootMenuLists;
    }
}

