/*
 * Decompiled with CFR 0.152.
 */
package com.zbkj.common.vo;

import cn.hutool.core.collection.CollUtil;
import com.zbkj.common.response.MenusResponse;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.stream.Collectors;

public class MenuTree {
    private List<MenusResponse> menuList = new ArrayList<MenusResponse>();

    public MenuTree(List<MenusResponse> menuList) {
        this.menuList = menuList;
    }

    public List<MenusResponse> buildTree() {
        ArrayList<MenusResponse> treeMenus = new ArrayList<MenusResponse>();
        for (MenusResponse menuNode : this.getRootNode()) {
            menuNode = this.buildChildTree(menuNode);
            treeMenus.add(menuNode);
        }
        return this.sortList(treeMenus);
    }

    private List<MenusResponse> sortList(List<MenusResponse> treeMenus) {
        treeMenus = treeMenus.stream().sorted(Comparator.comparing(MenusResponse::getSort).reversed()).collect(Collectors.toList());
        treeMenus.forEach(e -> {
            if (CollUtil.isNotEmpty(e.getChildList())) {
                e.setChildList(this.sortList(e.getChildList()));
            }
        });
        return treeMenus;
    }

    private MenusResponse buildChildTree(MenusResponse pNode) {
        ArrayList<MenusResponse> childMenus = new ArrayList<MenusResponse>();
        for (MenusResponse menuNode : this.menuList) {
            if (!menuNode.getPid().equals(pNode.getId())) continue;
            childMenus.add(this.buildChildTree(menuNode));
        }
        pNode.setChildList(childMenus);
        return pNode;
    }

    private List<MenusResponse> getRootNode() {
        ArrayList<MenusResponse> rootMenuLists = new ArrayList<MenusResponse>();
        for (MenusResponse menuNode : this.menuList) {
            if (!menuNode.getPid().equals(0)) continue;
            rootMenuLists.add(menuNode);
        }
        return rootMenuLists;
    }
}

