/*
 * Decompiled with CFR 0.152.
 */
package com.zbkj.common.vo;

import cn.hutool.core.collection.CollUtil;
import com.zbkj.common.enums.RegionTypeEnum;
import com.zbkj.common.vo.CityVo;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.stream.Collectors;

public class CityTree {
    private List<CityVo> cityList = new ArrayList<CityVo>();

    public CityTree(List<CityVo> cityVoList) {
        this.cityList = cityVoList;
    }

    public List<CityVo> buildTree() {
        ArrayList<CityVo> treeCity = new ArrayList<CityVo>();
        for (CityVo cityVo : this.getRootNode()) {
            cityVo = this.buildChildTree(cityVo);
            treeCity.add(cityVo);
        }
        return this.sortList(treeCity);
    }

    private List<CityVo> sortList(List<CityVo> treeCityList) {
        treeCityList = treeCityList.stream().sorted(Comparator.comparing(CityVo::getRegionId)).collect(Collectors.toList());
        treeCityList.forEach(e -> {
            if (CollUtil.isNotEmpty(e.getChild())) {
                e.setChild(this.sortList(e.getChild()));
            }
        });
        return treeCityList;
    }

    private CityVo buildChildTree(CityVo pNode) {
        ArrayList<CityVo> childCityList = new ArrayList<CityVo>();
        for (CityVo cityVo : this.cityList) {
            if (!cityVo.getParentId().equals(pNode.getRegionId())) continue;
            childCityList.add(this.buildChildTree(cityVo));
        }
        pNode.setChild(childCityList);
        return pNode;
    }

    private List<CityVo> getRootNode() {
        ArrayList<CityVo> cityVoList = new ArrayList<CityVo>();
        for (CityVo cityVo : this.cityList) {
            if (!cityVo.getRegionType().equals(RegionTypeEnum.PROVINCE.getValue())) continue;
            cityVoList.add(cityVo);
        }
        return cityVoList;
    }
}

