/*
 * Decompiled with CFR 0.152.
 */
package com.zbkj.common.utils;

import cn.hutool.core.util.RandomUtil;
import com.alibaba.druid.util.Base64;
import java.awt.Color;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.Serializable;
import java.util.Random;
import javax.imageio.ImageIO;
import org.springframework.stereotype.Component;

@Component
public class ValidateCodeUtil {
    private static Validate validate = null;
    private static final Random random = new Random();
    private static final String randString = "0123456789abcdefghjkmnpqrstuvwxyzABCDEFGHJKLMNPQRSTUVWXYZ";
    private static final int width = 80;
    private static final int height = 34;
    private static final int stringNum = 4;
    private static final int lineSize = 40;

    private ValidateCodeUtil() {
    }

    private static String getRandomChar(int index) {
        return String.valueOf(randString.charAt(index));
    }

    private static int getRandomNum(int min, int max) {
        return RandomUtil.randomInt((int)min, (int)max);
    }

    private static Font getFont() {
        return new Font("Fixedsys", 1, 25);
    }

    private static Color getRandColor(int frontColor, int backColor) {
        if (frontColor > 255) {
            frontColor = 255;
        }
        if (backColor > 255) {
            backColor = 255;
        }
        int red = frontColor + random.nextInt(backColor - frontColor - 16);
        int green = frontColor + random.nextInt(backColor - frontColor - 14);
        int blue = frontColor + random.nextInt(backColor - frontColor - 18);
        return new Color(red, green, blue);
    }

    private static String drawString(Graphics graphics, String randomString, int i) {
        Graphics2D g2d = (Graphics2D)graphics;
        g2d.setFont(ValidateCodeUtil.getFont());
        g2d.setColor(new Color(random.nextFloat(), random.nextFloat(), random.nextFloat()));
        String randChar = ValidateCodeUtil.getRandomChar(random.nextInt(randString.length()));
        randomString = randomString + randChar;
        int rot = ValidateCodeUtil.getRandomNum(1, 10);
        g2d.translate(random.nextInt(3), random.nextInt(3));
        g2d.rotate((double)rot * Math.PI / 180.0);
        g2d.drawString(randChar, 13 * i, 20);
        g2d.rotate((double)(-rot) * Math.PI / 180.0);
        return randomString;
    }

    private static void drawLine(Graphics graphics) {
        int x = random.nextInt(80);
        int y = random.nextInt(34);
        int xl = random.nextInt(13);
        int yl = random.nextInt(15);
        graphics.setColor(new Color(random.nextFloat(), random.nextFloat(), random.nextFloat()));
        graphics.drawLine(x, y, x + xl, y + yl);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static Validate getRandomCode() {
        validate = validate == null ? new Validate() : validate;
        BufferedImage image = new BufferedImage(80, 34, 4);
        Graphics Graphics2 = image.getGraphics();
        Graphics2.fillRect(0, 0, 80, 34);
        Graphics2.setFont(new Font("Times New Roman", 0, 18));
        Graphics2.setColor(ValidateCodeUtil.getRandColor(110, 133));
        for (int i = 0; i <= 40; ++i) {
            ValidateCodeUtil.drawLine(Graphics2);
        }
        String randomString = "";
        for (int i = 1; i <= 4; ++i) {
            randomString = ValidateCodeUtil.drawString(Graphics2, randomString, i);
            validate.setValue(randomString);
        }
        Graphics2.dispose();
        ByteArrayOutputStream bs = null;
        try {
            bs = new ByteArrayOutputStream();
            ImageIO.write((RenderedImage)image, "png", bs);
            String imgSrc = Base64.byteArrayToBase64((byte[])bs.toByteArray());
            validate.setBase64Str(imgSrc);
            return validate;
        }
        catch (Exception e) {
            e.printStackTrace();
            return validate;
        }
        finally {
            try {
                try {
                    bs.close();
                    bs = null;
                }
                catch (IOException e) {
                    e.printStackTrace();
                    bs = null;
                }
            }
            catch (Throwable throwable) {
                bs = null;
                throw throwable;
            }
        }
    }

    public static class Validate
    implements Serializable {
        private static final long serialVersionUID = 1L;
        private String Base64Str;
        private String value;

        public String getBase64Str() {
            return this.Base64Str;
        }

        public void setBase64Str(String base64Str) {
            this.Base64Str = base64Str;
        }

        public String getValue() {
            return this.value;
        }

        public void setValue(String value) {
            this.value = value;
        }
    }
}

