/*
 * Decompiled with CFR 0.152.
 */
package com.zbkj.service.service.impl;

import cn.hutool.core.collection.CollUtil;
import cn.hutool.core.date.DateUtil;
import cn.hutool.core.util.ObjectUtil;
import cn.hutool.core.util.StrUtil;
import cn.hutool.crypto.SecureUtil;
import com.alibaba.fastjson.JSONObject;
import com.zbkj.common.config.CrmebConfig;
import com.zbkj.common.constants.WeChatConstants;
import com.zbkj.common.exception.CrmebException;
import com.zbkj.common.model.wechat.WechatExceptions;
import com.zbkj.common.model.wechat.WechatPayInfo;
import com.zbkj.common.response.WeChatJsSdkConfigResponse;
import com.zbkj.common.response.WechatOpenUploadResponse;
import com.zbkj.common.response.WechatPublicShareResponse;
import com.zbkj.common.utils.CrmebUtil;
import com.zbkj.common.utils.RedisUtil;
import com.zbkj.common.utils.RestTemplateUtil;
import com.zbkj.common.utils.UploadWeChatMediaUtil;
import com.zbkj.common.utils.XmlUtil;
import com.zbkj.common.vo.CreateOrderRequestVo;
import com.zbkj.common.vo.CreateOrderResponseVo;
import com.zbkj.common.vo.MyRecord;
import com.zbkj.common.vo.ProgramTemplateMessageVo;
import com.zbkj.common.vo.TemplateMessageVo;
import com.zbkj.common.vo.WeChatAccessTokenVo;
import com.zbkj.common.vo.WeChatAuthorizeLoginUserInfoVo;
import com.zbkj.common.vo.WeChatMiniAuthorizeVo;
import com.zbkj.common.vo.WeChatOauthToken;
import com.zbkj.common.vo.WxRefundResponseVo;
import com.zbkj.common.vo.WxRefundVo;
import com.zbkj.service.service.SystemConfigService;
import com.zbkj.service.service.WechatExceptionsService;
import com.zbkj.service.service.WechatPayInfoService;
import com.zbkj.service.service.WechatService;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.TimeUnit;
import org.apache.commons.codec.binary.Base64;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.web.multipart.MultipartFile;

@Service
public class WechatServiceImpl
implements WechatService {
    private static final Logger logger = LoggerFactory.getLogger(WechatServiceImpl.class);
    @Autowired
    private CrmebConfig crmebConfig;
    @Autowired
    private RedisUtil redisUtil;
    @Autowired
    private RestTemplateUtil restTemplateUtil;
    @Autowired
    private SystemConfigService systemConfigService;
    @Autowired
    private WechatExceptionsService wechatExceptionsService;
    @Autowired
    private WechatPayInfoService wechatPayInfoService;

    @Override
    public String getPublicAccessToken() {
        boolean exists = this.redisUtil.exists("wechat_public_accessToken");
        if (exists) {
            Object accessToken = this.redisUtil.get("wechat_public_accessToken");
            return accessToken.toString();
        }
        String appId = this.systemConfigService.getValueByKey("wechat_appid");
        if (StrUtil.isBlank((CharSequence)appId)) {
            throw new CrmebException("\u5fae\u4fe1\u516c\u4f17\u53f7appId\u672a\u8bbe\u7f6e");
        }
        String secret = this.systemConfigService.getValueByKey("wechat_appsecret");
        if (StrUtil.isBlank((CharSequence)secret)) {
            throw new CrmebException("\u5fae\u4fe1\u516c\u4f17\u53f7secret\u672a\u8bbe\u7f6e");
        }
        WeChatAccessTokenVo accessTokenVo = this.getAccessToken(appId, secret, "public");
        this.redisUtil.set("wechat_public_accessToken", (Object)accessTokenVo.getAccessToken(), Long.valueOf(accessTokenVo.getExpiresIn().longValue() - 1800L), TimeUnit.SECONDS);
        return accessTokenVo.getAccessToken();
    }

    @Override
    public String getMiniAccessToken() {
        boolean exists = this.redisUtil.exists("wechat_mini_accessToken");
        if (exists) {
            Object accessToken = this.redisUtil.get("wechat_mini_accessToken");
            return accessToken.toString();
        }
        String appId = this.systemConfigService.getValueByKey("routine_appid");
        if (StrUtil.isBlank((CharSequence)appId)) {
            throw new CrmebException("\u5fae\u4fe1\u5c0f\u7a0b\u5e8fappId\u672a\u8bbe\u7f6e");
        }
        String secret = this.systemConfigService.getValueByKey("routine_appsecret");
        if (StrUtil.isBlank((CharSequence)secret)) {
            throw new CrmebException("\u5fae\u4fe1\u5c0f\u7a0b\u5e8fsecret\u672a\u8bbe\u7f6e");
        }
        WeChatAccessTokenVo accessTokenVo = this.getAccessToken(appId, secret, "mini");
        this.redisUtil.set("wechat_mini_accessToken", (Object)accessTokenVo.getAccessToken(), Long.valueOf(accessTokenVo.getExpiresIn().longValue() - 1800L), TimeUnit.SECONDS);
        return accessTokenVo.getAccessToken();
    }

    @Override
    public WeChatOauthToken getOauth2AccessToken(String code) {
        String appId = this.systemConfigService.getValueByKey("wechat_appid");
        if (StrUtil.isBlank((CharSequence)appId)) {
            throw new CrmebException("\u5fae\u4fe1\u516c\u4f17\u53f7appId\u672a\u8bbe\u7f6e");
        }
        String secret = this.systemConfigService.getValueByKey("wechat_appsecret");
        if (StrUtil.isBlank((CharSequence)secret)) {
            throw new CrmebException("\u5fae\u4fe1\u516c\u4f17\u53f7secret\u672a\u8bbe\u7f6e");
        }
        String url = StrUtil.format((CharSequence)"https://api.weixin.qq.com/sns/oauth2/access_token?appid={}&secret={}&code={}&grant_type=authorization_code", (Object[])new Object[]{appId, secret, code});
        JSONObject data = this.restTemplateUtil.getData(url);
        if (ObjectUtil.isNull((Object)data)) {
            throw new CrmebException("\u5fae\u4fe1\u5e73\u53f0\u63a5\u53e3\u5f02\u5e38\uff0c\u6ca1\u4efb\u4f55\u6570\u636e\u8fd4\u56de\uff01");
        }
        if (data.containsKey((Object)"errcode") && !data.getString("errcode").equals("0") && data.containsKey((Object)"errmsg")) {
            this.wxExceptionDispose(data, "\u5fae\u4fe1\u83b7\u53d6\u5f00\u653e\u5e73\u53f0access_token\u5f02\u5e38");
            throw new CrmebException("\u5fae\u4fe1\u63a5\u53e3\u8c03\u7528\u5931\u8d25\uff1a" + data.getString("errcode") + data.getString("errmsg"));
        }
        return (WeChatOauthToken)JSONObject.parseObject((String)data.toJSONString(), WeChatOauthToken.class);
    }

    @Override
    public WeChatAuthorizeLoginUserInfoVo getSnsUserInfo(String accessToken, String openid) {
        String url = StrUtil.format((CharSequence)"https://api.weixin.qq.com/sns/userinfo?access_token={}&openid={}&lang={}", (Object[])new Object[]{accessToken, openid, "zh_CN"});
        JSONObject data = this.restTemplateUtil.getData(url);
        if (ObjectUtil.isNull((Object)data)) {
            throw new CrmebException("\u5fae\u4fe1\u5e73\u53f0\u63a5\u53e3\u5f02\u5e38\uff0c\u6ca1\u4efb\u4f55\u6570\u636e\u8fd4\u56de\uff01");
        }
        if (data.containsKey((Object)"errcode") && !data.getString("errcode").equals("0") && data.containsKey((Object)"errmsg")) {
            this.wxExceptionDispose(data, "\u5fae\u4fe1\u83b7\u53d6\u5f00\u653e\u5e73\u53f0\u7528\u6237\u4fe1\u606f\u5f02\u5e38");
            throw new CrmebException("\u5fae\u4fe1\u63a5\u53e3\u8c03\u7528\u5931\u8d25\uff1a" + data.getString("errcode") + data.getString("errmsg"));
        }
        return (WeChatAuthorizeLoginUserInfoVo)JSONObject.parseObject((String)data.toJSONString(), WeChatAuthorizeLoginUserInfoVo.class);
    }

    @Override
    public WeChatMiniAuthorizeVo miniAuthCode(String code) {
        String appId = this.systemConfigService.getValueByKey("routine_appid");
        if (StrUtil.isBlank((CharSequence)appId)) {
            throw new CrmebException("\u5fae\u4fe1\u5c0f\u7a0b\u5e8fappId\u672a\u8bbe\u7f6e");
        }
        String secret = this.systemConfigService.getValueByKey("routine_appsecret");
        if (StrUtil.isBlank((CharSequence)secret)) {
            throw new CrmebException("\u5fae\u4fe1\u5c0f\u7a0b\u5e8fsecret\u672a\u8bbe\u7f6e");
        }
        String url = StrUtil.format((CharSequence)"https://api.weixin.qq.com/sns/jscode2session?appid={}&secret={}&js_code={}&grant_type=authorization_code", (Object[])new Object[]{appId, secret, code});
        JSONObject data = this.restTemplateUtil.getData(url);
        if (ObjectUtil.isNull((Object)data)) {
            throw new CrmebException("\u5fae\u4fe1\u5e73\u53f0\u63a5\u53e3\u5f02\u5e38\uff0c\u6ca1\u4efb\u4f55\u6570\u636e\u8fd4\u56de\uff01");
        }
        if (data.containsKey((Object)"errcode") && !data.getString("errcode").equals("0") && data.containsKey((Object)"errmsg")) {
            this.wxExceptionDispose(data, "\u5fae\u4fe1\u5c0f\u7a0b\u5e8f\u767b\u5f55\u51ed\u8bc1\u6821\u9a8c\u5f02\u5e38");
            throw new CrmebException("\u5fae\u4fe1\u63a5\u53e3\u8c03\u7528\u5931\u8d25\uff1a" + data.getString("errcode") + data.getString("errmsg"));
        }
        return (WeChatMiniAuthorizeVo)JSONObject.parseObject((String)data.toJSONString(), WeChatMiniAuthorizeVo.class);
    }

    @Override
    public WeChatJsSdkConfigResponse getPublicJsConfig(String url) {
        try {
            url = URLDecoder.decode(url, "UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            throw new CrmebException("url\u65e0\u6cd5\u89e3\u6790\uff01");
        }
        String appId = this.systemConfigService.getValueByKey("wechat_appid");
        if (StrUtil.isBlank((CharSequence)appId)) {
            throw new CrmebException("\u5fae\u4fe1\u516c\u4f17\u53f7appId\u672a\u8bbe\u7f6e");
        }
        String ticket = this.getJsApiTicket();
        String nonceStr = CrmebUtil.getUuid();
        Long timestamp = DateUtil.currentSeconds();
        String signature = this.getJsSDKSignature(nonceStr, ticket, timestamp, url);
        WeChatJsSdkConfigResponse response = new WeChatJsSdkConfigResponse();
        response.setUrl(url);
        response.setAppId(appId);
        response.setNonceStr(nonceStr);
        response.setTimestamp(timestamp);
        response.setSignature(signature);
        response.setJsApiList(CrmebUtil.stringToArrayStr((String)"editAddress,openAddress,updateTimelineShareData,updateAppMessageShareData,onMenuShareTimeline,onMenuShareAppMessage,onMenuShareQQ,onMenuShareWeibo,onMenuShareQZone,startRecord,stopRecord,onVoiceRecordEnd,playVoice,pauseVoice,stopVoice,onVoicePlayEnd,uploadVoice,downloadVoice,chooseImage,previewImage,uploadImage,downloadImage,translateVoice,getNetworkType,openLocation,getLocation,hideOptionMenu,showOptionMenu,hideMenuItems,showMenuItems,hideAllNonBaseMenuItem,showAllNonBaseMenuItem,closeWindow,scanQRCode,chooseWXPay,openProductSpecificView,addCard,chooseCard,openCard"));
        response.setDebug(this.crmebConfig.isWechatJsApiDebug());
        return response;
    }

    @Override
    public String createQrCode(JSONObject jsonObject) {
        String miniAccessToken = this.getMiniAccessToken();
        String url = StrUtil.format((CharSequence)"https://api.weixin.qq.com/wxa/getwxacodeunlimit?access_token={}", (Object[])new Object[]{miniAccessToken});
        byte[] bytes = this.restTemplateUtil.postJsonDataAndReturnBuffer(url, jsonObject);
        String response = new String(bytes);
        if (StringUtils.contains((CharSequence)response, (CharSequence)"errcode")) {
            logger.error("\u5fae\u4fe1\u751f\u6210\u5c0f\u7a0b\u5e8f\u7801\u5f02\u5e38" + response);
            JSONObject data = JSONObject.parseObject((String)response);
            this.wxExceptionDispose(data, "\u5fae\u4fe1\u5c0f\u7a0b\u5e8f\u751f\u6210\u5c0f\u7a0b\u5e8f\u7801\u5f02\u5e38");
            if (data.getString("errcode").equals("40001")) {
                this.redisUtil.delete(new String[]{"wechat_mini_accessToken"});
                miniAccessToken = this.getMiniAccessToken();
                url = StrUtil.format((CharSequence)"https://api.weixin.qq.com/wxa/getwxacodeunlimit?access_token={}", (Object[])new Object[]{miniAccessToken});
                bytes = this.restTemplateUtil.postJsonDataAndReturnBuffer(url, jsonObject);
                response = new String(bytes);
                if (StringUtils.contains((CharSequence)response, (CharSequence)"errcode")) {
                    logger.error("\u5fae\u4fe1\u751f\u6210\u5c0f\u7a0b\u5e8f\u7801\u91cd\u8bd5\u5f02\u5e38" + response);
                    JSONObject data2 = JSONObject.parseObject((String)response);
                    this.wxExceptionDispose(data2, "\u5fae\u4fe1\u5c0f\u7a0b\u5e8f\u91cd\u8bd5\u751f\u6210\u5c0f\u7a0b\u5e8f\u7801\u5f02\u5e38");
                } else {
                    try {
                        return CrmebUtil.getBase64Image((String)Base64.encodeBase64String((byte[])bytes));
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                        throw new CrmebException("\u5fae\u4fe1\u5c0f\u7a0b\u5e8f\u7801\u8f6c\u6362Base64\u5f02\u5e38");
                    }
                }
            }
            throw new CrmebException("\u5fae\u4fe1\u751f\u6210\u4e8c\u7ef4\u7801\u5f02\u5e38");
        }
        try {
            return CrmebUtil.getBase64Image((String)Base64.encodeBase64String((byte[])bytes));
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new CrmebException("\u5fae\u4fe1\u5c0f\u7a0b\u5e8f\u7801\u8f6c\u6362Base64\u5f02\u5e38");
        }
    }

    @Override
    public CreateOrderResponseVo payUnifiedorder(CreateOrderRequestVo unifiedorderVo) {
        try {
            String url = "https://api.mch.weixin.qq.com/pay/unifiedorder";
            String request = XmlUtil.objectToXml((Object)unifiedorderVo);
            String xml = this.restTemplateUtil.postXml(url, request);
            HashMap map = XmlUtil.xmlToMap((String)xml);
            if (null == map) {
                throw new CrmebException("\u5fae\u4fe1\u4e0b\u5355\u5931\u8d25\uff01");
            }
            WechatPayInfo wechatPayInfo = this.createWechatPayInfo(unifiedorderVo);
            CreateOrderResponseVo responseVo = (CreateOrderResponseVo)CrmebUtil.mapToObj((HashMap)map, CreateOrderResponseVo.class);
            if (responseVo.getReturnCode().equalsIgnoreCase("FAIL")) {
                this.wxPayExceptionDispose(map, "\u5fae\u4fe1\u652f\u4ed8\u9884\u4e0b\u5355\u5f02\u5e38");
                wechatPayInfo.setErrCode(map.get("return_code").toString());
                this.wechatPayInfoService.save(wechatPayInfo);
                throw new CrmebException("\u5fae\u4fe1\u4e0b\u5355\u5931\u8d251\uff01" + responseVo.getReturnMsg());
            }
            if (responseVo.getResultCode().equalsIgnoreCase("FAIL")) {
                this.wxPayExceptionDispose(map, "\u5fae\u4fe1\u652f\u4ed8\u9884\u4e0b\u5355\u4e1a\u52a1\u5f02\u5e38");
                wechatPayInfo.setErrCode(map.get("err_code").toString());
                this.wechatPayInfoService.save(wechatPayInfo);
                throw new CrmebException("\u5fae\u4fe1\u4e0b\u5355\u5931\u8d252\uff01" + responseVo.getErrCodeDes());
            }
            wechatPayInfo.setErrCode("200");
            wechatPayInfo.setPrepayId(responseVo.getPrepayId());
            this.wechatPayInfoService.save(wechatPayInfo);
            responseVo.setExtra(unifiedorderVo.getScene_info());
            return responseVo;
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new CrmebException(e.getMessage());
        }
    }

    private WechatPayInfo createWechatPayInfo(CreateOrderRequestVo vo) {
        WechatPayInfo payInfo = new WechatPayInfo();
        payInfo.setAppId(vo.getAppid());
        payInfo.setMchId(vo.getMch_id());
        payInfo.setDeviceInfo(vo.getDevice_info());
        payInfo.setOpenId(vo.getOpenid());
        payInfo.setNonceStr(vo.getNonce_str());
        payInfo.setSign(vo.getSign());
        payInfo.setSignType(vo.getSign_type());
        payInfo.setBody(vo.getBody());
        payInfo.setDetail(vo.getDetail());
        payInfo.setAttach(vo.getAttach());
        payInfo.setOutTradeNo(vo.getOut_trade_no());
        payInfo.setFeeType(vo.getFee_type());
        payInfo.setTotalFee(Integer.valueOf(vo.getTotal_fee()));
        payInfo.setSpbillCreateIp(vo.getSpbill_create_ip());
        payInfo.setTimeStart(vo.getTime_start());
        payInfo.setTimeExpire(vo.getTime_expire());
        payInfo.setNotifyUrl(vo.getNotify_url());
        payInfo.setTradeType(vo.getTrade_type());
        payInfo.setProductId(vo.getProduct_id());
        payInfo.setSceneInfo(vo.getScene_info());
        return payInfo;
    }

    @Override
    public MyRecord payOrderQuery(Map<String, String> payVo) {
        String url = "https://api.mch.weixin.qq.com/pay/orderquery";
        try {
            String request = XmlUtil.mapToXml(payVo);
            String xml = this.restTemplateUtil.postXml(url, request);
            HashMap map = XmlUtil.xmlToMap((String)xml);
            MyRecord record = new MyRecord();
            if (null == map) {
                throw new CrmebException("\u5fae\u4fe1\u8ba2\u5355\u67e5\u8be2\u5931\u8d25\uff01");
            }
            record.setColums((Map)map);
            if (record.getStr("return_code").equalsIgnoreCase("FAIL")) {
                this.wxPayQueryExceptionDispose(record, "\u5fae\u4fe1\u652f\u4ed8\u67e5\u8be2\u8ba2\u5355\u901a\u4fe1\u5f02\u5e38");
                throw new CrmebException("\u5fae\u4fe1\u8ba2\u5355\u67e5\u8be2\u5931\u8d251\uff01" + record.getStr("return_msg"));
            }
            if (record.getStr("result_code").equalsIgnoreCase("FAIL")) {
                this.wxPayQueryExceptionDispose(record, "\u5fae\u4fe1\u652f\u4ed8\u67e5\u8be2\u8ba2\u5355\u7ed3\u679c\u5f02\u5e38");
                throw new CrmebException("\u5fae\u4fe1\u8ba2\u5355\u67e5\u8be2\u5931\u8d252\uff01" + record.getStr("err_code") + record.getStr("err_code_des"));
            }
            if (!record.getStr("trade_state").equalsIgnoreCase("SUCCESS")) {
                this.wxPayQueryExceptionDispose(record, "\u5fae\u4fe1\u652f\u4ed8\u67e5\u8be2\u8ba2\u5355\u72b6\u6001\u5f02\u5e38");
                throw new CrmebException("\u5fae\u4fe1\u8ba2\u5355\u652f\u4ed8\u5931\u8d253\uff01" + record.getStr("trade_state"));
            }
            return record;
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new CrmebException("\u67e5\u8be2\u5fae\u4fe1\u8ba2\u5355mapToXml\u5f02\u5e38===\u300b" + e.getMessage());
        }
    }

    @Override
    public Boolean sendPublicTemplateMessage(TemplateMessageVo templateMessage) {
        JSONObject jsonData;
        String accessToken = this.getPublicAccessToken();
        String url = StrUtil.format((CharSequence)"https://api.weixin.qq.com/cgi-bin/message/template/send?access_token={}", (Object[])new Object[]{accessToken});
        String result = this.restTemplateUtil.postJsonData(url, jsonData = JSONObject.parseObject((String)JSONObject.toJSONString((Object)templateMessage)));
        JSONObject data = JSONObject.parseObject((String)result);
        if (ObjectUtil.isNull((Object)data)) {
            throw new CrmebException("\u5fae\u4fe1\u5e73\u53f0\u63a5\u53e3\u5f02\u5e38\uff0c\u6ca1\u4efb\u4f55\u6570\u636e\u8fd4\u56de\uff01");
        }
        if (data.containsKey((Object)"errcode") && !data.getString("errcode").equals("0") && data.containsKey((Object)"errmsg")) {
            this.wxExceptionDispose(data, "\u5fae\u4fe1\u516c\u4f17\u53f7\u53d1\u9001\u6a21\u677f\u6d88\u606f\u5f02\u5e38");
            throw new CrmebException("\u5fae\u4fe1\u63a5\u53e3\u8c03\u7528\u5931\u8d25\uff1a" + data.getString("errcode") + data.getString("errmsg"));
        }
        return Boolean.TRUE;
    }

    @Override
    public Boolean sendMiniSubscribeMessage(ProgramTemplateMessageVo templateMessage) {
        JSONObject messAge;
        String accessToken = this.getMiniAccessToken();
        String url = StrUtil.format((CharSequence)"https://api.weixin.qq.com/cgi-bin/message/subscribe/send?access_token={}", (Object[])new Object[]{accessToken});
        String result = this.restTemplateUtil.postJsonData(url, messAge = JSONObject.parseObject((String)JSONObject.toJSONString((Object)templateMessage)));
        JSONObject data = JSONObject.parseObject((String)result);
        if (ObjectUtil.isNull((Object)data)) {
            throw new CrmebException("\u5fae\u4fe1\u5e73\u53f0\u63a5\u53e3\u5f02\u5e38\uff0c\u6ca1\u4efb\u4f55\u6570\u636e\u8fd4\u56de\uff01");
        }
        if (data.containsKey((Object)"errcode") && !data.getString("errcode").equals("0")) {
            if (data.getString("errcode").equals("40001")) {
                this.wxExceptionDispose(data, "\u5fae\u4fe1\u5c0f\u7a0b\u5e8f\u53d1\u9001\u8ba2\u9605\u6d88\u606f\u5f02\u5e38");
                this.redisUtil.delete(new String[]{"wechat_mini_accessToken"});
                accessToken = this.getMiniAccessToken();
                url = StrUtil.format((CharSequence)"https://api.weixin.qq.com/cgi-bin/message/subscribe/send?access_token={}", (Object[])new Object[]{accessToken});
                result = this.restTemplateUtil.postJsonData(url, messAge);
                JSONObject data2 = JSONObject.parseObject((String)result);
                if (data2.containsKey((Object)"errcode") && !data2.getString("errcode").equals("0")) {
                    if (data2.containsKey((Object)"errmsg")) {
                        this.wxExceptionDispose(data2, "\u5fae\u4fe1\u5c0f\u7a0b\u5e8f\u53d1\u9001\u8ba2\u9605\u6d88\u606f\u91cd\u8bd5\u5f02\u5e38");
                        throw new CrmebException("\u5fae\u4fe1\u63a5\u53e3\u8c03\u7528\u5931\u8d25\uff1a" + data2.getString("errcode") + data2.getString("errmsg"));
                    }
                } else {
                    return Boolean.TRUE;
                }
            }
            if (data.containsKey((Object)"errmsg")) {
                this.wxExceptionDispose(data, "\u5fae\u4fe1\u5c0f\u7a0b\u5e8f\u53d1\u9001\u8ba2\u9605\u6d88\u606f\u5f02\u5e38");
                throw new CrmebException("\u5fae\u4fe1\u63a5\u53e3\u8c03\u7528\u5931\u8d25\uff1a" + data.getString("errcode") + data.getString("errmsg"));
            }
        }
        return Boolean.TRUE;
    }

    @Override
    public JSONObject getPublicCustomMenu() {
        JSONObject jsonObject = (JSONObject)this.redisUtil.get("wechat_public_menu_key");
        if (ObjectUtil.isNotNull((Object)jsonObject) && StrUtil.isNotBlank((CharSequence)jsonObject.toString())) {
            return jsonObject;
        }
        String accessToken = this.getPublicAccessToken();
        String url = StrUtil.format((CharSequence)"https://api.weixin.qq.com/cgi-bin/menu/get?access_token={}", (Object[])new Object[]{accessToken});
        JSONObject result = this.restTemplateUtil.getData(url);
        if (ObjectUtil.isNull((Object)result)) {
            throw new CrmebException("\u5fae\u4fe1\u5e73\u53f0\u63a5\u53e3\u5f02\u5e38\uff0c\u6ca1\u4efb\u4f55\u6570\u636e\u8fd4\u56de\uff01");
        }
        if (result.containsKey((Object)"errcode") && result.getString("errcode").equals("0")) {
            return result;
        }
        if (result.containsKey((Object)"errmsg")) {
            this.wxExceptionDispose(result, "\u5fae\u4fe1\u516c\u4f17\u53f7\u83b7\u53d6\u81ea\u5b9a\u4e49\u83dc\u5355\u914d\u7f6e\u5f02\u5e38");
            throw new CrmebException("\u5fae\u4fe1\u63a5\u53e3\u8c03\u7528\u5931\u8d25\uff1a" + result.getString("errcode") + result.getString("errmsg"));
        }
        this.redisUtil.set("wechat_public_menu_key", (Object)result);
        return result;
    }

    @Override
    public Boolean createPublicCustomMenu(String data) {
        String accessToken = this.getPublicAccessToken();
        String url = StrUtil.format((CharSequence)"https://api.weixin.qq.com/cgi-bin/menu/create?access_token={}", (Object[])new Object[]{accessToken});
        String result = this.restTemplateUtil.postJsonData(url, JSONObject.parseObject((String)data));
        logger.info("\u5fae\u4fe1\u6d88\u606f\u53d1\u9001\u7ed3\u679c:" + result);
        JSONObject jsonObject = JSONObject.parseObject((String)result);
        if (ObjectUtil.isNull((Object)jsonObject)) {
            throw new CrmebException("\u5fae\u4fe1\u5e73\u53f0\u63a5\u53e3\u5f02\u5e38\uff0c\u6ca1\u4efb\u4f55\u6570\u636e\u8fd4\u56de\uff01");
        }
        if (jsonObject.containsKey((Object)"errcode") && jsonObject.getString("errcode").equals("0")) {
            if (this.redisUtil.exists("wechat_public_menu_key").booleanValue()) {
                this.redisUtil.delete(new String[]{"wechat_public_menu_key"});
            }
            return Boolean.TRUE;
        }
        if (jsonObject.containsKey((Object)"errmsg")) {
            this.wxExceptionDispose(jsonObject, "\u5fae\u4fe1\u516c\u4f17\u53f7\u521b\u5efa\u81ea\u5b9a\u4e49\u83dc\u5355\u5f02\u5e38");
            throw new CrmebException("\u5fae\u4fe1\u63a5\u53e3\u8c03\u7528\u5931\u8d25\uff1a" + jsonObject.getString("errcode") + jsonObject.getString("errmsg"));
        }
        return Boolean.TRUE;
    }

    @Override
    public Boolean deletePublicCustomMenu() {
        String accessToken = this.getPublicAccessToken();
        String url = StrUtil.format((CharSequence)"https://api.weixin.qq.com/cgi-bin/menu/delete?access_token={}", (Object[])new Object[]{accessToken});
        JSONObject result = this.restTemplateUtil.getData(url);
        if (ObjectUtil.isNull((Object)result)) {
            throw new CrmebException("\u5fae\u4fe1\u5e73\u53f0\u63a5\u53e3\u5f02\u5e38\uff0c\u6ca1\u4efb\u4f55\u6570\u636e\u8fd4\u56de\uff01");
        }
        if (result.containsKey((Object)"errcode") && result.getString("errcode").equals("0")) {
            return Boolean.TRUE;
        }
        if (result.containsKey((Object)"errmsg")) {
            this.wxExceptionDispose(result, "\u5fae\u4fe1\u516c\u4f17\u53f7\u5220\u9664\u81ea\u5b9a\u4e49\u83dc\u5355\u5f02\u5e38");
            throw new CrmebException("\u5fae\u4fe1\u63a5\u53e3\u8c03\u7528\u5931\u8d25\uff1a" + result.getString("errcode") + result.getString("errmsg"));
        }
        if (this.redisUtil.exists("wechat_public_menu_key").booleanValue()) {
            this.redisUtil.delete(new String[]{"wechat_public_menu_key"});
        }
        return Boolean.TRUE;
    }

    @Override
    public String qyapiAddMaterialUrl(String type) {
        String accessToken = this.getPublicAccessToken();
        return StrUtil.format((CharSequence)"https://qyapi.weixin.qq.com/cgi-bin/material/add_material?type={}&access_token={}", (Object[])new Object[]{type, accessToken});
    }

    @Override
    public WxRefundResponseVo payRefund(WxRefundVo wxRefundVo, String path) {
        String xmlStr = XmlUtil.objectToXml((Object)wxRefundVo);
        String url = "https://api.mch.weixin.qq.com/secapi/pay/refund";
        HashMap map = CollUtil.newHashMap();
        String xml = "";
        try {
            xml = this.restTemplateUtil.postWXRefundXml(url, xmlStr, wxRefundVo.getMch_id(), path);
            map = XmlUtil.xmlToMap((String)xml);
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new CrmebException("xmlToMap\u9519\u8bef\uff0cxml = " + xml);
        }
        if (null == map) {
            throw new CrmebException("\u5fae\u4fe1\u65e0\u4fe1\u606f\u8fd4\u56de\uff0c\u5fae\u4fe1\u7533\u8bf7\u9000\u6b3e\u5931\u8d25\uff01");
        }
        WxRefundResponseVo responseVo = (WxRefundResponseVo)CrmebUtil.mapToObj((HashMap)map, WxRefundResponseVo.class);
        if (responseVo.getReturnCode().equalsIgnoreCase("FAIL")) {
            this.wxPayExceptionDispose(map, "\u5fae\u4fe1\u7533\u8bf7\u9000\u6b3e\u5f02\u5e381");
            throw new CrmebException("\u5fae\u4fe1\u7533\u8bf7\u9000\u6b3e\u5931\u8d251\uff01" + responseVo.getReturnMsg());
        }
        if (responseVo.getResultCode().equalsIgnoreCase("FAIL")) {
            this.wxPayExceptionDispose(map, "\u5fae\u4fe1\u7533\u8bf7\u9000\u6b3e\u4e1a\u52a1\u5f02\u5e38");
            throw new CrmebException("\u5fae\u4fe1\u7533\u8bf7\u9000\u6b3e\u5931\u8d252\uff01" + responseVo.getErrCodeDes());
        }
        System.out.println("================\u5fae\u4fe1\u7533\u8bf7\u9000\u6b3e\u7ed3\u675f=========================");
        return responseVo;
    }

    @Override
    public WechatOpenUploadResponse openMediaUpload(MultipartFile file, String type) {
        InputStream inputStream;
        if (StrUtil.isBlank((CharSequence)type)) {
            throw new CrmebException("\u8bf7\u9009\u62e9\u7d20\u6750\u7c7b\u578b");
        }
        if (!"image".equals(type) && !"voice".equals(type)) {
            throw new CrmebException("\u672a\u77e5\u7684\u7d20\u6750\u7c7b\u578b");
        }
        String[] split = Objects.requireNonNull(file.getOriginalFilename()).split("\\.");
        String suffixName = split[split.length - 1];
        this.isValidPic(file.getSize(), suffixName, type);
        String url = this.qyapiAddMaterialUrl(type);
        try {
            inputStream = file.getResource().getInputStream();
        }
        catch (Exception e) {
            logger.error("\u83b7\u53d6\u6587\u4ef6\u8f93\u5165\u6d41\u5931\u8d25");
            throw new CrmebException(e.getMessage());
        }
        JSONObject uploadFile = UploadWeChatMediaUtil.uploadFile((String)url, (InputStream)inputStream, (String)file.getOriginalFilename());
        if (ObjectUtil.isNull((Object)uploadFile) || !uploadFile.containsKey((Object)"media_id")) {
            String message = ObjectUtil.isNotNull((Object)uploadFile) ? uploadFile.getString("errmsg") : "";
            throw new CrmebException("\u7d20\u6750\u4e0a\u4f20\u5931\u8d25" + message);
        }
        WechatOpenUploadResponse response = new WechatOpenUploadResponse();
        response.setMediaId(uploadFile.getString("media_id"));
        response.setUrl(uploadFile.getString("url"));
        response.setName(file.getOriginalFilename().replace(suffixName, ""));
        return response;
    }

    @Override
    public WechatPublicShareResponse getPublicShare() {
        WechatPublicShareResponse response = new WechatPublicShareResponse();
        response.setImage(this.systemConfigService.getValueByKey("wechat_share_img"));
        response.setTitle(this.systemConfigService.getValueByKey("wechat_share_title"));
        response.setSynopsis(this.systemConfigService.getValueByKey("wechat_share_synopsis"));
        return response;
    }

    private String getJsSDKSignature(String nonceStr, String ticket, Long timestamp, String url) {
        String paramString = StrUtil.format((CharSequence)"jsapi_ticket={}&noncestr={}&timestamp={}&url={}", (Object[])new Object[]{ticket, nonceStr, timestamp, url});
        return SecureUtil.sha1((String)paramString);
    }

    private String getJsApiTicket() {
        boolean exists = this.redisUtil.exists("wechat_js_api_ticket");
        if (exists) {
            Object ticket = this.redisUtil.get("wechat_js_api_ticket");
            return ticket.toString();
        }
        String accessToken = this.getPublicAccessToken();
        String url = StrUtil.format((CharSequence)"https://api.weixin.qq.com/cgi-bin/ticket/getticket?access_token={}&type=jsapi", (Object[])new Object[]{accessToken});
        JSONObject data = this.restTemplateUtil.getData(url);
        if (ObjectUtil.isNull((Object)data)) {
            throw new CrmebException("\u5fae\u4fe1\u5e73\u53f0\u63a5\u53e3\u5f02\u5e38\uff0c\u6ca1\u4efb\u4f55\u6570\u636e\u8fd4\u56de\uff01");
        }
        if (data.containsKey((Object)"errcode") && !data.getString("errcode").equals("0") && data.containsKey((Object)"errmsg")) {
            this.wxExceptionDispose(data, "\u5fae\u4fe1\u83b7\u53d6JS-SDK\u7684ticket\u5f02\u5e38");
            throw new CrmebException("\u5fae\u4fe1\u63a5\u53e3\u8c03\u7528\u5931\u8d25\uff1a" + data.getString("errcode") + data.getString("errmsg"));
        }
        String ticket = data.getString("ticket");
        this.redisUtil.set("wechat_js_api_ticket", (Object)ticket, WeChatConstants.REDIS_PUBLIC_JS_API_TICKET_EXPRESS, TimeUnit.SECONDS);
        return ticket;
    }

    private WeChatAccessTokenVo getAccessToken(String appId, String secret, String type) {
        String url = StrUtil.format((CharSequence)"https://api.weixin.qq.com/cgi-bin/token?grant_type=client_credential&appid={}&secret={}", (Object[])new Object[]{appId, secret});
        JSONObject data = this.restTemplateUtil.getData(url);
        if (ObjectUtil.isNull((Object)data)) {
            throw new CrmebException("\u5fae\u4fe1\u5e73\u53f0\u63a5\u53e3\u5f02\u5e38\uff0c\u6ca1\u4efb\u4f55\u6570\u636e\u8fd4\u56de\uff01");
        }
        if (data.containsKey((Object)"errcode") && !data.getString("errcode").equals("0") && data.containsKey((Object)"errmsg")) {
            this.wxExceptionDispose(data, StrUtil.format((CharSequence)"\u5fae\u4fe1\u83b7\u53d6accessToken\u5f02\u5e38\uff0c{}\u7aef", (Object[])new Object[]{type}));
            throw new CrmebException("\u5fae\u4fe1\u63a5\u53e3\u8c03\u7528\u5931\u8d25\uff1a" + data.getString("errcode") + data.getString("errmsg"));
        }
        return (WeChatAccessTokenVo)JSONObject.parseObject((String)data.toJSONString(), WeChatAccessTokenVo.class);
    }

    private void wxExceptionDispose(JSONObject jsonObject, String remark) {
        WechatExceptions wechatExceptions = new WechatExceptions();
        wechatExceptions.setErrcode(jsonObject.getString("errcode"));
        wechatExceptions.setErrmsg(StrUtil.isNotBlank((CharSequence)jsonObject.getString("errmsg")) ? jsonObject.getString("errmsg") : "");
        wechatExceptions.setData(jsonObject.toJSONString());
        wechatExceptions.setRemark(remark);
        wechatExceptions.setCreateTime((Date)DateUtil.date());
        wechatExceptions.setUpdateTime((Date)DateUtil.date());
        this.wechatExceptionsService.save(wechatExceptions);
    }

    private void wxPayExceptionDispose(HashMap<String, Object> map, String remark) {
        WechatExceptions wechatExceptions = new WechatExceptions();
        String returnCode = (String)map.get("return_code");
        if (returnCode.equalsIgnoreCase("FAIL")) {
            wechatExceptions.setErrcode("-100");
            wechatExceptions.setErrmsg(map.get("return_msg").toString());
        } else {
            wechatExceptions.setErrcode(map.get("err_code").toString());
            wechatExceptions.setErrmsg(map.get("err_code_des").toString());
        }
        wechatExceptions.setData(JSONObject.toJSONString(map));
        wechatExceptions.setRemark(remark);
        wechatExceptions.setCreateTime((Date)DateUtil.date());
        wechatExceptions.setUpdateTime((Date)DateUtil.date());
        this.wechatExceptionsService.save(wechatExceptions);
    }

    private void wxPayQueryExceptionDispose(MyRecord record, String remark) {
        WechatExceptions wechatExceptions = new WechatExceptions();
        if (record.getStr("return_code").equalsIgnoreCase("FAIL")) {
            wechatExceptions.setErrcode("-200");
            wechatExceptions.setErrmsg(record.getStr("return_msg"));
        } else if (record.getStr("result_code").equalsIgnoreCase("FAIL")) {
            wechatExceptions.setErrcode(record.getStr("err_code"));
            wechatExceptions.setErrmsg(record.getStr("err_code_des"));
        } else if (!record.getStr("trade_state").equalsIgnoreCase("SUCCESS")) {
            wechatExceptions.setErrcode("-201");
            wechatExceptions.setErrmsg(record.getStr("trade_state"));
        }
        wechatExceptions.setData(JSONObject.toJSONString((Object)record.getColumns()));
        wechatExceptions.setRemark(remark);
        wechatExceptions.setCreateTime((Date)DateUtil.date());
        wechatExceptions.setUpdateTime((Date)DateUtil.date());
        this.wechatExceptionsService.save(wechatExceptions);
    }

    private void isValidPic(long size, String suffixName, String type) {
        JSONObject config = this.getMediaUploadConfig();
        long supportSize = config.getJSONObject(type).getLong("size");
        if (supportSize < size) {
            throw new CrmebException("\u6587\u4ef6\u5927\u5c0f\u4e0d\u80fd\u8d85\u8fc7" + supportSize);
        }
        String supportNameSuffix = config.getJSONObject(type).getString("suffix");
        List suffixNameList = CrmebUtil.stringToArrayStr((String)supportNameSuffix);
        if (!suffixNameList.contains(suffixName)) {
            throw new CrmebException("\u6587\u4ef6\u683c\u5f0f\u5fc5\u987b\u662f" + supportSize);
        }
    }

    private JSONObject getMediaUploadConfig() {
        String data = StrUtil.format((CharSequence)"{image:{size:\"{}\", suffix: \"{}\"}, voice:{size:\"{}\", suffix: \"{}\"}}", (Object[])new Object[]{WeChatConstants.OPEN_MEDIA_UPLOAD_IMAGE_MAX_SIZE, "bmp,png,jpeg,jpg,gif", WeChatConstants.OPEN_MEDIA_UPLOAD_VOICE_MAX_SIZE, "mp3,wma,wav,amr"});
        return JSONObject.parseObject((String)data);
    }
}

