/*
 * Decompiled with CFR 0.152.
 */
package com.zbkj.service.service.impl;

import cn.hutool.core.collection.CollUtil;
import cn.hutool.core.util.ObjectUtil;
import cn.hutool.core.util.StrUtil;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.baomidou.mybatisplus.core.toolkit.support.SFunction;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.github.pagehelper.PageHelper;
import com.zbkj.common.config.CrmebConfig;
import com.zbkj.common.exception.CrmebException;
import com.zbkj.common.model.system.SystemConfig;
import com.zbkj.common.model.system.SystemFormTemp;
import com.zbkj.common.request.SystemConfigAdminRequest;
import com.zbkj.common.request.SystemFormCheckRequest;
import com.zbkj.common.request.SystemFormItemCheckRequest;
import com.zbkj.common.utils.RedisUtil;
import com.zbkj.common.vo.ExpressSheetVo;
import com.zbkj.service.dao.SystemConfigDao;
import com.zbkj.service.service.SystemAttachmentService;
import com.zbkj.service.service.SystemConfigService;
import com.zbkj.service.service.SystemFormTempService;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.stream.Collectors;
import javax.annotation.PostConstruct;
import javax.annotation.Resource;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.support.TransactionTemplate;

@Service
public class SystemConfigServiceImpl
extends ServiceImpl<SystemConfigDao, SystemConfig>
implements SystemConfigService {
    @Resource
    private SystemConfigDao dao;
    @Autowired
    private SystemFormTempService systemFormTempService;
    @Autowired
    private SystemAttachmentService systemAttachmentService;
    @Autowired
    private RedisUtil redisUtil;
    @Autowired
    private CrmebConfig crmebConfig;
    @Autowired
    private TransactionTemplate transactionTemplate;

    @PostConstruct
    public void loadingConfigCache() {
        Long hashSize;
        if (!this.crmebConfig.isAsyncConfig().booleanValue()) {
            return;
        }
        if (this.redisUtil.exists("config_list").booleanValue() && (hashSize = this.redisUtil.getHashSize("config_list")) > 0L) {
            return;
        }
        LambdaQueryWrapper lqw = Wrappers.lambdaQuery();
        lqw.select(new SFunction[]{SystemConfig::getName, SystemConfig::getValue});
        lqw.eq(SystemConfig::getStatus, (Object)false);
        List systemConfigList = this.dao.selectList((Wrapper)lqw);
        systemConfigList.forEach(config -> this.redisUtil.hset("config_list", config.getName(), (Object)config.getValue()));
    }

    @Override
    public String getValueByKey(String name) {
        return this.get(name);
    }

    @Override
    public String getValueByKeyException(String name) {
        String value = this.get(name);
        if (StrUtil.isBlank((CharSequence)value)) {
            throw new CrmebException("\u6ca1\u6709\u627e\u5230\u6216\u914d\u7f6e\uff1a" + name + "\u6570\u636e");
        }
        return value;
    }

    @Override
    public Boolean saveForm(SystemFormCheckRequest systemFormCheckRequest) {
        this.systemFormTempService.checkForm(systemFormCheckRequest);
        ArrayList<SystemConfig> systemConfigList = new ArrayList<SystemConfig>();
        SystemFormTemp systemFormTemp = (SystemFormTemp)this.systemFormTempService.getById(systemFormCheckRequest.getId());
        for (SystemFormItemCheckRequest systemFormItemCheckRequest : systemFormCheckRequest.getFields()) {
            SystemConfig systemConfig = new SystemConfig();
            systemConfig.setName(systemFormItemCheckRequest.getName());
            String value = this.systemAttachmentService.clearPrefix(systemFormItemCheckRequest.getValue());
            if (StrUtil.isBlank((CharSequence)value)) {
                value = systemFormItemCheckRequest.getValue();
            }
            systemConfig.setValue(value);
            systemConfig.setFormId(systemFormCheckRequest.getId());
            systemConfig.setTitle(systemFormItemCheckRequest.getTitle());
            if (systemFormCheckRequest.getId() > 0) {
                systemConfig.setFormName(systemFormTemp.getName());
            }
            systemConfigList.add(systemConfig);
        }
        LambdaQueryWrapper oldLqw = Wrappers.lambdaQuery();
        oldLqw.eq(SystemConfig::getFormId, (Object)systemFormCheckRequest.getId());
        List systemConfigOldList = this.dao.selectList((Wrapper)oldLqw);
        Boolean execute = (Boolean)this.transactionTemplate.execute(e -> {
            if (CollUtil.isNotEmpty((Collection)systemConfigOldList)) {
                this.dao.delete((Wrapper)oldLqw);
            }
            this.saveBatch(systemConfigList);
            return Boolean.TRUE;
        });
        if (execute.booleanValue() && this.crmebConfig.isAsyncConfig().booleanValue()) {
            if (CollUtil.isNotEmpty((Collection)systemConfigOldList)) {
                this.asyncDelete(systemConfigOldList);
            }
            this.async(systemConfigList);
        }
        return execute;
    }

    private void asyncDelete(List<SystemConfig> systemConfigList) {
        systemConfigList.forEach(config -> {
            if (this.redisUtil.exists(config.getName()).booleanValue()) {
                this.redisUtil.hmDelete("config_list", (Object)config.getName());
            }
        });
    }

    @Override
    public Boolean updateOrSaveValueByName(String name, String value) {
        value = this.systemAttachmentService.clearPrefix(value);
        LambdaQueryWrapper lambdaQueryWrapper = Wrappers.lambdaQuery();
        lambdaQueryWrapper.eq(SystemConfig::getName, (Object)name);
        List systemConfigs = this.dao.selectList((Wrapper)lambdaQueryWrapper);
        if (systemConfigs.size() >= 2) {
            throw new CrmebException("\u914d\u7f6e\u540d\u79f0\u5b58\u5728\u591a\u4e2a\u8bf7\u68c0\u67e5\u914d\u7f6e eb_system_config \u91cd\u590d\u6570\u636e\uff1a" + name + "\u6761\u6570\uff1a" + systemConfigs.size());
        }
        if (systemConfigs.size() == 1) {
            SystemConfig systemConfig = (SystemConfig)systemConfigs.get(0);
            systemConfig.setValue(value);
            boolean update = this.updateById(systemConfig);
            if (update && this.crmebConfig.isAsyncConfig().booleanValue()) {
                this.async(systemConfig);
            }
            return update;
        }
        SystemConfig systemConfig = new SystemConfig().setName(name).setValue(value);
        boolean save = this.save(systemConfig);
        if (save && this.crmebConfig.isAsyncConfig().booleanValue()) {
            this.async(systemConfig);
        }
        return save;
    }

    @Override
    public HashMap<String, String> info(Integer formId) {
        LambdaQueryWrapper lqw = Wrappers.lambdaQuery();
        lqw.eq(SystemConfig::getFormId, (Object)formId);
        List systemConfigList = this.dao.selectList((Wrapper)lqw);
        if (ObjectUtil.isNull((Object)systemConfigList)) {
            return CollUtil.newHashMap();
        }
        HashMap<String, String> map = new HashMap<String, String>();
        for (SystemConfig systemConfig : systemConfigList) {
            map.put(systemConfig.getName(), systemConfig.getValue());
        }
        map.put("id", formId.toString());
        return map;
    }

    @Override
    public Boolean checkName(String name) {
        String value = this.get(name);
        return StrUtil.isBlank((CharSequence)value);
    }

    @Override
    public List<SystemConfig> getListByKey(String key) {
        LambdaQueryWrapper lqw = Wrappers.lambdaQuery();
        lqw.eq(SystemConfig::getName, (Object)key);
        return this.dao.selectList((Wrapper)lqw);
    }

    @Override
    public ExpressSheetVo getDeliveryInfo() {
        String exportId = this.get("config_export_id");
        String exportTempId = this.get("config_export_temp_id");
        String exportCom = this.get("config_export_com");
        String exportToName = this.get("config_export_to_name");
        String exportToTel = this.get("config_export_to_tel");
        String exportToAddress = this.get("config_export_to_address");
        String exportSiid = this.get("config_export_siid");
        String exportOpen = this.get("config_export_open");
        return new ExpressSheetVo(Integer.valueOf(exportId), exportCom, exportTempId, exportToName, exportToTel, exportToAddress, exportSiid, Integer.valueOf(exportOpen));
    }

    @Override
    public Boolean updateByList(List<SystemConfigAdminRequest> requestList) {
        List<SystemConfig> configList = requestList.stream().map(e -> {
            SystemConfig systemConfig = new SystemConfig();
            BeanUtils.copyProperties((Object)e, (Object)systemConfig);
            return systemConfig;
        }).collect(Collectors.toList());
        boolean batch = this.updateBatchById(configList);
        if (batch && this.crmebConfig.isAsyncConfig().booleanValue()) {
            this.async(configList);
        }
        return batch;
    }

    @Override
    public SystemConfig getColorConfig() {
        String colorConfig = this.getValueByKeyException("change_color_config");
        SystemConfig systemConfig = new SystemConfig();
        systemConfig.setName("change_color_config");
        systemConfig.setValue(colorConfig);
        return systemConfig;
    }

    private void asyncBlank(String key) {
        this.redisUtil.hset("config_list", key, (Object)"");
    }

    private void async(SystemConfig systemConfig) {
        this.redisUtil.hset("config_list", systemConfig.getName(), (Object)systemConfig.getValue());
    }

    private void async(List<SystemConfig> systemConfigList) {
        for (SystemConfig systemConfig : systemConfigList) {
            this.redisUtil.hset("config_list", systemConfig.getName(), (Object)systemConfig.getValue());
        }
    }

    private String get(String name) {
        if (!this.crmebConfig.isAsyncConfig().booleanValue()) {
            SystemConfig systemConfig = this.getByName(name);
            if (ObjectUtil.isNull((Object)systemConfig) || StrUtil.isBlank((CharSequence)systemConfig.getValue())) {
                return "";
            }
            return systemConfig.getValue();
        }
        Long size = this.redisUtil.getHashSize("config_list");
        if (size <= 0L) {
            SystemConfig systemConfig = this.getByName(name);
            if (ObjectUtil.isNull((Object)systemConfig) || StrUtil.isBlank((CharSequence)systemConfig.getValue())) {
                this.asyncBlank(name);
                return "";
            }
            this.async(systemConfig);
            return systemConfig.getValue();
        }
        Object data = this.redisUtil.hget("config_list", name);
        if (ObjectUtil.isNull((Object)data)) {
            this.asyncBlank(name);
            return "";
        }
        return data.toString();
    }

    private SystemConfig getByName(String name) {
        PageHelper.clearPage();
        LambdaQueryWrapper lqw = Wrappers.lambdaQuery();
        lqw.select(new SFunction[]{SystemConfig::getId, SystemConfig::getName, SystemConfig::getValue});
        lqw.eq(SystemConfig::getStatus, (Object)false);
        lqw.eq(SystemConfig::getName, (Object)name);
        lqw.last(" limit 1");
        return (SystemConfig)this.getOne((Wrapper)lqw);
    }

    @Override
    public String getAgreementByKey(String agreementName) {
        if (ObjectUtil.isEmpty((Object)agreementName)) {
            return "Key Not Empty";
        }
        LambdaQueryWrapper lqw = Wrappers.lambdaQuery();
        lqw.eq(SystemConfig::getName, (Object)agreementName);
        lqw.eq(SystemConfig::getStatus, (Object)0);
        SystemConfig systemConfig = (SystemConfig)this.dao.selectOne((Wrapper)lqw);
        if (ObjectUtil.isNull((Object)systemConfig)) {
            return "";
        }
        return systemConfig.getValue();
    }

    @Override
    public String getFrontDomain() {
        return this.getValueByKey("site_url");
    }

    @Override
    public String getMediaDomain() {
        return this.systemAttachmentService.getCdnUrl();
    }

    @Override
    public String getRiskSystemUrl() {
        String riskUrl = this.getValueByKey("e_risk_system_url");
        if (StrUtil.isBlank((CharSequence)riskUrl)) {
            throw new CrmebException("\u672a\u914d\u7f6e\u98ce\u8bc4\u7cfb\u7edfurl\u5730\u5740\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458");
        }
        return riskUrl;
    }
}

