/*
 * Decompiled with CFR 0.152.
 */
package com.zbkj.service.service.impl;

import cn.hutool.core.collection.CollUtil;
import cn.hutool.core.date.DateUtil;
import cn.hutool.core.util.ObjectUtil;
import cn.hutool.core.util.StrUtil;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.baomidou.mybatisplus.core.toolkit.support.SFunction;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.github.pagehelper.Page;
import com.github.pagehelper.PageHelper;
import com.github.pagehelper.PageInfo;
import com.zbkj.common.constants.BalanceRecordConstants;
import com.zbkj.common.constants.OrderConstants;
import com.zbkj.common.constants.ProductConstants;
import com.zbkj.common.exception.CrmebException;
import com.zbkj.common.model.admin.SystemAdmin;
import com.zbkj.common.model.merchant.Merchant;
import com.zbkj.common.model.order.Order;
import com.zbkj.common.model.order.OrderDetail;
import com.zbkj.common.model.order.RefundOrder;
import com.zbkj.common.model.order.RefundOrderInfo;
import com.zbkj.common.model.user.User;
import com.zbkj.common.model.user.UserBalanceRecord;
import com.zbkj.common.page.CommonPage;
import com.zbkj.common.request.OrderRefundAuditRequest;
import com.zbkj.common.request.PageParamRequest;
import com.zbkj.common.request.RefundOrderRemarkRequest;
import com.zbkj.common.request.RefundOrderSearchRequest;
import com.zbkj.common.response.MerchantRefundOrderPageResponse;
import com.zbkj.common.response.PlatformRefundOrderPageResponse;
import com.zbkj.common.response.RefundOrderAdminDetailResponse;
import com.zbkj.common.response.RefundOrderCountItemResponse;
import com.zbkj.common.response.RefundOrderInfoResponse;
import com.zbkj.common.response.bcx.BcxOrderSummaryInfo;
import com.zbkj.common.utils.CrmebDateUtil;
import com.zbkj.common.utils.RedisUtil;
import com.zbkj.common.utils.SecurityUtil;
import com.zbkj.common.utils.WxPayUtil;
import com.zbkj.common.vo.DateLimitUtilVo;
import com.zbkj.common.vo.WxRefundVo;
import com.zbkj.service.dao.RefundOrderDao;
import com.zbkj.service.service.AliPayService;
import com.zbkj.service.service.BcxPerformanceReportService;
import com.zbkj.service.service.MerchantService;
import com.zbkj.service.service.OrderDetailService;
import com.zbkj.service.service.OrderService;
import com.zbkj.service.service.PayService;
import com.zbkj.service.service.RefundOrderInfoService;
import com.zbkj.service.service.RefundOrderService;
import com.zbkj.service.service.SystemConfigService;
import com.zbkj.service.service.UserBalanceRecordService;
import com.zbkj.service.service.UserService;
import com.zbkj.service.service.WechatService;
import java.math.BigDecimal;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.support.TransactionTemplate;

@Service
public class RefundOrderServiceImpl
extends ServiceImpl<RefundOrderDao, RefundOrder>
implements RefundOrderService {
    @Resource
    private RefundOrderDao dao;
    @Autowired
    private OrderService orderService;
    @Autowired
    private OrderDetailService orderDetailService;
    @Autowired
    private PayService payService;
    @Autowired
    private RefundOrderInfoService refundOrderInfoService;
    @Autowired
    private TransactionTemplate transactionTemplate;
    @Autowired
    private WechatService wechatService;
    @Autowired
    private SystemConfigService systemConfigService;
    @Autowired
    private AliPayService aliPayService;
    @Autowired
    private UserService userService;
    @Autowired
    private RedisUtil redisUtil;
    @Autowired
    private UserBalanceRecordService userBalanceRecordService;
    @Autowired
    private MerchantService merchantService;
    @Autowired
    private BcxPerformanceReportService bcxPerformanceReportService;
    private static Logger logger = LoggerFactory.getLogger(RefundOrderServiceImpl.class);

    @Override
    public PageInfo<MerchantRefundOrderPageResponse> getMerchantAdminPageSql(RefundOrderSearchRequest request, PageParamRequest pageParamRequest) {
        request.setMerId(SecurityUtil.getLoginUserVo().getUser().getMerId());
        Page page = PageHelper.startPage((int)pageParamRequest.getPage(), (int)pageParamRequest.getLimit());
        Map<String, Object> queryParam = RefundOrderServiceImpl.concatQueryParam(request);
        return CommonPage.copyPageInfo((Page)page, this.dao.queryMerchantRefundOrderList(queryParam));
    }

    @Override
    @Deprecated
    public PageInfo<MerchantRefundOrderPageResponse> getMerchantAdminPage(RefundOrderSearchRequest request, PageParamRequest pageParamRequest) {
        SystemAdmin systemAdmin = SecurityUtil.getLoginUserVo().getUser();
        Page page = PageHelper.startPage((int)pageParamRequest.getPage(), (int)pageParamRequest.getLimit());
        QueryWrapper wrapper = Wrappers.query();
        wrapper.eq((Object)"mer_id", (Object)systemAdmin.getMerId());
        if (StrUtil.isNotEmpty((CharSequence)request.getRefundOrderNo())) {
            wrapper.eq((Object)"refund_order_no", (Object)request.getRefundOrderNo());
        }
        if (StrUtil.isNotEmpty((CharSequence)request.getOrderNo())) {
            wrapper.eq((Object)"order_no", (Object)request.getOrderNo());
        }
        if (StrUtil.isNotEmpty((CharSequence)request.getDateLimit())) {
            this.getRequestTimeWhere((QueryWrapper<RefundOrder>)wrapper, request.getDateLimit());
        }
        this.getStatusWhere((QueryWrapper<RefundOrder>)wrapper, request.getRefundStatus());
        wrapper.orderByDesc((Object)"id");
        List refundOrderList = this.dao.selectList((Wrapper)wrapper);
        if (CollUtil.isEmpty((Collection)refundOrderList)) {
            return CommonPage.copyPageInfo((Page)page, (List)CollUtil.newArrayList((Object[])new MerchantRefundOrderPageResponse[0]));
        }
        List<Integer> uidList = refundOrderList.stream().map(RefundOrder::getUid).distinct().collect(Collectors.toList());
        Map<Integer, User> userMap = this.userService.getUidMapList(uidList);
        List responseList = refundOrderList.stream().map(order -> {
            MerchantRefundOrderPageResponse response = new MerchantRefundOrderPageResponse();
            BeanUtils.copyProperties((Object)order, (Object)response);
            response.setUserNickName(((User)userMap.get(order.getUid())).getNickname());
            return response;
        }).collect(Collectors.toList());
        return CommonPage.copyPageInfo((Page)page, responseList);
    }

    @Override
    public RefundOrderCountItemResponse getMerchantOrderStatusNum(String dateLimit) {
        SystemAdmin systemAdmin = SecurityUtil.getLoginUserVo().getUser();
        return this.getOrderStatusNum(dateLimit, systemAdmin.getMerId());
    }

    @Override
    public Boolean mark(RefundOrderRemarkRequest request) {
        RefundOrder refundOrder = this.getInfoException(request.getRefundOrderNo());
        refundOrder.setMerRemark(request.getRemark());
        return this.updateById(refundOrder);
    }

    @Override
    public Boolean refundRefuse(OrderRefundAuditRequest request) {
        if (StrUtil.isEmpty((CharSequence)request.getReason())) {
            throw new CrmebException("\u8bf7\u586b\u5199\u62d2\u7edd\u9000\u6b3e\u539f\u56e0");
        }
        SystemAdmin systemAdmin = SecurityUtil.getLoginUserVo().getUser();
        RefundOrder refundOrder = this.getInfoException(request.getRefundOrderNo());
        if (!refundOrder.getRefundStatus().equals(OrderConstants.MERCHANT_REFUND_ORDER_STATUS_APPLY)) {
            throw new CrmebException("\u9000\u6b3e\u5355\u72b6\u6001\u5f02\u5e38");
        }
        if (!refundOrder.getMerId().equals(systemAdmin.getMerId())) {
            throw new CrmebException("\u65e0\u6cd5\u64cd\u4f5c\u975e\u81ea\u5df1\u5546\u6237\u7684\u8ba2\u5355");
        }
        refundOrder.setRefundStatus(OrderConstants.MERCHANT_REFUND_ORDER_STATUS_REJECT);
        refundOrder.setRefundReason(request.getReason());
        Order order = this.orderService.getByOrderNo(refundOrder.getOrderNo());
        if (ObjectUtil.isNull((Object)order)) {
            throw new CrmebException("\u9000\u6b3e\u5355\u5173\u8054\u7684\u8ba2\u5355\u4e0d\u5b58\u5728");
        }
        RefundOrderInfo refundOrderInfo = this.refundOrderInfoService.getByRefundOrderNo(refundOrder.getRefundOrderNo());
        OrderDetail orderDetail = (OrderDetail)this.orderDetailService.getById(refundOrderInfo.getOrderDetailId());
        orderDetail.setApplyRefundNum(Integer.valueOf(orderDetail.getApplyRefundNum() - refundOrderInfo.getApplyRefundNum()));
        Boolean execute = (Boolean)this.transactionTemplate.execute(e -> {
            this.updateById(refundOrder);
            this.orderDetailService.updateById(orderDetail);
            return Boolean.TRUE;
        });
        if (execute.booleanValue()) {
            this.settingOrderStatus(order);
            this.orderService.updateById(order);
        }
        return execute;
    }

    @Override
    public Boolean refund(OrderRefundAuditRequest request) {
        SystemAdmin systemAdmin = SecurityUtil.getLoginUserVo().getUser();
        RefundOrder refundOrder = this.getInfoException(request.getRefundOrderNo());
        if (!refundOrder.getMerId().equals(systemAdmin.getMerId())) {
            throw new CrmebException("\u65e0\u6cd5\u64cd\u4f5c\u975e\u81ea\u5df1\u5546\u6237\u7684\u8ba2\u5355");
        }
        return this.dealRefund(refundOrder);
    }

    @Override
    public Boolean dealRefund(RefundOrder refundOrder) {
        BigDecimal refundPrice;
        if (!refundOrder.getRefundStatus().equals(OrderConstants.MERCHANT_REFUND_ORDER_STATUS_APPLY)) {
            throw new CrmebException("\u9000\u6b3e\u5355\u72b6\u6001\u5f02\u5e38");
        }
        Order order = this.orderService.getByOrderNo(refundOrder.getOrderNo());
        if (!order.getPaid().booleanValue()) {
            throw new CrmebException("\u672a\u652f\u4ed8\u65e0\u6cd5\u9000\u6b3e");
        }
        RefundOrderInfo refundOrderInfo = this.refundOrderInfoService.getByRefundOrderNo(refundOrder.getRefundOrderNo());
        OrderDetail orderDetail = (OrderDetail)this.orderDetailService.getById(refundOrderInfo.getOrderDetailId());
        if (orderDetail.getPayNum().equals(refundOrderInfo.getApplyRefundNum())) {
            refundPrice = orderDetail.getPayPrice();
            if (order.getBizType().equals(ProductConstants.BIZ_TYPE_INSURANCE)) {
                refundPrice = refundOrderInfo.getRefundPrice();
            }
            orderDetail.setRefundPrice(refundPrice);
            refundOrderInfo.setRefundPrice(refundPrice);
            if (orderDetail.getUseIntegral() > 0) {
                orderDetail.setRefundUseIntegral(orderDetail.getUseIntegral());
                orderDetail.setRefundIntegralPrice(orderDetail.getIntegralPrice());
                refundOrderInfo.setRefundUseIntegral(orderDetail.getRefundUseIntegral());
                refundOrderInfo.setRefundIntegralPrice(orderDetail.getRefundIntegralPrice());
            }
            if (orderDetail.getGainIntegral() > 0) {
                orderDetail.setRefundGainIntegral(orderDetail.getGainIntegral());
                refundOrderInfo.setRefundGainIntegral(orderDetail.getRefundGainIntegral());
            }
            if (orderDetail.getFirstBrokerageFee().compareTo(BigDecimal.ZERO) > 0) {
                orderDetail.setRefundFirstBrokerageFee(orderDetail.getFirstBrokerageFee());
                refundOrderInfo.setRefundFirstBrokerageFee(orderDetail.getRefundFirstBrokerageFee());
            }
            if (orderDetail.getSecondBrokerageFee().compareTo(BigDecimal.ZERO) > 0) {
                orderDetail.setRefundSecondBrokerageFee(orderDetail.getSecondBrokerageFee());
                refundOrderInfo.setRefundSecondBrokerageFee(orderDetail.getRefundSecondBrokerageFee());
            }
            if (orderDetail.getPlatCouponPrice().compareTo(BigDecimal.ZERO) > 0) {
                orderDetail.setRefundPlatCouponPrice(orderDetail.getPlatCouponPrice());
                refundOrderInfo.setRefundPlatCouponPrice(orderDetail.getPlatCouponPrice());
            }
            refundOrderInfo.setMerchantRefundPrice(refundPrice);
            if (orderDetail.getFreightFee().compareTo(BigDecimal.ZERO) > 0) {
                refundOrderInfo.setRefundFreightFee(orderDetail.getFreightFee());
                orderDetail.setRefundFreightFee(orderDetail.getFreightFee());
            }
        } else if (orderDetail.getPayNum() == orderDetail.getRefundNum() + refundOrderInfo.getApplyRefundNum()) {
            refundPrice = orderDetail.getPayPrice().subtract(orderDetail.getRefundPrice());
            if (order.getBizType().equals(ProductConstants.BIZ_TYPE_INSURANCE)) {
                refundPrice = refundOrderInfo.getRefundPrice();
            }
            orderDetail.setRefundPrice(orderDetail.getPayPrice());
            refundOrderInfo.setRefundPrice(refundPrice);
            refundOrderInfo.setMerchantRefundPrice(refundPrice);
            if (orderDetail.getUseIntegral() > 0) {
                refundOrderInfo.setRefundUseIntegral(Integer.valueOf(orderDetail.getUseIntegral() - orderDetail.getRefundUseIntegral()));
                refundOrderInfo.setRefundIntegralPrice(orderDetail.getIntegralPrice().subtract(orderDetail.getRefundIntegralPrice()));
                orderDetail.setRefundUseIntegral(orderDetail.getUseIntegral());
                orderDetail.setRefundIntegralPrice(orderDetail.getIntegralPrice());
            }
            if (orderDetail.getGainIntegral() > 0) {
                refundOrderInfo.setRefundGainIntegral(Integer.valueOf(orderDetail.getGainIntegral() - orderDetail.getRefundGainIntegral()));
                orderDetail.setRefundGainIntegral(orderDetail.getGainIntegral());
            }
            if (orderDetail.getFirstBrokerageFee().compareTo(BigDecimal.ZERO) > 0) {
                refundOrderInfo.setRefundFirstBrokerageFee(orderDetail.getFirstBrokerageFee().subtract(orderDetail.getRefundFirstBrokerageFee()));
                orderDetail.setRefundFirstBrokerageFee(orderDetail.getFirstBrokerageFee());
            }
            if (orderDetail.getSecondBrokerageFee().compareTo(BigDecimal.ZERO) > 0) {
                refundOrderInfo.setRefundSecondBrokerageFee(orderDetail.getSecondBrokerageFee().subtract(orderDetail.getRefundSecondBrokerageFee()));
                orderDetail.setRefundSecondBrokerageFee(orderDetail.getSecondBrokerageFee());
            }
            if (orderDetail.getPlatCouponPrice().compareTo(BigDecimal.ZERO) > 0) {
                refundOrderInfo.setRefundPlatCouponPrice(orderDetail.getPlatCouponPrice().subtract(orderDetail.getRefundPlatCouponPrice()));
                orderDetail.setRefundPlatCouponPrice(orderDetail.getPlatCouponPrice());
            }
            if (orderDetail.getFreightFee().compareTo(BigDecimal.ZERO) > 0) {
                refundOrderInfo.setRefundFreightFee(orderDetail.getFreightFee().subtract(orderDetail.getRefundFreightFee()));
                orderDetail.setRefundFreightFee(orderDetail.getFreightFee());
            }
        } else {
            BigDecimal ratio = new BigDecimal(refundOrderInfo.getApplyRefundNum()).divide(new BigDecimal(orderDetail.getPayNum()), 10, 4);
            refundPrice = orderDetail.getPayPrice().multiply(ratio).setScale(2, 4);
            if (order.getBizType().equals(ProductConstants.BIZ_TYPE_INSURANCE)) {
                refundPrice = refundOrderInfo.getRefundPrice();
            }
            orderDetail.setRefundPrice(orderDetail.getRefundPrice().add(refundPrice));
            refundOrderInfo.setRefundPrice(refundPrice);
            refundOrderInfo.setMerchantRefundPrice(refundPrice);
            if (orderDetail.getUseIntegral() > 0) {
                refundOrderInfo.setRefundUseIntegral(Integer.valueOf(new BigDecimal(orderDetail.getUseIntegral().toString()).multiply(ratio).setScale(0, 4).intValue()));
                refundOrderInfo.setRefundIntegralPrice(orderDetail.getIntegralPrice().multiply(ratio).setScale(2, 4));
                orderDetail.setRefundUseIntegral(Integer.valueOf(orderDetail.getRefundUseIntegral() + refundOrderInfo.getRefundUseIntegral()));
                orderDetail.setRefundIntegralPrice(orderDetail.getRefundIntegralPrice().add(refundOrderInfo.getRefundIntegralPrice()));
            }
            if (orderDetail.getGainIntegral() > 0) {
                refundOrderInfo.setRefundGainIntegral(Integer.valueOf(new BigDecimal(orderDetail.getGainIntegral().toString()).multiply(ratio).setScale(0, 4).intValue()));
                orderDetail.setRefundGainIntegral(Integer.valueOf(orderDetail.getRefundGainIntegral() + refundOrderInfo.getRefundGainIntegral()));
            }
            if (orderDetail.getFirstBrokerageFee().compareTo(BigDecimal.ZERO) > 0) {
                refundOrderInfo.setRefundFirstBrokerageFee(orderDetail.getFirstBrokerageFee().multiply(ratio).setScale(2, 4));
                orderDetail.setRefundFirstBrokerageFee(orderDetail.getRefundFirstBrokerageFee().add(refundOrderInfo.getRefundFirstBrokerageFee()));
            }
            if (orderDetail.getSecondBrokerageFee().compareTo(BigDecimal.ZERO) > 0) {
                refundOrderInfo.setRefundSecondBrokerageFee(orderDetail.getSecondBrokerageFee().multiply(ratio).setScale(2, 4));
                orderDetail.setRefundSecondBrokerageFee(orderDetail.getRefundSecondBrokerageFee().add(refundOrderInfo.getRefundSecondBrokerageFee()));
            }
            if (orderDetail.getPlatCouponPrice().compareTo(BigDecimal.ZERO) > 0) {
                refundOrderInfo.setRefundPlatCouponPrice(orderDetail.getPlatCouponPrice().multiply(ratio).setScale(2, 4));
                orderDetail.setRefundPlatCouponPrice(orderDetail.getRefundPlatCouponPrice().add(refundOrderInfo.getRefundPlatCouponPrice()));
            }
            if (orderDetail.getFreightFee().compareTo(BigDecimal.ZERO) > 0) {
                refundOrderInfo.setRefundFreightFee(orderDetail.getFreightFee().multiply(ratio).setScale(2, 4));
                orderDetail.setRefundFreightFee(orderDetail.getRefundFreightFee().add(refundOrderInfo.getRefundFreightFee()));
            }
        }
        refundOrder.setRefundPrice(refundPrice);
        refundOrder.setMerchantRefundPrice(refundOrderInfo.getMerchantRefundPrice());
        refundOrder.setRefundUseIntegral(refundOrderInfo.getRefundUseIntegral());
        refundOrder.setRefundIntegralPrice(refundOrderInfo.getRefundIntegralPrice());
        refundOrder.setRefundGainIntegral(refundOrderInfo.getRefundGainIntegral());
        refundOrder.setRefundFirstBrokerageFee(refundOrderInfo.getRefundFirstBrokerageFee());
        refundOrder.setRefundSecondBrokerageFee(refundOrderInfo.getRefundSecondBrokerageFee());
        refundOrder.setRefundPayType(order.getPayType());
        refundOrder.setRefundPlatCouponPrice(refundOrderInfo.getRefundPlatCouponPrice());
        refundOrder.setRefundFreightFee(refundOrderInfo.getRefundFreightFee());
        if (order.getPayType().equals("weixin") && refundPrice.compareTo(BigDecimal.ZERO) > 0) {
            try {
                Order platOrder = this.orderService.getByOrderNo(order.getPlatOrderNo());
                this.wxRefund(order, refundOrder.getRefundOrderNo(), refundPrice, platOrder.getPayPrice());
            }
            catch (Exception e2) {
                e2.printStackTrace();
                throw new CrmebException("\u5fae\u4fe1\u7533\u8bf7\u9000\u6b3e\u5931\u8d25\uff01" + e2.getMessage());
            }
        }
        if (order.getPayType().equals("alipay") && refundPrice.compareTo(BigDecimal.ZERO) > 0) {
            try {
                this.aliPayService.refund(order.getOrderNo(), refundOrder.getRefundOrderNo(), refundOrder.getRefundReasonWapExplain(), refundPrice);
            }
            catch (Exception e3) {
                e3.printStackTrace();
                throw new CrmebException("\u652f\u4ed8\u5b9d\u7533\u8bf7\u9000\u6b3e\u5931\u8d25\uff01" + e3.getMessage());
            }
        }
        orderDetail.setApplyRefundNum(Integer.valueOf(orderDetail.getApplyRefundNum() - refundOrderInfo.getApplyRefundNum()));
        orderDetail.setRefundNum(Integer.valueOf(orderDetail.getRefundNum() + refundOrderInfo.getApplyRefundNum()));
        User user = (User)this.userService.getById(order.getUid());
        refundOrder.setRefundTime((Date)DateUtil.date());
        Boolean execute = (Boolean)this.transactionTemplate.execute(e -> {
            logger.info("\u9000\u6b3e\u64cd\u4f5c");
            this.orderDetailService.updateById(orderDetail);
            this.refundOrderInfoService.updateById(refundOrderInfo);
            refundOrder.setRefundStatus(OrderConstants.MERCHANT_REFUND_ORDER_STATUS_REFUNDING);
            if (refundOrder.getRefundPrice().compareTo(BigDecimal.ZERO) <= 0) {
                logger.info("\u9000\u6b3e\u91d1\u989d<=0");
                refundOrder.setRefundStatus(OrderConstants.MERCHANT_REFUND_ORDER_STATUS_REFUND);
            } else if (order.getBizType().equals(ProductConstants.BIZ_TYPE_INSURANCE)) {
                logger.info("\u4fdd\u9669\u8ba2\u5355\u9000\u6b3e");
                this.log.warn("\u4fdd\u9669\u8ba2\u5355\u9000\u6b3e\uff0c\u6682\u65f6\u4e0d\u662f\u901a\u8fc7\u5546\u57ce\u652f\u4ed8\uff0c\u4e5f\u4e0d\u8d70\u5546\u57ce\u9000\u6b3e\uff0c\u5728\u5546\u57ce\u5185\u53ea\u505a\u4f63\u91d1\u9000\u6b3e");
                refundOrder.setRefundStatus(OrderConstants.MERCHANT_REFUND_ORDER_STATUS_REFUND);
            } else if (order.getPayType().equals("yue")) {
                logger.info("\u4f59\u989d\u4ed8\u6b3e\u8ba2\u5355\u9000\u6b3e");
                refundOrder.setRefundStatus(OrderConstants.MERCHANT_REFUND_ORDER_STATUS_REFUND);
                if (refundOrder.getRefundPrice().compareTo(BigDecimal.ZERO) > 0) {
                    this.userService.updateNowMoney(order.getUid(), refundOrder.getRefundPrice(), "add");
                    UserBalanceRecord userBalanceRecord = new UserBalanceRecord();
                    userBalanceRecord.setUid(user.getId());
                    userBalanceRecord.setLinkId(refundOrder.getRefundOrderNo());
                    userBalanceRecord.setLinkType("order");
                    userBalanceRecord.setType(BalanceRecordConstants.BALANCE_RECORD_TYPE_ADD);
                    userBalanceRecord.setAmount(refundOrder.getRefundPrice());
                    userBalanceRecord.setBalance(user.getNowMoney().add(refundOrder.getRefundPrice()));
                    userBalanceRecord.setRemark(StrUtil.format((CharSequence)"\u7528\u6237\u8ba2\u5355\u9000\u6b3e\u6210\u529f,\u8fd4\u8fd8\u4f59\u989d{}\u5143", (Object[])new Object[]{refundOrder.getRefundPrice()}));
                    this.userBalanceRecordService.save(userBalanceRecord);
                }
            } else {
                if (order.getPayType().equals("wallet")) {
                    logger.info("\u4f01\u4e1a\u94b1\u5305\u4ed8\u6b3e\u8ba2\u5355\u9000\u6b3e");
                    Integer bizType = order.getBizType();
                    if (!bizType.equals(ProductConstants.BIZ_TYPE_SPACIAL) && !bizType.equals(ProductConstants.BIZ_TYPE_PHYSICAL)) {
                        this.log.error("\u865a\u62df\u5546\u54c1\u4e0d\u5141\u8bb8\u9000\u8d27\u9000\u6b3e-orderNo:" + order.getOrderNo() + ":orderDetailId:" + orderDetail.getId() + ":\u8bf7\u4ece\u6e90\u5934\u5355\u636e\u7981\u6b62");
                        return false;
                    }
                    try {
                        refundOrder.setRefundStatus(OrderConstants.MERCHANT_REFUND_ORDER_STATUS_REFUND);
                        Merchant merchant = this.merchantService.getByIdException(orderDetail.getMerId());
                        this.payService.walletUnfreeze(order, CollUtil.newArrayList((Object[])new OrderDetail[]{orderDetail}), bizType, user, merchant);
                    }
                    catch (Exception pe) {
                        this.log.error(pe.getMessage());
                        e.setRollbackOnly();
                        return false;
                    }
                }
                if (order.getPayType().equals("weixin2huifu")) {
                    logger.info("\u5fae\u4fe1\u652f\u4ed8\u5230\u6c47\u4ed8\u4ed8\u6b3e\u8ba2\u5355\u9000\u6b3e");
                    Integer bizType = order.getBizType();
                    if (!bizType.equals(ProductConstants.BIZ_TYPE_RISK)) {
                        this.log.error("\u53ea\u6709\u98ce\u8bc4\u8ba2\u5355\u901a\u8fc7\u5c0f\u7a0b\u5e8f\u652f\u4ed8\u9000\u6b3e-orderNo:" + order.getOrderNo() + ":orderDetailId:" + orderDetail.getId() + ":\u8bf7\u4ece\u6e90\u5934\u5355\u636e\u7981\u6b62");
                        return false;
                    }
                    try {
                        this.payService.wechat2HuifuRefund(order);
                        refundOrder.setRefundStatus(OrderConstants.MERCHANT_REFUND_ORDER_STATUS_REFUND);
                    }
                    catch (Exception pe) {
                        this.log.error(pe.getMessage());
                        e.setRollbackOnly();
                        return false;
                    }
                }
                if (!order.getPayType().equals("offline")) {
                    this.log.error("\u9664\u4e86\u4f59\u989d\u652f\u4ed8\u3001\u4f01\u4e1a\u94b1\u5305\u652f\u4ed8\u548c \u98ce\u8bc4\u5c0f\u7a0b\u5e8f\u652f\u4ed8\uff0c\u5176\u4ed6\u7c7b\u578b\u4e0d\u652f\u6301\u8be5\u65b9\u6cd5\u9000\u6b3e-orderNo:" + order.getOrderNo() + ":orderDetailId:" + orderDetail.getId() + ":\u8bf7\u4ece\u6e90\u5934\u5355\u636e\u7981\u6b62");
                    return false;
                }
                Integer bizType = order.getBizType();
                if (bizType.equals(ProductConstants.BIZ_TYPE_RISK) || order.getPayChannel().equals("offline")) {
                    throw new CrmebException("\u7ebf\u4e0b\u4ed8\u6b3e\u6682\u4e0d\u652f\u6301\u9000\u6b3e");
                }
                try {
                    refundOrder.setRefundStatus(OrderConstants.MERCHANT_REFUND_ORDER_STATUS_REFUND);
                    Merchant merchant = this.merchantService.getByIdException(orderDetail.getMerId());
                    this.payService.walletUnfreeze(order, CollUtil.newArrayList((Object[])new OrderDetail[]{orderDetail}), bizType, user, merchant);
                }
                catch (Exception pe) {
                    this.log.error(pe.getMessage());
                    e.setRollbackOnly();
                    return false;
                }
            }
            this.updateById(refundOrder);
            return Boolean.TRUE;
        });
        if (Boolean.TRUE.equals(execute)) {
            this.settingOrderStatus(order);
            this.orderService.updateById(order);
            if (order.getPayType().equals("yue")) {
                this.redisUtil.lPush("alterOrderRefundByUser", (Object)refundOrder.getRefundOrderNo());
            }
        } else {
            throw new CrmebException("\u9000\u6b3e\u5931\u8d25\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458");
        }
        logger.info("\u8c03\u7528\u751f\u6210\u9000\u6b3e\u4e1a\u7ee9\u62a5\u8868\u670d\u52a1\u63a5\u53e3");
        this.bcxPerformanceReportService.generateRefundReport(refundOrder.getRefundOrderNo());
        return true;
    }

    private void wxRefund(Order order, String refundOrderNo, BigDecimal refundPrice, BigDecimal totalPrice) {
        String appId = "";
        String mchId = "";
        String signKey = "";
        String path = "";
        switch (order.getPayChannel()) {
            case "public": 
            case "h5": {
                appId = this.systemConfigService.getValueByKeyException("wechat_appid");
                mchId = this.systemConfigService.getValueByKeyException("pay_weixin_mchid");
                signKey = this.systemConfigService.getValueByKeyException("pay_weixin_key");
                path = this.systemConfigService.getValueByKeyException("pay_weixin_certificate_path");
                break;
            }
            case "mini": {
                appId = this.systemConfigService.getValueByKeyException("routine_appid");
                mchId = this.systemConfigService.getValueByKeyException("pay_routine_mchid");
                signKey = this.systemConfigService.getValueByKeyException("pay_routine_key");
                path = this.systemConfigService.getValueByKeyException("pay_routine_certificate_path");
                break;
            }
            case "wechatIos": 
            case "wechatAndroid": {
                appId = this.systemConfigService.getValueByKeyException("wechat_app_appid");
                mchId = this.systemConfigService.getValueByKeyException("pay_weixin_app_mchid");
                signKey = this.systemConfigService.getValueByKeyException("pay_weixin_app_key");
                path = this.systemConfigService.getValueByKeyException("pay_weixin_app_certificate_path");
            }
        }
        String apiDomain = this.systemConfigService.getValueByKeyException("api_url");
        WxRefundVo wxRefundVo = new WxRefundVo();
        wxRefundVo.setAppid(appId);
        wxRefundVo.setMch_id(mchId);
        wxRefundVo.setNonce_str(WxPayUtil.getNonceStr());
        wxRefundVo.setOut_trade_no(order.getOutTradeNo());
        wxRefundVo.setOut_refund_no(refundOrderNo);
        wxRefundVo.setTotal_fee(totalPrice.multiply(BigDecimal.TEN).multiply(BigDecimal.TEN).intValue());
        wxRefundVo.setRefund_fee(refundPrice.multiply(BigDecimal.TEN).multiply(BigDecimal.TEN).intValue());
        wxRefundVo.setNotify_url(apiDomain + "/api/publicly/payment/callback/wechat/refund");
        String sign = WxPayUtil.getSign((WxRefundVo)wxRefundVo, (String)signKey);
        wxRefundVo.setSign(sign);
        this.wechatService.payRefund(wxRefundVo, path);
    }

    private void settingOrderStatus(Order order) {
        List<OrderDetail> orderDetailList = this.orderDetailService.getByOrderNo(order.getOrderNo());
        long count = orderDetailList.stream().filter(e -> e.getRefundNum().equals(0)).count();
        if (count == (long)orderDetailList.size()) {
            order.setRefundStatus(OrderConstants.ORDER_REFUND_STATUS_NORMAL);
            return;
        }
        OrderDetail orderDetail = orderDetailList.stream().filter(e -> e.getApplyRefundNum() > 0).findAny().orElse(null);
        if (ObjectUtil.isNotNull((Object)orderDetail)) {
            order.setRefundStatus(OrderConstants.ORDER_REFUND_STATUS_APPLY);
            return;
        }
        long refundCount = orderDetailList.stream().filter(e -> e.getRefundNum().equals(e.getPayNum())).count();
        if (refundCount == (long)orderDetailList.size()) {
            order.setRefundStatus(OrderConstants.ORDER_REFUND_STATUS_ALL);
            return;
        }
        order.setRefundStatus(OrderConstants.ORDER_REFUND_STATUS_PORTION);
    }

    @Override
    public RefundOrder getInfoException(String refundOrderNo) {
        LambdaQueryWrapper lqw = Wrappers.lambdaQuery();
        lqw.eq(RefundOrder::getRefundOrderNo, (Object)refundOrderNo);
        lqw.last(" limit 1");
        RefundOrder refundOrder = (RefundOrder)this.dao.selectOne((Wrapper)lqw);
        if (ObjectUtil.isNull((Object)refundOrder)) {
            throw new CrmebException("\u9000\u6b3e\u5355\u4e0d\u5b58\u5728");
        }
        return refundOrder;
    }

    @Override
    public PageInfo<RefundOrder> getH5List(Integer type, PageParamRequest pageRequest) {
        Integer userId = this.userService.getUserId();
        Page page = PageHelper.startPage((int)pageRequest.getPage(), (int)pageRequest.getLimit());
        LambdaQueryWrapper lqw = Wrappers.lambdaQuery();
        lqw.eq(RefundOrder::getUid, (Object)userId);
        if (type.equals(0)) {
            lqw.eq(RefundOrder::getRefundStatus, (Object)type);
        }
        lqw.orderByDesc(RefundOrder::getId);
        List list = this.dao.selectList((Wrapper)lqw);
        return CommonPage.copyPageInfo((Page)page, (List)list);
    }

    @Override
    public RefundOrderInfoResponse getRefundOrderDetailByRefundOrderNo(String refundOrderNo) {
        return this.dao.getRefundOrderDetailByRefundOrderNo(refundOrderNo);
    }

    @Override
    public RefundOrderAdminDetailResponse getMerchantDetail(String refundOrderNo) {
        SystemAdmin admin = SecurityUtil.getLoginUserVo().getUser();
        RefundOrder refundOrder = this.getInfoException(refundOrderNo);
        if (!admin.getMerId().equals(refundOrder.getMerId())) {
            throw new CrmebException("\u9000\u6b3e\u5355\u4e0d\u5b58\u5728");
        }
        RefundOrderInfo refundOrderInfo = this.refundOrderInfoService.getByRefundOrderNo(refundOrderNo);
        RefundOrderAdminDetailResponse response = new RefundOrderAdminDetailResponse();
        BeanUtils.copyProperties((Object)refundOrderInfo, (Object)response);
        BeanUtils.copyProperties((Object)refundOrder, (Object)response);
        return response;
    }

    @Override
    public PageInfo<PlatformRefundOrderPageResponse> getPlatformAdminPageSql(RefundOrderSearchRequest request, PageParamRequest pageParamRequest) {
        Page page = PageHelper.startPage((int)pageParamRequest.getPage(), (int)pageParamRequest.getLimit());
        Map<String, Object> queryParam = RefundOrderServiceImpl.concatQueryParam(request);
        return CommonPage.copyPageInfo((Page)page, this.dao.queryPlatformRefundOrderList(queryParam));
    }

    private static Map<String, Object> concatQueryParam(RefundOrderSearchRequest request) {
        HashMap<String, Object> queryParam = new HashMap<String, Object>(12);
        if (ObjectUtil.isNotNull((Object)request.getRefundStatus()) && request.getRefundStatus() != 9) {
            queryParam.put("refundStatus", request.getRefundStatus());
        }
        if (StrUtil.isNotEmpty((CharSequence)request.getDateLimit())) {
            DateLimitUtilVo dateLimitUtilVo = CrmebDateUtil.getDateLimit((String)request.getDateLimit());
            queryParam.put("startTime", dateLimitUtilVo.getStartTime());
            queryParam.put("endTime", dateLimitUtilVo.getEndTime());
        }
        if (ObjectUtil.isNotNull((Object)request.getMerId()) && request.getMerId() > 0) {
            queryParam.put("merId", request.getMerId());
        }
        queryParam.put("refundOrderNo", request.getRefundOrderNo());
        queryParam.put("orderNo", request.getOrderNo());
        queryParam.put("payType", request.getPayType());
        queryParam.put("productName", request.getProductName());
        queryParam.put("nickname", request.getUserName());
        queryParam.put("memberName", request.getMemberName());
        queryParam.put("insuranceType", request.getInsuranceType());
        queryParam.put("categoryId", request.getCategoryId());
        return queryParam;
    }

    @Override
    public BcxOrderSummaryInfo getSummaryOrderInfo(RefundOrderSearchRequest request) {
        Map<String, Object> queryParam = RefundOrderServiceImpl.concatQueryParam(request);
        return this.dao.queryPlatformRefundOrderSummary(queryParam);
    }

    @Override
    public PageInfo<PlatformRefundOrderPageResponse> getPlatformAdminPage(RefundOrderSearchRequest request, PageParamRequest pageParamRequest) {
        Page page = PageHelper.startPage((int)pageParamRequest.getPage(), (int)pageParamRequest.getLimit());
        QueryWrapper wrapper = Wrappers.query();
        if (ObjectUtil.isNotNull((Object)request.getMerId()) && request.getMerId() > 0) {
            wrapper.eq((Object)"mer_id", (Object)request.getMerId());
        }
        if (StrUtil.isNotEmpty((CharSequence)request.getRefundOrderNo())) {
            wrapper.eq((Object)"refund_order_no", (Object)request.getRefundOrderNo());
        }
        if (StrUtil.isNotEmpty((CharSequence)request.getOrderNo())) {
            wrapper.eq((Object)"order_no", (Object)request.getOrderNo());
        }
        if (StrUtil.isNotEmpty((CharSequence)request.getDateLimit())) {
            this.getRequestTimeWhere((QueryWrapper<RefundOrder>)wrapper, request.getDateLimit());
        }
        this.getStatusWhere((QueryWrapper<RefundOrder>)wrapper, request.getRefundStatus());
        wrapper.orderByDesc((Object)"id");
        List refundOrderList = this.dao.selectList((Wrapper)wrapper);
        if (CollUtil.isEmpty((Collection)refundOrderList)) {
            return CommonPage.copyPageInfo((Page)page, (List)CollUtil.newArrayList((Object[])new PlatformRefundOrderPageResponse[0]));
        }
        List<Integer> merIdList = refundOrderList.stream().map(RefundOrder::getMerId).distinct().collect(Collectors.toList());
        Map<Integer, Merchant> merchantMap = this.merchantService.getMerIdMapByIdList(merIdList);
        List<Integer> uidList = refundOrderList.stream().map(RefundOrder::getUid).distinct().collect(Collectors.toList());
        Map<Integer, User> userMap = this.userService.getUidMapList(uidList);
        List responseList = refundOrderList.stream().map(order -> {
            PlatformRefundOrderPageResponse response = new PlatformRefundOrderPageResponse();
            BeanUtils.copyProperties((Object)order, (Object)response);
            response.setMerName(((Merchant)merchantMap.get(order.getMerId())).getName());
            response.setUserNickName(((User)userMap.get(order.getUid())).getNickname());
            return response;
        }).collect(Collectors.toList());
        return CommonPage.copyPageInfo((Page)page, responseList);
    }

    @Override
    public RefundOrderCountItemResponse getPlatformOrderStatusNum(String dateLimit) {
        return this.getOrderStatusNum(dateLimit, 0);
    }

    @Override
    public Boolean platformMark(RefundOrderRemarkRequest request) {
        RefundOrder refundOrder = this.getInfoException(request.getRefundOrderNo());
        refundOrder.setPlatformRemark(request.getRemark());
        return this.updateById(refundOrder);
    }

    @Override
    public RefundOrderAdminDetailResponse getPlatformDetail(String refundOrderNo) {
        RefundOrder refundOrder = this.getInfoException(refundOrderNo);
        RefundOrderInfo refundOrderInfo = this.refundOrderInfoService.getByRefundOrderNo(refundOrderNo);
        RefundOrderAdminDetailResponse response = new RefundOrderAdminDetailResponse();
        BeanUtils.copyProperties((Object)refundOrderInfo, (Object)response);
        BeanUtils.copyProperties((Object)refundOrder, (Object)response);
        return response;
    }

    @Override
    public List<RefundOrder> findByDate(Integer merId, String date) {
        LambdaQueryWrapper lqw = Wrappers.lambdaQuery();
        if (merId > 0) {
            lqw.eq(RefundOrder::getMerId, (Object)merId);
        }
        lqw.eq(RefundOrder::getRefundStatus, (Object)OrderConstants.MERCHANT_REFUND_ORDER_STATUS_REFUND);
        lqw.apply("date_format(refund_time, '%Y-%m-%d') = {0}", new Object[]{date});
        return this.dao.selectList((Wrapper)lqw);
    }

    @Override
    public List<RefundOrder> findByMonth(Integer merId, String month) {
        LambdaQueryWrapper lqw = Wrappers.lambdaQuery();
        if (merId > 0) {
            lqw.eq(RefundOrder::getMerId, (Object)merId);
        }
        lqw.eq(RefundOrder::getRefundStatus, (Object)OrderConstants.MERCHANT_REFUND_ORDER_STATUS_REFUND);
        lqw.apply("date_format(refund_time, '%Y-%m') = {0}", new Object[]{month});
        return this.dao.selectList((Wrapper)lqw);
    }

    @Override
    public Integer getRefundOrderNumByDate(String date) {
        LambdaQueryWrapper lqw = Wrappers.lambdaQuery();
        lqw.select(new SFunction[]{RefundOrder::getId});
        lqw.eq(RefundOrder::getRefundStatus, (Object)OrderConstants.MERCHANT_REFUND_ORDER_STATUS_REFUND);
        lqw.apply("date_format(update_time, '%Y-%m-%d') = {0}", new Object[]{date});
        return this.dao.selectCount((Wrapper)lqw);
    }

    @Override
    public BigDecimal getRefundOrderAmountByDate(String date) {
        LambdaQueryWrapper lqw = Wrappers.lambdaQuery();
        lqw.select(new SFunction[]{RefundOrder::getRefundPrice});
        lqw.eq(RefundOrder::getRefundStatus, (Object)OrderConstants.MERCHANT_REFUND_ORDER_STATUS_REFUND);
        lqw.apply("date_format(update_time, '%Y-%m-%d') = {0}", new Object[]{date});
        List orderList = this.dao.selectList((Wrapper)lqw);
        if (CollUtil.isEmpty((Collection)orderList)) {
            return BigDecimal.ZERO;
        }
        return orderList.stream().map(RefundOrder::getRefundPrice).reduce(BigDecimal.ZERO, BigDecimal::add);
    }

    @Override
    public Integer getRefundingCount(Integer userId) {
        LambdaQueryWrapper lqw = Wrappers.lambdaQuery();
        lqw.eq(RefundOrder::getUid, (Object)userId);
        lqw.eq(RefundOrder::getRefundStatus, (Object)OrderConstants.MERCHANT_REFUND_ORDER_STATUS_APPLY);
        return this.dao.selectCount((Wrapper)lqw);
    }

    @Override
    public RefundOrder getByRefundOrderNo(String refundOrderNo) {
        LambdaQueryWrapper lqw = Wrappers.lambdaQuery();
        lqw.eq(RefundOrder::getRefundOrderNo, (Object)refundOrderNo);
        lqw.last(" limit 1");
        return (RefundOrder)this.dao.selectOne((Wrapper)lqw);
    }

    @Override
    public Integer getAwaitAuditNum(Integer merId) {
        LambdaQueryWrapper lqw = Wrappers.lambdaQuery();
        lqw.select(new SFunction[]{RefundOrder::getId});
        lqw.eq(RefundOrder::getRefundStatus, (Object)OrderConstants.MERCHANT_REFUND_ORDER_STATUS_APPLY);
        if (merId > 0) {
            lqw.eq(RefundOrder::getMerId, (Object)merId);
        }
        return this.dao.selectCount((Wrapper)lqw);
    }

    private RefundOrderCountItemResponse getOrderStatusNum(String dateLimit, Integer merId) {
        RefundOrderCountItemResponse response = new RefundOrderCountItemResponse();
        response.setAll(this.getCount(dateLimit, 9, merId));
        response.setAwait(this.getCount(dateLimit, OrderConstants.MERCHANT_REFUND_ORDER_STATUS_APPLY, merId));
        response.setReject(this.getCount(dateLimit, OrderConstants.MERCHANT_REFUND_ORDER_STATUS_REJECT, merId));
        response.setRefunding(this.getCount(dateLimit, OrderConstants.MERCHANT_REFUND_ORDER_STATUS_REFUNDING, merId));
        response.setRefunded(this.getCount(dateLimit, OrderConstants.MERCHANT_REFUND_ORDER_STATUS_REFUND, merId));
        return response;
    }

    private Integer getCount(String dateLimit, Integer status, Integer merId) {
        QueryWrapper queryWrapper = new QueryWrapper();
        if (merId > 0) {
            queryWrapper.eq((Object)"mer_id", (Object)merId);
        }
        if (StrUtil.isNotBlank((CharSequence)dateLimit)) {
            this.getRequestTimeWhere((QueryWrapper<RefundOrder>)queryWrapper, dateLimit);
        }
        this.getStatusWhere((QueryWrapper<RefundOrder>)queryWrapper, status);
        return this.dao.selectCount((Wrapper)queryWrapper);
    }

    private void getRequestTimeWhere(QueryWrapper<RefundOrder> queryWrapper, String dateLimit) {
        DateLimitUtilVo dateLimitUtilVo = CrmebDateUtil.getDateLimit((String)dateLimit);
        queryWrapper.between((Object)"create_time", (Object)dateLimitUtilVo.getStartTime(), (Object)dateLimitUtilVo.getEndTime());
    }

    private void getStatusWhere(QueryWrapper<RefundOrder> queryWrapper, Integer status) {
        if (ObjectUtil.isNull((Object)status)) {
            return;
        }
        if (status == 9) {
            return;
        }
        queryWrapper.eq((Object)"refund_status", (Object)status);
    }
}

