/*
 * Decompiled with CFR 0.152.
 */
package com.zbkj.service.service.impl;

import cn.hutool.core.util.ObjectUtil;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.update.LambdaUpdateWrapper;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.zbkj.common.model.product.ProductBrandCategory;
import com.zbkj.service.dao.ProductBrandCategoryDao;
import com.zbkj.service.service.ProductBrandCategoryService;
import java.util.List;
import javax.annotation.Resource;
import org.springframework.stereotype.Service;

@Service
public class ProductBrandCategoryServiceImpl
extends ServiceImpl<ProductBrandCategoryDao, ProductBrandCategory>
implements ProductBrandCategoryService {
    @Resource
    private ProductBrandCategoryDao dao;

    @Override
    public Boolean deleteByBid(Integer bid) {
        LambdaUpdateWrapper wrapper = Wrappers.lambdaUpdate();
        wrapper.eq(ProductBrandCategory::getBid, (Object)bid);
        return this.dao.delete((Wrapper)wrapper) > 0;
    }

    @Override
    public List<ProductBrandCategory> getListByBrandId(Integer brandId) {
        LambdaQueryWrapper lqw = Wrappers.lambdaQuery();
        lqw.eq(ProductBrandCategory::getBid, (Object)brandId);
        return this.dao.selectList((Wrapper)lqw);
    }

    @Override
    public Boolean isExistCategory(Integer categoryId) {
        LambdaQueryWrapper lqw = Wrappers.lambdaQuery();
        lqw.eq(ProductBrandCategory::getCid, (Object)categoryId);
        lqw.last(" limit 1");
        ProductBrandCategory productBrandCategory = (ProductBrandCategory)this.dao.selectOne((Wrapper)lqw);
        return ObjectUtil.isNotNull((Object)productBrandCategory);
    }
}

