/*
 * Decompiled with CFR 0.152.
 */
package com.zbkj.service.service.impl;

import cn.hutool.core.collection.CollUtil;
import cn.hutool.core.date.DateUtil;
import cn.hutool.core.util.ObjectUtil;
import cn.hutool.core.util.StrUtil;
import cn.hutool.core.util.URLUtil;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.update.LambdaUpdateWrapper;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.github.pagehelper.Page;
import com.github.pagehelper.PageHelper;
import com.github.pagehelper.PageInfo;
import com.zbkj.common.enums.PayComponentEditStatusEnum;
import com.zbkj.common.enums.PayComponentPlatformEditStatusEnum;
import com.zbkj.common.enums.PayComponentPlatformStatusEnum;
import com.zbkj.common.enums.PayComponentStatusEnum;
import com.zbkj.common.exception.CrmebException;
import com.zbkj.common.model.admin.SystemAdmin;
import com.zbkj.common.model.wechat.video.PayComponentCat;
import com.zbkj.common.model.wechat.video.PayComponentDraftProduct;
import com.zbkj.common.model.wechat.video.PayComponentProduct;
import com.zbkj.common.model.wechat.video.PayComponentProductInfo;
import com.zbkj.common.model.wechat.video.PayComponentProductSku;
import com.zbkj.common.model.wechat.video.PayComponentProductSkuAttr;
import com.zbkj.common.page.CommonPage;
import com.zbkj.common.request.PageParamRequest;
import com.zbkj.common.request.ProductAttrValueAddRequest;
import com.zbkj.common.request.wxvedio.product.ComponentProductSearchRequest;
import com.zbkj.common.request.wxvedio.product.PayComponentDraftProductMerchantOperationReviewStatus;
import com.zbkj.common.request.wxvedio.product.PayComponentDraftProductPlatformOperationReviewStatus;
import com.zbkj.common.request.wxvedio.product.PayComponentProductAddRequest;
import com.zbkj.common.utils.CrmebDateUtil;
import com.zbkj.common.utils.CrmebUtil;
import com.zbkj.common.utils.SecurityUtil;
import com.zbkj.common.vo.wxvedioshop.ShopSpuAddResponseVo;
import com.zbkj.common.vo.wxvedioshop.ShopSpuAddVo;
import com.zbkj.common.vo.wxvedioshop.ShopSpuInfoVo;
import com.zbkj.common.vo.wxvedioshop.ShopSpuSkuAttrVo;
import com.zbkj.common.vo.wxvedioshop.ShopSpuSkuVo;
import com.zbkj.service.dao.PayComponentDraftProductDao;
import com.zbkj.service.service.MerchantService;
import com.zbkj.service.service.PayComponentCatService;
import com.zbkj.service.service.PayComponentDraftProductService;
import com.zbkj.service.service.PayComponentProductService;
import com.zbkj.service.service.PayComponentProductSkuService;
import com.zbkj.service.service.SystemAttachmentService;
import com.zbkj.service.service.WechatVideoBeforeService;
import com.zbkj.service.service.WechatVideoSpuService;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.support.TransactionTemplate;

@Service
public class PayComponentDraftProductServiceImpl
extends ServiceImpl<PayComponentDraftProductDao, PayComponentDraftProduct>
implements PayComponentDraftProductService {
    private static final Logger logger = LoggerFactory.getLogger(PayComponentDraftProductServiceImpl.class);
    @Resource
    private PayComponentDraftProductDao dao;
    @Autowired
    private TransactionTemplate transactionTemplate;
    @Autowired
    private PayComponentProductService productService;
    @Autowired
    private WechatVideoSpuService wechatVideoSpuService;
    @Autowired
    private PayComponentProductSkuService skuService;
    @Autowired
    private SystemAttachmentService systemAttachmentService;
    @Autowired
    private PayComponentCatService catService;
    @Autowired
    private MerchantService merchantService;
    @Autowired
    private WechatVideoBeforeService wechatVideoBeforeService;

    @Override
    public Boolean add(PayComponentProductAddRequest addRequest) {
        logger.info("\u81ea\u5b9a\u4e49\u4ea4\u6613\u7ec4\u4ef6\u521b\u5efa\u8349\u7a3f\u5546\u54c1 --\u300bSTART:{}", (Object)JSON.toJSONString((Object)addRequest));
        List<PayComponentDraftProduct> draftProductByOperation = this.getDraftProductByOperation(null, addRequest.getTitle());
        if (ObjectUtil.isNull(draftProductByOperation) || draftProductByOperation.size() > 0) {
            throw new CrmebException("\u5f53\u524d\u8349\u7a3f\u5546\u54c1\u7684\u540d\u79f0\u5df2\u5b58\u5728");
        }
        SystemAdmin currentMerchant = SecurityUtil.getLoginUserVo().getUser();
        PayComponentProduct product = new PayComponentProduct();
        BeanUtils.copyProperties((Object)addRequest, (Object)product);
        if (ObjectUtil.isNull((Object)addRequest.getBrandId()) || addRequest.getBrandId() == 0) {
            product.setBrandId(Integer.valueOf(2100000000));
        }
        product.setHeadImg(addRequest.getHeadImg());
        if (StrUtil.isNotBlank((CharSequence)product.getQualificationPics()) && !product.getQualificationPics().equals("[]")) {
            product.setQualificationPics(this.systemAttachmentService.clearPrefix(product.getQualificationPics()));
        }
        product.setIsDel(Boolean.valueOf(true));
        ArrayList skuList = CollUtil.newArrayList((Object[])new PayComponentProductSku[0]);
        if (!addRequest.getSpecType().booleanValue()) {
            PayComponentProductSkuAttr skuAttr = new PayComponentProductSkuAttr();
            skuAttr.setAttrKey("\u8bf7\u9009\u62e9\u89c4\u683c");
            skuAttr.setAttrValue("\u9ed8\u8ba4");
            skuAttr.setIsDel(Boolean.valueOf(false));
            ArrayList attrList = CollUtil.newArrayList((Object[])new PayComponentProductSkuAttr[0]);
            attrList.add(skuAttr);
            ProductAttrValueAddRequest attrValueRequest2 = (ProductAttrValueAddRequest)addRequest.getAttrValue().get(0);
            PayComponentProductSku sku = new PayComponentProductSku();
            sku.setThumbImg(attrValueRequest2.getImage());
            sku.setSalePrice(Long.valueOf(attrValueRequest2.getPrice().multiply(new BigDecimal("100")).longValue()));
            sku.setMarketPrice(Long.valueOf(attrValueRequest2.getOtPrice().multiply(new BigDecimal("100")).longValue()));
            sku.setStockNum(attrValueRequest2.getStock());
            sku.setAttrList((List)attrList);
            sku.setIsDel(Boolean.valueOf(true));
            sku.setSku("\u9ed8\u8ba4");
            skuList.add(sku);
        } else {
            List valueRequestList = addRequest.getAttrValue();
            valueRequestList.forEach(attrValueRequest -> {
                PayComponentProductSku sku = new PayComponentProductSku();
                sku.setThumbImg(attrValueRequest.getImage());
                sku.setSalePrice(Long.valueOf(attrValueRequest.getPrice().multiply(new BigDecimal("100")).longValue()));
                sku.setMarketPrice(Long.valueOf(attrValueRequest.getOtPrice().multiply(new BigDecimal("100")).longValue()));
                sku.setStockNum(attrValueRequest.getStock());
                sku.setIsDel(Boolean.valueOf(true));
                ArrayList<String> skuAttrList = new ArrayList<String>();
                String attrValueJson = attrValueRequest.getAttrValue();
                JSONObject jsonObject = JSONObject.parseObject((String)attrValueJson);
                ArrayList attrList = CollUtil.newArrayList((Object[])new PayComponentProductSkuAttr[0]);
                for (Map.Entry vo : jsonObject.entrySet()) {
                    skuAttrList.add(vo.getValue().toString());
                    PayComponentProductSkuAttr skuAttr = new PayComponentProductSkuAttr();
                    skuAttr.setAttrKey((String)vo.getKey());
                    skuAttr.setAttrValue(vo.getValue().toString());
                    skuAttr.setIsDel(Boolean.valueOf(false));
                    attrList.add(skuAttr);
                }
                sku.setSku(String.join((CharSequence)",", skuAttrList));
                sku.setAttrList((List)attrList);
                skuList.add(sku);
            });
        }
        Boolean execute = (Boolean)this.transactionTemplate.execute(e -> {
            product.setMerId(currentMerchant.getMerId());
            product.setPlatformEditStatus(PayComponentPlatformEditStatusEnum.INIT.getCode());
            this.productService.save(product);
            product.setPath(StrUtil.format((CharSequence)"/pages/goods/goods_details/index?id={}&type={}", (Object[])new Object[]{product.getId(), "video"}));
            this.productService.updateById(product);
            for (PayComponentProductSku sku : skuList) {
                sku.setProductId(product.getId());
            }
            this.skuService.saveOrUpdateBatch(skuList);
            return Boolean.TRUE;
        });
        if (!execute.booleanValue()) {
            throw new CrmebException("\u672c\u5730\u4fdd\u5b58\u5546\u54c1\u65f6\u9519\u8bef");
        }
        PayComponentDraftProduct draftProduct = new PayComponentDraftProduct();
        BeanUtils.copyProperties((Object)product, (Object)draftProduct);
        draftProduct.setId(null);
        draftProduct.setProductId(product.getId());
        draftProduct.setComponentProductId(null);
        draftProduct.setCreateTime(CrmebDateUtil.nowDate((String)"yyyy-MM-dd HH:mm:ss"));
        draftProduct.setUpdateTime(CrmebDateUtil.nowDate((String)"yyyy-MM-dd HH:mm:ss"));
        draftProduct.setStatus(PayComponentStatusEnum.STATUS_INIT.getCode());
        draftProduct.setEditStatus(PayComponentEditStatusEnum.BEFORE_REVIEW.getCode());
        draftProduct.setPlatformStatus(PayComponentPlatformStatusEnum.INIT.getCode());
        draftProduct.setMerId(currentMerchant.getMerId());
        draftProduct.setSku(JSONArray.toJSONString((Object)skuList));
        draftProduct.setAttr(JSONArray.toJSONString((Object)addRequest.getAttr()));
        draftProduct.setAttrValue(JSONArray.toJSONString((Object)addRequest.getAttrValue()));
        draftProduct.setIsDel(Boolean.valueOf(false));
        draftProduct.setAddTime((Date)DateUtil.date());
        draftProduct.setSales(Integer.valueOf(0));
        draftProduct.setSpecType(addRequest.getSpecType());
        draftProduct.setDescInfo(this.systemAttachmentService.clearPrefix(addRequest.getDescInfo()));
        int stock = skuList.stream().mapToInt(PayComponentProductSku::getStockNum).sum();
        draftProduct.setStock(Integer.valueOf(stock));
        boolean save = this.save(draftProduct);
        logger.info("\u81ea\u5b9a\u4e49\u4ea4\u6613\u7ec4\u4ef6\u521b\u5efa\u8349\u7a3f\u5546\u54c1 --\u300bEND:{}", (Object)JSON.toJSONString((Object)draftProduct));
        logger.info("\u81ea\u5b9a\u4e49\u4ea4\u6613\u7ec4\u4ef6\u521b\u5efa\u6b63\u5f0f(\u6807\u8bb0\u4e3a\u4e0d\u53ef\u88ab\u67e5\u8be2\u7684)\u5546\u54c1 --\u300bEND:{}", (Object)JSON.toJSONString((Object)product));
        if (!save) {
            throw new CrmebException("\u672c\u5730\u4fdd\u5b58\u8349\u7a3f\u5546\u54c1\u65f6\u9519\u8bef");
        }
        return save;
    }

    @Override
    public Boolean edit(PayComponentProductAddRequest addRequest) {
        if (ObjectUtil.isEmpty((Object)addRequest.getId())) {
            throw new CrmebException("id\u4e0d\u80fd\u4e3a\u7a7a");
        }
        PayComponentProduct product = (PayComponentProduct)this.productService.getById(addRequest.getProductId());
        BeanUtils.copyProperties((Object)addRequest, (Object)product);
        if (ObjectUtil.isNull((Object)addRequest.getBrandId()) || addRequest.getBrandId() == 0) {
            product.setBrandId(Integer.valueOf(2100000000));
        }
        product.setHeadImg(addRequest.getHeadImg());
        if (StrUtil.isNotBlank((CharSequence)product.getQualificationPics()) && !product.getQualificationPics().equals("[]")) {
            product.setQualificationPics(this.systemAttachmentService.clearPrefix(product.getQualificationPics()));
        }
        product.setIsDel(Boolean.valueOf(true));
        ArrayList skuList = CollUtil.newArrayList((Object[])new PayComponentProductSku[0]);
        if (!addRequest.getSpecType().booleanValue()) {
            PayComponentProductSkuAttr skuAttr = new PayComponentProductSkuAttr();
            skuAttr.setAttrKey("\u8bf7\u9009\u62e9\u89c4\u683c");
            skuAttr.setAttrValue("\u9ed8\u8ba4");
            skuAttr.setIsDel(Boolean.valueOf(false));
            ArrayList attrList = CollUtil.newArrayList((Object[])new PayComponentProductSkuAttr[0]);
            attrList.add(skuAttr);
            ProductAttrValueAddRequest attrValueRequest2 = (ProductAttrValueAddRequest)addRequest.getAttrValue().get(0);
            PayComponentProductSku sku = new PayComponentProductSku();
            sku.setThumbImg(attrValueRequest2.getImage());
            sku.setSalePrice(Long.valueOf(attrValueRequest2.getPrice().multiply(new BigDecimal("100")).longValue()));
            sku.setMarketPrice(Long.valueOf(attrValueRequest2.getOtPrice().multiply(new BigDecimal("100")).longValue()));
            sku.setStockNum(attrValueRequest2.getStock());
            sku.setAttrList((List)attrList);
            sku.setIsDel(Boolean.valueOf(true));
            sku.setSku("\u9ed8\u8ba4");
            skuList.add(sku);
        } else {
            List valueRequestList = addRequest.getAttrValue();
            valueRequestList.forEach(attrValueRequest -> {
                PayComponentProductSku sku = new PayComponentProductSku();
                sku.setThumbImg(attrValueRequest.getImage());
                sku.setSalePrice(Long.valueOf(attrValueRequest.getPrice().multiply(new BigDecimal("100")).longValue()));
                sku.setMarketPrice(Long.valueOf(attrValueRequest.getOtPrice().multiply(new BigDecimal("100")).longValue()));
                sku.setStockNum(attrValueRequest.getStock());
                sku.setIsDel(Boolean.valueOf(true));
                ArrayList<String> skuAttrList = new ArrayList<String>();
                String attrValueJson = attrValueRequest.getAttrValue();
                JSONObject jsonObject = JSONObject.parseObject((String)attrValueJson);
                ArrayList attrList = CollUtil.newArrayList((Object[])new PayComponentProductSkuAttr[0]);
                for (Map.Entry vo : jsonObject.entrySet()) {
                    skuAttrList.add(vo.getValue().toString());
                    PayComponentProductSkuAttr skuAttr = new PayComponentProductSkuAttr();
                    skuAttr.setAttrKey((String)vo.getKey());
                    skuAttr.setAttrValue(vo.getValue().toString());
                    skuAttr.setIsDel(Boolean.valueOf(false));
                    attrList.add(skuAttr);
                }
                sku.setSku(String.join((CharSequence)",", skuAttrList));
                sku.setAttrList((List)attrList);
                skuList.add(sku);
            });
        }
        Boolean execute = (Boolean)this.transactionTemplate.execute(e -> {
            this.productService.updateById(product);
            for (PayComponentProductSku sku : skuList) {
                sku.setProductId(product.getId());
            }
            this.skuService.saveOrUpdateBatch(skuList);
            return Boolean.TRUE;
        });
        if (!execute.booleanValue()) {
            throw new CrmebException("\u672c\u5730\u4fdd\u5b58\u5546\u54c1\u65f6\u9519\u8bef");
        }
        PayComponentDraftProduct draftProduct = new PayComponentDraftProduct();
        BeanUtils.copyProperties((Object)product, (Object)draftProduct);
        draftProduct.setId(addRequest.getId());
        draftProduct.setProductId(product.getId());
        draftProduct.setComponentProductId(product.getComponentProductId());
        draftProduct.setCreateTime(CrmebDateUtil.nowDate((String)"yyyy-MM-dd HH:mm:ss"));
        draftProduct.setUpdateTime(CrmebDateUtil.nowDate((String)"yyyy-MM-dd HH:mm:ss"));
        draftProduct.setStatus(PayComponentStatusEnum.STATUS_INIT.getCode());
        draftProduct.setEditStatus(PayComponentEditStatusEnum.BEFORE_REVIEW.getCode());
        draftProduct.setPlatformStatus(PayComponentPlatformEditStatusEnum.INIT.getCode());
        draftProduct.setSku(JSONArray.toJSONString((Object)skuList));
        draftProduct.setAttr(JSONArray.toJSONString((Object)addRequest.getAttr()));
        draftProduct.setAttrValue(JSONArray.toJSONString((Object)addRequest.getAttrValue()));
        draftProduct.setIsDel(Boolean.valueOf(false));
        draftProduct.setAddTime((Date)DateUtil.date());
        draftProduct.setSales(Integer.valueOf(0));
        draftProduct.setSpecType(addRequest.getSpecType());
        draftProduct.setDescInfo(this.systemAttachmentService.clearPrefix(addRequest.getDescInfo()));
        int stock = skuList.stream().mapToInt(PayComponentProductSku::getStockNum).sum();
        draftProduct.setStock(Integer.valueOf(stock));
        boolean draftUpdate = this.updateById(draftProduct);
        if (!draftUpdate) {
            throw new CrmebException("\u672c\u5730\u4fdd\u5b58\u8349\u7a3f\u5546\u54c1\u65f6\u9519\u8bef");
        }
        return draftUpdate;
    }

    @Override
    public PayComponentDraftProduct getByProId(Integer proId) {
        LambdaQueryWrapper lqw = Wrappers.lambdaQuery();
        lqw.eq(PayComponentDraftProduct::getProductId, (Object)proId);
        return (PayComponentDraftProduct)this.dao.selectOne((Wrapper)lqw);
    }

    @Override
    public Boolean deleteByProId(Integer proId) {
        LambdaUpdateWrapper luw = Wrappers.lambdaUpdate();
        luw.set(PayComponentDraftProduct::getIsDel, (Object)true);
        luw.eq(PayComponentDraftProduct::getProductId, (Object)proId);
        return this.update((Wrapper)luw);
    }

    @Override
    public PageInfo<PayComponentDraftProduct> getCurrentMerchantAdminListBeforeWeChatReview(ComponentProductSearchRequest request, PageParamRequest pageParamRequest) {
        SystemAdmin currentMerchantAdmin = SecurityUtil.getLoginUserVo().getUser();
        Page page = PageHelper.startPage((int)pageParamRequest.getPage(), (int)pageParamRequest.getLimit());
        LambdaQueryWrapper lqw = Wrappers.lambdaQuery();
        lqw.eq(PayComponentDraftProduct::getIsDel, (Object)false);
        if (ObjectUtil.isNotNull((Object)request.getProId())) {
            lqw.eq(PayComponentDraftProduct::getProductId, (Object)request.getProId());
        }
        if (StrUtil.isNotBlank((CharSequence)request.getSearch())) {
            lqw.like(PayComponentDraftProduct::getTitle, (Object)URLUtil.decode((String)request.getSearch()));
        }
        lqw.eq(PayComponentDraftProduct::getIsDel, (Object)false);
        lqw.eq(PayComponentDraftProduct::getMerId, (Object)currentMerchantAdmin.getMerId());
        lqw.lt(PayComponentDraftProduct::getEditStatus, (Object)PayComponentEditStatusEnum.REVIEW_SUCCESS.getCode());
        lqw.orderByDesc(PayComponentDraftProduct::getId);
        List productList = this.dao.selectList((Wrapper)lqw);
        productList.forEach(e -> {
            PayComponentCat componentCat = this.catService.getByThirdCatId(e.getThirdCatId());
            if (ObjectUtil.isNull((Object)componentCat)) {
                e.setThirdCatName("");
            } else {
                e.setThirdCatName(Optional.ofNullable(componentCat.getThirdCatName()).orElse(""));
            }
        });
        return CommonPage.copyPageInfo((Page)page, (List)productList);
    }

    @Override
    public PageInfo<PayComponentDraftProduct> getPlatformAdminListAfterMerchantReviewBeforeWeChatReview(ComponentProductSearchRequest request, PageParamRequest pageParamRequest) {
        Page page = PageHelper.startPage((int)pageParamRequest.getPage(), (int)pageParamRequest.getLimit());
        LambdaQueryWrapper lqw = Wrappers.lambdaQuery();
        lqw.eq(PayComponentDraftProduct::getIsDel, (Object)false);
        if (ObjectUtil.isNotNull((Object)request.getProId())) {
            lqw.eq(PayComponentDraftProduct::getProductId, (Object)request.getProId());
        }
        if (StrUtil.isNotBlank((CharSequence)request.getSearch())) {
            lqw.like(PayComponentDraftProduct::getTitle, (Object)URLUtil.decode((String)request.getSearch()));
        }
        lqw.eq(PayComponentDraftProduct::getIsDel, (Object)false);
        lqw.eq(PayComponentDraftProduct::getPlatformEditStatus, (Object)PayComponentPlatformEditStatusEnum.PLATFORM_REVIEW_ING.getCode());
        lqw.lt(PayComponentDraftProduct::getEditStatus, (Object)PayComponentEditStatusEnum.REVIEW_SUCCESS.getCode());
        lqw.orderByDesc(PayComponentDraftProduct::getId);
        List productList = this.dao.selectList((Wrapper)lqw);
        productList.forEach(e -> {
            PayComponentCat componentCat = this.catService.getByThirdCatId(e.getThirdCatId());
            if (ObjectUtil.isNull((Object)componentCat)) {
                e.setThirdCatName("");
            } else {
                e.setThirdCatName(Optional.ofNullable(componentCat.getThirdCatName()).orElse(""));
            }
        });
        return CommonPage.copyPageInfo((Page)page, (List)productList);
    }

    @Override
    public PayComponentDraftProduct getInfo(Integer id) {
        PayComponentDraftProduct draftProduct = (PayComponentDraftProduct)this.getById(id);
        if (ObjectUtil.isNull((Object)draftProduct) || draftProduct.getIsDel().booleanValue()) {
            throw new CrmebException("\u5546\u54c1\u4e0d\u5b58\u5728");
        }
        PayComponentCat componentCat = this.catService.getByThirdCatId(draftProduct.getThirdCatId());
        draftProduct.setCatInfo(componentCat);
        return draftProduct;
    }

    @Override
    public Boolean OperationPlatformReviewStatusByMerchant(PayComponentDraftProductMerchantOperationReviewStatus reviewStatus) {
        LambdaUpdateWrapper draftProductLambdaUpdateWrapper = Wrappers.lambdaUpdate();
        draftProductLambdaUpdateWrapper.eq(PayComponentDraftProduct::getId, (Object)reviewStatus.getDraftProductId());
        draftProductLambdaUpdateWrapper.set(PayComponentDraftProduct::getPlatformEditStatus, (Object)reviewStatus.getPlatformEditStatus());
        return this.update((Wrapper)draftProductLambdaUpdateWrapper);
    }

    @Override
    public Boolean OperationPlatformReviewStatusByPlatform(PayComponentDraftProductPlatformOperationReviewStatus reviewStatus) {
        logger.info("\u5e73\u53f0\u5ba1\u6838\u5546\u5bb6\u63d0\u5ba1\u7684\u89c6\u9891\u53f7\u5546\u54c1:{}", (Object)JSON.toJSONString((Object)reviewStatus));
        if (reviewStatus.getPlatformEditStatus().equals(PayComponentPlatformEditStatusEnum.PLATFORM_REVIEW_FAILED.getCode()) && ObjectUtil.isEmpty((Object)reviewStatus.getPlatformStatusReason())) {
            logger.error("\u5e73\u53f0\u5ba1\u6838\u89c6\u9891\u53f7\u8349\u7a3f\u5546\u54c1\u62d2\u7edd\u65f6 \u5fc5\u987b\u586b\u5199\u62d2\u7edd\u539f\u56e0{}", (Object)JSON.toJSONString((Object)reviewStatus));
            throw new CrmebException("\u5e73\u53f0\u5ba1\u6838\u89c6\u9891\u53f7\u8349\u7a3f\u5546\u54c1\u62d2\u7edd\u65f6 \u5fc5\u987b\u586b\u5199\u62d2\u7edd\u539f\u56e0");
        }
        LambdaUpdateWrapper draftProductLambdaUpdateWrapper = Wrappers.lambdaUpdate();
        draftProductLambdaUpdateWrapper.eq(PayComponentDraftProduct::getId, (Object)reviewStatus.getDraftProductId());
        draftProductLambdaUpdateWrapper.set(PayComponentDraftProduct::getPlatformEditStatus, (Object)reviewStatus.getPlatformEditStatus());
        if (ObjectUtil.isNotEmpty((Object)reviewStatus.getPlatformStatusReason())) {
            draftProductLambdaUpdateWrapper.set(PayComponentDraftProduct::getPlatformStatusReason, (Object)reviewStatus.getPlatformStatusReason());
        }
        if (reviewStatus.getPlatformEditStatus().equals(PayComponentPlatformEditStatusEnum.PLATFORM_REVIEW_FAILED.getCode())) {
            logger.info("\u5e73\u53f0\u62d2\u7edd\u4e86\u5546\u5bb6\u63d0\u5ba1\u7684\u89c6\u9891\u53f7\u5546\u54c1:{}", (Object)PayComponentPlatformEditStatusEnum.PLATFORM_REVIEW_FAILED.getCode());
            LambdaUpdateWrapper productLambdaUpdateWrapper = Wrappers.lambdaUpdate();
            productLambdaUpdateWrapper.eq(PayComponentProduct::getId, (Object)reviewStatus.getDraftProductId());
            productLambdaUpdateWrapper.set(PayComponentProduct::getPlatformEditStatus, (Object)reviewStatus.getPlatformEditStatus());
            this.update((Wrapper)draftProductLambdaUpdateWrapper);
            this.productService.update((Wrapper)productLambdaUpdateWrapper);
            return true;
        }
        PayComponentDraftProduct currentDraftProduct = (PayComponentDraftProduct)this.getById(reviewStatus.getDraftProductId());
        PayComponentProduct currentPayComponentProduct = (PayComponentProduct)this.productService.getById(currentDraftProduct.getProductId());
        ArrayList skuList = CollUtil.newArrayList((Object[])new PayComponentProductSku[0]);
        if (!currentDraftProduct.getSpecType().booleanValue()) {
            PayComponentProductSkuAttr skuAttr = new PayComponentProductSkuAttr();
            skuAttr.setAttrKey("\u8bf7\u9009\u62e9\u89c4\u683c");
            skuAttr.setAttrValue("\u9ed8\u8ba4");
            skuAttr.setIsDel(Boolean.valueOf(false));
            ArrayList attrList = CollUtil.newArrayList((Object[])new PayComponentProductSkuAttr[0]);
            attrList.add(skuAttr);
            ProductAttrValueAddRequest attrValueRequest2 = (ProductAttrValueAddRequest)JSONObject.parseObject((String)JSONArray.parseArray((String)currentDraftProduct.getAttrValue()).get(0).toString(), ProductAttrValueAddRequest.class);
            PayComponentProductSku sku = new PayComponentProductSku();
            sku.setThumbImg(attrValueRequest2.getImage());
            sku.setSalePrice(Long.valueOf(attrValueRequest2.getPrice().multiply(new BigDecimal("100")).longValue()));
            sku.setMarketPrice(Long.valueOf(attrValueRequest2.getOtPrice().multiply(new BigDecimal("100")).longValue()));
            sku.setStockNum(attrValueRequest2.getStock());
            sku.setAttrList((List)attrList);
            sku.setIsDel(Boolean.valueOf(true));
            sku.setId(attrValueRequest2.getId());
            sku.setSku("\u9ed8\u8ba4");
            skuList.add(sku);
            logger.info("\u89c6\u9891\u53f7\u5546\u54c1 \u5355\u89c4\u683c\u5904\u7406\u5b8c\u6bd5:{}", (Object)JSON.toJSONString((Object)skuList));
        } else {
            List valueRequestList = JSONArray.parseArray((String)currentDraftProduct.getAttrValue(), ProductAttrValueAddRequest.class);
            valueRequestList.forEach(attrValueRequest -> {
                PayComponentProductSku sku = new PayComponentProductSku();
                sku.setThumbImg(attrValueRequest.getImage());
                sku.setSalePrice(Long.valueOf(attrValueRequest.getPrice().multiply(new BigDecimal("100")).longValue()));
                sku.setMarketPrice(Long.valueOf(attrValueRequest.getOtPrice().multiply(new BigDecimal("100")).longValue()));
                sku.setStockNum(attrValueRequest.getStock());
                sku.setIsDel(Boolean.valueOf(true));
                sku.setId(attrValueRequest.getId());
                ArrayList<String> skuAttrList = new ArrayList<String>();
                String attrValueJson = attrValueRequest.getAttrValue();
                JSONObject jsonObject = JSONObject.parseObject((String)attrValueJson);
                ArrayList attrList = CollUtil.newArrayList((Object[])new PayComponentProductSkuAttr[0]);
                for (Map.Entry vo : jsonObject.entrySet()) {
                    skuAttrList.add(vo.getValue().toString());
                    PayComponentProductSkuAttr skuAttr = new PayComponentProductSkuAttr();
                    skuAttr.setAttrKey((String)vo.getKey());
                    skuAttr.setAttrValue(vo.getValue().toString());
                    skuAttr.setIsDel(Boolean.valueOf(false));
                    attrList.add(skuAttr);
                }
                sku.setSku(String.join((CharSequence)",", skuAttrList));
                sku.setAttrList((List)attrList);
                skuList.add(sku);
            });
            logger.info("\u89c6\u9891\u53f7\u5546\u54c1 \u591a\u89c4\u683c\u5904\u7406\u5b8c\u6bd5:{}", (Object)JSON.toJSONString((Object)skuList));
        }
        PayComponentProductInfo productInfo = new PayComponentProductInfo();
        if (StrUtil.isNotBlank((CharSequence)currentDraftProduct.getDescInfo())) {
            productInfo.setDesc(this.systemAttachmentService.clearPrefix(currentDraftProduct.getDescInfo()));
        }
        ShopSpuAddVo shopSpuAddVo = this.assembleShopSpuVo(currentPayComponentProduct, skuList, productInfo);
        LambdaUpdateWrapper productLambdaUpdateWrapper = Wrappers.lambdaUpdate();
        productLambdaUpdateWrapper.eq(PayComponentProduct::getId, (Object)reviewStatus.getDraftProductId());
        productLambdaUpdateWrapper.set(PayComponentProduct::getPlatformEditStatus, (Object)reviewStatus.getPlatformEditStatus());
        ShopSpuAddResponseVo spuAddResponseVo = null;
        try {
            spuAddResponseVo = this.wechatVideoSpuService.shopSpuAdd(shopSpuAddVo);
            logger.error("\u5e73\u53f0\u64cd\u4f5c--\u300b\u8349\u7a3f\u5546\u54c1\u5ba1\u6838\u901a\u8fc7\uff0c\u63d0\u4ea4\u5230\u5fae\u4fe1\u7aef\u5ba1\u6838\u8fd4\u56de\u6570\u636e{}", (Object)JSON.toJSONString((Object)spuAddResponseVo));
            draftProductLambdaUpdateWrapper.set(PayComponentDraftProduct::getEditStatus, (Object)PayComponentEditStatusEnum.REVIEW_ING.getCode());
            this.update((Wrapper)draftProductLambdaUpdateWrapper);
            this.productService.update((Wrapper)productLambdaUpdateWrapper);
            logger.info("\u89c6\u9891\u53f7\u5546\u54c1 \u5ba1\u6838\u6210\u529f\u63d0\u4ea4\u7ed9\u5fae\u4fe1\u4fa7\u5ba1\u6838 \u6210\u529f:{}", (Object)JSON.toJSONString((Object)spuAddResponseVo));
        }
        catch (Exception e) {
            draftProductLambdaUpdateWrapper.set(PayComponentDraftProduct::getPlatformStatusReason, (Object)e.getMessage());
            draftProductLambdaUpdateWrapper.set(PayComponentDraftProduct::getPlatformEditStatus, (Object)PayComponentPlatformEditStatusEnum.PLATFORM_REVIEW_FAILED.getCode());
            this.update((Wrapper)draftProductLambdaUpdateWrapper);
            productLambdaUpdateWrapper.set(PayComponentProduct::getPlatformEditStatus, (Object)PayComponentPlatformEditStatusEnum.PLATFORM_REVIEW_FAILED.getCode());
            this.productService.update((Wrapper)productLambdaUpdateWrapper);
            logger.info("\u89c6\u9891\u53f7\u5546\u54c1 \u5ba1\u6838\u6210\u529f\u63d0\u4ea4\u7ed9\u5fae\u4fe1\u4fa7\u5ba1\u6838 \u5931\u8d25:{}", (Object)JSON.toJSONString((Object)spuAddResponseVo));
        }
        return true;
    }

    @Override
    public List<PayComponentDraftProduct> getDraftProductByOperation(Integer id, String title) {
        LambdaQueryWrapper lambdaQueryWrapper = Wrappers.lambdaQuery();
        if (ObjectUtil.isNotEmpty((Object)id)) {
            lambdaQueryWrapper.eq(PayComponentDraftProduct::getId, (Object)id);
        }
        if (ObjectUtil.isNotEmpty((Object)title)) {
            lambdaQueryWrapper.eq(PayComponentDraftProduct::getTitle, (Object)title);
        }
        return this.dao.selectList((Wrapper)lambdaQueryWrapper);
    }

    private ShopSpuAddVo assembleShopSpuVo(PayComponentProduct product, List<PayComponentProductSku> skuList, PayComponentProductInfo productInfo) {
        ShopSpuAddVo shopSpuAddVo = new ShopSpuAddVo();
        shopSpuAddVo.setOutProductId(product.getId().toString());
        shopSpuAddVo.setTitle(product.getTitle());
        shopSpuAddVo.setPath(product.getPath());
        List stringList = JSONArray.parseArray((String)product.getHeadImg(), String.class);
        shopSpuAddVo.setHeadImg(stringList);
        if (StrUtil.isNotBlank((CharSequence)product.getQualificationPics()) && !product.getQualificationPics().equals("[]")) {
            shopSpuAddVo.setQualificationPics(CrmebUtil.stringToArrayStr((String)product.getQualificationPics()));
        }
        if (StrUtil.isNotBlank((CharSequence)productInfo.getDesc())) {
            ShopSpuInfoVo shopSpuInfoVo = new ShopSpuInfoVo();
            shopSpuInfoVo.setDesc(productInfo.getDesc());
            shopSpuAddVo.setDescInfo(shopSpuInfoVo);
        }
        shopSpuAddVo.setThirdCatId(product.getThirdCatId());
        shopSpuAddVo.setBrandId(product.getBrandId());
        List skuVoList = skuList.stream().map(sku -> {
            ShopSpuSkuVo spuSkuVo = new ShopSpuSkuVo();
            BeanUtils.copyProperties((Object)sku, (Object)spuSkuVo);
            spuSkuVo.setOutProductId(product.getId().toString());
            spuSkuVo.setOutSkuId(sku.getId().toString());
            List attrVoList = sku.getAttrList().stream().map(attr -> {
                ShopSpuSkuAttrVo shopSpuSkuAttrVo = new ShopSpuSkuAttrVo();
                BeanUtils.copyProperties((Object)attr, (Object)shopSpuSkuAttrVo);
                return shopSpuSkuAttrVo;
            }).collect(Collectors.toList());
            spuSkuVo.setSkuAttrs(attrVoList);
            return spuSkuVo;
        }).collect(Collectors.toList());
        shopSpuAddVo.setSkus(skuVoList);
        return shopSpuAddVo;
    }
}

