/*
 * Decompiled with CFR 0.152.
 */
package com.zbkj.service.service.impl;

import cn.hutool.core.collection.CollUtil;
import cn.hutool.core.util.ObjectUtil;
import cn.hutool.core.util.StrUtil;
import cn.hutool.crypto.SecureUtil;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.zbkj.common.exception.CrmebException;
import com.zbkj.common.model.express.Express;
import com.zbkj.common.request.OnePassLoginRequest;
import com.zbkj.common.request.OnePassMealCodeRequest;
import com.zbkj.common.request.OnePassRegisterRequest;
import com.zbkj.common.request.OnePassServiceOpenRequest;
import com.zbkj.common.request.OnePassUpdateRequest;
import com.zbkj.common.request.OnePassUserCodeRequest;
import com.zbkj.common.request.OnePassUserRecordRequest;
import com.zbkj.common.response.OnePassLoginResponse;
import com.zbkj.common.utils.CrmebDateUtil;
import com.zbkj.common.utils.CrmebUtil;
import com.zbkj.common.utils.RedisUtil;
import com.zbkj.common.utils.ValidateFormUtil;
import com.zbkj.common.vo.MyRecord;
import com.zbkj.common.vo.OnePassLoginVo;
import com.zbkj.common.vo.OnePassLogisticsQueryVo;
import com.zbkj.common.vo.OnePassMealCodeVo;
import com.zbkj.common.vo.OnePassMealListVo;
import com.zbkj.common.vo.OnePassRecordListVo;
import com.zbkj.common.vo.OnePassUserInfoVo;
import com.zbkj.service.service.ExpressService;
import com.zbkj.service.service.OnePassService;
import com.zbkj.service.service.SystemConfigService;
import com.zbkj.service.service.impl.OnePassSmsServiceImpl;
import com.zbkj.service.util.OnePassUtil;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.support.TransactionTemplate;
import org.springframework.util.LinkedMultiValueMap;
import org.springframework.util.MultiValueMap;

@Service
public class OnePassServiceImpl
implements OnePassService {
    private static final Logger logger = LoggerFactory.getLogger(OnePassSmsServiceImpl.class);
    @Autowired
    private SystemConfigService systemConfigService;
    @Autowired
    private RedisUtil redisUtil;
    @Autowired
    private TransactionTemplate transactionTemplate;
    @Autowired
    private OnePassUtil onePassUtil;
    @Autowired
    private ExpressService expressService;

    @Override
    public Object sendUserCode(OnePassUserCodeRequest request) {
        LinkedMultiValueMap map = new LinkedMultiValueMap();
        map.add((Object)"phone", (Object)request.getPhone());
        if (ObjectUtil.isNotNull((Object)request.getTypes())) {
            map.add((Object)"types", (Object)request.getTypes());
        }
        return this.onePassUtil.postFrom("https://sms.crmeb.net/api/user/code", (MultiValueMap<String, Object>)map, null);
    }

    @Override
    public String register(OnePassRegisterRequest registerRequest) {
        LinkedMultiValueMap map = new LinkedMultiValueMap();
        map.add((Object)"account", (Object)registerRequest.getAccount());
        map.add((Object)"password", (Object)SecureUtil.md5((String)registerRequest.getPassword()));
        map.add((Object)"phone", (Object)registerRequest.getPhone());
        map.add((Object)"verify_code", (Object)registerRequest.getCode());
        map.add((Object)"url", (Object)registerRequest.getDomain());
        JSONObject post = this.onePassUtil.postFrom("https://sms.crmeb.net/api/user/register", (MultiValueMap<String, Object>)map, null);
        String accessToken = "Bearer-".concat(post.getJSONObject("data").getString("access_token"));
        Long expiresIn = post.getJSONObject("data").getLong("expires_in");
        expiresIn = expiresIn - CrmebDateUtil.getTime();
        String secret = SecureUtil.md5((String)(registerRequest.getPhone() + SecureUtil.md5((String)registerRequest.getPassword())));
        this.redisUtil.set(StrUtil.format((CharSequence)"one_pass_token_{}", (Object[])new Object[]{secret}), (Object)accessToken, expiresIn, TimeUnit.SECONDS);
        this.setConfigSmsInfo(registerRequest.getPhone(), registerRequest.getPassword());
        return post.getString("msg");
    }

    @Override
    public OnePassLoginResponse login(OnePassLoginRequest request) {
        LinkedMultiValueMap param = new LinkedMultiValueMap();
        param.add((Object)"account", (Object)request.getAccount());
        String secret = SecureUtil.md5((String)(request.getAccount() + SecureUtil.md5((String)request.getPassword())));
        param.add((Object)"secret", (Object)secret);
        JSONObject jsonObject = this.onePassUtil.postFrom("https://sms.crmeb.net/api/user/login", (MultiValueMap<String, Object>)param, null);
        this.setConfigSmsInfo(request.getAccount(), request.getPassword());
        String accessToken = "Bearer-".concat(jsonObject.getJSONObject("data").getString("access_token"));
        Long expiresIn = jsonObject.getJSONObject("data").getLong("expires_in");
        expiresIn = expiresIn - CrmebDateUtil.getTime();
        this.redisUtil.set(StrUtil.format((CharSequence)"one_pass_token_{}", (Object[])new Object[]{secret}), (Object)accessToken, expiresIn, TimeUnit.SECONDS);
        return new OnePassLoginResponse(request.getAccount());
    }

    @Override
    public OnePassLoginResponse isLogin() {
        OnePassLoginVo loginVo;
        try {
            loginVo = this.getLoginVo();
        }
        catch (Exception e) {
            return new OnePassLoginResponse(Boolean.FALSE);
        }
        this.onePassUtil.getToken(loginVo);
        return new OnePassLoginResponse(loginVo.getAccount());
    }

    @Override
    public OnePassUserInfoVo info() {
        String printerNo;
        OnePassUserInfoVo info = this.getInfo();
        Integer open = info.getDump().getOpen();
        if (open.equals(1) && StrUtil.isBlank((CharSequence)(printerNo = this.systemConfigService.getValueByKey("config_export_siid")))) {
            info.getDump().setOpen(Integer.valueOf(0));
        }
        return info;
    }

    private OnePassUserInfoVo getInfo() {
        OnePassLoginVo loginVo = this.getLoginVo();
        String accessToken = this.onePassUtil.getToken(loginVo);
        HashMap<String, String> header = this.onePassUtil.getCommonHeader(accessToken);
        JSONObject jsonObject = this.onePassUtil.postFrom("https://sms.crmeb.net/api/user/info", null, header);
        OnePassUserInfoVo userInfoVo = (OnePassUserInfoVo)jsonObject.getObject("data", OnePassUserInfoVo.class);
        userInfoVo.setAccount(loginVo.getAccount());
        return userInfoVo;
    }

    @Override
    public Boolean logOut() {
        OnePassLoginVo loginVo = this.getLoginVo();
        this.onePassUtil.removeToken(loginVo);
        this.setConfigSmsInfo("", "");
        return Boolean.TRUE;
    }

    @Override
    public Boolean updatePassword(OnePassUpdateRequest request) {
        if (StrUtil.isBlank((CharSequence)request.getPassword())) {
            throw new CrmebException("\u5bc6\u7801\u4e0d\u80fd\u4e3a\u7a7a");
        }
        LinkedMultiValueMap map = new LinkedMultiValueMap();
        map.add((Object)"account", (Object)request.getAccount());
        map.add((Object)"password", (Object)SecureUtil.md5((String)request.getPassword().trim()));
        map.add((Object)"phone", (Object)request.getPhone());
        map.add((Object)"verify_code", (Object)request.getCode());
        this.onePassUtil.postFrom("https://sms.crmeb.net/api/user/modify", (MultiValueMap<String, Object>)map, null);
        this.setConfigSmsInfo("", "");
        return Boolean.TRUE;
    }

    @Override
    public Boolean updatePhone(OnePassUpdateRequest request) {
        ValidateFormUtil.isPhoneException((String)request.getPhone());
        LinkedMultiValueMap map = new LinkedMultiValueMap();
        map.add((Object)"account", (Object)request.getAccount());
        map.add((Object)"phone", (Object)request.getPhone());
        map.add((Object)"verify_code", (Object)request.getCode());
        OnePassLoginVo loginVo = this.getLoginVo();
        String token = this.onePassUtil.getToken(loginVo);
        HashMap<String, String> header = this.onePassUtil.getCommonHeader(token);
        this.onePassUtil.postFrom("https://sms.crmeb.net/api/user/modify/phone", (MultiValueMap<String, Object>)map, header);
        this.onePassUtil.removeToken(loginVo);
        this.setConfigSmsInfo("", "");
        return true;
    }

    @Override
    public OnePassMealListVo mealList(String type) {
        if (!this.validateMealType(type).booleanValue()) {
            throw new CrmebException("\u8bf7\u9009\u62e9\u6b63\u786e\u7684\u5957\u9910\u7c7b\u578b");
        }
        LinkedMultiValueMap params = new LinkedMultiValueMap();
        params.add((Object)"type", (Object)type);
        OnePassLoginVo loginVo = this.getLoginVo();
        String token = this.onePassUtil.getToken(loginVo);
        HashMap<String, String> header = this.onePassUtil.getCommonHeader(token);
        JSONObject jsonObject = this.onePassUtil.postFrom("https://sms.crmeb.net/api/meal/list", (MultiValueMap<String, Object>)params, header);
        return (OnePassMealListVo)jsonObject.getObject("data", OnePassMealListVo.class);
    }

    @Override
    public OnePassMealCodeVo mealCode(OnePassMealCodeRequest request) {
        OnePassLoginVo loginVo = this.getLoginVo();
        String token = this.onePassUtil.getToken(loginVo);
        HashMap<String, String> header = this.onePassUtil.getCommonHeader(token);
        JSONObject jsonObject = this.onePassUtil.postFrom("https://sms.crmeb.net/api/user/info", null, header);
        OnePassUserInfoVo userInfoVo = (OnePassUserInfoVo)jsonObject.getObject("data", OnePassUserInfoVo.class);
        boolean isGrant = false;
        switch (request.getType()) {
            case "sms": {
                isGrant = userInfoVo.getSms().getOpen().equals(1);
                break;
            }
            case "expr_query": {
                isGrant = userInfoVo.getQuery().getOpen().equals(1);
                break;
            }
            case "expr_dump": {
                isGrant = userInfoVo.getDump().getOpen().equals(1);
                break;
            }
            case "copy": {
                isGrant = userInfoVo.getCopy().getOpen().equals(1);
            }
        }
        if (!isGrant) {
            throw new CrmebException("\u8bf7\u5148\u5f00\u901a\u5bf9\u5e94\u7684\u670d\u52a1");
        }
        LinkedMultiValueMap params = new LinkedMultiValueMap();
        params.add((Object)"meal_id", (Object)request.getMealId());
        params.add((Object)"price", (Object)request.getPrice());
        params.add((Object)"num", (Object)request.getNum());
        params.add((Object)"type", (Object)request.getType());
        params.add((Object)"pay_type", (Object)request.getPayType());
        JSONObject post = this.onePassUtil.postFrom("https://sms.crmeb.net/api/meal/code", (MultiValueMap<String, Object>)params, header);
        return (OnePassMealCodeVo)post.getObject("data", OnePassMealCodeVo.class);
    }

    @Override
    public Boolean serviceOpen(OnePassServiceOpenRequest request) {
        Boolean open = false;
        switch (request.getType()) {
            case "sms": {
                if (StrUtil.isBlank((CharSequence)request.getSign())) {
                    throw new CrmebException("\u7b7e\u540d\u4e0d\u80fd\u4e3a\u7a7a");
                }
                open = this.smsOpen(request);
                break;
            }
            case "expr_query": {
                open = this.expressOpen(request);
                break;
            }
            case "expr_dump": {
                this.expressOpenValidate(request);
                open = this.expressOpen(request);
                break;
            }
            case "copy": {
                open = this.copyOpen();
            }
        }
        return open;
    }

    @Override
    public OnePassRecordListVo userRecord(OnePassUserRecordRequest request) {
        LinkedMultiValueMap params = new LinkedMultiValueMap();
        params.add((Object)"type", (Object)request.getType());
        params.add((Object)"page", (Object)request.getPage());
        params.add((Object)"limit", (Object)request.getLimit());
        if ("sms".equals(request.getType()) && ObjectUtil.isNotNull((Object)request.getStatus()) && request.getStatus() != 3) {
            params.add((Object)"status", (Object)request.getStatus());
        }
        OnePassLoginVo loginVo = this.getLoginVo();
        String token = this.onePassUtil.getToken(loginVo);
        HashMap<String, String> header = this.onePassUtil.getCommonHeader(token);
        JSONObject jsonObject = this.onePassUtil.postFrom("https://sms.crmeb.net/api/user/record", (MultiValueMap<String, Object>)params, header);
        OnePassRecordListVo listVo = (OnePassRecordListVo)jsonObject.getObject("data", OnePassRecordListVo.class);
        if ("sms".equals(request.getType())) {
            listVo.getData().forEach(e -> {
                if (StrUtil.isNotBlank((CharSequence)e.getPhone())) {
                    e.setPhone(CrmebUtil.maskMobile((String)e.getPhone()));
                }
            });
        }
        return listVo;
    }

    @Override
    public JSONObject copyGoods(String url) {
        logger.info("\u5546\u54c1\u91c7\u96c6 URL:{}", (Object)url);
        OnePassLoginVo loginVo = this.getLoginVo();
        HashMap<String, String> header = this.onePassUtil.getCommonHeader(this.onePassUtil.getToken(loginVo));
        LinkedMultiValueMap params = new LinkedMultiValueMap();
        params.add((Object)"url", (Object)url);
        JSONObject jsonObject = this.onePassUtil.postFrom("https://sms.crmeb.net/api/copy/goods", (MultiValueMap<String, Object>)params, header);
        logger.info("one pass copy product = {}", (Object)jsonObject);
        return jsonObject.getJSONObject("data");
    }

    @Override
    public MyRecord expressDump(MyRecord record) {
        OnePassLoginVo loginVo = this.getLoginVo();
        HashMap<String, String> header = this.onePassUtil.getCommonHeader(this.onePassUtil.getToken(loginVo));
        LinkedMultiValueMap params = new LinkedMultiValueMap();
        Map columns = record.getColumns();
        logger.info("\u7535\u5b50\u9762\u5355\u539f\u672c\u7684\u53c2\u6570:{}", (Object)JSON.toJSONString((Object)columns));
        Object siid = columns.get("siid");
        logger.info("\u539f\u59cb\u6570\u636e\u7684siid\u6570\u636e:{}", siid);
        if (ObjectUtil.isEmpty(siid)) {
            columns.put("print_type", "IMAGE");
            header.put("version", "v1.1");
        }
        columns.forEach((arg_0, arg_1) -> ((MultiValueMap)params).add(arg_0, arg_1));
        logger.info("\u8bf7\u6c42\u524d\u53c2\u6570params:{}", (Object)JSON.toJSONString((Object)params));
        logger.info("\u8bf7\u6c42\u524d\u53c2\u6570header:{}", (Object)JSON.toJSONString(header));
        JSONObject post = this.onePassUtil.postFrom("https://sms.crmeb.net/api/expr/dump", (MultiValueMap<String, Object>)params, header);
        MyRecord myRecord = new MyRecord();
        JSONObject jsonObject = post.getJSONObject("data");
        return myRecord.setColums(jsonObject);
    }

    @Override
    public OnePassLogisticsQueryVo exprQuery(String expressNo, String com) {
        OnePassLoginVo loginVo = this.getLoginVo();
        HashMap<String, String> header = this.onePassUtil.getCommonHeader(this.onePassUtil.getToken(loginVo));
        LinkedMultiValueMap params = new LinkedMultiValueMap();
        params.add((Object)"com", (Object)com);
        params.add((Object)"num", (Object)expressNo);
        JSONObject post = this.onePassUtil.postFrom("https://sms.crmeb.net/api/expr/query", (MultiValueMap<String, Object>)params, header);
        String dataStr = post.getString("data");
        if (StrUtil.isBlank((CharSequence)dataStr) || dataStr.equals("[]")) {
            return null;
        }
        JSONObject jsonObject = post.getJSONObject("data");
        return (OnePassLogisticsQueryVo)JSONObject.toJavaObject((JSON)jsonObject, OnePassLogisticsQueryVo.class);
    }

    @Override
    public Boolean beforeUpdatePhoneValidator(OnePassLoginRequest request) {
        OnePassLoginVo loginVo = this.getLoginVo();
        if (!loginVo.getAccount().equals(request.getAccount())) {
            throw new CrmebException("\u8d26\u53f7\u4e0d\u5339\u914d");
        }
        String secret = SecureUtil.md5((String)(request.getAccount() + SecureUtil.md5((String)request.getPassword())));
        if (!loginVo.getSecret().equals(secret)) {
            throw new CrmebException("\u5bc6\u7801\u4e0d\u5339\u914d");
        }
        return Boolean.TRUE;
    }

    @Override
    public Boolean checkAccount() {
        String account = this.systemConfigService.getValueByKey("sms_account");
        if (StrUtil.isBlank((CharSequence)account)) {
            return Boolean.FALSE;
        }
        String token = this.systemConfigService.getValueByKey("sms_token");
        if (StrUtil.isBlank((CharSequence)token)) {
            return Boolean.FALSE;
        }
        return Boolean.TRUE;
    }

    private void expressOpenValidate(OnePassServiceOpenRequest request) {
        if (StrUtil.isBlank((CharSequence)request.getCom())) {
            throw new CrmebException("\u8bf7\u9009\u62e9\u5feb\u9012\u516c\u53f8");
        }
        if (StrUtil.isBlank((CharSequence)request.getTempId())) {
            throw new CrmebException("\u8bf7\u9009\u62e9\u5feb\u9012\u6a21\u677f");
        }
        if (StrUtil.isBlank((CharSequence)request.getToName())) {
            throw new CrmebException("\u8bf7\u586b\u5199\u5bc4\u4ef6\u4eba\u59d3\u540d");
        }
        if (StrUtil.isBlank((CharSequence)request.getToTel())) {
            throw new CrmebException("\u8bf7\u8f93\u5165\u5bc4\u4ef6\u4eba\u624b\u673a\u53f7\u7801");
        }
        if (StrUtil.isBlank((CharSequence)request.getToAddress())) {
            throw new CrmebException("\u8bf7\u586b\u5199\u5bc4\u4ef6\u4eba\u8be6\u7ec6\u5730\u5740");
        }
        if (StrUtil.isBlank((CharSequence)request.getSiid())) {
            throw new CrmebException("\u8bf7\u586b\u5199\u4e91\u6253\u5370\u673a\u7f16\u53f7");
        }
        ValidateFormUtil.isPhoneException((String)request.getToTel());
    }

    private Boolean copyOpen() {
        OnePassLoginVo loginVo = this.getLoginVo();
        String token = this.onePassUtil.getToken(loginVo);
        HashMap<String, String> header = this.onePassUtil.getCommonHeader(token);
        this.onePassUtil.postFrom("https://sms.crmeb.net/api/copy/open", null, header);
        return Boolean.TRUE;
    }

    private Boolean expressOpen(OnePassServiceOpenRequest request) {
        OnePassLoginVo loginVo = this.getLoginVo();
        String token = this.onePassUtil.getToken(loginVo);
        HashMap<String, String> header = this.onePassUtil.getCommonHeader(token);
        if (request.getType().equals("expr_query")) {
            this.onePassUtil.postFrom("https://sms.crmeb.net/api/expr/open", null, header);
            return Boolean.TRUE;
        }
        Express express = this.expressService.getByCode(request.getCom());
        if (ObjectUtil.isNull((Object)express)) {
            throw new CrmebException("\u6ca1\u6709\u627e\u5230\u5bf9\u5e94\u7684\u5feb\u9012\u516c\u53f8");
        }
        Boolean execute = (Boolean)this.transactionTemplate.execute(e -> {
            this.systemConfigService.updateOrSaveValueByName("config_export_id", express.getId().toString());
            this.systemConfigService.updateOrSaveValueByName("config_export_temp_id", request.getTempId());
            this.systemConfigService.updateOrSaveValueByName("config_export_com", request.getCom());
            this.systemConfigService.updateOrSaveValueByName("config_export_to_name", request.getToName());
            this.systemConfigService.updateOrSaveValueByName("config_export_to_tel", request.getToTel());
            this.systemConfigService.updateOrSaveValueByName("config_export_to_address", request.getToAddress());
            this.systemConfigService.updateOrSaveValueByName("config_export_siid", request.getSiid());
            return Boolean.TRUE;
        });
        if (Boolean.FALSE.equals(execute)) {
            throw new CrmebException("\u4fdd\u5b58\u5e73\u53f0\u7535\u5b50\u9762\u5355\u6253\u5370\u4fe1\u606f\u5931\u8d25");
        }
        OnePassUserInfoVo userInfoVo = this.info();
        if (userInfoVo.getDump().getOpen().equals(1)) {
            return Boolean.TRUE;
        }
        this.onePassUtil.postFrom("https://sms.crmeb.net/api/expr/open", null, header);
        return Boolean.TRUE;
    }

    private Boolean smsOpen(OnePassServiceOpenRequest request) {
        OnePassLoginVo loginVo = this.getLoginVo();
        String token = this.onePassUtil.getToken(loginVo);
        HashMap<String, String> header = this.onePassUtil.getCommonHeader(token);
        LinkedMultiValueMap params = new LinkedMultiValueMap();
        params.add((Object)"sign", (Object)request.getSign());
        this.onePassUtil.postFrom("https://sms.crmeb.net/api/sms_v2/open", (MultiValueMap<String, Object>)params, header);
        return Boolean.TRUE;
    }

    private Boolean validateMealType(String type) {
        ArrayList list = CollUtil.newArrayList((Object[])new String[0]);
        list.add("sms");
        list.add("expr_query");
        list.add("expr_dump");
        list.add("copy");
        return list.contains(type);
    }

    private void setConfigSmsInfo(String account, String password) {
        boolean accountResult = this.systemConfigService.updateOrSaveValueByName("sms_account", account);
        boolean tokenResult = this.systemConfigService.updateOrSaveValueByName("sms_token", password);
        if (!accountResult || !tokenResult) {
            throw new CrmebException("\u6570\u636e\u66f4\u65b0\u5931\u8d25\uff01");
        }
    }

    @Override
    public OnePassLoginVo getLoginVo() {
        String account = this.systemConfigService.getValueByKey("sms_account");
        if (StrUtil.isBlank((CharSequence)account)) {
            throw new CrmebException("\u8bf7\u914d\u7f6e\u4e00\u53f7\u901a\u8d26\u53f7\uff01");
        }
        String token = this.systemConfigService.getValueByKey("sms_token");
        if (StrUtil.isBlank((CharSequence)token)) {
            throw new CrmebException("\u8bf7\u914d\u7f6e\u4e00\u53f7\u901a\u5bc6\u7801\uff01");
        }
        String secret = SecureUtil.md5((String)(account + SecureUtil.md5((String)token)));
        OnePassLoginVo loginVo = new OnePassLoginVo();
        loginVo.setAccount(account);
        loginVo.setSecret(secret);
        return loginVo;
    }
}

