/*
 * Decompiled with CFR 0.152.
 */
package com.zbkj.service.service.impl;

import cn.hutool.core.collection.CollUtil;
import cn.hutool.core.date.DateUtil;
import cn.hutool.core.util.StrUtil;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.github.pagehelper.Page;
import com.github.pagehelper.PageHelper;
import com.github.pagehelper.PageInfo;
import com.zbkj.common.model.admin.SystemAdmin;
import com.zbkj.common.model.bill.MerchantMonthStatement;
import com.zbkj.common.model.order.OrderProfitSharing;
import com.zbkj.common.model.order.RefundOrder;
import com.zbkj.common.page.CommonPage;
import com.zbkj.common.request.PageParamRequest;
import com.zbkj.common.utils.CrmebDateUtil;
import com.zbkj.common.utils.SecurityUtil;
import com.zbkj.common.vo.DateLimitUtilVo;
import com.zbkj.service.dao.MerchantMonthStatementDao;
import com.zbkj.service.service.MerchantMonthStatementService;
import com.zbkj.service.service.OrderProfitSharingService;
import com.zbkj.service.service.OrderService;
import com.zbkj.service.service.RefundOrderService;
import java.math.BigDecimal;
import java.util.Collection;
import java.util.List;
import javax.annotation.Resource;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class MerchantMonthStatementServiceImpl
extends ServiceImpl<MerchantMonthStatementDao, MerchantMonthStatement>
implements MerchantMonthStatementService {
    @Resource
    private MerchantMonthStatementDao dao;
    @Autowired
    private OrderProfitSharingService orderProfitSharingService;
    @Autowired
    private OrderService orderService;
    @Autowired
    private RefundOrderService refundOrderService;

    @Override
    public List<MerchantMonthStatement> findByMonth(String month) {
        LambdaQueryWrapper lqw = Wrappers.lambdaQuery();
        lqw.eq(MerchantMonthStatement::getDataDate, (Object)month);
        return this.dao.selectList((Wrapper)lqw);
    }

    @Override
    public PageInfo<MerchantMonthStatement> getPageList(String dateLimit, PageParamRequest pageParamRequest) {
        SystemAdmin systemAdmin = SecurityUtil.getLoginUserVo().getUser();
        Page page = PageHelper.startPage((int)pageParamRequest.getPage(), (int)pageParamRequest.getLimit());
        LambdaQueryWrapper lqw = Wrappers.lambdaQuery();
        lqw.eq(MerchantMonthStatement::getMerId, (Object)systemAdmin.getMerId());
        if (StrUtil.isNotBlank((CharSequence)dateLimit)) {
            DateLimitUtilVo dateLimitVo = CrmebDateUtil.getMonthLimit((String)dateLimit);
            String startMonth = dateLimitVo.getStartTime();
            String endMonth = dateLimitVo.getEndTime();
            lqw.between(MerchantMonthStatement::getDataDate, (Object)startMonth, (Object)endMonth);
        }
        lqw.orderByDesc(MerchantMonthStatement::getId);
        List list = this.dao.selectList((Wrapper)lqw);
        if (CollUtil.isEmpty((Collection)list)) {
            return CommonPage.copyPageInfo((Page)page, (List)list);
        }
        String nowMonth = DateUtil.date().toString("yyyy-MM");
        for (MerchantMonthStatement monthStatement : list) {
            if (!monthStatement.getDataDate().equals(nowMonth)) continue;
            this.writeMonthStatement(monthStatement);
        }
        return CommonPage.copyPageInfo((Page)page, (List)list);
    }

    private void writeMonthStatement(MerchantMonthStatement monthStatement) {
        List<OrderProfitSharing> sharingList = this.orderProfitSharingService.findByMonth(monthStatement.getMerId(), monthStatement.getDataDate());
        List<RefundOrder> refundOrderList = this.refundOrderService.findByMonth(monthStatement.getMerId(), monthStatement.getDataDate());
        BigDecimal orderPayAmount = new BigDecimal("0.00");
        int orderNum = 0;
        BigDecimal orderIncomeAmount = new BigDecimal("0.00");
        BigDecimal handlingFee = new BigDecimal("0.00");
        BigDecimal firstBrokerage = new BigDecimal("0.00");
        BigDecimal secondBrokerage = new BigDecimal("0.00");
        BigDecimal refundAmount = new BigDecimal("0.00");
        int refundNum = 0;
        BigDecimal platCouponPrice = new BigDecimal("0.00");
        BigDecimal integralPrice = new BigDecimal("0.00");
        BigDecimal brokeragePrice = new BigDecimal("0.00");
        BigDecimal orderRefundPrice = new BigDecimal("0.00");
        BigDecimal refundPlatCouponPrice = new BigDecimal("0.00");
        BigDecimal refundIntegralPrice = new BigDecimal("0.00");
        BigDecimal refundHandlingFee = new BigDecimal("0.00");
        BigDecimal refundBrokeragePrice = new BigDecimal("0.00");
        BigDecimal refundMerchantTransferAmount = new BigDecimal("0.00");
        BigDecimal freightFee = new BigDecimal("0.00");
        BigDecimal refundFreightFee = new BigDecimal("0.00");
        if (CollUtil.isNotEmpty(sharingList)) {
            orderPayAmount = sharingList.stream().map(OrderProfitSharing::getOrderPrice).reduce(BigDecimal.ZERO, BigDecimal::add);
            orderNum = sharingList.size();
            orderIncomeAmount = sharingList.stream().map(OrderProfitSharing::getProfitSharingMerPrice).reduce(BigDecimal.ZERO, BigDecimal::add);
            handlingFee = sharingList.stream().map(OrderProfitSharing::getProfitSharingPlatPrice).reduce(BigDecimal.ZERO, BigDecimal::add);
            firstBrokerage = sharingList.stream().map(OrderProfitSharing::getFirstBrokerageFee).reduce(BigDecimal.ZERO, BigDecimal::add);
            secondBrokerage = sharingList.stream().map(OrderProfitSharing::getSecondBrokerageFee).reduce(BigDecimal.ZERO, BigDecimal::add);
            platCouponPrice = sharingList.stream().map(OrderProfitSharing::getPlatCouponPrice).reduce(BigDecimal.ZERO, BigDecimal::add);
            integralPrice = sharingList.stream().map(OrderProfitSharing::getIntegralPrice).reduce(BigDecimal.ZERO, BigDecimal::add);
            brokeragePrice = firstBrokerage.add(secondBrokerage);
            freightFee = sharingList.stream().map(OrderProfitSharing::getFreightFee).reduce(BigDecimal.ZERO, BigDecimal::add);
        }
        if (CollUtil.isNotEmpty(refundOrderList)) {
            refundAmount = refundOrderList.stream().map(RefundOrder::getRefundPrice).reduce(BigDecimal.ZERO, BigDecimal::add);
            refundNum = refundOrderList.size();
            refundMerchantTransferAmount = refundOrderList.stream().map(RefundOrder::getMerchantRefundPrice).reduce(BigDecimal.ZERO, BigDecimal::add);
            refundHandlingFee = refundOrderList.stream().map(RefundOrder::getPlatformRefundPrice).reduce(BigDecimal.ZERO, BigDecimal::add);
            refundPlatCouponPrice = refundOrderList.stream().map(RefundOrder::getRefundPlatCouponPrice).reduce(BigDecimal.ZERO, BigDecimal::add);
            refundBrokeragePrice = refundOrderList.stream().map(e -> e.getRefundFirstBrokerageFee().add(e.getRefundSecondBrokerageFee())).reduce(BigDecimal.ZERO, BigDecimal::add);
            refundIntegralPrice = refundOrderList.stream().map(RefundOrder::getRefundIntegralPrice).reduce(BigDecimal.ZERO, BigDecimal::add);
            orderRefundPrice = refundOrderList.stream().map(RefundOrder::getRefundPrice).reduce(BigDecimal.ZERO, BigDecimal::add);
            refundFreightFee = refundOrderList.stream().map(RefundOrder::getRefundFreightFee).reduce(BigDecimal.ZERO, BigDecimal::add);
        }
        BigDecimal orderReceivable = orderPayAmount.add(platCouponPrice).add(integralPrice);
        BigDecimal orderRefundable = BigDecimal.ZERO.subtract(refundMerchantTransferAmount).subtract(refundHandlingFee).subtract(refundBrokeragePrice);
        BigDecimal orderRefund = orderRefundable.subtract(refundPlatCouponPrice).subtract(refundIntegralPrice);
        BigDecimal platformHandling = handlingFee.subtract(refundHandlingFee);
        BigDecimal brokerage = brokeragePrice.subtract(refundBrokeragePrice);
        BigDecimal income = orderReceivable.add(orderRefundable);
        BigDecimal payout = platformHandling.add(brokerage);
        BigDecimal incomeExpenditure = income.subtract(payout);
        monthStatement.setOrderPayAmount(orderPayAmount);
        monthStatement.setOrderNum(Integer.valueOf(orderNum));
        monthStatement.setOrderIncomeAmount(orderIncomeAmount);
        monthStatement.setHandlingFee(handlingFee);
        monthStatement.setFirstBrokerage(firstBrokerage);
        monthStatement.setSecondBrokerage(secondBrokerage);
        monthStatement.setRefundAmount(refundAmount);
        monthStatement.setRefundNum(Integer.valueOf(refundNum));
        monthStatement.setIncomeExpenditure(incomeExpenditure.abs());
        monthStatement.setPlatCouponPrice(platCouponPrice);
        monthStatement.setIntegralPrice(integralPrice);
        monthStatement.setBrokeragePrice(brokeragePrice);
        monthStatement.setOrderRefundPrice(orderRefundPrice);
        monthStatement.setRefundPlatCouponPrice(refundPlatCouponPrice);
        monthStatement.setRefundIntegralPrice(refundIntegralPrice);
        monthStatement.setRefundHandlingFee(refundHandlingFee);
        monthStatement.setRefundBrokeragePrice(refundBrokeragePrice);
        monthStatement.setRefundMerchantTransferAmount(refundMerchantTransferAmount);
        monthStatement.setFreightFee(freightFee);
        monthStatement.setRefundFreightFee(refundFreightFee);
    }
}

