/*
 * Decompiled with CFR 0.152.
 */
package com.zbkj.service.service.impl;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.alibaba.fastjson.TypeReference;
import com.alibaba.fastjson.parser.Feature;
import com.github.pagehelper.util.StringUtil;
import com.google.common.collect.Maps;
import com.huifu.bspay.sdk.opps.core.utils.SequenceTools;
import com.zbkj.common.dto.HuifuWalletAccountDto;
import com.zbkj.common.dto.HuifuWalletBusiDto;
import com.zbkj.common.exception.CrmebException;
import com.zbkj.common.model.huifu.HuifuWalletReconciliation;
import com.zbkj.common.model.huifu.HuifuWalletTrade;
import com.zbkj.common.model.huifu.HuifuWalletTranslog;
import com.zbkj.common.utils.FileUtil;
import com.zbkj.service.config.PaymentChannel;
import com.zbkj.service.dao.HuifuWalletAccountDao;
import com.zbkj.service.dao.HuifuWalletAccountDetailDao;
import com.zbkj.service.dao.HuifuWalletBusiDao;
import com.zbkj.service.dao.HuifuWalletReconciliationDao;
import com.zbkj.service.dao.HuifuWalletTradeDao;
import com.zbkj.service.dao.HuifuWalletTranslogDao;
import com.zbkj.service.huifu.constants.HFBusiCode;
import com.zbkj.service.huifu.v2.V2ApiRequest;
import com.zbkj.service.service.CommonConfigService;
import com.zbkj.service.service.HuifuReconcileService;
import com.zbkj.service.service.TaskResidualService;
import com.zbkj.service.service.TransactionLogService;
import com.zbkj.service.service.impl.ReconcileType;
import com.zbkj.service.wangshang.api.WSApiRequest;
import com.zbkj.service.wangshang.api.config.WSTransactionType;
import com.zbkj.service.wangshang.constants.WSBusiCode;
import java.io.File;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Resource;
import org.apache.commons.lang3.StringUtils;
import org.redisson.api.RedissonClient;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.support.TransactionTemplate;

@Service
public class HuifuReconcileServiceImpl
implements HuifuReconcileService {
    private static final Logger logger = LoggerFactory.getLogger(HuifuReconcileService.class);
    private static final ReconcileType TYPE_ORDER = new ReconcileType().setName("\u8ba2\u5355/\u4ea4\u6613\u5bf9\u8d26").setReconType("2").setFileType("1").setFileFix("_order_");
    private static final ReconcileType TYPE_SETTLE = new ReconcileType().setName("\u7ed3\u7b97\u5bf9\u8d26").setReconType("1").setFileType("2").setFileFix("_settle_");
    private static final ReconcileType TYPE_SETTLE_USER = new ReconcileType().setName("\u7ed3\u7b97\u7528\u6237\u5bf9\u8d26").setReconType("1").setFileType("8").setFileFix("_settleuser_");
    private static final ReconcileType TYPE_OUTCASH = new ReconcileType().setName("\u51fa\u91d1\u5bf9\u8d26").setReconType("1").setFileType("5").setFileFix("_outcash_");
    private static final ReconcileType TYPE_SPLIT = new ReconcileType().setName("\u5206\u8d26\u5bf9\u8d26").setReconType("1").setFileType("3").setFileFix("_split_");
    public static final String SUCCESS_CODE = "00000000";
    public static final String CHARSET = "GB18030";
    public static final String BATCH_NO = "1";
    @Resource
    private HuifuWalletReconciliationDao huifuWalletReconciliationDao;
    @Resource
    private HuifuWalletTradeDao huifuWalletTradeDao;
    @Autowired
    private TransactionTemplate transactionTemplate;
    @Autowired
    private CommonConfigService commonConfigService;
    @Resource
    private HuifuWalletAccountDao huifuWalletAccountDao;
    @Autowired
    TransactionLogService transactionLogService;
    @Resource
    private HuifuWalletTranslogDao huifuWalletTranslogDao;
    @Resource
    private HuifuWalletAccountDetailDao huifuWalletAccountDetailDao;
    @Resource
    private HuifuWalletBusiDao huifuWalletBusiDao;
    @Autowired
    TaskResidualService taskResidualService;
    @Autowired
    private RedissonClient redisson;
    private static final String SCHKEY = "SchTask:";
    private static Map<String, HuifuWalletAccountDto> accountMap = Maps.newHashMap();

    @Override
    public void reconcileOrder(String date, String huifuId) {
        this.executeReconcile(date, TYPE_ORDER, huifuId);
    }

    @Override
    public void reconcileSettle(String date, String huifuId) {
        this.executeReconcile(date, TYPE_SETTLE, huifuId);
    }

    @Override
    public void reconcileSettleuser(String date, String huifuId) {
        this.executeReconcile(date, TYPE_SETTLE_USER, huifuId);
    }

    @Override
    public void reconcileOutcash(String date, String huifuId) {
        this.executeReconcile(date, TYPE_OUTCASH, huifuId);
    }

    @Override
    public void reconcileSplit(String date, String huifuId) {
        this.executeReconcile(date, TYPE_SPLIT, huifuId);
    }

    @Override
    public void reconcileSplitWS(String date) {
        this.executeReconcileWS(date);
    }

    private void executeReconcileWS(String tradeDate) {
        if (StringUtils.isEmpty((CharSequence)tradeDate)) {
            throw new CrmebException("\u67e5\u8be2\u65e5\u671f\u4e0d\u80fd\u4e3a\u7a7a");
        }
        HashMap<String, Object> param = new HashMap<String, Object>();
        param.put("reqSeqId", SequenceTools.getReqSeqId32());
        param.put("fileDate", tradeDate);
        try {
            Map<String, Object> response = WSApiRequest.api(WSBusiCode.ZDQUERY, param);
            String isSuf = "0";
            if (SUCCESS_CODE.equals(response.get("resp_code"))) {
                isSuf = BATCH_NO;
            }
            this.transactionLogService.save(WSBusiCode.ZDQUERY.toString(), isSuf, JSONObject.toJSONString(param), JSONObject.toJSONString(response), PaymentChannel.WANGSHANG.toString());
            this.processResultWS(tradeDate, response);
        }
        catch (Exception e) {
            this.transactionLogService.save(WSBusiCode.ZDQUERY.toString(), "0", JSONObject.toJSONString(param), e.getMessage(), PaymentChannel.WANGSHANG.toString());
            logger.error(e.getMessage());
        }
    }

    private void processResultWS(String tradeDate, Map<String, Object> response) {
        if (SUCCESS_CODE.equals(response.get("resp_code"))) {
            String downloadUrl = response.get("downloadUrl").toString();
            String outTradeNo = response.get("outTradeNo").toString();
            if (StringUtils.isEmpty((CharSequence)downloadUrl)) {
                return;
            }
            this.dealWithEachZipFileWS(tradeDate, downloadUrl, outTradeNo + ".txt");
        } else {
            logger.error(response.get("resp_desc").toString());
        }
    }

    private void dealWithEachZipFileWS(String tradeDate, String downloadUrl, String fileName) {
        String localFile;
        String downloadToFolder = this.commonConfigService.getValueByKey("payment_reconciliation_download_folder");
        if (!cn.hutool.core.io.FileUtil.exist((String)downloadToFolder)) {
            cn.hutool.core.io.FileUtil.mkdir((String)downloadToFolder);
        }
        if ((localFile = FileUtil.downloadHttpUrl((String)downloadUrl, (String)(downloadToFolder + "/"), (String)fileName)) == null) {
            logger.info("\u5bf9\u8d26ZIP\u6587\u4ef6\u4e0b\u8f7d\u9519\u8bef\uff1a{},{},{}", new Object[]{downloadUrl, downloadToFolder, fileName});
            return;
        }
        File file = new File(localFile);
        if (!file.exists()) {
            return;
        }
        List lines = FileUtil.readCsv((String)localFile, (String)CHARSET);
        if (lines == null) {
            logger.info("\u5bf9\u8d26CSV\u6587\u4ef6\u8bfb\u53d6\u9519\u8bef\uff1a{}", (Object)localFile);
            return;
        }
        lines.remove(0);
        if (lines.isEmpty()) {
            logger.info("\u5bf9\u8d26CSV\u5185\u5bb9\u4e3a\u7a7a\uff1a{}", (Object)localFile);
            return;
        }
        ArrayList<HuifuWalletReconciliation> reconciliationsList = new ArrayList<HuifuWalletReconciliation>();
        HuifuWalletReconciliation huifuWalletReconciliation = null;
        for (String line : lines) {
            line = line.replace("=\"\"", "").replace("=\"", "").replace("\"", "");
            logger.info("\u5bf9\u8d26CSV\u5185\u5bb9\u884c\u6570\u636e\u4fe1\u606f\uff1a{}", (Object)line);
            huifuWalletReconciliation = this.constructSplitReconWS(line);
            if (huifuWalletReconciliation == null) continue;
            reconciliationsList.add(huifuWalletReconciliation);
        }
        if (reconciliationsList.size() > 0) {
            Boolean bl = (Boolean)this.transactionTemplate.execute(e -> {
                Boolean update = Boolean.TRUE;
                try {
                    this.huifuWalletReconciliationDao.insertTempReconciliationList(reconciliationsList);
                    this.huifuWalletReconciliationDao.insertHuifuWalletReconciliation(tradeDate);
                    this.huifuWalletReconciliationDao.deleteTempWalletReconciliation();
                }
                catch (Exception exception) {
                    logger.error(exception.getMessage());
                    logger.error("\u4f01\u4e1a\u94b1\u5305-\u5bf9\u5e10\u6570\u636e-\u63d2\u5165\u5931\u8d25\uff0c\u5bf9\u8d26\u65e5\u671f = {}", (Object)tradeDate);
                    update = false;
                }
                return update;
            });
        }
        accountMap = Maps.newHashMap();
    }

    private HuifuWalletReconciliation constructSplitReconWS(String line) {
        if (StringUtil.isNotEmpty((String)line)) {
            String inHuifuId;
            String[] detailStr = line.split(",");
            HuifuWalletTrade trade = this.huifuWalletTradeDao.getHuifuWalletTradeByHfSeqId(detailStr[2]);
            if (trade == null) {
                return null;
            }
            HuifuWalletReconciliation huifuWalletReconciliation = new HuifuWalletReconciliation();
            huifuWalletReconciliation.setTradeSerialNo(detailStr[2]);
            huifuWalletReconciliation.setMerchantNo(trade.getExpendAccountNo());
            huifuWalletReconciliation.setRequestSerialNo(detailStr[3]);
            huifuWalletReconciliation.setTradeAmount(StringUtils.isEmpty((CharSequence)detailStr[6]) ? BigDecimal.ZERO : new BigDecimal(detailStr[6]));
            huifuWalletReconciliation.setTradeStatus(detailStr[9]);
            huifuWalletReconciliation.setBankTradeType(WSTransactionType.getDescriptionByType(detailStr[4]));
            huifuWalletReconciliation.setTradeStartTime(detailStr[10]);
            huifuWalletReconciliation.setTradeEndTime(detailStr[11]);
            String outHuifuId = trade.getExpendAccountNo();
            if (StringUtils.isNotEmpty((CharSequence)outHuifuId)) {
                HuifuWalletAccountDto account = accountMap.get(outHuifuId);
                if (account == null) {
                    account = this.huifuWalletAccountDao.getHuifuWalletAccountByWalletNo(outHuifuId);
                    accountMap.put(outHuifuId, account);
                }
                if (account != null) {
                    huifuWalletReconciliation.setExpendUniId(account.getUniId());
                    huifuWalletReconciliation.setExpendBankCode(account.getBranchCode());
                    huifuWalletReconciliation.setExpendAccountNo(outHuifuId);
                    huifuWalletReconciliation.setExpendAccountName(account.getCardName());
                }
            }
            if (StringUtils.isNotEmpty((CharSequence)(inHuifuId = trade.getIncomeAccountNo()))) {
                HuifuWalletAccountDto account = accountMap.get(inHuifuId);
                if (account == null) {
                    account = this.huifuWalletAccountDao.getHuifuWalletAccountByWalletNo(inHuifuId);
                    accountMap.put(inHuifuId, account);
                }
                if (account != null) {
                    huifuWalletReconciliation.setIncomeUniId(account.getUniId());
                    huifuWalletReconciliation.setIncomedBankCode(account.getBranchCode());
                    huifuWalletReconciliation.setIncomeAccountNo(inHuifuId);
                    huifuWalletReconciliation.setIncomeAccountName(account.getCardName());
                    huifuWalletReconciliation.setIncomeCerNo(account.getComCerNo());
                }
            }
            huifuWalletReconciliation.setMerchantRetain("");
            huifuWalletReconciliation.setRemark("");
            huifuWalletReconciliation.setServiceCharge(detailStr[7]);
            return huifuWalletReconciliation;
        }
        return null;
    }

    private void executeReconcile(String tradeDate, ReconcileType type, String huifuId) {
        if (StringUtils.isEmpty((CharSequence)tradeDate)) {
            throw new CrmebException("\u67e5\u8be2\u65e5\u671f\u4e0d\u80fd\u4e3a\u7a7a");
        }
        HashMap<String, Object> param = new HashMap<String, Object>();
        param.put("reqSeqId", SequenceTools.getReqSeqId32());
        param.put("fileDate", tradeDate);
        param.put("huifuId", huifuId);
        param.put("fileTypeQuery", type.getReconType());
        try {
            Map<String, Object> response = V2ApiRequest.api(HFBusiCode.ZDQUERY, param);
            String isSuf = "0";
            if (SUCCESS_CODE.equals(response.get("resp_code"))) {
                isSuf = BATCH_NO;
            }
            this.transactionLogService.save(HFBusiCode.ZDQUERY.toString(), isSuf, JSONObject.toJSONString(param), JSONObject.toJSONString(response), PaymentChannel.HUIFU.toString());
            this.processResult(tradeDate, response, type);
        }
        catch (Exception e) {
            this.transactionLogService.save("executeReconcile", "0", JSONObject.toJSONString(param), e.getMessage(), PaymentChannel.HUIFU.toString());
            logger.error(e.getMessage());
        }
    }

    private void processResult(String tradeDate, Map<String, Object> response, ReconcileType type) {
        if (SUCCESS_CODE.equals(response.get("resp_code"))) {
            if (response.get("file_details") == null) {
                return;
            }
            ArrayList recordlist = (ArrayList)JSON.parseObject((String)response.get("file_details").toString(), (TypeReference)new TypeReference<ArrayList<Map>>(){}, (Feature[])new Feature[0]);
            for (Map record : recordlist) {
                String downloadUrl = record.get("download_url").toString();
                String fileName = record.get("file_name").toString();
                String fileType = record.get("file_type").toString();
                this.dealWithEachZipFile(tradeDate, downloadUrl, fileName, type, BATCH_NO);
            }
        } else {
            logger.error(response.get("resp_desc").toString());
        }
    }

    private static Map<String, Object> genParamMap(String tradeDate) {
        HashMap<String, Object> p = new HashMap<String, Object>();
        p.put("reqSeqId", SequenceTools.getReqSeqId32());
        p.put("fileDate", tradeDate);
        return p;
    }

    private void dealWithEachZipFile(String tradeDate, String downloadUrl, String fileName, ReconcileType reconType, String batchNo) {
        String localFile;
        String downloadToFolder = this.commonConfigService.getValueByKey("payment_reconciliation_download_folder");
        if (!cn.hutool.core.io.FileUtil.exist((String)downloadToFolder)) {
            cn.hutool.core.io.FileUtil.mkdir((String)downloadToFolder);
        }
        if ((localFile = FileUtil.downloadHttpUrl((String)downloadUrl, (String)(downloadToFolder + "/"), (String)fileName)) == null) {
            logger.info("\u5bf9\u8d26ZIP\u6587\u4ef6\u4e0b\u8f7d\u9519\u8bef\uff1a{},{},{}", new Object[]{downloadUrl, downloadToFolder, fileName});
            return;
        }
        String upzipFolder = downloadToFolder + File.separator + fileName.substring(0, fileName.length() - 4);
        try {
            FileUtil.upzip((String)localFile, (String)upzipFolder);
        }
        catch (Exception e2) {
            logger.info("\u5bf9\u8d26ZIP\u6587\u4ef6\u89e3\u538b\u9519\u8bef\uff1a{},{}", (Object)localFile, (Object)upzipFolder);
            return;
        }
        File zipFile = new File(upzipFolder);
        if (!zipFile.exists()) {
            return;
        }
        File[] fi = zipFile.listFiles();
        if (fi.length == 0) {
            return;
        }
        for (File file : fi) {
            String reconciliationFile = upzipFolder + File.separator + file.getName();
            List lines = FileUtil.readCsv((String)reconciliationFile, (String)CHARSET);
            if (lines == null) {
                logger.info("\u5bf9\u8d26CSV\u6587\u4ef6\u8bfb\u53d6\u9519\u8bef\uff1a{}", (Object)reconciliationFile);
                continue;
            }
            lines.remove(0);
            if (lines.isEmpty()) {
                logger.info("\u5bf9\u8d26CSV\u5185\u5bb9\u4e3a\u7a7a\uff1a{}", (Object)reconciliationFile);
                continue;
            }
            ArrayList<HuifuWalletReconciliation> reconciliationsList = new ArrayList<HuifuWalletReconciliation>();
            for (String line : lines) {
                line = line.replace("=\"\"", "").replace("=\"", "").replace("\"", "");
                logger.info("\u5bf9\u8d26CSV\u5185\u5bb9\u884c\u6570\u636e\u4fe1\u606f\uff1a{}", (Object)line);
                HuifuWalletReconciliation huifuWalletReconciliation = null;
                if (TYPE_ORDER.equals(reconType) && file.getName().contains(reconType.getFileFix())) {
                    this.constructOrderRecon(line);
                }
                if (TYPE_SETTLE.equals(reconType) && file.getName().contains(reconType.getFileFix())) {
                    huifuWalletReconciliation = this.constructSettleRecon(line);
                }
                if (TYPE_SETTLE_USER.equals(reconType) && file.getName().contains(reconType.getFileFix())) {
                    huifuWalletReconciliation = this.constructSettleuserRecon(line);
                }
                if (TYPE_OUTCASH.equals(reconType) && file.getName().contains(reconType.getFileFix())) {
                    huifuWalletReconciliation = this.constructOutcashRecon(line);
                }
                if (TYPE_SPLIT.equals(reconType) && file.getName().contains(reconType.getFileFix())) {
                    huifuWalletReconciliation = this.constructSplitRecon(line);
                }
                if (huifuWalletReconciliation == null) continue;
                reconciliationsList.add(huifuWalletReconciliation);
            }
            if (reconciliationsList.size() <= 0) continue;
            Boolean bl = (Boolean)this.transactionTemplate.execute(e -> {
                Boolean update = Boolean.TRUE;
                try {
                    this.huifuWalletReconciliationDao.insertTempReconciliationList(reconciliationsList);
                    this.huifuWalletReconciliationDao.insertHuifuWalletReconciliation(tradeDate);
                    this.huifuWalletReconciliationDao.deleteTempWalletReconciliation();
                }
                catch (Exception exception) {
                    logger.error(exception.getMessage());
                    logger.error("\u4f01\u4e1a\u94b1\u5305-\u5bf9\u5e10\u6570\u636e-\u63d2\u5165\u5931\u8d25\uff0c\u5bf9\u8d26\u65e5\u671f = {}", (Object)tradeDate);
                    update = false;
                }
                return update;
            });
        }
        accountMap = Maps.newHashMap();
    }

    private HuifuWalletReconciliation constructSplitRecon(String line) {
        if (StringUtil.isNotEmpty((String)line)) {
            String inHuifuId;
            String[] detailStr = line.split(",");
            HuifuWalletReconciliation huifuWalletReconciliation = new HuifuWalletReconciliation();
            huifuWalletReconciliation.setTradeSerialNo(detailStr[3]);
            huifuWalletReconciliation.setMerchantNo(detailStr[1]);
            huifuWalletReconciliation.setRequestSerialNo(detailStr[15]);
            huifuWalletReconciliation.setTradeAmount(StringUtils.isEmpty((CharSequence)detailStr[9]) ? BigDecimal.ZERO : new BigDecimal(detailStr[9]));
            huifuWalletReconciliation.setTradeStatus(detailStr[11]);
            huifuWalletReconciliation.setBankTradeType(detailStr[12]);
            huifuWalletReconciliation.setTradeStartTime(detailStr[6]);
            huifuWalletReconciliation.setTradeEndTime(detailStr[13]);
            String outHuifuId = detailStr[17];
            if (StringUtils.isNotEmpty((CharSequence)outHuifuId)) {
                HuifuWalletAccountDto account = accountMap.get(outHuifuId);
                if (account == null) {
                    account = this.huifuWalletAccountDao.getHuifuWalletAccountByWalletNo(outHuifuId);
                    accountMap.put(outHuifuId, account);
                }
                if (account != null) {
                    huifuWalletReconciliation.setExpendUniId(account.getUniId());
                    huifuWalletReconciliation.setExpendBankCode(account.getBranchCode());
                    huifuWalletReconciliation.setExpendAccountNo(outHuifuId);
                    huifuWalletReconciliation.setExpendAccountName(account.getCardName());
                }
            }
            if (StringUtils.isNotEmpty((CharSequence)(inHuifuId = detailStr[8]))) {
                HuifuWalletAccountDto account = accountMap.get(inHuifuId);
                if (account == null) {
                    account = this.huifuWalletAccountDao.getHuifuWalletAccountByWalletNo(inHuifuId);
                    accountMap.put(inHuifuId, account);
                }
                if (account != null) {
                    huifuWalletReconciliation.setIncomeUniId(account.getUniId());
                    huifuWalletReconciliation.setIncomedBankCode(account.getBranchCode());
                    huifuWalletReconciliation.setIncomeAccountNo(inHuifuId);
                    huifuWalletReconciliation.setIncomeAccountName(account.getCardName());
                    huifuWalletReconciliation.setIncomeCerNo(account.getComCerNo());
                }
            }
            huifuWalletReconciliation.setMerchantRetain("");
            huifuWalletReconciliation.setRemark("");
            huifuWalletReconciliation.setServiceCharge(detailStr[10]);
            return huifuWalletReconciliation;
        }
        return null;
    }

    private HuifuWalletReconciliation constructOutcashRecon(String line) {
        if (StringUtil.isNotEmpty((String)line)) {
            String accountNo;
            String[] detailStr = line.split(",");
            HuifuWalletReconciliation huifuWalletReconciliation = new HuifuWalletReconciliation();
            huifuWalletReconciliation.setTradeSerialNo(detailStr[4]);
            huifuWalletReconciliation.setMerchantNo(detailStr[2]);
            huifuWalletReconciliation.setRequestSerialNo(detailStr[10]);
            huifuWalletReconciliation.setTradeAmount(StringUtils.isEmpty((CharSequence)detailStr[6]) ? BigDecimal.ZERO : new BigDecimal(detailStr[6]));
            huifuWalletReconciliation.setTradeStatus(detailStr[8]);
            huifuWalletReconciliation.setBankTradeType("ENCHASHMENT".equals(detailStr[5]) ? "\u63d0\u73b0" : detailStr[5]);
            huifuWalletReconciliation.setTradeStartTime(detailStr[11]);
            huifuWalletReconciliation.setTradeEndTime(detailStr[16]);
            String outHuifuId = detailStr[2];
            if (StringUtils.isNotEmpty((CharSequence)outHuifuId)) {
                HuifuWalletAccountDto account = accountMap.get(outHuifuId);
                if (account == null) {
                    account = this.huifuWalletAccountDao.getHuifuWalletAccountByWalletNo(outHuifuId);
                    accountMap.put(outHuifuId, account);
                }
                if (account != null) {
                    huifuWalletReconciliation.setExpendUniId(account.getUniId());
                    huifuWalletReconciliation.setExpendBankCode(account.getBranchCode());
                    huifuWalletReconciliation.setExpendAccountNo(outHuifuId);
                    huifuWalletReconciliation.setExpendAccountName(account.getCardName());
                }
            }
            if (StringUtils.isNotEmpty((CharSequence)(accountNo = detailStr[13]))) {
                if (accountNo.contains("***")) {
                    HuifuWalletBusiDto busiDto = this.huifuWalletBusiDao.getHuifuWalletBusiByWalletNo(huifuWalletReconciliation.getExpendAccountNo());
                    if (busiDto != null) {
                        huifuWalletReconciliation.setIncomeUniId(huifuWalletReconciliation.getExpendUniId());
                        huifuWalletReconciliation.setIncomedBankCode(busiDto.getBranchCode());
                        huifuWalletReconciliation.setIncomeAccountNo(accountNo);
                        huifuWalletReconciliation.setIncomeAccountName(busiDto.getCardName());
                    }
                } else {
                    HuifuWalletAccountDto account = accountMap.get(accountNo);
                    if (account == null) {
                        account = this.huifuWalletAccountDao.getHuifuWalletAccountByAccountNo(accountNo, PaymentChannel.HUIFU.toString());
                        accountMap.put(accountNo, account);
                    }
                    if (account != null) {
                        huifuWalletReconciliation.setIncomeUniId(account.getUniId());
                        huifuWalletReconciliation.setIncomedBankCode(account.getBranchCode());
                        huifuWalletReconciliation.setIncomeAccountNo(detailStr[13]);
                        huifuWalletReconciliation.setIncomeAccountName(detailStr[14]);
                        huifuWalletReconciliation.setIncomeCerNo(account.getComCerNo());
                    }
                }
            }
            huifuWalletReconciliation.setMerchantRetain("");
            huifuWalletReconciliation.setRemark("");
            huifuWalletReconciliation.setServiceCharge(detailStr[7]);
            return huifuWalletReconciliation;
        }
        return null;
    }

    private HuifuWalletReconciliation constructSettleRecon(String line) {
        if (line != null || null == line) {
            return null;
        }
        if (StringUtil.isNotEmpty((String)line)) {
            String inHuifuId;
            String[] detailStr = line.split(",");
            HuifuWalletReconciliation huifuWalletReconciliation = new HuifuWalletReconciliation();
            huifuWalletReconciliation.setTradeSerialNo("");
            huifuWalletReconciliation.setMerchantNo(detailStr[2]);
            huifuWalletReconciliation.setRequestSerialNo("");
            huifuWalletReconciliation.setTradeAmount(StringUtils.isEmpty((CharSequence)detailStr[10]) ? BigDecimal.ZERO : new BigDecimal(detailStr[10]));
            huifuWalletReconciliation.setTradeStatus(detailStr[9]);
            huifuWalletReconciliation.setBankTradeType(detailStr[4]);
            huifuWalletReconciliation.setTradeStartTime(detailStr[5]);
            huifuWalletReconciliation.setTradeEndTime(detailStr[5]);
            String outHuifuId = detailStr[2];
            if (StringUtils.isNotEmpty((CharSequence)outHuifuId)) {
                HuifuWalletAccountDto account = accountMap.get(outHuifuId);
                if (account == null) {
                    account = this.huifuWalletAccountDao.getHuifuWalletAccountByWalletNo(outHuifuId);
                    accountMap.put(outHuifuId, account);
                }
                if (account != null) {
                    huifuWalletReconciliation.setExpendUniId(account.getUniId());
                    huifuWalletReconciliation.setExpendBankCode(account.getBranchCode());
                    huifuWalletReconciliation.setExpendAccountNo(outHuifuId);
                    huifuWalletReconciliation.setExpendAccountName(account.getCardName());
                }
            }
            if (StringUtils.isNotEmpty((CharSequence)(inHuifuId = detailStr[6]))) {
                HuifuWalletAccountDto account = accountMap.get(inHuifuId);
                if (account == null) {
                    account = this.huifuWalletAccountDao.getHuifuWalletAccountByWalletNo(inHuifuId);
                    accountMap.put(inHuifuId, account);
                }
                if (account != null) {
                    huifuWalletReconciliation.setIncomeUniId(account.getUniId());
                    huifuWalletReconciliation.setIncomedBankCode(account.getBranchCode());
                    huifuWalletReconciliation.setIncomeAccountNo(inHuifuId);
                    huifuWalletReconciliation.setIncomeAccountName(account.getCardName());
                    huifuWalletReconciliation.setIncomeCerNo(account.getComCerNo());
                }
            }
            huifuWalletReconciliation.setMerchantRetain("");
            huifuWalletReconciliation.setRemark("");
            huifuWalletReconciliation.setServiceCharge(detailStr[11]);
            return huifuWalletReconciliation;
        }
        return null;
    }

    private HuifuWalletReconciliation constructSettleuserRecon(String line) {
        if (line != null || null == line) {
            return null;
        }
        if (StringUtil.isNotEmpty((String)line)) {
            String inHuifuId;
            String[] detailStr = line.split(",");
            HuifuWalletReconciliation huifuWalletReconciliation = new HuifuWalletReconciliation();
            huifuWalletReconciliation.setTradeSerialNo("");
            huifuWalletReconciliation.setMerchantNo(detailStr[2]);
            huifuWalletReconciliation.setRequestSerialNo("");
            huifuWalletReconciliation.setTradeAmount(StringUtils.isEmpty((CharSequence)detailStr[12]) ? BigDecimal.ZERO : new BigDecimal(detailStr[12]));
            huifuWalletReconciliation.setTradeStatus(detailStr[11]);
            huifuWalletReconciliation.setBankTradeType(detailStr[6]);
            huifuWalletReconciliation.setTradeStartTime(detailStr[7]);
            huifuWalletReconciliation.setTradeEndTime(detailStr[7]);
            String outHuifuId = detailStr[2];
            if (StringUtils.isNotEmpty((CharSequence)outHuifuId)) {
                HuifuWalletAccountDto account = accountMap.get(outHuifuId);
                if (account == null) {
                    account = this.huifuWalletAccountDao.getHuifuWalletAccountByWalletNo(outHuifuId);
                    accountMap.put(outHuifuId, account);
                }
                if (account != null) {
                    huifuWalletReconciliation.setExpendUniId(account.getUniId());
                    huifuWalletReconciliation.setExpendBankCode(account.getBranchCode());
                    huifuWalletReconciliation.setExpendAccountNo(outHuifuId);
                    huifuWalletReconciliation.setExpendAccountName(account.getCardName());
                }
            }
            if (StringUtils.isNotEmpty((CharSequence)(inHuifuId = detailStr[8]))) {
                HuifuWalletAccountDto account = accountMap.get(inHuifuId);
                if (account == null) {
                    account = this.huifuWalletAccountDao.getHuifuWalletAccountByAccountNo(inHuifuId, PaymentChannel.HUIFU.toString());
                    accountMap.put(inHuifuId, account);
                }
                if (account != null) {
                    huifuWalletReconciliation.setIncomeUniId(account.getUniId());
                    huifuWalletReconciliation.setIncomedBankCode(account.getBranchCode());
                    huifuWalletReconciliation.setIncomeAccountNo(inHuifuId);
                    huifuWalletReconciliation.setIncomeAccountName(account.getCardName());
                    huifuWalletReconciliation.setIncomeCerNo(account.getComCerNo());
                }
            }
            huifuWalletReconciliation.setMerchantRetain("");
            huifuWalletReconciliation.setRemark("");
            huifuWalletReconciliation.setServiceCharge(detailStr[13]);
            return huifuWalletReconciliation;
        }
        return null;
    }

    private HuifuWalletReconciliation constructOrderRecon(String line) {
        if (StringUtil.isNotEmpty((String)line)) {
            String[] detailStr = line.split(",");
            HuifuWalletTrade huifuWalletTrade = this.huifuWalletTradeDao.getHuifuWalletTradeByHfSeqId(detailStr[5]);
            HuifuWalletReconciliation huifuWalletReconciliation = new HuifuWalletReconciliation();
            huifuWalletReconciliation.setTradeSerialNo(detailStr[5]);
            huifuWalletReconciliation.setMerchantNo(detailStr[1]);
            huifuWalletReconciliation.setRequestSerialNo(detailStr[6]);
            huifuWalletReconciliation.setTradeAmount(StringUtils.isEmpty((CharSequence)detailStr[9]) ? BigDecimal.ZERO : new BigDecimal(detailStr[9]));
            huifuWalletReconciliation.setTradeStatus(detailStr[12]);
            huifuWalletReconciliation.setBankTradeType(detailStr[7]);
            huifuWalletReconciliation.setTradeStartTime(detailStr[37]);
            huifuWalletReconciliation.setTradeEndTime(detailStr[30]);
            String outHuifuId = huifuWalletTrade.getExpendAccountNo();
            if (StringUtils.isNotEmpty((CharSequence)outHuifuId)) {
                HuifuWalletAccountDto account = accountMap.get(outHuifuId);
                if (account == null) {
                    account = this.huifuWalletAccountDao.getHuifuWalletAccountByWalletNo(outHuifuId);
                    accountMap.put(outHuifuId, account);
                }
                if (account != null) {
                    huifuWalletReconciliation.setExpendUniId(account.getUniId());
                    huifuWalletReconciliation.setExpendBankCode(account.getBranchCode());
                    huifuWalletReconciliation.setExpendAccountNo(outHuifuId);
                    huifuWalletReconciliation.setExpendAccountName(account.getCardName());
                }
            }
            String inHuifuId = huifuWalletTrade.getIncomeAccountNo();
            String incomedBankCode = "";
            if (StringUtils.isNotEmpty((CharSequence)inHuifuId)) {
                HuifuWalletAccountDto account = accountMap.get(inHuifuId);
                if (account == null) {
                    account = this.huifuWalletAccountDao.getHuifuWalletAccountByWalletNo(inHuifuId);
                    accountMap.put(inHuifuId, account);
                }
                if (account != null) {
                    incomedBankCode = account.getBankCode();
                    huifuWalletReconciliation.setIncomeUniId(account.getUniId());
                    huifuWalletReconciliation.setIncomedBankCode(account.getBranchCode());
                    huifuWalletReconciliation.setIncomeAccountNo(inHuifuId);
                    huifuWalletReconciliation.setIncomeAccountName(account.getCardName());
                    huifuWalletReconciliation.setIncomeCerNo(account.getComCerNo());
                }
            }
            huifuWalletReconciliation.setMerchantRetain(detailStr[34]);
            huifuWalletReconciliation.setRemark(detailStr[39]);
            huifuWalletReconciliation.setServiceCharge(detailStr[10]);
            if ("01".equals(huifuWalletTrade.getTradeType()) && this.huifuWalletTranslogDao.findSizeByTransId(huifuWalletReconciliation.getTradeSerialNo()) < 1) {
                HuifuWalletTranslog translog = new HuifuWalletTranslog();
                translog.setUniId(huifuWalletTrade.getUniId());
                translog.setCreateTime(new Date());
                translog.setTransId(huifuWalletReconciliation.getTradeSerialNo());
                translog.setTransDate(huifuWalletReconciliation.getRequestSerialNo());
                translog.setTransAmt(huifuWalletReconciliation.getTradeAmount().toString());
                translog.setTransStat(huifuWalletReconciliation.getTradeStatus());
                translog.setCardNo(huifuWalletReconciliation.getIncomeCerNo());
                translog.setCardName(huifuWalletReconciliation.getIncomeAccountName());
                translog.setBankCode(incomedBankCode);
                translog.setFeeAmt(huifuWalletReconciliation.getServiceCharge());
                translog.setRemark(huifuWalletReconciliation.getRemark());
                translog.setTransType(huifuWalletReconciliation.getBankTradeType());
                this.huifuWalletTranslogDao.insert(translog);
            }
            return huifuWalletReconciliation;
        }
        return null;
    }

    private static String RET(Map<String, Object> response, int type) {
        if (type == 1) {
            return response.get("resp_code").toString();
        }
        return response.get("resp_desc").toString();
    }
}

