/*
 * Decompiled with CFR 0.152.
 */
package com.zbkj.service.service.impl;

import cn.hutool.core.collection.CollUtil;
import cn.hutool.core.util.ObjectUtil;
import cn.hutool.core.util.StrUtil;
import cn.hutool.core.util.URLUtil;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.baomidou.mybatisplus.core.toolkit.support.SFunction;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.github.pagehelper.Page;
import com.github.pagehelper.PageHelper;
import com.github.pagehelper.PageInfo;
import com.zbkj.common.constants.CommunityConstants;
import com.zbkj.common.constants.Constants;
import com.zbkj.common.exception.CrmebException;
import com.zbkj.common.model.community.CommunityNotes;
import com.zbkj.common.model.community.CommunityTopic;
import com.zbkj.common.page.CommonPage;
import com.zbkj.common.request.CommonSearchRequest;
import com.zbkj.common.request.CommunityTopicSaveRequest;
import com.zbkj.common.request.CommunityTopicSearchRequest;
import com.zbkj.common.result.CommonResultCode;
import com.zbkj.common.result.CommunityResultCode;
import com.zbkj.common.result.IResultEnum;
import com.zbkj.common.utils.CrmebUtil;
import com.zbkj.service.dao.community.CommunityTopicDao;
import com.zbkj.service.service.CommunityNotesService;
import com.zbkj.service.service.CommunityTopicService;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.support.TransactionTemplate;

@Service
public class CommunityTopicServiceImpl
extends ServiceImpl<CommunityTopicDao, CommunityTopic>
implements CommunityTopicService {
    @Resource
    private CommunityTopicDao dao;
    @Autowired
    private TransactionTemplate transactionTemplate;
    @Autowired
    private CommunityNotesService notesService;

    @Override
    public PageInfo<CommunityTopic> findPageList(CommunityTopicSearchRequest request) {
        Page page = PageHelper.startPage((int)request.getPage(), (int)request.getLimit());
        LambdaQueryWrapper lqw = Wrappers.lambdaQuery();
        lqw.select(new SFunction[]{CommunityTopic::getId, CommunityTopic::getName, CommunityTopic::getIsHot, CommunityTopic::getCreateTime, CommunityTopic::getCountUse});
        if (StrUtil.isNotBlank((CharSequence)request.getName())) {
            lqw.like(CommunityTopic::getName, (Object)URLUtil.decode((String)request.getName()));
        }
        if (ObjectUtil.isNotNull((Object)request.getIsHot())) {
            lqw.eq(CommunityTopic::getIsHot, (Object)request.getIsHot());
        }
        lqw.eq(CommunityTopic::getIsDel, (Object)0);
        lqw.orderByDesc((Object[])new SFunction[]{CommunityTopic::getIsHot, CommunityTopic::getId});
        List list = this.dao.selectList((Wrapper)lqw);
        if (CollUtil.isNotEmpty((Collection)list)) {
            list.forEach(l -> l.setCountUse(this.notesService.getCountByTopic(l.getId())));
        }
        return CommonPage.copyPageInfo((Page)page, (List)list);
    }

    @Override
    public void add(CommunityTopicSaveRequest request) {
        if (this.isExistName(request.getName(), 0)) {
            throw new CrmebException((IResultEnum)CommunityResultCode.COMMUNITY_TOPIC_NAME_EXIST);
        }
        CommunityTopic topic = new CommunityTopic();
        BeanUtils.copyProperties((Object)request, (Object)topic, (String[])new String[]{"id"});
        topic.setIsHot(Integer.valueOf(0));
        boolean save = this.save(topic);
        if (!save) {
            throw new CrmebException((IResultEnum)CommonResultCode.ERROR.setMessage("\u6dfb\u52a0\u793e\u533a\u8bdd\u9898\u5931\u8d25"));
        }
    }

    @Override
    public void edit(CommunityTopicSaveRequest request) {
        if (ObjectUtil.isNull((Object)request.getId()) || request.getId() <= 0) {
            throw new CrmebException((IResultEnum)CommunityResultCode.COMMUNITY_TOPIC_ID_NULL);
        }
        CommunityTopic communityTopic = this.getByIdException(request.getId());
        if (!communityTopic.getName().equals(request.getName()) && this.isExistName(request.getName(), request.getId())) {
            throw new CrmebException((IResultEnum)CommunityResultCode.COMMUNITY_TOPIC_NAME_EXIST);
        }
        BeanUtils.copyProperties((Object)request, (Object)communityTopic);
        boolean update = this.updateById(communityTopic);
        if (!update) {
            throw new CrmebException((IResultEnum)CommonResultCode.ERROR.setMessage("\u7f16\u8f91\u793e\u533a\u8bdd\u9898\u5931\u8d25"));
        }
    }

    @Override
    public void deleteById(Integer id) {
        CommunityTopic communityTopic = this.getByIdException(id);
        communityTopic.setIsDel(Integer.valueOf(1));
        List<CommunityNotes> communityNotes = this.notesService.findAllByTopic(id);
        communityNotes.forEach(note -> note.setTopicIds(this.noteDeleteTopicId(note.getTopicIds(), id)));
        Boolean execute = (Boolean)this.transactionTemplate.execute(e -> {
            this.updateById(communityTopic);
            if (CollUtil.isNotEmpty((Collection)communityNotes)) {
                communityNotes.forEach(note -> this.notesService.updateTopicIds(note.getId(), note.getTopicIds()));
            }
            return Boolean.TRUE;
        });
        if (!execute.booleanValue()) {
            throw new CrmebException((IResultEnum)CommonResultCode.ERROR.setMessage("\u5220\u9664\u793e\u533a\u8bdd\u9898\u5931\u8d25"));
        }
    }

    @Override
    public Map<Integer, CommunityTopic> getMapInIdList(List<Integer> topicIdList) {
        HashMap map = CollUtil.newHashMap();
        if (CollUtil.isEmpty(topicIdList)) {
            return map;
        }
        List<CommunityTopic> list = this.findAllByIdList(topicIdList);
        list.forEach(e -> map.put(e.getId(), e));
        return map;
    }

    @Override
    public Map<Integer, String> getNameMapInIdList(List<Integer> topicIdList) {
        HashMap map = CollUtil.newHashMap();
        if (CollUtil.isEmpty(topicIdList)) {
            return map;
        }
        List<CommunityTopic> list = this.findAllByIdList(topicIdList);
        list.forEach(e -> map.put(e.getId(), e.getName()));
        return map;
    }

    @Override
    public List<CommunityTopic> findAllByIdList(List<Integer> topicIdList) {
        LambdaQueryWrapper lqw = Wrappers.lambdaQuery();
        lqw.select(new SFunction[]{CommunityTopic::getId, CommunityTopic::getName});
        lqw.eq(CommunityTopic::getIsDel, (Object)0);
        lqw.in(CommunityTopic::getId, topicIdList);
        return this.dao.selectList((Wrapper)lqw);
    }

    @Override
    public void recommendSwitch(Integer id) {
        CommunityTopic topic = this.getByIdException(id);
        if (topic.getIsHot().equals(0) && this.getRecommendCount() >= CommunityConstants.COMMUNITY_TOPIC_RECOMMEND_NUM) {
            throw new CrmebException((IResultEnum)CommunityResultCode.COMMUNITY_TOPIC_RECOMMEND_NUM);
        }
        topic.setIsHot(Integer.valueOf(topic.getIsHot().equals(1) ? 0 : 1));
        boolean update = this.updateById(topic);
        if (!update) {
            throw new CrmebException((IResultEnum)CommonResultCode.ERROR.setMessage("\u793e\u533a\u8bdd\u9898\u5f00\u542f/\u5173\u95ed\u63a8\u8350\u5931\u8d25"));
        }
    }

    @Override
    public List<CommunityTopic> findRecommendTopicList() {
        LambdaQueryWrapper lqw = Wrappers.lambdaQuery();
        lqw.select(new SFunction[]{CommunityTopic::getId, CommunityTopic::getName});
        lqw.eq(CommunityTopic::getIsHot, (Object)Constants.COMMON_IS_FILED_ONE);
        lqw.eq(CommunityTopic::getIsDel, (Object)Constants.COMMON_IS_FILED_ZERO);
        lqw.orderByDesc((Object[])new SFunction[]{CommunityTopic::getIsHot, CommunityTopic::getId});
        return this.dao.selectList((Wrapper)lqw);
    }

    @Override
    public PageInfo<CommunityTopic> findSearchTopicList(CommonSearchRequest request) {
        Page page = PageHelper.startPage((int)request.getPage(), (int)request.getLimit());
        LambdaQueryWrapper lqw = Wrappers.lambdaQuery();
        lqw.select(new SFunction[]{CommunityTopic::getId, CommunityTopic::getName});
        if (StrUtil.isNotBlank((CharSequence)request.getKeywords())) {
            lqw.likeRight(CommunityTopic::getName, (Object)URLUtil.decode((String)request.getKeywords()));
        }
        lqw.eq(CommunityTopic::getIsDel, (Object)Constants.COMMON_IS_FILED_ZERO);
        lqw.orderByDesc(CommunityTopic::getId);
        List list = this.dao.selectList((Wrapper)lqw);
        return CommonPage.copyPageInfo((Page)page, (List)list);
    }

    private Integer getRecommendCount() {
        LambdaQueryWrapper lqw = Wrappers.lambdaQuery();
        lqw.eq(CommunityTopic::getIsDel, (Object)0);
        lqw.eq(CommunityTopic::getIsHot, (Object)1);
        return this.dao.selectCount((Wrapper)lqw);
    }

    private String noteDeleteTopicId(String topicIds, Integer delId) {
        List tidList = CrmebUtil.stringToArray((String)topicIds);
        for (int i = 0; i < tidList.size(); ++i) {
            if (!((Integer)tidList.get(i)).equals(delId)) continue;
            tidList.remove(i);
            break;
        }
        if (CollUtil.isEmpty((Collection)tidList)) {
            return "";
        }
        if (tidList.size() == 1) {
            return ((Integer)tidList.get(0)).toString();
        }
        return tidList.stream().map(String::valueOf).collect(Collectors.joining(","));
    }

    private CommunityTopic getByIdException(Integer id) {
        CommunityTopic topic = (CommunityTopic)this.getById(id);
        if (ObjectUtil.isNull((Object)topic) || topic.getIsDel().equals(1)) {
            throw new CrmebException((IResultEnum)CommunityResultCode.COMMUNITY_TOPIC_NOT_EXIST);
        }
        return topic;
    }

    private boolean isExistName(String name, Integer id) {
        LambdaQueryWrapper lqw = Wrappers.lambdaQuery();
        lqw.select(new SFunction[]{CommunityTopic::getId});
        lqw.eq(CommunityTopic::getName, (Object)name);
        lqw.eq(CommunityTopic::getIsDel, (Object)0);
        if (ObjectUtil.isNotNull((Object)id) && id > 0) {
            lqw.ne(CommunityTopic::getId, (Object)id);
        }
        lqw.last(" limit 1");
        CommunityTopic communityTopic = (CommunityTopic)this.dao.selectOne((Wrapper)lqw);
        return ObjectUtil.isNotNull((Object)communityTopic);
    }
}

