/*
 * Decompiled with CFR 0.152.
 */
package com.zbkj.service.service.impl;

import cn.hutool.core.util.ObjectUtil;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.update.LambdaUpdateWrapper;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.zbkj.common.model.community.CommunityNotesProduct;
import com.zbkj.common.model.product.Product;
import com.zbkj.service.dao.community.CommunityNotesProductDao;
import com.zbkj.service.service.CommunityNotesProductService;
import com.zbkj.service.service.ProductService;
import java.util.List;
import javax.annotation.Resource;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class CommunityNotesProductServiceImpl
extends ServiceImpl<CommunityNotesProductDao, CommunityNotesProduct>
implements CommunityNotesProductService {
    @Resource
    private CommunityNotesProductDao dao;
    @Autowired
    private ProductService productService;

    @Override
    public List<CommunityNotesProduct> findListByNoteId(Integer noteId) {
        LambdaQueryWrapper lqw = Wrappers.lambdaQuery();
        lqw.eq(CommunityNotesProduct::getNoteId, (Object)noteId);
        List list = this.dao.selectList((Wrapper)lqw);
        list.forEach(np -> {
            Product product = (Product)this.productService.getById(np.getProductId());
            if (ObjectUtil.isNotNull((Object)product)) {
                np.setProductName(product.getName());
                np.setProductImage(product.getImage());
                np.setPrice(product.getPrice());
                np.setOtPrice(product.getOtPrice());
            }
        });
        return list;
    }

    @Override
    public void deleteByNoteId(Integer noteId) {
        LambdaUpdateWrapper wrapper = Wrappers.lambdaUpdate();
        wrapper.eq(CommunityNotesProduct::getNoteId, (Object)noteId);
        this.dao.delete((Wrapper)wrapper);
    }
}

