/*
 * Decompiled with CFR 0.152.
 */
package com.zbkj.service.service.bcx;

import cn.hutool.core.collection.CollUtil;
import cn.hutool.core.util.ObjectUtil;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.github.pagehelper.Page;
import com.github.pagehelper.PageHelper;
import com.github.pagehelper.PageInfo;
import com.zbkj.common.exception.CrmebException;
import com.zbkj.common.model.bcx.BcxPlatformFeeConfig;
import com.zbkj.common.page.CommonPage;
import com.zbkj.common.request.PageParamRequest;
import com.zbkj.common.request.bcx.BcxPlatformFeeConfigRequest;
import com.zbkj.service.dao.bcx.BcxPlatformFeeConfigDao;
import com.zbkj.service.service.bcx.BcxPlatformFeeConfigService;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javax.annotation.Resource;
import org.springframework.beans.BeanUtils;
import org.springframework.stereotype.Service;

@Service
public class BcxPlatformFeeConfigServiceImpl
extends ServiceImpl<BcxPlatformFeeConfigDao, BcxPlatformFeeConfig>
implements BcxPlatformFeeConfigService {
    @Resource
    private BcxPlatformFeeConfigDao dao;

    @Override
    public BcxPlatformFeeConfig queryById(Integer id) {
        return (BcxPlatformFeeConfig)this.dao.selectById(id);
    }

    @Override
    public BcxPlatformFeeConfig queryByProductId(Integer productId) {
        LambdaQueryWrapper lqw = new LambdaQueryWrapper();
        lqw.eq(BcxPlatformFeeConfig::getProductId, (Object)productId);
        lqw.eq(BcxPlatformFeeConfig::getLevel, (Object)3);
        lqw.orderByDesc(BcxPlatformFeeConfig::getUpdateTime);
        lqw.last("limit 1");
        return (BcxPlatformFeeConfig)this.dao.selectOne((Wrapper)lqw);
    }

    @Override
    public BcxPlatformFeeConfig queryBySkuId(Integer skuId) {
        LambdaQueryWrapper lqw = new LambdaQueryWrapper();
        lqw.eq(BcxPlatformFeeConfig::getSkuId, (Object)skuId);
        lqw.eq(BcxPlatformFeeConfig::getLevel, (Object)4);
        lqw.orderByDesc(BcxPlatformFeeConfig::getUpdateTime);
        lqw.last("limit 1");
        return (BcxPlatformFeeConfig)this.dao.selectOne((Wrapper)lqw);
    }

    @Override
    public BcxPlatformFeeConfig queryByMerId(Integer merId) {
        LambdaQueryWrapper lqw = new LambdaQueryWrapper();
        lqw.eq(BcxPlatformFeeConfig::getMerId, (Object)merId);
        lqw.eq(BcxPlatformFeeConfig::getLevel, (Object)1);
        lqw.orderByDesc(BcxPlatformFeeConfig::getUpdateTime);
        lqw.last("limit 1");
        return (BcxPlatformFeeConfig)this.dao.selectOne((Wrapper)lqw);
    }

    @Override
    public BcxPlatformFeeConfig queryByAnyId(Integer merId, Integer productId, Integer skuId) {
        BcxPlatformFeeConfig config;
        if (skuId > 0 && (config = this.queryBySkuId(skuId)) != null) {
            return config;
        }
        if (productId > 0 && (config = this.queryByProductId(productId)) != null) {
            return config;
        }
        if (merId > 0) {
            return this.queryByMerId(merId);
        }
        return null;
    }

    @Override
    public PageInfo<BcxPlatformFeeConfig> queryPagedList(BcxPlatformFeeConfig request, PageParamRequest pageParamRequest) {
        LambdaQueryWrapper lqw = new LambdaQueryWrapper();
        lqw.eq(BcxPlatformFeeConfig::getId, (Object)request.getId());
        Page page = PageHelper.startPage((int)pageParamRequest.getPage(), (int)pageParamRequest.getLimit());
        List sources = this.dao.selectList((Wrapper)lqw);
        if (CollUtil.isEmpty((Collection)sources)) {
            return CommonPage.copyPageInfo((Page)page, (List)CollUtil.newArrayList((Object[])new BcxPlatformFeeConfig[0]));
        }
        List<BcxPlatformFeeConfig> result = this.transform2target(sources);
        return CommonPage.copyPageInfo((Page)page, result);
    }

    private List<BcxPlatformFeeConfig> transform2target(List<BcxPlatformFeeConfig> sources) {
        ArrayList<BcxPlatformFeeConfig> result = new ArrayList<BcxPlatformFeeConfig>();
        for (BcxPlatformFeeConfig source : sources) {
            BcxPlatformFeeConfig target = new BcxPlatformFeeConfig();
            BeanUtils.copyProperties((Object)source, (Object)target);
            result.add(target);
        }
        return result;
    }

    @Override
    public Boolean create(BcxPlatformFeeConfigRequest request) {
        if (ObjectUtil.isNull((Object)request.getProductId())) {
            throw new CrmebException("\u5546\u54c1id\u4e0d\u80fd\u4e3a\u7a7a");
        }
        BcxPlatformFeeConfig exists = this.queryByProductId(request.getProductId());
        BcxPlatformFeeConfig config = new BcxPlatformFeeConfig();
        BeanUtils.copyProperties((Object)request, (Object)config);
        config.setId(exists != null ? exists.getId() : null);
        config.setLevel(Integer.valueOf(3));
        return this.saveOrUpdate(config);
    }

    @Override
    public Boolean update(BcxPlatformFeeConfigRequest request) {
        if (ObjectUtil.isNull((Object)request.getId())) {
            throw new CrmebException("id\u4e0d\u80fd\u4e3a\u7a7a");
        }
        BcxPlatformFeeConfig config = this.queryById(request.getId());
        if (ObjectUtil.isNull((Object)config)) {
            throw new CrmebException("\u672a\u627e\u5230\u8be5\u914d\u7f6e" + request.getId());
        }
        BeanUtils.copyProperties((Object)request, (Object)config);
        config.setLevel(Integer.valueOf(3));
        return this.updateById(config);
    }

    @Override
    public Boolean delete(Integer id) {
        return this.removeById(id);
    }

    @Override
    public BigDecimal calcSellPlatformFee(BcxPlatformFeeConfig config, BigDecimal payPrice, Integer payNum) {
        if (config.getSellFeeType() == 0) {
            return payPrice.multiply(config.getSellFee());
        }
        if (config.getSellFeeType() == 1) {
            return config.getSellFee().multiply(BigDecimal.valueOf(payNum.intValue()));
        }
        this.log.error("\u672a\u77e5\u7684\u9500\u552e\u5e73\u53f0\u670d\u52a1\u8d39\u7c7b\u578b\uff1a" + config.getSellFeeType());
        throw new CrmebException("\u672a\u77e5\u7684\u9500\u552e\u5e73\u53f0\u670d\u52a1\u8d39\u7c7b\u578b");
    }

    @Override
    public BigDecimal calcLeasePlatformFee(BcxPlatformFeeConfig config, BigDecimal payPrice, Integer payNum) {
        if (config.getLeaseFeeType() == 0) {
            return payPrice.multiply(config.getLeaseFee());
        }
        if (config.getLeaseFeeType() == 1) {
            return config.getLeaseFee().multiply(BigDecimal.valueOf(payNum.intValue()));
        }
        this.log.error("\u672a\u77e5\u7684\u79df\u8d41\u5e73\u53f0\u670d\u52a1\u8d39\u7c7b\u578b\uff1a" + config.getLeaseFeeType());
        throw new CrmebException("\u672a\u77e5\u7684\u79df\u8d41\u5e73\u53f0\u670d\u52a1\u8d39\u7c7b\u578b");
    }

    @Override
    public BigDecimal calcInstalmentPlatformFee(BcxPlatformFeeConfig config, BigDecimal payPrice, Integer payNum, Integer period) {
        BigDecimal fee;
        switch (period) {
            case 3: {
                fee = config.getPeriod3Fee();
                break;
            }
            case 6: {
                fee = config.getPeriod6Fee();
                break;
            }
            case 9: {
                fee = config.getPeriod9Fee();
                break;
            }
            case 12: {
                fee = config.getPeriod12Fee();
                break;
            }
            default: {
                this.log.error("\u672a\u77e5\u7684\u5206\u671f\u6570\u7c7b\u578b\uff1a" + period);
                throw new CrmebException("\u672a\u77e5\u7684\u5206\u671f\u670d\u52a1\u8d39\u7c7b\u578b");
            }
        }
        if (config.getInstalmentFeeType() == 0) {
            return payPrice.multiply(fee);
        }
        if (config.getInstalmentFeeType() == 1) {
            return fee.multiply(BigDecimal.valueOf(payNum.intValue()));
        }
        this.log.error("\u672a\u77e5\u7684\u5206\u671f\u670d\u52a1\u8d39\u7c7b\u578b\uff1a" + config.getInstalmentFeeType());
        throw new CrmebException("\u672a\u77e5\u7684\u5206\u671f\u670d\u52a1\u8d39\u7c7b\u578b");
    }

    @Override
    public BigDecimal calcPlatformFee(BcxPlatformFeeConfig platFeeConfig, Integer specType, BigDecimal payPrice, Integer payNum, Integer instalmentPeriod) {
        BigDecimal platformFee;
        if (specType.equals(2)) {
            platformFee = this.calcLeasePlatformFee(platFeeConfig, payPrice, payNum);
        } else if (specType.equals(3)) {
            platformFee = this.calcInstalmentPlatformFee(platFeeConfig, payPrice, payNum, instalmentPeriod);
        } else if (specType.equals(0)) {
            platformFee = this.calcSellPlatformFee(platFeeConfig, payPrice, payNum);
        } else {
            throw new CrmebException("\u672a\u77e5\u7684\u8ba2\u5355\u4e1a\u52a1\u7c7b\u578b\uff1a" + specType);
        }
        return platformFee;
    }

    @Override
    public Integer calcPlatformFeePriority(BcxPlatformFeeConfig platFeeConfig, Integer specType) {
        if (specType.equals(2)) {
            return platFeeConfig.getLeaseFeePriority();
        }
        if (specType.equals(3)) {
            return platFeeConfig.getInstalmentFeePriority();
        }
        if (specType.equals(0)) {
            return platFeeConfig.getSellFeePriority();
        }
        throw new CrmebException("\u672a\u77e5\u7684\u8ba2\u5355\u4e1a\u52a1\u7c7b\u578b" + specType);
    }
}

