/*
 * Decompiled with CFR 0.152.
 */
package com.zbkj.service.service.bcx;

import cn.hutool.core.collection.CollUtil;
import cn.hutool.core.date.DateUtil;
import cn.hutool.core.util.StrUtil;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.extension.conditions.query.QueryChainWrapper;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.github.pagehelper.Page;
import com.github.pagehelper.PageHelper;
import com.github.pagehelper.PageInfo;
import com.zbkj.common.exception.CrmebException;
import com.zbkj.common.model.bcx.BcxOrderFapiao;
import com.zbkj.common.model.order.Order;
import com.zbkj.common.model.order.OrderDetail;
import com.zbkj.common.model.user.User;
import com.zbkj.common.page.CommonPage;
import com.zbkj.common.request.PageParamRequest;
import com.zbkj.common.request.bcx.BcxFapiaoTitleRequest;
import com.zbkj.common.request.bcx.BcxOrderFapiaoQueryRequest;
import com.zbkj.common.request.bcx.BcxOrderFapiaoRequest;
import com.zbkj.common.request.bcx.BcxWriteFapiaoRequest;
import com.zbkj.common.response.bcx.BcxOrderFapiaoResponse;
import com.zbkj.common.utils.CrmebUtil;
import com.zbkj.service.dao.bcx.BcxOrderFapiaoDao;
import com.zbkj.service.service.OrderDetailService;
import com.zbkj.service.service.OrderService;
import com.zbkj.service.service.ProductService;
import com.zbkj.service.service.UserService;
import com.zbkj.service.service.bcx.BcxOrderFapiaoService;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import javax.validation.Validator;
import org.springframework.beans.BeanUtils;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.transaction.support.TransactionTemplate;

@Service
public class BcxOrderFapiaoServiceImpl
extends ServiceImpl<BcxOrderFapiaoDao, BcxOrderFapiao>
implements BcxOrderFapiaoService {
    @Resource
    private BcxOrderFapiaoDao dao;
    @Resource
    private UserService userService;
    @Resource
    private OrderService orderService;
    @Resource
    private OrderDetailService orderDetailService;
    @Resource
    private Validator validator;
    @Resource
    private TransactionTemplate transactionTemplate;
    @Resource
    private ProductService productService;

    @Override
    public BcxOrderFapiaoResponse queryById(Integer id) {
        BcxOrderFapiao fapiao = this.getFapiaoById(id);
        BcxOrderFapiaoResponse response = new BcxOrderFapiaoResponse();
        BeanUtils.copyProperties((Object)fapiao, (Object)response);
        return response;
    }

    public BcxOrderFapiao getFapiaoById(Integer id) {
        BcxOrderFapiao fapiao;
        Integer userId = this.userService.getUserIdException();
        if (!userId.equals((fapiao = (BcxOrderFapiao)this.dao.selectById(id)).getUid())) {
            throw new CrmebException("\u627e\u4e0d\u5230\u53d1\u7968");
        }
        return fapiao;
    }

    @Override
    public PageInfo<BcxOrderFapiaoResponse> queryPagedList(String orderNo, PageParamRequest pageParamRequest) {
        Integer userId = this.userService.getUserIdException();
        LambdaQueryWrapper lqw = new LambdaQueryWrapper();
        lqw.eq(BcxOrderFapiao::getUid, (Object)userId);
        lqw.orderByDesc(BcxOrderFapiao::getId);
        if (StrUtil.isNotBlank((CharSequence)orderNo)) {
            lqw.apply(" FIND_IN_SET ('" + orderNo + "',order_no)", new Object[0]);
        }
        Page page = PageHelper.startPage((int)pageParamRequest.getPage(), (int)pageParamRequest.getLimit());
        List sources = this.dao.selectList((Wrapper)lqw);
        if (CollUtil.isEmpty((Collection)sources)) {
            return CommonPage.copyPageInfo((Page)page, (List)CollUtil.newArrayList((Object[])new BcxOrderFapiaoResponse[0]));
        }
        List<BcxOrderFapiaoResponse> result = this.transform2target(sources);
        return CommonPage.copyPageInfo((Page)page, result);
    }

    @Override
    public PageInfo<BcxOrderFapiaoResponse> queryMerchantFapiaoPagedList(Integer merId, BcxOrderFapiaoQueryRequest request, PageParamRequest pageParamRequest) {
        LambdaQueryWrapper lqw = new LambdaQueryWrapper();
        lqw.eq(BcxOrderFapiao::getMerId, (Object)merId);
        return this.queryFapiaoList(request, pageParamRequest, (LambdaQueryWrapper<BcxOrderFapiao>)lqw);
    }

    @Override
    public PageInfo<BcxOrderFapiaoResponse> queryPlatformFapiaoPagedList(BcxOrderFapiaoQueryRequest request, PageParamRequest pageParamRequest) {
        LambdaQueryWrapper lqw = new LambdaQueryWrapper();
        return this.queryFapiaoList(request, pageParamRequest, (LambdaQueryWrapper<BcxOrderFapiao>)lqw);
    }

    private PageInfo<BcxOrderFapiaoResponse> queryFapiaoList(BcxOrderFapiaoQueryRequest request, PageParamRequest pageParamRequest, LambdaQueryWrapper<BcxOrderFapiao> lqw) {
        lqw.orderByDesc(BcxOrderFapiao::getId);
        this.concatQueryParam(lqw, request);
        Page page = PageHelper.startPage((int)pageParamRequest.getPage(), (int)pageParamRequest.getLimit());
        List sources = this.dao.selectList((Wrapper)lqw);
        if (CollUtil.isEmpty((Collection)sources)) {
            return CommonPage.copyPageInfo((Page)page, (List)CollUtil.newArrayList((Object[])new BcxOrderFapiaoResponse[0]));
        }
        List<BcxOrderFapiaoResponse> result = this.transform2target(sources);
        return CommonPage.copyPageInfo((Page)page, result);
    }

    private void concatQueryParam(LambdaQueryWrapper<BcxOrderFapiao> lqw, BcxOrderFapiaoQueryRequest request) {
        String keyword;
        if (request.getFapiaoStatus() != null) {
            lqw.eq(BcxOrderFapiao::getFapiaoStatus, (Object)request.getFapiaoStatus());
        }
        if (request.getTimeFrom() != null) {
            lqw.ge(BcxOrderFapiao::getApplyTime, (Object)request.getTimeFrom());
        }
        if (request.getTimeTo() != null) {
            lqw.le(BcxOrderFapiao::getApplyTime, (Object)request.getTimeTo());
        }
        if (StrUtil.isNotBlank((CharSequence)(keyword = request.getKeyword()))) {
            lqw.and(qw -> {
                LambdaQueryWrapper cfr_ignored_0 = (LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)qw.eq(BcxOrderFapiao::getOrderNo, (Object)keyword)).or()).eq(BcxOrderFapiao::getApplyNo, (Object)keyword)).or()).eq(BcxOrderFapiao::getFapiaoNo, (Object)keyword);
            });
        }
        if (CollUtil.isNotEmpty((Collection)request.getFapiaoIds())) {
            lqw.in(BcxOrderFapiao::getId, (Collection)request.getFapiaoIds());
        }
    }

    private List<BcxOrderFapiaoResponse> transform2target(List<BcxOrderFapiao> sources) {
        ArrayList<BcxOrderFapiaoResponse> result = new ArrayList<BcxOrderFapiaoResponse>();
        List orderNoList = sources.stream().map(BcxOrderFapiao::getOrderNo).collect(Collectors.toList());
        List<Integer> uidList = sources.stream().map(BcxOrderFapiao::getUid).collect(Collectors.toList());
        Map<Integer, User> userMap = this.userService.getUidMapList(uidList);
        for (BcxOrderFapiao source : sources) {
            BcxOrderFapiaoResponse target = new BcxOrderFapiaoResponse();
            BeanUtils.copyProperties((Object)source, (Object)target);
            target.setUserName(userMap.get(source.getUid()) == null ? "" : userMap.get(source.getUid()).getNickname());
            result.add(target);
        }
        return result;
    }

    @Override
    public BcxOrderFapiao create(BcxOrderFapiaoRequest request) {
        Integer userId = this.userService.getUserIdException();
        String orderNo = request.getOrderNo();
        List<String> orderNos = Arrays.asList(orderNo.split(","));
        Map<String, Order> orderMap = this.orderService.getMapByOrderNoList(orderNos);
        if (orderMap.size() != orderNos.size()) {
            throw new CrmebException("\u8ba2\u5355\u4e0d\u5b58\u5728" + orderNo);
        }
        Collection<Order> orders = orderMap.values();
        if (orders.stream().map(Order::getMerId).distinct().count() > 1L) {
            throw new CrmebException("\u8ba2\u5355\u4e0d\u5c5e\u4e8e\u540c\u4e00\u4e2a\u5546\u6237\uff0c\u4e0d\u80fd\u5408\u5e76");
        }
        List details = ((QueryChainWrapper)this.orderDetailService.query().in((Object)"order_no", orderNos)).list();
        List productIds = details.stream().map(OrderDetail::getProductId).collect(Collectors.toList());
        int categoryCount = ((QueryChainWrapper)((QueryChainWrapper)this.productService.query().select(new String[]{"category_id"}).in((Object)"id", productIds)).groupBy((Object)"category_id")).list().size();
        if (categoryCount > 1) {
            throw new CrmebException("\u8ba2\u5355\u4e0d\u5c5e\u4e8e\u540c\u4e00\u4e2a\u5546\u54c1\u5206\u7c7b\uff0c\u4e0d\u80fd\u5408\u5e76");
        }
        String productInfo = details.stream().map(detail -> detail.getProductName() + ":" + detail.getPrice() + "(\u5143)*" + detail.getPayNum() + "\u4efd").collect(Collectors.joining(";"));
        orders.forEach(order -> {
            if (!userId.equals(order.getUid())) {
                throw new CrmebException("\u975e\u6cd5\u8bf7\u6c42");
            }
            if (order.getStatus() != 6) {
                throw new CrmebException("\u8ba2\u5355\u672a\u5b8c\u6210\uff0c\u4e0d\u80fd\u7533\u8bf7" + order.getOrderNo());
            }
            if (order.getFapiaoStatus() != 0) {
                throw new CrmebException("\u672a\u5f00\u53d1\u7968\u7684\u8ba2\u5355\u624d\u80fd\u7533\u8bf7" + order.getOrderNo());
            }
            order.setFapiaoStatus(Integer.valueOf(2));
        });
        this.validateParam(request);
        BcxOrderFapiao fapiao = new BcxOrderFapiao();
        BeanUtils.copyProperties((Object)request, (Object)fapiao);
        fapiao.setUid(userId);
        fapiao.setMerId(orders.iterator().next().getMerId());
        fapiao.setApplyTime(new Date());
        fapiao.setFapiaoStatus(Integer.valueOf(0));
        fapiao.setApplyNo(CrmebUtil.getOrderNo((String)"FP"));
        fapiao.setAmount(orders.stream().map(Order::getPayPrice).reduce(BigDecimal.ZERO, BigDecimal::add));
        fapiao.setBizType(orders.iterator().next().getBizType());
        fapiao.setProductInfo(productInfo);
        fapiao.setOrderNo(orderNo);
        if (((Boolean)this.transactionTemplate.execute(transactionStatus -> {
            this.orderService.updateBatchById(orders);
            return this.save(fapiao);
        })).booleanValue()) {
            return fapiao;
        }
        return null;
    }

    public void validateParam(BcxOrderFapiaoRequest request) {
        if (request.getTitleType() == 0 && request.getFapiaoType() == 1) {
            throw new CrmebException("\u4e2a\u4eba\u53ea\u80fd\u5f00\u589e\u503c\u7a0e\u666e\u901a\u53d1\u7968");
        }
        if (request.getTitleType() == 1) {
            if (request.getFapiaoType() == 0) {
                this.validator.validate((Object)request, new Class[]{BcxFapiaoTitleRequest.CompanyPlainGroup.class});
            } else {
                this.validator.validate((Object)request, new Class[]{BcxFapiaoTitleRequest.CompanyDedicatedGroup.class});
            }
        }
    }

    @Override
    public Boolean update(BcxOrderFapiaoRequest request) {
        BcxOrderFapiao fapiao = this.getFapiaoById(request.getId());
        if (fapiao.getFapiaoStatus() != 0) {
            throw new CrmebException("\u53d1\u7968\u7533\u8bf7\u5df2\u5904\u7406\uff0c\u4e0d\u80fd\u4fee\u6539");
        }
        if (!fapiao.getOrderNo().equals(request.getOrderNo())) {
            throw new CrmebException("\u8ba2\u5355\u53f7\u4e0d\u80fd\u4fee\u6539");
        }
        this.validateParam(request);
        BeanUtils.copyProperties((Object)request, (Object)fapiao);
        return this.updateById(fapiao);
    }

    @Override
    public Boolean delete(Integer id) {
        BcxOrderFapiao fapiao = this.getFapiaoById(id);
        if (fapiao.getFapiaoStatus() != 0) {
            throw new CrmebException("\u53d1\u7968\u7533\u8bf7\u5df2\u5904\u7406\uff0c\u4e0d\u80fd\u5220\u9664");
        }
        return this.removeById(id);
    }

    @Override
    public BcxOrderFapiao getFapiaoByOrderNo(String orderNo) {
        LambdaQueryWrapper lqw = new LambdaQueryWrapper();
        lqw.orderByDesc(BcxOrderFapiao::getId);
        if (StrUtil.isNotBlank((CharSequence)orderNo)) {
            lqw.apply(" FIND_IN_SET ('" + orderNo + "',order_no)", new Object[0]);
            return (BcxOrderFapiao)this.dao.selectOne((Wrapper)lqw);
        }
        return null;
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public boolean writeFapiao(BcxWriteFapiaoRequest request, Integer merId) {
        String applyNo = request.getApplyNo();
        LambdaQueryWrapper lqw = new LambdaQueryWrapper();
        lqw.eq(BcxOrderFapiao::getApplyNo, (Object)applyNo);
        List fapiaoList = this.dao.selectList((Wrapper)lqw);
        if (fapiaoList.size() < 1) {
            throw new CrmebException("\u6d41\u6c34\u53f7\u4e0d\u5bf9\uff0c\u7cfb\u7edf\u627e\u4e0d\u5230\u76f8\u5e94\u7684\u8bb0\u5f55");
        }
        if (fapiaoList.stream().anyMatch(f -> f.getFapiaoStatus() == 1)) {
            throw new CrmebException("\u6d41\u6c34\u53f7\u91cd\u590d\u6216\u5df2\u5f00\u5b8c\u7968\uff0c\u8bf7\u6838\u5bf9");
        }
        if (fapiaoList.stream().anyMatch(f -> !Objects.equals(f.getMerId(), merId))) {
            throw new CrmebException("\u6d41\u6c34\u53f7\u4e0d\u5c5e\u4e8e\u5546\u6237" + merId + "\u65e0\u6cd5\u5f00\u7968");
        }
        List<String> orderNoList = fapiaoList.stream().flatMap(f -> Arrays.stream(f.getOrderNo().split(","))).collect(Collectors.toList());
        fapiaoList.forEach(f -> {
            f.setFapiaoNo(request.getFapiaoNo());
            f.setFapiaoStatus(Integer.valueOf(1));
            f.setRemark(request.getRejectReason());
            if (StrUtil.isNotBlank((CharSequence)request.getWriteTime())) {
                try {
                    f.setWriteTime((Date)DateUtil.parse((String)request.getWriteTime()));
                }
                catch (Exception e) {
                    this.log.error("\u5bfc\u5165\u5f00\u7968\u65e5\u671f\u683c\u5f0f\u9519\u8bef", (Throwable)e);
                    f.setWriteTime(new Date());
                }
            } else {
                f.setWriteTime(new Date());
            }
        });
        this.updateBatchById(fapiaoList);
        this.orderService.writeFapiaoSuccess(orderNoList);
        return true;
    }
}

