/*
 * Decompiled with CFR 0.152.
 */
package com.zbkj.service.service.bcx;

import cn.hutool.core.collection.CollUtil;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.update.LambdaUpdateWrapper;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.github.pagehelper.Page;
import com.github.pagehelper.PageHelper;
import com.github.pagehelper.PageInfo;
import com.zbkj.common.exception.CrmebException;
import com.zbkj.common.model.bcx.BcxFapiaoTitle;
import com.zbkj.common.page.CommonPage;
import com.zbkj.common.request.PageParamRequest;
import com.zbkj.common.request.bcx.BcxFapiaoTitleRequest;
import com.zbkj.service.dao.bcx.BcxFapiaoTitleDao;
import com.zbkj.service.service.UserService;
import com.zbkj.service.service.bcx.BcxFapiaoTitleService;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javax.annotation.Resource;
import javax.validation.Validator;
import org.springframework.beans.BeanUtils;
import org.springframework.stereotype.Service;

@Service
public class BcxFapiaoTitleServiceImpl
extends ServiceImpl<BcxFapiaoTitleDao, BcxFapiaoTitle>
implements BcxFapiaoTitleService {
    @Resource
    private BcxFapiaoTitleDao dao;
    @Resource
    private UserService userService;
    @Resource
    private Validator validator;

    @Override
    public BcxFapiaoTitle queryById(Integer id) {
        BcxFapiaoTitle title;
        Integer userId = this.userService.getUserIdException();
        if (!userId.equals((title = (BcxFapiaoTitle)this.dao.selectById(id)).getUid())) {
            throw new CrmebException("\u627e\u4e0d\u5230\u8be5\u62ac\u5934");
        }
        return title;
    }

    @Override
    public PageInfo<BcxFapiaoTitle> queryPagedList(PageParamRequest pageParamRequest) {
        Integer userId = this.userService.getUserIdException();
        LambdaQueryWrapper lqw = new LambdaQueryWrapper();
        lqw.eq(BcxFapiaoTitle::getUid, (Object)userId);
        Page page = PageHelper.startPage((int)pageParamRequest.getPage(), (int)pageParamRequest.getLimit());
        List sources = this.dao.selectList((Wrapper)lqw);
        if (CollUtil.isEmpty((Collection)sources)) {
            return CommonPage.copyPageInfo((Page)page, (List)CollUtil.newArrayList((Object[])new BcxFapiaoTitle[0]));
        }
        List<BcxFapiaoTitle> result = this.transform2target(sources);
        return CommonPage.copyPageInfo((Page)page, result);
    }

    private List<BcxFapiaoTitle> transform2target(List<BcxFapiaoTitle> sources) {
        ArrayList<BcxFapiaoTitle> result = new ArrayList<BcxFapiaoTitle>();
        for (BcxFapiaoTitle source : sources) {
            BcxFapiaoTitle target = new BcxFapiaoTitle();
            BeanUtils.copyProperties((Object)source, (Object)target);
            result.add(target);
        }
        return result;
    }

    @Override
    public Boolean create(BcxFapiaoTitleRequest request) {
        Integer userId = this.userService.getUserIdException();
        this.validateParam(request);
        BcxFapiaoTitle title = new BcxFapiaoTitle();
        BeanUtils.copyProperties((Object)request, (Object)title);
        title.setUid(userId);
        return this.save(title);
    }

    public void validateParam(BcxFapiaoTitleRequest request) {
        if (request.getTitleType() == 0 && request.getFapiaoType() == 1) {
            throw new CrmebException("\u4e2a\u4eba\u53ea\u80fd\u5f00\u589e\u503c\u7a0e\u666e\u901a\u53d1\u7968");
        }
        if (request.getTitleType() == 1) {
            if (request.getFapiaoType() == 0) {
                this.validator.validate((Object)request, new Class[]{BcxFapiaoTitleRequest.CompanyPlainGroup.class});
            } else {
                this.validator.validate((Object)request, new Class[]{BcxFapiaoTitleRequest.CompanyDedicatedGroup.class});
            }
        }
    }

    @Override
    public Boolean update(BcxFapiaoTitleRequest request) {
        Integer userId = this.userService.getUserIdException();
        this.validateParam(request);
        BcxFapiaoTitle title = this.queryById(request.getId());
        BeanUtils.copyProperties((Object)request, (Object)title);
        title.setUid(userId);
        return this.updateById(title);
    }

    @Override
    public Boolean delete(Integer id) {
        this.queryById(id);
        return this.removeById(id);
    }

    public void setDefaultTitle(Integer titleId) {
        Integer userId = this.userService.getUserIdException();
        LambdaUpdateWrapper luw = new LambdaUpdateWrapper();
        luw.set(BcxFapiaoTitle::getIsDefault, (Object)false);
        luw.eq(BcxFapiaoTitle::getUid, (Object)userId);
        luw.ne(BcxFapiaoTitle::getId, (Object)titleId);
        this.dao.update(null, (Wrapper)luw);
    }
}

