/*
 * Decompiled with CFR 0.152.
 */
package com.zbkj.service.service.bcx;

import cn.hutool.core.collection.CollUtil;
import cn.hutool.core.collection.CollectionUtil;
import cn.hutool.core.util.StrUtil;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.baomidou.mybatisplus.extension.conditions.query.LambdaQueryChainWrapper;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.github.pagehelper.Page;
import com.github.pagehelper.PageHelper;
import com.github.pagehelper.PageInfo;
import com.zbkj.common.enums.BcxPerformanceReportBelongTypeEnum;
import com.zbkj.common.exception.CrmebException;
import com.zbkj.common.model.bcx.BcxFapiaoSource;
import com.zbkj.common.model.bcx.BcxPlatformFee;
import com.zbkj.common.model.bcx.BcxSettle;
import com.zbkj.common.model.merchant.Merchant;
import com.zbkj.common.model.order.Order;
import com.zbkj.common.model.order.OrderDetail;
import com.zbkj.common.model.product.Product;
import com.zbkj.common.model.user.User;
import com.zbkj.common.page.CommonPage;
import com.zbkj.common.request.PageParamRequest;
import com.zbkj.common.request.bcx.BcxFapiaoSourceRequest;
import com.zbkj.common.response.bcx.BcxFapiaoSourceResponse;
import com.zbkj.common.response.bcx.BcxSummaryInfo;
import com.zbkj.common.result.CommonResultCode;
import com.zbkj.common.result.IResultEnum;
import com.zbkj.common.utils.CrmebDateUtil;
import com.zbkj.common.vo.DateLimitUtilVo;
import com.zbkj.service.dao.bcx.BcxFapiaoSourceDao;
import com.zbkj.service.service.MerchantService;
import com.zbkj.service.service.OrderDetailService;
import com.zbkj.service.service.OrderService;
import com.zbkj.service.service.ProductService;
import com.zbkj.service.service.UserService;
import com.zbkj.service.service.bcx.BcxFapiaoSourceService;
import com.zbkj.service.service.bcx.BcxPlatformFeeService;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.apache.commons.lang3.StringUtils;
import org.springframework.stereotype.Service;

@Service
public class BcxFapiaoSourceServiceImpl
extends ServiceImpl<BcxFapiaoSourceDao, BcxFapiaoSource>
implements BcxFapiaoSourceService {
    @Resource
    private BcxFapiaoSourceDao dao;
    @Resource
    private UserService userService;
    @Resource
    private OrderService orderService;
    @Resource
    private OrderDetailService orderDetailService;
    @Resource
    private BcxPlatformFeeService bcxPlatformFeeService;
    @Resource
    private MerchantService merchantService;
    @Resource
    private ProductService productService;

    @Override
    public PageInfo<BcxFapiaoSourceResponse> queryPagedList(BcxFapiaoSourceRequest request, PageParamRequest pageParamRequest) {
        HashMap<String, Object> param = this.concatQueryParam(request);
        Page page = PageHelper.startPage((int)pageParamRequest.getPage(), (int)pageParamRequest.getLimit());
        ArrayList sources = this.dao.selectSourceJoinApplyList(param);
        return CommonPage.copyPageInfo((Page)page, CollUtil.isEmpty(sources) ? CollUtil.newArrayList((Object[])new BcxFapiaoSourceResponse[0]) : sources);
    }

    private HashMap<String, Object> concatQueryParam(BcxFapiaoSourceRequest request) {
        Integer userId = this.userService.getUserIdException();
        HashMap<String, Object> param = new HashMap<String, Object>();
        param.put("sourceNo", request.getSourceNo());
        param.put("applyNo", request.getApplyNo());
        param.put("fapiaoNo", request.getFapiaoNo());
        if (StrUtil.isNotEmpty((CharSequence)request.getSourceTime())) {
            DateLimitUtilVo sourceTime = CrmebDateUtil.getDateLimit((String)request.getSourceTime());
            param.put("sourceTimeStart", sourceTime.getStartTime());
            param.put("sourceTimeEnd", sourceTime.getEndTime());
        }
        if (StrUtil.isNotEmpty((CharSequence)request.getFapiaoTime())) {
            DateLimitUtilVo fapiaoTime = CrmebDateUtil.getDateLimit((String)request.getSourceTime());
            param.put("fapiaoTimeStart", fapiaoTime.getStartTime());
            param.put("fapiaoTimeEnd", fapiaoTime.getEndTime());
        }
        param.put("fapiaoStatus", request.getFapiaoStatus());
        param.put("sourceType", request.getSourceType());
        param.put("categoryId", request.getCategoryId());
        param.put("writer", request.getWriter());
        param.put("productInfo", request.getProductInfo());
        param.put("receiverId", userId);
        return param;
    }

    @Override
    public List<BcxFapiaoSource> queryByApplyNo(String applyNo) {
        LambdaQueryWrapper lqw = Wrappers.lambdaQuery();
        lqw.in(BcxFapiaoSource::getApplyNo, new Object[]{applyNo});
        return this.dao.selectList((Wrapper)lqw);
    }

    @Override
    public BcxSummaryInfo getSummaryInfo(BcxFapiaoSourceRequest request) {
        HashMap<String, Object> queryParam = this.concatQueryParam(request);
        return this.dao.querySummary(queryParam);
    }

    @Override
    public void saveSourceFromOrder(String orderNo) {
        Order order = this.orderService.getByOrderNo(orderNo);
        List<OrderDetail> orderDetails = this.orderDetailService.getByOrderNo(orderNo);
        BcxPlatformFee bcxPlatformFee = this.bcxPlatformFeeService.queryByOrderNo(orderNo, 0);
        User receiver = (User)this.userService.getById(order.getUid());
        Merchant merchant = this.merchantService.getByIdException(order.getMerId());
        User merchantUser = this.userService.getByAccount("org_" + merchant.getIdentityNo());
        Integer productId = orderDetails.stream().map(OrderDetail::getProductId).distinct().findFirst().orElse(0);
        Product product = (Product)this.productService.getById(productId);
        BcxFapiaoSource source = new BcxFapiaoSource();
        source.setSourceNo(orderNo);
        source.setSourceType(Integer.valueOf(0));
        source.setSourceTime(order.getPayTime());
        if (merchantUser != null) {
            source.setWriter(merchantUser.getRealName());
            source.setWriterId(merchantUser.getId());
        }
        source.setProductInfo(orderDetails.stream().map(OrderDetail::getProductName).collect(Collectors.joining(",")));
        source.setReceiver(StrUtil.isNotBlank((CharSequence)receiver.getRealName()) ? receiver.getRealName() : "\u5c0f\u7a0b\u5e8f\u7528\u6237:" + receiver.getPhone());
        source.setReceiverId(receiver.getId());
        source.setCategoryId(product.getCategoryId());
        source.setAmount(order.getPayPrice());
        source.setQuantity(orderDetails.stream().map(OrderDetail::getPayNum).reduce(0, Integer::sum));
        source.setPrice(orderDetails.stream().map(OrderDetail::getPrice).reduce(BigDecimal.ZERO, BigDecimal::max));
        this.dao.insert(source);
        User platform = this.userService.getPlatformUser();
        BcxFapiaoSource platformFeeSource = new BcxFapiaoSource();
        platformFeeSource.setSourceNo(orderNo);
        platformFeeSource.setSourceType(Integer.valueOf(1));
        platformFeeSource.setSourceTime(order.getPayTime());
        if (platform != null) {
            platformFeeSource.setWriter(platform.getRealName());
            platformFeeSource.setWriterId(platform.getId());
        }
        platformFeeSource.setProductInfo(orderDetails.stream().map(OrderDetail::getProductName).collect(Collectors.joining(",")));
        if (merchantUser != null) {
            platformFeeSource.setReceiver(merchantUser.getRealName());
            platformFeeSource.setReceiverId(merchantUser.getId());
        }
        platformFeeSource.setCategoryId(product.getCategoryId());
        platformFeeSource.setAmount(bcxPlatformFee.getPlatFee());
        platformFeeSource.setQuantity(null);
        platformFeeSource.setPrice(bcxPlatformFee.getPlatFee());
        this.dao.insert(platformFeeSource);
    }

    @Override
    public Map<Integer, BcxFapiaoSource> getMapBySourceIdList(List<Integer> sourceIds) {
        LambdaQueryWrapper lqw = Wrappers.lambdaQuery();
        lqw.in(BcxFapiaoSource::getId, sourceIds);
        List sourceList = this.dao.selectList((Wrapper)lqw);
        if (CollUtil.isEmpty((Collection)sourceList)) {
            return CollUtil.newHashMap((int)0);
        }
        return sourceList.stream().distinct().collect(Collectors.toMap(BcxFapiaoSource::getId, Function.identity(), (o, n) -> o));
    }

    @Override
    public void saveSourceFromBrokerage(BcxSettle bcxSettle) {
        int sourceType = -100;
        if (bcxSettle.getBelongType().intValue() == BcxPerformanceReportBelongTypeEnum.CHANNEL.getValue().intValue()) {
            sourceType = 2;
        } else if (bcxSettle.getBelongType().intValue() == BcxPerformanceReportBelongTypeEnum.USER_FXS.getValue().intValue()) {
            sourceType = 3;
        }
        if (sourceType != -100) {
            User applyUser = this.userService.getPlatformUser();
            User openUser = (User)this.userService.getById(bcxSettle.getBelongId());
            BcxFapiaoSource source = new BcxFapiaoSource();
            source.setSourceNo(bcxSettle.getSettleNo());
            source.setSourceType(Integer.valueOf(sourceType));
            source.setSourceTime(bcxSettle.getCreateTime());
            source.setWriter(openUser.getRealName());
            source.setWriterId(openUser.getId());
            source.setReceiver(applyUser.getRealName());
            source.setReceiverId(applyUser.getId());
            source.setAmount(bcxSettle.getBrokerageTotalPrice());
            this.dao.insert(source);
        }
    }

    @Override
    public void deleteSourceFromBrokerage(String settleNo) {
        LambdaQueryChainWrapper lqw = this.lambdaQuery();
        lqw.eq(BcxFapiaoSource::getSourceNo, (Object)settleNo);
        lqw.last("limit 1");
        List list = lqw.list();
        if (CollectionUtil.isNotEmpty((Collection)list)) {
            BcxFapiaoSource source = (BcxFapiaoSource)list.get(0);
            if (StringUtils.isNotBlank((CharSequence)source.getApplyNo())) {
                throw new CrmebException((IResultEnum)CommonResultCode.ERROR.setMessage("\u5df2\u7533\u8bf7\u5f00\u7968\u7684\u7ed3\u7b97\u5355\u4e0d\u80fd\u64a4\u9500"));
            }
            this.removeById(source.getId());
        }
    }
}

