/*
 * Decompiled with CFR 0.152.
 */
package com.zbkj.service.exception;

import cn.hutool.core.util.ObjectUtil;
import com.zbkj.common.exception.BusinessException;
import com.zbkj.common.exception.CrmebException;
import com.zbkj.common.model.exception.ExceptionLog;
import com.zbkj.common.result.CommonResult;
import com.zbkj.common.result.CommonResultCode;
import com.zbkj.common.wrapper.ContentCachingRequestWrapper;
import com.zbkj.service.service.ExceptionLogService;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.io.Writer;
import java.util.List;
import java.util.Objects;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.io.IOUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.HttpStatus;
import org.springframework.http.converter.HttpMessageNotReadableException;
import org.springframework.validation.BindException;
import org.springframework.validation.BindingResult;
import org.springframework.validation.FieldError;
import org.springframework.web.HttpMediaTypeNotSupportedException;
import org.springframework.web.bind.MethodArgumentNotValidException;
import org.springframework.web.bind.MissingServletRequestParameterException;
import org.springframework.web.bind.annotation.ExceptionHandler;
import org.springframework.web.bind.annotation.ModelAttribute;
import org.springframework.web.bind.annotation.ResponseStatus;
import org.springframework.web.bind.annotation.RestControllerAdvice;

@RestControllerAdvice
public class GlobalExceptionHandler {
    private static final Logger LOGGER = LoggerFactory.getLogger(GlobalExceptionHandler.class);
    private static String REQUESTBODY = "requestBodyMessage";
    @Autowired
    private ExceptionLogService exceptionLogService;

    @ResponseStatus(value=HttpStatus.OK)
    @ExceptionHandler(value={CrmebException.class})
    public CommonResult crmebExceptionHandler(HttpServletRequest request, CrmebException e) {
        this.doLog(request, (Exception)e);
        if (ObjectUtil.isNull((Object)e.getCode())) {
            return CommonResult.failed((String)e.getMessage());
        }
        return CommonResult.failed((CrmebException)e);
    }

    @ResponseStatus(value=HttpStatus.OK)
    @ExceptionHandler(value={BusinessException.class})
    public CommonResult crmebExceptionHandler(HttpServletRequest request, BusinessException e) {
        this.doLog(request, (Exception)e);
        if (ObjectUtil.isNull((Object)e.getCode())) {
            return CommonResult.failed((String)e.getMessage());
        }
        return CommonResult.failed((CrmebException)e);
    }

    @ResponseStatus(value=HttpStatus.OK)
    @ExceptionHandler(value={Exception.class})
    public CommonResult crmebExceptionHandler(HttpServletRequest request, Exception e) {
        this.doLog(request, e);
        return CommonResult.failed((String)e.getMessage());
    }

    @ResponseStatus(value=HttpStatus.OK)
    @ExceptionHandler(value={MissingServletRequestParameterException.class})
    public CommonResult parameterMissingExceptionHandler(HttpServletRequest request, MissingServletRequestParameterException e) {
        this.doLog(request, (Exception)e);
        return CommonResult.failed((CommonResultCode)CommonResultCode.VALIDATE_FAILED, (String)("\u8bf7\u6c42\u53c2\u6570 " + e.getParameterName() + " \u4e0d\u80fd\u4e3a\u7a7a"));
    }

    @ResponseStatus(value=HttpStatus.OK)
    @ExceptionHandler(value={HttpMessageNotReadableException.class})
    public CommonResult parameterBodyMissingExceptionHandler(HttpServletRequest request, HttpMessageNotReadableException e) {
        this.doLog(request, (Exception)e);
        return CommonResult.failed((CommonResultCode)CommonResultCode.VALIDATE_FAILED, (String)"\u53c2\u6570\u4f53\u4e0d\u80fd\u4e3a\u7a7a");
    }

    @ResponseStatus(value=HttpStatus.OK)
    @ExceptionHandler(value={MethodArgumentNotValidException.class})
    public CommonResult parameterExceptionHandler(HttpServletRequest request, MethodArgumentNotValidException e) {
        List errors;
        this.doLog(request, (Exception)e);
        BindingResult exceptions = e.getBindingResult();
        if (exceptions.hasErrors() && !(errors = exceptions.getAllErrors()).isEmpty()) {
            FieldError fieldError = (FieldError)errors.get(0);
            return CommonResult.failed((CommonResultCode)CommonResultCode.VALIDATE_FAILED, (String)fieldError.getDefaultMessage());
        }
        return CommonResult.failed((CommonResultCode)CommonResultCode.VALIDATE_FAILED, (String)"\u8bf7\u6c42\u53c2\u6570\u6821\u9a8c\u5f02\u5e38");
    }

    @ResponseStatus(value=HttpStatus.OK)
    @ExceptionHandler(value={BindException.class})
    public CommonResult bindException(HttpServletRequest request, BindException e) {
        this.doLog(request, (Exception)e);
        BindingResult bindingResult = e.getBindingResult();
        return CommonResult.failed((CommonResultCode)CommonResultCode.VALIDATE_FAILED, (String)Objects.requireNonNull(bindingResult.getFieldError()).getDefaultMessage());
    }

    @ResponseStatus(value=HttpStatus.OK)
    @ExceptionHandler(value={HttpMediaTypeNotSupportedException.class})
    public CommonResult bindException(HttpServletRequest request, HttpMediaTypeNotSupportedException e) {
        this.doLog(request, (Exception)e);
        return CommonResult.failed((CommonResultCode)CommonResultCode.VALIDATE_FAILED, (String)Objects.requireNonNull(e.getMessage()));
    }

    @ModelAttribute
    public void getBobyInfo(HttpServletRequest request) {
        try {
            ContentCachingRequestWrapper requestWapper = null;
            if (request instanceof HttpServletRequest) {
                requestWapper = (ContentCachingRequestWrapper)request;
            }
            String body = IOUtils.toString((byte[])requestWapper.getBody(), (String)request.getCharacterEncoding());
            request.setAttribute(REQUESTBODY, (Object)body);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private void doLog(HttpServletRequest request, Exception e) {
        LOGGER.error("\u6355\u83b7\u5230\u5f02\u5e38\uff1a", (Throwable)e);
        StringWriter sw = new StringWriter();
        e.printStackTrace(new PrintWriter((Writer)sw, true));
        String expDetail = sw.toString();
        try {
            sw.close();
        }
        catch (IOException ioException) {
            LOGGER.error("\u5f02\u5e38\u65e5\u5fd7\uff1a\u5173\u95ed\u5f02\u5e38\u8be6\u60c5Writer\u5f02\u5e38");
        }
        String expUrl = request.getRequestURI();
        Object body = request.getAttribute(REQUESTBODY);
        String expParams = ObjectUtil.isNotNull((Object)body) ? body.toString() : "";
        String expType = e.getClass().getName();
        StackTraceElement stackTraceElement = e.getStackTrace()[0];
        String expController = stackTraceElement.getClassName();
        String expMethod = stackTraceElement.getMethodName();
        ExceptionLog exceptionLog = new ExceptionLog();
        exceptionLog.setExpUrl(expUrl);
        exceptionLog.setExpParams(expParams);
        exceptionLog.setExpType(expType);
        exceptionLog.setExpController(expController);
        exceptionLog.setExpMethod(expMethod);
        exceptionLog.setExpDetail(expDetail);
        this.exceptionLogService.save(exceptionLog);
    }
}

