	var ProductManager = {
		current:function(){
			var obj = null;
			var parent = null;
			var context = null;
			return {
				show:function(putObj,keep){
					this.reset(keep);
					obj = putObj;
					$("#"+obj).fadeTo(200,0.8);
				},
				get:function(){
					return obj;
				},
				reset:function(keep){
					try{
						$("#"+obj).fadeOut(200);
						if(!keep){
							//$("#"+obj).html("");
						}
					}catch(e){}
					obj = null;
					parent = null;
				},
				setParent:function(p){
					parent = p;
				},
				getParent:function(){
					return parent;
				},
				setContext:function(c){
					context = c;
				},
				context:function(){
					return context;
				}
			};
		}(),
		loader:function(){
			var reload = null;
			return{
				setReload:function(r){
					reload = r;
				},
				getReload:function(){
					return reload;
				}
			};
		}(),
		prop:function(){
			var current = null;
			var createHolder = null;
			return {
				set:function(e){
					current = e;
				},
				get:function(){
					if(current == null){
						return '';
					}
					return current;
				},
				type:function(){
					if("" == current){
						return "_defaultValue";
					}
					return "_constantValue";
				},
				index:function(){
					if("" == current){
						return "_indexValue";
					}
					return "_constantIndexValue";
				},
				sourceDiv:function(){
					if("" == current){
						return "PropertySourceDiv";
					}
					return "ConstantPropertySourceDiv";
				},
				targetDiv:function(){
					if("" == current){
						return "PropertyTargetDiv";
					}
					return "ConstantPropertyTargetDiv";
				},
				setCreater:function(creater){
					createHolder = creater;
				},
				creater:function(){
					return createHolder;
				}
				
			};
		}(),
		rule:function(){
			var ruleType = null;
			return {
				ruleSourceDiv:function(){
					if(ruleType == ''){
						return "RuleSourceDiv";
					}
					return "CalculationsSourceDiv";
				},
				ruleTargetDiv:function(){
					if(ruleType == ''){
						return "RuleTargetDiv";
					}
					return "CalculationsTargetDiv";
				},
				target:function(){
					if(ruleType == ''){
						return "RuleTarget";
					}
					return "CalculationsTarget";
				},
				type:function(t){
					ruleType = t;
				}
			};
		}()
	};
	
	function loadRule(loader){
		$.ajax({
			url:loader.source,
			data:{clazz:loader.type},
			type:"POST",
			context: document.body,
			xhrFields:{
				withCredentials: true
			}
			}).done(function(json) {
				if(loader.put && json){
					var propertyArray = $.parseJSON(json);
					cleanComponent({put:loader.put});
					for(var p in propertyArray){
						showRule({put:loader.put,oid:p,name:propertyArray[p]});
					}
				}
			}).fail(function() {
				alert( "error" );
			}).always(function() {
			});
	}
	
	function loadInsuranceTarget(source,data){
		if($(source).val() === "PHYSICAL"){
			$.ajax({
				url:data.url,
				data:{},
				type:"POST",
				dataType:"html",
				context: document.body,
				xhrFields:{
					withCredentials: true
				}
				}).done(function(msg) {
					if(data.down && msg){
						$('#'+data.down).html(msg);
						$('#'+data.show).attr("display","block");
					}
				}).fail(function() {
					alert( "error" );
				}).always(function() {
				});
		} else {
			$("#"+data.down).html(null);
		} 
	}
	
	function loadProperty(loader){
		ProductManager.current.setContext(loader.type);
		$.ajax({
			url:loader.url,
			data:{propertyType:loader.creater},
			type:"POST",
			context: document.body,
			xhrFields:{
				withCredentials: true
			}
			}).done(function(json) {
				if(loader.put && json){
					var propertyArray = $.parseJSON(json);
					cleanComponent({put:loader.put});
					for(var p in propertyArray){
						showProperty({put:loader.put,oid:p,name:propertyArray[p]});
					}
				}
			}).fail(function() {
				alert( "error" );
			}).always(function() {
			});
	}
	
	function showProperty(source){
		$('#'+source.put).append('<tr class="showLine" ><td><input type="checkbox" onclick="selectProperty(this);"><input type="hidden" class="rolePropertyOid" value="'+source.oid+'"><input type="hidden" class="rolePropertyName" value="'+source.name+'"></td><td>'+source.name+'</td></tr>');
	}
	
	function showRule(source){
		$('#'+source.put).append('<tr class="showLine" ><td><input type="checkbox" onclick="selectRule(this);"><input type="hidden" class="rolePropertyOid" value="'+source.oid+'"><input type="hidden" class="rolePropertyName" value="'+source.name+'"></td><td>'+source.name+'</td></tr>');
	}
	
	function selectRule(source){
		if(source.checked){
			var node = $(source.parentNode.parentNode);
			putRule({put:(ProductManager.current.context()+ProductManager.rule.target()),oid:(node.find("input[class='rolePropertyOid']").val()),name:(node.find("input[class='rolePropertyName']").val())});
		}
	}
	
	function putRule(source){
		var view = '<tr class="composationTable"><td><label>'+source.name+'</label></td><td><input id="'+source.oid+'" type="hidden" name="'+source.oid+'_Rule" value="'+source.oid+'"></td><td><div class="composationDiv" onclick="removeComponent(this);">×</div></td></tr>';
		$('#'+source.put).append(view);
	}
	
	function cleanComponent(source){
		$('#'+source.put).html(null);
	}
	
	function putProperty(source){
		var str = '<tr class="composationTable"><td>'+source.name+'</td><td><label><a href="#" onclick="editProperty(this);">默认值</a></label><input id="'+source.oid+'" type="hidden" class="defaultValue" name="'+(source.oid+ProductManager.prop.type())+'"></td><td><label><a href="#" onclick="editIndexVal(this);">排序</a></label><input id="index_'+source.oid+'" type="hidden" class="indexVal" name="'+(source.oid+ProductManager.prop.index())+'"></td><td><div class="composationDiv" onclick="removeComponent(this);">×</div></td></tr>';
		$('#'+(ProductManager.current.context()+ProductManager.prop.get()+source.put)).append(str);
	}
	
	function editProperty(source){
		var defaultValue = $(source.parentNode.parentNode).find("input[class='defaultValue']");
		if("text" === defaultValue.attr("type")){
			defaultValue.attr("type","hidden");
			return;
		}
		defaultValue.attr("type","text");
	}
	
	function editIndexVal(source){
		var defaultValue = $(source.parentNode.parentNode).find("input[class='indexVal']");
		if("text" === defaultValue.attr("type")){
			defaultValue.attr("type","hidden");
			return;
		}
		defaultValue.attr("type","text");
	}
	
	function selectProperty(source){
		if(source.checked){
			var node = $(source.parentNode.parentNode);
			putProperty({put:"PropertyTarget",oid:(node.find("input[class='rolePropertyOid']").val()),name:(node.find("input[class='rolePropertyName']").val())});
		}
	}
	
	function removeComponent(target){
		removeComponentNode({remove:target.parentNode.parentNode});
	}
	function onSelectColor(source,type,context){
		ProductManager.prop.set(type);
		$(source).parent().parent().parent().find("td.tdborder").attr("class",null);
		$(source).parent().parent().find("td:first-child").attr("class","tdborder");
		if(context){
			$("#"+context).find("div.show").attr("class","down");
			var sourceId = (ProductManager.current.context()+ProductManager.prop.sourceDiv());
			var targetId = (ProductManager.current.context()+ProductManager.prop.targetDiv());
			$("#"+sourceId).attr("class","show");
			$("#"+targetId).attr("class","show");
		}
	}
	
	function onRuleFocus(source,data){
		$(source).parent().parent().parent().find("td.tdborder").attr("class",null);
		$(source).parent().parent().find("td:first-child").attr("class","tdborder");
		$("#"+data.context).find("div.show").attr("class","down");
		$("#"+(ProductManager.current.context()+ProductManager.rule.ruleSourceDiv())).attr("class","show");
		$("#"+(ProductManager.current.context()+ProductManager.rule.ruleTargetDiv())).attr("class","show");
	}
	
	function onSelectRule(source,data){
		ProductManager.rule.type(data.type);
		ProductManager.current.setContext(data.clazz);
		onRuleFocus(source,data);
		$.ajax({
			url:data.source,
			data:{clazz:data.clazz,type:data.type},
			type:"POST",
			context: document.body,
			xhrFields:{
				withCredentials: true
			}
			}).done(function(json) {
				if(data.put && json){
					var propertyArray = $.parseJSON(json);
					cleanComponent({put:data.put});
					for(var p in propertyArray){
						showRule({put:data.put,oid:p,name:propertyArray[p]});
					}
				}
			}).fail(function() {
				alert( "error" );
			}).always(function() {
			});
	}
	
	function save(para){
		var isPropertySave = (para.form == "propertyForm"); 
		if(!isPropertySave && para.preceding && !precedingFun()){
			return;
		}
		var formObj = $("#"+para.form);
		var serializeObj = formObj.serialize();
		var propertyCreater = ProductManager.prop.creater();
		if(propertyCreater){
			serializeObj+="&creater="+propertyCreater;
		}
		var source = {};
		var name_input = formObj.find("input[name='name']").val();
		if(!para.skip){
			if(!name_input){
				name_input = $("#"+para.form+" select[name='kind'] option:selected").text();
			}
			var kind_input = formObj.find("input[name='externalReference']").val();
			if(!kind_input){
				kind_input = formObj.find("select[name='kind'] option:selected").val();
			}
			source.kind=kind_input;
			source.target=para.content;
		}
		source.name=name_input;
		if(formObj.attr("action")){
			$.ajax({
				url:formObj.attr("action"),
				data:serializeObj,
				type:"POST",
				dataType:"text",
				context: document.body,
				xhrFields:{
					withCredentials: true
				}
				}).done(function(msg) {
					var resultObj = $.parseJSON(msg);
					source.id=resultObj.oid;
					if(!resultObj.status){
						if(para.put && resultObj.oid){
							$('#'+para.put).val(resultObj.oid);
						}
						if(para.isProp){
							putProperty({oid:source.id,name:source.name,put:para.put});
						}
						if(para.preceding){
							cancel();
						}
						if(para.show){
							addComponent(source);
							ProductManager.current.reset();
						}
					}
					if(resultObj.message != ""){
						alert(resultObj.message);
					}
				}).fail(function() {
					alert( "error" );
				}).always(function() {
				});
		}
	}
	
	function addComponent(obj){
		if($("#"+obj.target).find("#"+obj.id).length < 1){
			$("#"+obj.target).append($('<div><div id="'+obj.id+'" onclick="showComponent(this);"><div class="composationDiv">'+obj.name+'('+obj.kind+')</div ></div><div class="composationDiv" onclick="removeComponet(this,'+obj.id+');">×</div></div>'));
		}
	}
	
	function showComponent(source,idList){
		var sourceId = $(source).parent().parent().attr("id");
		var componentType = sourceId.substr(sourceId.indexOf("_")+1);
		var holder = sourceId.substr(0,sourceId.indexOf("_"));
		var  transfer = {oid:$(source).attr("id"),type:componentType,put:holder};
		loadComponent(transfer,idList);
	}
	
	function setContextId(idObj){
		for(var v in idObj){
			$("#"+v).val(idObj[v]);
		}
	}
	
	function formatComponent(source){
		var jsonObj = $.parseJSON(source.json);
		//jsonObj
	}
	
	function formatRole(source){
		//var jsonObj = $.parseJSON(source.json);
		
	}
	
	
	function loadComponent(source,idList){
		$.ajax({
			url:ProductManager.loader.getReload(),
			data:{oid:source.oid,type:source.type},
			type:"POST",
			dataType:"html",
			context: document.body,
			xhrFields:{
				withCredentials: true
			}
			}).done(function(msg) {
				if(msg && source.put){
					ProductManager.current.show(source.put);
					$('#'+source.put).html(msg);
					setContextId(idList);
				}
			}).fail(function() {
				alert( "error" );
			}).always(function() {
			});
	}
	
	function removeComponet(source,delId){
		var id = $(source).parent().parent().attr("id");
		var componentType = id.substr(id.indexOf("_")+1);
		removeRequest({oid:delId,url:$("#deleteRequest").val(),type:componentType,remove:source.parentNode});
	}
	
	function removeComponentNode(source){
		$(source.remove).remove();
	}
	
	function removeRequest(source,target,sourceType){
		$.ajax({
			url:source.url,
			data:{oid:source.oid,contextType:source.type},
			type:"POST",
			dataType:"html",
			context: document.body,
			xhrFields:{
				withCredentials: true
			}
			}).done(function(msg) {
				if(msg){
					removeComponentNode(source);
				}
			}).fail(function() {
				alert( "error" );
			}).always(function() {
			});
	}
	
	function transform(obj){
		ProductManager.current.setContext(obj.party);
		$.ajax({
			url:obj.url,
			data:{},
			type:"POST",
			dataType:"html",
			context: document.body,
			xhrFields:{
				withCredentials: true
			}
			}).done(function(msg) {
				if(obj.down && msg){
					ProductManager.current.show(obj.down);
					$('#'+obj.down).html(msg);
				}
			}).fail(function() {
				alert( "error" );
			}).always(function() {
			});
	}
	
	function addProperty(event,source){
		$.ajax({
			url:source.url,
			data:{},
			type:"POST",
			dataType:"html",
			context: document.body,
			xhrFields:{
				withCredentials: true
			}
			}).done(function(msg) {
				if(source.down && msg){
					$('#'+source.down).html(msg);
					document.getElementById(source.show).style.display='block';
					ProductManager.current.show(source.show,true);
					$(event).attr("onclick","ProductManager.current.show('"+source.show+"',true)");
				}
			}).fail(function() {
				alert( "error" );
			}).always(function() {
			});
	}
		
	function precedingFun(){
		var oid = $('#oid').val();
		if(oid == ""){
			alert("请先保存产品信息");
			return false;
		}
		$('#'+ProductManager.current.context()+'ParentOid').val(oid);
		return true;
	}
	
	function saveRule(s){
		var ruleName = $("#"+s.form).find("input[name='name']").val();
		var serialize = $("#"+s.form).serialize();
		serialize+=('&clazz='+ProductManager.current.context());
		$.ajax({
			url:$("#"+s.form).attr("action"),
			data:serialize,
			type:"POST",
			dataType:"text",
			context: document.body,
			xhrFields:{
				withCredentials: true
			}
			}).done(function(msg) {
				var resultObj = $.parseJSON(msg);
				if(resultObj.oid){
					$('#'+s.target).html(resultObj.oid);
					putRule({oid:resultObj.oid,name:ruleName,put:(ProductManager.current.context()+ProductManager.rule.ruleTargetDiv())});
				}
				hideOverlay();
				if(resultObj.message != ""){
					alert(resultObj.message);
				}
			}).fail(function() {
				alert( "error" );
			}).always(function() {
			});
	}
	
	function addFun(s){
		ProductManager.current.setContext(s.parent);
		ProductManager.prop.set(s.actual);
		ProductManager.prop.setCreater(s.ceater);
		$.ajax({
			url:s.source,
			data:{},
			type:"POST",
			dataType:"html",
			context: document.body,
			xhrFields:{
				withCredentials: true
			}
			}).done(function(msg) {
				if(s.target && msg){
					$('#'+s.target).html(msg);
				}
				showOverlay();
			}).fail(function() {
				alert( "error" );
			}).always(function() {
			});
	}
	
	function cancel(){
		hideOverlay();
	}
	
	function request(obj,url,paraId){
		var optoinObj = $('#'+paraId);
		var req = url+"?"+optoinObj.attr("name")+"="+optoinObj.val();
		obj.href=req;
	};
	
	 function showOverlay() {
		$("#overlay").fadeTo(200, 0.8);
	}

	 function hideOverlay() {
		$("#overlay").fadeOut(200);
	 }
	 
	 function pageHeight() {
		 return document.body.scrollHeight;
	 }
	 
	 function pageWidth() {
		return document.body.scrollWidth;
	 }
	 
	 
	 function adjust(id) {
		      var w = $(id).width();
		      var h = $(id).height();
		      
		      var t = scrollY() + (windowHeight()/2) - (h/2);
		      if(t < 0) t = 0;
		      
		      var l = scrollX() + (windowWidth()/2) - (w/2);
		     if(l < 0) l = 0;
		     
		     $(id).css({left: l+'px', top: t+'px'});
	}
	 
	function windowHeight() {
		var de = document.documentElement;
		return self.innerHeight || (de && de.clientHeight) || document.body.clientHeight;
	}

	function windowWidth() {
		var de = document.documentElement;
		return self.innerWidth || (de && de.clientWidth) || document.body.clientWidth;
	}

	function scrollY() {
		var de = document.documentElement;
		return self.pageYOffset || (de && de.scrollTop) || document.body.scrollTop;
	}

	function scrollX() {
		var de = document.documentElement;
		return self.pageXOffset || (de && de.scrollLeft) || document.body.scrollLeft;
	}